<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/aiplatform/v1/featurestore_service.proto

namespace Google\Cloud\AIPlatform\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for [FeaturestoreService.BatchReadFeatureValues][google.cloud.aiplatform.v1.FeaturestoreService.BatchReadFeatureValues].
 *
 * Generated from protobuf message <code>google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest</code>
 */
class BatchReadFeatureValuesRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the Featurestore from which to query Feature values.
     * Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}`
     *
     * Generated from protobuf field <code>string featurestore = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $featurestore = '';
    /**
     * Required. Specifies output location and format.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.FeatureValueDestination destination = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $destination = null;
    /**
     * When not empty, the specified fields in the *_read_instances source will be
     * joined as-is in the output, in addition to those fields from the
     * Featurestore Entity.
     * For BigQuery source, the type of the pass-through values will be
     * automatically inferred. For CSV source, the pass-through values will be
     * passed as opaque bytes.
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest.PassThroughField pass_through_fields = 8;</code>
     */
    private $pass_through_fields;
    /**
     * Required. Specifies EntityType grouping Features to read values of and settings.
     * Each EntityType referenced in
     * [BatchReadFeatureValuesRequest.entity_type_specs] must have a column
     * specifying entity IDs in the EntityType in
     * [BatchReadFeatureValuesRequest.request][] .
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest.EntityTypeSpec entity_type_specs = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $entity_type_specs;
    /**
     * Optional. Excludes Feature values with feature generation timestamp before this
     * timestamp. If not set, retrieve oldest values kept in Feature Store.
     * Timestamp, if present, must not have higher than millisecond precision.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $start_time = null;
    protected $read_option;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\AIPlatform\V1\CsvSource $csv_read_instances
     *           Each read instance consists of exactly one read timestamp and one or more
     *           entity IDs identifying entities of the corresponding EntityTypes whose
     *           Features are requested.
     *           Each output instance contains Feature values of requested entities
     *           concatenated together as of the read time.
     *           An example read instance may be `foo_entity_id, bar_entity_id,
     *           2020-01-01T10:00:00.123Z`.
     *           An example output instance may be `foo_entity_id, bar_entity_id,
     *           2020-01-01T10:00:00.123Z, foo_entity_feature1_value,
     *           bar_entity_feature2_value`.
     *           Timestamp in each read instance must be millisecond-aligned.
     *           `csv_read_instances` are read instances stored in a plain-text CSV file.
     *           The header should be:
     *               [ENTITY_TYPE_ID1], [ENTITY_TYPE_ID2], ..., timestamp
     *           The columns can be in any order.
     *           Values in the timestamp column must use the RFC 3339 format, e.g.
     *           `2012-07-30T10:43:17.123Z`.
     *     @type \Google\Cloud\AIPlatform\V1\BigQuerySource $bigquery_read_instances
     *           Similar to csv_read_instances, but from BigQuery source.
     *     @type string $featurestore
     *           Required. The resource name of the Featurestore from which to query Feature values.
     *           Format:
     *           `projects/{project}/locations/{location}/featurestores/{featurestore}`
     *     @type \Google\Cloud\AIPlatform\V1\FeatureValueDestination $destination
     *           Required. Specifies output location and format.
     *     @type array<\Google\Cloud\AIPlatform\V1\BatchReadFeatureValuesRequest\PassThroughField>|\Google\Protobuf\Internal\RepeatedField $pass_through_fields
     *           When not empty, the specified fields in the *_read_instances source will be
     *           joined as-is in the output, in addition to those fields from the
     *           Featurestore Entity.
     *           For BigQuery source, the type of the pass-through values will be
     *           automatically inferred. For CSV source, the pass-through values will be
     *           passed as opaque bytes.
     *     @type array<\Google\Cloud\AIPlatform\V1\BatchReadFeatureValuesRequest\EntityTypeSpec>|\Google\Protobuf\Internal\RepeatedField $entity_type_specs
     *           Required. Specifies EntityType grouping Features to read values of and settings.
     *           Each EntityType referenced in
     *           [BatchReadFeatureValuesRequest.entity_type_specs] must have a column
     *           specifying entity IDs in the EntityType in
     *           [BatchReadFeatureValuesRequest.request][] .
     *     @type \Google\Protobuf\Timestamp $start_time
     *           Optional. Excludes Feature values with feature generation timestamp before this
     *           timestamp. If not set, retrieve oldest values kept in Feature Store.
     *           Timestamp, if present, must not have higher than millisecond precision.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Aiplatform\V1\FeaturestoreService::initOnce();
        parent::__construct($data);
    }

    /**
     * Each read instance consists of exactly one read timestamp and one or more
     * entity IDs identifying entities of the corresponding EntityTypes whose
     * Features are requested.
     * Each output instance contains Feature values of requested entities
     * concatenated together as of the read time.
     * An example read instance may be `foo_entity_id, bar_entity_id,
     * 2020-01-01T10:00:00.123Z`.
     * An example output instance may be `foo_entity_id, bar_entity_id,
     * 2020-01-01T10:00:00.123Z, foo_entity_feature1_value,
     * bar_entity_feature2_value`.
     * Timestamp in each read instance must be millisecond-aligned.
     * `csv_read_instances` are read instances stored in a plain-text CSV file.
     * The header should be:
     *     [ENTITY_TYPE_ID1], [ENTITY_TYPE_ID2], ..., timestamp
     * The columns can be in any order.
     * Values in the timestamp column must use the RFC 3339 format, e.g.
     * `2012-07-30T10:43:17.123Z`.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.CsvSource csv_read_instances = 3;</code>
     * @return \Google\Cloud\AIPlatform\V1\CsvSource|null
     */
    public function getCsvReadInstances()
    {
        return $this->readOneof(3);
    }

    public function hasCsvReadInstances()
    {
        return $this->hasOneof(3);
    }

    /**
     * Each read instance consists of exactly one read timestamp and one or more
     * entity IDs identifying entities of the corresponding EntityTypes whose
     * Features are requested.
     * Each output instance contains Feature values of requested entities
     * concatenated together as of the read time.
     * An example read instance may be `foo_entity_id, bar_entity_id,
     * 2020-01-01T10:00:00.123Z`.
     * An example output instance may be `foo_entity_id, bar_entity_id,
     * 2020-01-01T10:00:00.123Z, foo_entity_feature1_value,
     * bar_entity_feature2_value`.
     * Timestamp in each read instance must be millisecond-aligned.
     * `csv_read_instances` are read instances stored in a plain-text CSV file.
     * The header should be:
     *     [ENTITY_TYPE_ID1], [ENTITY_TYPE_ID2], ..., timestamp
     * The columns can be in any order.
     * Values in the timestamp column must use the RFC 3339 format, e.g.
     * `2012-07-30T10:43:17.123Z`.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.CsvSource csv_read_instances = 3;</code>
     * @param \Google\Cloud\AIPlatform\V1\CsvSource $var
     * @return $this
     */
    public function setCsvReadInstances($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\CsvSource::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Similar to csv_read_instances, but from BigQuery source.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.BigQuerySource bigquery_read_instances = 5;</code>
     * @return \Google\Cloud\AIPlatform\V1\BigQuerySource|null
     */
    public function getBigqueryReadInstances()
    {
        return $this->readOneof(5);
    }

    public function hasBigqueryReadInstances()
    {
        return $this->hasOneof(5);
    }

    /**
     * Similar to csv_read_instances, but from BigQuery source.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.BigQuerySource bigquery_read_instances = 5;</code>
     * @param \Google\Cloud\AIPlatform\V1\BigQuerySource $var
     * @return $this
     */
    public function setBigqueryReadInstances($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\BigQuerySource::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Required. The resource name of the Featurestore from which to query Feature values.
     * Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}`
     *
     * Generated from protobuf field <code>string featurestore = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getFeaturestore()
    {
        return $this->featurestore;
    }

    /**
     * Required. The resource name of the Featurestore from which to query Feature values.
     * Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}`
     *
     * Generated from protobuf field <code>string featurestore = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setFeaturestore($var)
    {
        GPBUtil::checkString($var, True);
        $this->featurestore = $var;

        return $this;
    }

    /**
     * Required. Specifies output location and format.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.FeatureValueDestination destination = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\AIPlatform\V1\FeatureValueDestination|null
     */
    public function getDestination()
    {
        return $this->destination;
    }

    public function hasDestination()
    {
        return isset($this->destination);
    }

    public function clearDestination()
    {
        unset($this->destination);
    }

    /**
     * Required. Specifies output location and format.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.FeatureValueDestination destination = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\AIPlatform\V1\FeatureValueDestination $var
     * @return $this
     */
    public function setDestination($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\FeatureValueDestination::class);
        $this->destination = $var;

        return $this;
    }

    /**
     * When not empty, the specified fields in the *_read_instances source will be
     * joined as-is in the output, in addition to those fields from the
     * Featurestore Entity.
     * For BigQuery source, the type of the pass-through values will be
     * automatically inferred. For CSV source, the pass-through values will be
     * passed as opaque bytes.
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest.PassThroughField pass_through_fields = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPassThroughFields()
    {
        return $this->pass_through_fields;
    }

    /**
     * When not empty, the specified fields in the *_read_instances source will be
     * joined as-is in the output, in addition to those fields from the
     * Featurestore Entity.
     * For BigQuery source, the type of the pass-through values will be
     * automatically inferred. For CSV source, the pass-through values will be
     * passed as opaque bytes.
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest.PassThroughField pass_through_fields = 8;</code>
     * @param array<\Google\Cloud\AIPlatform\V1\BatchReadFeatureValuesRequest\PassThroughField>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPassThroughFields($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\AIPlatform\V1\BatchReadFeatureValuesRequest\PassThroughField::class);
        $this->pass_through_fields = $arr;

        return $this;
    }

    /**
     * Required. Specifies EntityType grouping Features to read values of and settings.
     * Each EntityType referenced in
     * [BatchReadFeatureValuesRequest.entity_type_specs] must have a column
     * specifying entity IDs in the EntityType in
     * [BatchReadFeatureValuesRequest.request][] .
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest.EntityTypeSpec entity_type_specs = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEntityTypeSpecs()
    {
        return $this->entity_type_specs;
    }

    /**
     * Required. Specifies EntityType grouping Features to read values of and settings.
     * Each EntityType referenced in
     * [BatchReadFeatureValuesRequest.entity_type_specs] must have a column
     * specifying entity IDs in the EntityType in
     * [BatchReadFeatureValuesRequest.request][] .
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest.EntityTypeSpec entity_type_specs = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Cloud\AIPlatform\V1\BatchReadFeatureValuesRequest\EntityTypeSpec>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEntityTypeSpecs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\AIPlatform\V1\BatchReadFeatureValuesRequest\EntityTypeSpec::class);
        $this->entity_type_specs = $arr;

        return $this;
    }

    /**
     * Optional. Excludes Feature values with feature generation timestamp before this
     * timestamp. If not set, retrieve oldest values kept in Feature Store.
     * Timestamp, if present, must not have higher than millisecond precision.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getStartTime()
    {
        return $this->start_time;
    }

    public function hasStartTime()
    {
        return isset($this->start_time);
    }

    public function clearStartTime()
    {
        unset($this->start_time);
    }

    /**
     * Optional. Excludes Feature values with feature generation timestamp before this
     * timestamp. If not set, retrieve oldest values kept in Feature Store.
     * Timestamp, if present, must not have higher than millisecond precision.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->start_time = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getReadOption()
    {
        return $this->whichOneof("read_option");
    }

}

