<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/v1/transaction.proto

namespace Google\Cloud\Spanner\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Options to use for transactions.
 *
 * Generated from protobuf message <code>google.spanner.v1.TransactionOptions</code>
 */
class TransactionOptions extends \Google\Protobuf\Internal\Message
{
    /**
     * When `exclude_txn_from_change_streams` is set to `true`, it prevents read
     * or write transactions from being tracked in change streams.
     * * If the DDL option `allow_txn_exclusion` is set to `true`, then the
     * updates
     *  made within this transaction aren't recorded in the change stream.
     * * If you don't set the DDL option `allow_txn_exclusion` or if it's
     *  set to `false`, then the updates made within this transaction are
     *  recorded in the change stream.
     * When `exclude_txn_from_change_streams` is set to `false` or not set,
     * modifications from this transaction are recorded in all change streams
     * that are tracking columns modified by these transactions.
     * The `exclude_txn_from_change_streams` option can only be specified
     * for read-write or partitioned DML transactions, otherwise the API returns
     * an `INVALID_ARGUMENT` error.
     *
     * Generated from protobuf field <code>bool exclude_txn_from_change_streams = 5;</code>
     */
    private $exclude_txn_from_change_streams = false;
    /**
     * Isolation level for the transaction.
     *
     * Generated from protobuf field <code>.google.spanner.v1.TransactionOptions.IsolationLevel isolation_level = 6;</code>
     */
    private $isolation_level = 0;
    protected $mode;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Spanner\V1\TransactionOptions\ReadWrite $read_write
     *           Transaction may write.
     *           Authorization to begin a read-write transaction requires
     *           `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     *           on the `session` resource.
     *     @type \Google\Cloud\Spanner\V1\TransactionOptions\PartitionedDml $partitioned_dml
     *           Partitioned DML transaction.
     *           Authorization to begin a Partitioned DML transaction requires
     *           `spanner.databases.beginPartitionedDmlTransaction` permission
     *           on the `session` resource.
     *     @type \Google\Cloud\Spanner\V1\TransactionOptions\PBReadOnly $read_only
     *           Transaction does not write.
     *           Authorization to begin a read-only transaction requires
     *           `spanner.databases.beginReadOnlyTransaction` permission
     *           on the `session` resource.
     *     @type bool $exclude_txn_from_change_streams
     *           When `exclude_txn_from_change_streams` is set to `true`, it prevents read
     *           or write transactions from being tracked in change streams.
     *           * If the DDL option `allow_txn_exclusion` is set to `true`, then the
     *           updates
     *            made within this transaction aren't recorded in the change stream.
     *           * If you don't set the DDL option `allow_txn_exclusion` or if it's
     *            set to `false`, then the updates made within this transaction are
     *            recorded in the change stream.
     *           When `exclude_txn_from_change_streams` is set to `false` or not set,
     *           modifications from this transaction are recorded in all change streams
     *           that are tracking columns modified by these transactions.
     *           The `exclude_txn_from_change_streams` option can only be specified
     *           for read-write or partitioned DML transactions, otherwise the API returns
     *           an `INVALID_ARGUMENT` error.
     *     @type int $isolation_level
     *           Isolation level for the transaction.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\V1\Transaction::initOnce();
        parent::__construct($data);
    }

    /**
     * Transaction may write.
     * Authorization to begin a read-write transaction requires
     * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     * on the `session` resource.
     *
     * Generated from protobuf field <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     * @return \Google\Cloud\Spanner\V1\TransactionOptions\ReadWrite|null
     */
    public function getReadWrite()
    {
        return $this->readOneof(1);
    }

    public function hasReadWrite()
    {
        return $this->hasOneof(1);
    }

    /**
     * Transaction may write.
     * Authorization to begin a read-write transaction requires
     * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     * on the `session` resource.
     *
     * Generated from protobuf field <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     * @param \Google\Cloud\Spanner\V1\TransactionOptions\ReadWrite $var
     * @return $this
     */
    public function setReadWrite($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\V1\TransactionOptions\ReadWrite::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Partitioned DML transaction.
     * Authorization to begin a Partitioned DML transaction requires
     * `spanner.databases.beginPartitionedDmlTransaction` permission
     * on the `session` resource.
     *
     * Generated from protobuf field <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
     * @return \Google\Cloud\Spanner\V1\TransactionOptions\PartitionedDml|null
     */
    public function getPartitionedDml()
    {
        return $this->readOneof(3);
    }

    public function hasPartitionedDml()
    {
        return $this->hasOneof(3);
    }

    /**
     * Partitioned DML transaction.
     * Authorization to begin a Partitioned DML transaction requires
     * `spanner.databases.beginPartitionedDmlTransaction` permission
     * on the `session` resource.
     *
     * Generated from protobuf field <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
     * @param \Google\Cloud\Spanner\V1\TransactionOptions\PartitionedDml $var
     * @return $this
     */
    public function setPartitionedDml($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\V1\TransactionOptions\PartitionedDml::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Transaction does not write.
     * Authorization to begin a read-only transaction requires
     * `spanner.databases.beginReadOnlyTransaction` permission
     * on the `session` resource.
     *
     * Generated from protobuf field <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     * @return \Google\Cloud\Spanner\V1\TransactionOptions\PBReadOnly|null
     */
    public function getReadOnly()
    {
        return $this->readOneof(2);
    }

    public function hasReadOnly()
    {
        return $this->hasOneof(2);
    }

    /**
     * Transaction does not write.
     * Authorization to begin a read-only transaction requires
     * `spanner.databases.beginReadOnlyTransaction` permission
     * on the `session` resource.
     *
     * Generated from protobuf field <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     * @param \Google\Cloud\Spanner\V1\TransactionOptions\PBReadOnly $var
     * @return $this
     */
    public function setReadOnly($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\V1\TransactionOptions\PBReadOnly::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * When `exclude_txn_from_change_streams` is set to `true`, it prevents read
     * or write transactions from being tracked in change streams.
     * * If the DDL option `allow_txn_exclusion` is set to `true`, then the
     * updates
     *  made within this transaction aren't recorded in the change stream.
     * * If you don't set the DDL option `allow_txn_exclusion` or if it's
     *  set to `false`, then the updates made within this transaction are
     *  recorded in the change stream.
     * When `exclude_txn_from_change_streams` is set to `false` or not set,
     * modifications from this transaction are recorded in all change streams
     * that are tracking columns modified by these transactions.
     * The `exclude_txn_from_change_streams` option can only be specified
     * for read-write or partitioned DML transactions, otherwise the API returns
     * an `INVALID_ARGUMENT` error.
     *
     * Generated from protobuf field <code>bool exclude_txn_from_change_streams = 5;</code>
     * @return bool
     */
    public function getExcludeTxnFromChangeStreams()
    {
        return $this->exclude_txn_from_change_streams;
    }

    /**
     * When `exclude_txn_from_change_streams` is set to `true`, it prevents read
     * or write transactions from being tracked in change streams.
     * * If the DDL option `allow_txn_exclusion` is set to `true`, then the
     * updates
     *  made within this transaction aren't recorded in the change stream.
     * * If you don't set the DDL option `allow_txn_exclusion` or if it's
     *  set to `false`, then the updates made within this transaction are
     *  recorded in the change stream.
     * When `exclude_txn_from_change_streams` is set to `false` or not set,
     * modifications from this transaction are recorded in all change streams
     * that are tracking columns modified by these transactions.
     * The `exclude_txn_from_change_streams` option can only be specified
     * for read-write or partitioned DML transactions, otherwise the API returns
     * an `INVALID_ARGUMENT` error.
     *
     * Generated from protobuf field <code>bool exclude_txn_from_change_streams = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setExcludeTxnFromChangeStreams($var)
    {
        GPBUtil::checkBool($var);
        $this->exclude_txn_from_change_streams = $var;

        return $this;
    }

    /**
     * Isolation level for the transaction.
     *
     * Generated from protobuf field <code>.google.spanner.v1.TransactionOptions.IsolationLevel isolation_level = 6;</code>
     * @return int
     */
    public function getIsolationLevel()
    {
        return $this->isolation_level;
    }

    /**
     * Isolation level for the transaction.
     *
     * Generated from protobuf field <code>.google.spanner.v1.TransactionOptions.IsolationLevel isolation_level = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setIsolationLevel($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Spanner\V1\TransactionOptions\IsolationLevel::class);
        $this->isolation_level = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getMode()
    {
        return $this->whichOneof("mode");
    }

}

