<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/admin/instance/v1/spanner_instance_admin.proto

namespace Google\Cloud\Spanner\Admin\Instance\V1\AutoscalingConfig;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The autoscaling limits for the instance. Users can define the minimum and
 * maximum compute capacity allocated to the instance, and the autoscaler will
 * only scale within that range. Users can either use nodes or processing
 * units to specify the limits, but should use the same unit to set both the
 * min_limit and max_limit.
 *
 * Generated from protobuf message <code>google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits</code>
 */
class AutoscalingLimits extends \Google\Protobuf\Internal\Message
{
    protected $min_limit;
    protected $max_limit;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $min_nodes
     *           Minimum number of nodes allocated to the instance. If set, this number
     *           should be greater than or equal to 1.
     *     @type int $min_processing_units
     *           Minimum number of processing units allocated to the instance. If set,
     *           this number should be multiples of 1000.
     *     @type int $max_nodes
     *           Maximum number of nodes allocated to the instance. If set, this number
     *           should be greater than or equal to min_nodes.
     *     @type int $max_processing_units
     *           Maximum number of processing units allocated to the instance. If set,
     *           this number should be multiples of 1000 and be greater than or equal to
     *           min_processing_units.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\Admin\Instance\V1\SpannerInstanceAdmin::initOnce();
        parent::__construct($data);
    }

    /**
     * Minimum number of nodes allocated to the instance. If set, this number
     * should be greater than or equal to 1.
     *
     * Generated from protobuf field <code>int32 min_nodes = 1;</code>
     * @return int
     */
    public function getMinNodes()
    {
        return $this->readOneof(1);
    }

    public function hasMinNodes()
    {
        return $this->hasOneof(1);
    }

    /**
     * Minimum number of nodes allocated to the instance. If set, this number
     * should be greater than or equal to 1.
     *
     * Generated from protobuf field <code>int32 min_nodes = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setMinNodes($var)
    {
        GPBUtil::checkInt32($var);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Minimum number of processing units allocated to the instance. If set,
     * this number should be multiples of 1000.
     *
     * Generated from protobuf field <code>int32 min_processing_units = 2;</code>
     * @return int
     */
    public function getMinProcessingUnits()
    {
        return $this->readOneof(2);
    }

    public function hasMinProcessingUnits()
    {
        return $this->hasOneof(2);
    }

    /**
     * Minimum number of processing units allocated to the instance. If set,
     * this number should be multiples of 1000.
     *
     * Generated from protobuf field <code>int32 min_processing_units = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setMinProcessingUnits($var)
    {
        GPBUtil::checkInt32($var);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Maximum number of nodes allocated to the instance. If set, this number
     * should be greater than or equal to min_nodes.
     *
     * Generated from protobuf field <code>int32 max_nodes = 3;</code>
     * @return int
     */
    public function getMaxNodes()
    {
        return $this->readOneof(3);
    }

    public function hasMaxNodes()
    {
        return $this->hasOneof(3);
    }

    /**
     * Maximum number of nodes allocated to the instance. If set, this number
     * should be greater than or equal to min_nodes.
     *
     * Generated from protobuf field <code>int32 max_nodes = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxNodes($var)
    {
        GPBUtil::checkInt32($var);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Maximum number of processing units allocated to the instance. If set,
     * this number should be multiples of 1000 and be greater than or equal to
     * min_processing_units.
     *
     * Generated from protobuf field <code>int32 max_processing_units = 4;</code>
     * @return int
     */
    public function getMaxProcessingUnits()
    {
        return $this->readOneof(4);
    }

    public function hasMaxProcessingUnits()
    {
        return $this->hasOneof(4);
    }

    /**
     * Maximum number of processing units allocated to the instance. If set,
     * this number should be multiples of 1000 and be greater than or equal to
     * min_processing_units.
     *
     * Generated from protobuf field <code>int32 max_processing_units = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxProcessingUnits($var)
    {
        GPBUtil::checkInt32($var);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getMinLimit()
    {
        return $this->whichOneof("min_limit");
    }

    /**
     * @return string
     */
    public function getMaxLimit()
    {
        return $this->whichOneof("max_limit");
    }

}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AutoscalingLimits::class, \Google\Cloud\Spanner\Admin\Instance\V1\AutoscalingConfig_AutoscalingLimits::class);

