<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/accounts/v1/homepage.proto

namespace Google\Shopping\Merchant\Accounts\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The `Homepage` message represents a business's store homepage within the
 * system.
 * A business's homepage is the primary domain where customers interact with
 * their store.
 * The homepage can be claimed and verified as a proof of ownership and allows
 * the business to unlock features that require a verified website. For more
 * information, see [Understanding online store URL
 * verification](//support.google.com/merchants/answer/176793).
 *
 * Generated from protobuf message <code>google.shopping.merchant.accounts.v1.Homepage</code>
 */
class Homepage extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name of the store's homepage.
     * Format: `accounts/{account}/homepage`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. The URI (typically a URL) of the store's homepage.
     *
     * Generated from protobuf field <code>optional string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $uri = null;
    /**
     * Output only. Whether the homepage is claimed. See
     * https://support.google.com/merchants/answer/176793.
     *
     * Generated from protobuf field <code>bool claimed = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $claimed = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The resource name of the store's homepage.
     *           Format: `accounts/{account}/homepage`
     *     @type string $uri
     *           Required. The URI (typically a URL) of the store's homepage.
     *     @type bool $claimed
     *           Output only. Whether the homepage is claimed. See
     *           https://support.google.com/merchants/answer/176793.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Accounts\V1\Homepage::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The resource name of the store's homepage.
     * Format: `accounts/{account}/homepage`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name of the store's homepage.
     * Format: `accounts/{account}/homepage`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The URI (typically a URL) of the store's homepage.
     *
     * Generated from protobuf field <code>optional string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getUri()
    {
        return isset($this->uri) ? $this->uri : '';
    }

    public function hasUri()
    {
        return isset($this->uri);
    }

    public function clearUri()
    {
        unset($this->uri);
    }

    /**
     * Required. The URI (typically a URL) of the store's homepage.
     *
     * Generated from protobuf field <code>optional string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->uri = $var;

        return $this;
    }

    /**
     * Output only. Whether the homepage is claimed. See
     * https://support.google.com/merchants/answer/176793.
     *
     * Generated from protobuf field <code>bool claimed = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getClaimed()
    {
        return $this->claimed;
    }

    /**
     * Output only. Whether the homepage is claimed. See
     * https://support.google.com/merchants/answer/176793.
     *
     * Generated from protobuf field <code>bool claimed = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setClaimed($var)
    {
        GPBUtil::checkBool($var);
        $this->claimed = $var;

        return $this;
    }

}

