<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/api/cloudquotas/v1beta/resources.proto

namespace Google\Cloud\CloudQuotas\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * QuotaPreference represents the preferred quota configuration specified for
 * a project, folder or organization. There is only one QuotaPreference
 * resource for a quota value targeting a unique set of dimensions.
 *
 * Generated from protobuf message <code>google.api.cloudquotas.v1beta.QuotaPreference</code>
 */
class QuotaPreference extends \Google\Protobuf\Internal\Message
{
    /**
     * Required except in the CREATE requests.
     * The resource name of the quota preference.
     * The path that follows `/locations` must be `/global`.
     * For example:
     * `projects/123/locations/global/quotaPreferences/my-config-for-us-east1`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Immutable. The dimensions that this quota preference applies to. The key of
     * the map entry is the name of a dimension, such as `region`, `zone`,
     * `network_id`, and the value of the map entry is the dimension value.
     * If a dimension is missing from the map of dimensions, the quota preference
     * applies to all the dimension values except for those that have other quota
     * preferences configured for the specific value.
     * Note: QuotaPreferences can only be applied across all values of `user` and
     * `resource` dimension. Do not set values for `user` or `resource` in the
     * dimension map.
     * For example: `{"provider" : "Example Organization"}` where `provider` is a
     * service-specific quota dimension and `Example Organization` is the provider
     * name.
     *
     * Generated from protobuf field <code>map<string, string> dimensions = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $dimensions;
    /**
     * Required. Preferred quota configuration.
     *
     * Generated from protobuf field <code>.google.api.cloudquotas.v1beta.QuotaConfig quota_config = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $quota_config = null;
    /**
     * Optional. The current etag of the quota preference. If an etag is provided
     * on update and does not match the current server's etag of the quota
     * preference, the request will be blocked and an ABORTED error will be
     * returned. See https://google.aip.dev/134#etags for more details on etags.
     *
     * Generated from protobuf field <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $etag = '';
    /**
     * Output only. Create time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. Update time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Required. The name of the service to which the quota preference is applied.
     *
     * Generated from protobuf field <code>string service = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $service = '';
    /**
     * Required. The id of the quota to which the quota preference is applied. A
     * quota name is unique in the service. For example, `CpusPerProjectPerRegion`
     *
     * Generated from protobuf field <code>string quota_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $quota_id = '';
    /**
     * Output only. Is the quota preference pending Google Cloud approval and
     * fulfillment.
     *
     * Generated from protobuf field <code>bool reconciling = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $reconciling = false;
    /**
     * The reason / justification for this quota preference.
     *
     * Generated from protobuf field <code>string justification = 11;</code>
     */
    protected $justification = '';
    /**
     * Input only. An email address that can be used to contact the user, in case
     * Google Cloud needs more information to make a decision before additional
     * quota can be granted.
     * When requesting a quota increase, the email address is required.
     * When requesting a quota decrease, the email address is optional.
     * For example, the email address is optional when the
     * `QuotaConfig.preferred_value` is smaller than the
     * `QuotaDetails.reset_value`.
     *
     * Generated from protobuf field <code>string contact_email = 12 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    protected $contact_email = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required except in the CREATE requests.
     *           The resource name of the quota preference.
     *           The path that follows `/locations` must be `/global`.
     *           For example:
     *           `projects/123/locations/global/quotaPreferences/my-config-for-us-east1`
     *     @type array|\Google\Protobuf\Internal\MapField $dimensions
     *           Immutable. The dimensions that this quota preference applies to. The key of
     *           the map entry is the name of a dimension, such as `region`, `zone`,
     *           `network_id`, and the value of the map entry is the dimension value.
     *           If a dimension is missing from the map of dimensions, the quota preference
     *           applies to all the dimension values except for those that have other quota
     *           preferences configured for the specific value.
     *           Note: QuotaPreferences can only be applied across all values of `user` and
     *           `resource` dimension. Do not set values for `user` or `resource` in the
     *           dimension map.
     *           For example: `{"provider" : "Example Organization"}` where `provider` is a
     *           service-specific quota dimension and `Example Organization` is the provider
     *           name.
     *     @type \Google\Cloud\CloudQuotas\V1beta\QuotaConfig $quota_config
     *           Required. Preferred quota configuration.
     *     @type string $etag
     *           Optional. The current etag of the quota preference. If an etag is provided
     *           on update and does not match the current server's etag of the quota
     *           preference, the request will be blocked and an ABORTED error will be
     *           returned. See https://google.aip.dev/134#etags for more details on etags.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Create time stamp
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Update time stamp
     *     @type string $service
     *           Required. The name of the service to which the quota preference is applied.
     *     @type string $quota_id
     *           Required. The id of the quota to which the quota preference is applied. A
     *           quota name is unique in the service. For example, `CpusPerProjectPerRegion`
     *     @type bool $reconciling
     *           Output only. Is the quota preference pending Google Cloud approval and
     *           fulfillment.
     *     @type string $justification
     *           The reason / justification for this quota preference.
     *     @type string $contact_email
     *           Input only. An email address that can be used to contact the user, in case
     *           Google Cloud needs more information to make a decision before additional
     *           quota can be granted.
     *           When requesting a quota increase, the email address is required.
     *           When requesting a quota decrease, the email address is optional.
     *           For example, the email address is optional when the
     *           `QuotaConfig.preferred_value` is smaller than the
     *           `QuotaDetails.reset_value`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Api\Cloudquotas\V1Beta\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * Required except in the CREATE requests.
     * The resource name of the quota preference.
     * The path that follows `/locations` must be `/global`.
     * For example:
     * `projects/123/locations/global/quotaPreferences/my-config-for-us-east1`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required except in the CREATE requests.
     * The resource name of the quota preference.
     * The path that follows `/locations` must be `/global`.
     * For example:
     * `projects/123/locations/global/quotaPreferences/my-config-for-us-east1`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Immutable. The dimensions that this quota preference applies to. The key of
     * the map entry is the name of a dimension, such as `region`, `zone`,
     * `network_id`, and the value of the map entry is the dimension value.
     * If a dimension is missing from the map of dimensions, the quota preference
     * applies to all the dimension values except for those that have other quota
     * preferences configured for the specific value.
     * Note: QuotaPreferences can only be applied across all values of `user` and
     * `resource` dimension. Do not set values for `user` or `resource` in the
     * dimension map.
     * For example: `{"provider" : "Example Organization"}` where `provider` is a
     * service-specific quota dimension and `Example Organization` is the provider
     * name.
     *
     * Generated from protobuf field <code>map<string, string> dimensions = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getDimensions()
    {
        return $this->dimensions;
    }

    /**
     * Immutable. The dimensions that this quota preference applies to. The key of
     * the map entry is the name of a dimension, such as `region`, `zone`,
     * `network_id`, and the value of the map entry is the dimension value.
     * If a dimension is missing from the map of dimensions, the quota preference
     * applies to all the dimension values except for those that have other quota
     * preferences configured for the specific value.
     * Note: QuotaPreferences can only be applied across all values of `user` and
     * `resource` dimension. Do not set values for `user` or `resource` in the
     * dimension map.
     * For example: `{"provider" : "Example Organization"}` where `provider` is a
     * service-specific quota dimension and `Example Organization` is the provider
     * name.
     *
     * Generated from protobuf field <code>map<string, string> dimensions = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setDimensions($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->dimensions = $arr;

        return $this;
    }

    /**
     * Required. Preferred quota configuration.
     *
     * Generated from protobuf field <code>.google.api.cloudquotas.v1beta.QuotaConfig quota_config = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\CloudQuotas\V1beta\QuotaConfig|null
     */
    public function getQuotaConfig()
    {
        return $this->quota_config;
    }

    public function hasQuotaConfig()
    {
        return isset($this->quota_config);
    }

    public function clearQuotaConfig()
    {
        unset($this->quota_config);
    }

    /**
     * Required. Preferred quota configuration.
     *
     * Generated from protobuf field <code>.google.api.cloudquotas.v1beta.QuotaConfig quota_config = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\CloudQuotas\V1beta\QuotaConfig $var
     * @return $this
     */
    public function setQuotaConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudQuotas\V1beta\QuotaConfig::class);
        $this->quota_config = $var;

        return $this;
    }

    /**
     * Optional. The current etag of the quota preference. If an etag is provided
     * on update and does not match the current server's etag of the quota
     * preference, the request will be blocked and an ABORTED error will be
     * returned. See https://google.aip.dev/134#etags for more details on etags.
     *
     * Generated from protobuf field <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Optional. The current etag of the quota preference. If an etag is provided
     * on update and does not match the current server's etag of the quota
     * preference, the request will be blocked and an ABORTED error will be
     * returned. See https://google.aip.dev/134#etags for more details on etags.
     *
     * Generated from protobuf field <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * Output only. Create time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Create time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Update time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Update time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Required. The name of the service to which the quota preference is applied.
     *
     * Generated from protobuf field <code>string service = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }

    /**
     * Required. The name of the service to which the quota preference is applied.
     *
     * Generated from protobuf field <code>string service = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setService($var)
    {
        GPBUtil::checkString($var, True);
        $this->service = $var;

        return $this;
    }

    /**
     * Required. The id of the quota to which the quota preference is applied. A
     * quota name is unique in the service. For example, `CpusPerProjectPerRegion`
     *
     * Generated from protobuf field <code>string quota_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getQuotaId()
    {
        return $this->quota_id;
    }

    /**
     * Required. The id of the quota to which the quota preference is applied. A
     * quota name is unique in the service. For example, `CpusPerProjectPerRegion`
     *
     * Generated from protobuf field <code>string quota_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setQuotaId($var)
    {
        GPBUtil::checkString($var, True);
        $this->quota_id = $var;

        return $this;
    }

    /**
     * Output only. Is the quota preference pending Google Cloud approval and
     * fulfillment.
     *
     * Generated from protobuf field <code>bool reconciling = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getReconciling()
    {
        return $this->reconciling;
    }

    /**
     * Output only. Is the quota preference pending Google Cloud approval and
     * fulfillment.
     *
     * Generated from protobuf field <code>bool reconciling = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setReconciling($var)
    {
        GPBUtil::checkBool($var);
        $this->reconciling = $var;

        return $this;
    }

    /**
     * The reason / justification for this quota preference.
     *
     * Generated from protobuf field <code>string justification = 11;</code>
     * @return string
     */
    public function getJustification()
    {
        return $this->justification;
    }

    /**
     * The reason / justification for this quota preference.
     *
     * Generated from protobuf field <code>string justification = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setJustification($var)
    {
        GPBUtil::checkString($var, True);
        $this->justification = $var;

        return $this;
    }

    /**
     * Input only. An email address that can be used to contact the user, in case
     * Google Cloud needs more information to make a decision before additional
     * quota can be granted.
     * When requesting a quota increase, the email address is required.
     * When requesting a quota decrease, the email address is optional.
     * For example, the email address is optional when the
     * `QuotaConfig.preferred_value` is smaller than the
     * `QuotaDetails.reset_value`.
     *
     * Generated from protobuf field <code>string contact_email = 12 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return string
     */
    public function getContactEmail()
    {
        return $this->contact_email;
    }

    /**
     * Input only. An email address that can be used to contact the user, in case
     * Google Cloud needs more information to make a decision before additional
     * quota can be granted.
     * When requesting a quota increase, the email address is required.
     * When requesting a quota decrease, the email address is optional.
     * For example, the email address is optional when the
     * `QuotaConfig.preferred_value` is smaller than the
     * `QuotaDetails.reset_value`.
     *
     * Generated from protobuf field <code>string contact_email = 12 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setContactEmail($var)
    {
        GPBUtil::checkString($var, True);
        $this->contact_email = $var;

        return $this;
    }

}

