<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dataproc/v1/clusters.proto

namespace Google\Cloud\Dataproc\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A request to collect cluster diagnostic information.
 *
 * Generated from protobuf message <code>google.cloud.dataproc.v1.DiagnoseClusterRequest</code>
 */
class DiagnoseClusterRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The ID of the Google Cloud Platform project that the cluster
     * belongs to.
     *
     * Generated from protobuf field <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $project_id = '';
    /**
     * Required. The Dataproc region in which to handle the request.
     *
     * Generated from protobuf field <code>string region = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $region = '';
    /**
     * Required. The cluster name.
     *
     * Generated from protobuf field <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $cluster_name = '';
    /**
     * Optional. (Optional) The output Cloud Storage directory for the diagnostic
     * tarball. If not specified, a task-specific directory in the cluster's
     * staging bucket will be used.
     *
     * Generated from protobuf field <code>string tarball_gcs_dir = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $tarball_gcs_dir = '';
    /**
     * Optional. (Optional) The access type to the diagnostic tarball. If not
     * specified, falls back to default access of the bucket
     *
     * Generated from protobuf field <code>.google.cloud.dataproc.v1.DiagnoseClusterRequest.TarballAccess tarball_access = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $tarball_access = 0;
    /**
     * Optional. Time interval in which diagnosis should be carried out on the
     * cluster.
     *
     * Generated from protobuf field <code>.google.type.Interval diagnosis_interval = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $diagnosis_interval = null;
    /**
     * Optional. Specifies a list of jobs on which diagnosis is to be performed.
     * Format: projects/{project}/regions/{region}/jobs/{job}
     *
     * Generated from protobuf field <code>repeated string jobs = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $jobs;
    /**
     * Optional. Specifies a list of yarn applications on which diagnosis is to be
     * performed.
     *
     * Generated from protobuf field <code>repeated string yarn_application_ids = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $yarn_application_ids;

    /**
     * @param string $projectId   Required. The ID of the Google Cloud Platform project that the cluster
     *                            belongs to.
     * @param string $region      Required. The Dataproc region in which to handle the request.
     * @param string $clusterName Required. The cluster name.
     *
     * @return \Google\Cloud\Dataproc\V1\DiagnoseClusterRequest
     *
     * @experimental
     */
    public static function build(string $projectId, string $region, string $clusterName): self
    {
        return (new self())
            ->setProjectId($projectId)
            ->setRegion($region)
            ->setClusterName($clusterName);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $project_id
     *           Required. The ID of the Google Cloud Platform project that the cluster
     *           belongs to.
     *     @type string $region
     *           Required. The Dataproc region in which to handle the request.
     *     @type string $cluster_name
     *           Required. The cluster name.
     *     @type string $tarball_gcs_dir
     *           Optional. (Optional) The output Cloud Storage directory for the diagnostic
     *           tarball. If not specified, a task-specific directory in the cluster's
     *           staging bucket will be used.
     *     @type int $tarball_access
     *           Optional. (Optional) The access type to the diagnostic tarball. If not
     *           specified, falls back to default access of the bucket
     *     @type \Google\Type\Interval $diagnosis_interval
     *           Optional. Time interval in which diagnosis should be carried out on the
     *           cluster.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $jobs
     *           Optional. Specifies a list of jobs on which diagnosis is to be performed.
     *           Format: projects/{project}/regions/{region}/jobs/{job}
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $yarn_application_ids
     *           Optional. Specifies a list of yarn applications on which diagnosis is to be
     *           performed.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dataproc\V1\Clusters::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The ID of the Google Cloud Platform project that the cluster
     * belongs to.
     *
     * Generated from protobuf field <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getProjectId()
    {
        return $this->project_id;
    }

    /**
     * Required. The ID of the Google Cloud Platform project that the cluster
     * belongs to.
     *
     * Generated from protobuf field <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setProjectId($var)
    {
        GPBUtil::checkString($var, True);
        $this->project_id = $var;

        return $this;
    }

    /**
     * Required. The Dataproc region in which to handle the request.
     *
     * Generated from protobuf field <code>string region = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * Required. The Dataproc region in which to handle the request.
     *
     * Generated from protobuf field <code>string region = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setRegion($var)
    {
        GPBUtil::checkString($var, True);
        $this->region = $var;

        return $this;
    }

    /**
     * Required. The cluster name.
     *
     * Generated from protobuf field <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getClusterName()
    {
        return $this->cluster_name;
    }

    /**
     * Required. The cluster name.
     *
     * Generated from protobuf field <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setClusterName($var)
    {
        GPBUtil::checkString($var, True);
        $this->cluster_name = $var;

        return $this;
    }

    /**
     * Optional. (Optional) The output Cloud Storage directory for the diagnostic
     * tarball. If not specified, a task-specific directory in the cluster's
     * staging bucket will be used.
     *
     * Generated from protobuf field <code>string tarball_gcs_dir = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getTarballGcsDir()
    {
        return $this->tarball_gcs_dir;
    }

    /**
     * Optional. (Optional) The output Cloud Storage directory for the diagnostic
     * tarball. If not specified, a task-specific directory in the cluster's
     * staging bucket will be used.
     *
     * Generated from protobuf field <code>string tarball_gcs_dir = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setTarballGcsDir($var)
    {
        GPBUtil::checkString($var, True);
        $this->tarball_gcs_dir = $var;

        return $this;
    }

    /**
     * Optional. (Optional) The access type to the diagnostic tarball. If not
     * specified, falls back to default access of the bucket
     *
     * Generated from protobuf field <code>.google.cloud.dataproc.v1.DiagnoseClusterRequest.TarballAccess tarball_access = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getTarballAccess()
    {
        return $this->tarball_access;
    }

    /**
     * Optional. (Optional) The access type to the diagnostic tarball. If not
     * specified, falls back to default access of the bucket
     *
     * Generated from protobuf field <code>.google.cloud.dataproc.v1.DiagnoseClusterRequest.TarballAccess tarball_access = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setTarballAccess($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dataproc\V1\DiagnoseClusterRequest\TarballAccess::class);
        $this->tarball_access = $var;

        return $this;
    }

    /**
     * Optional. Time interval in which diagnosis should be carried out on the
     * cluster.
     *
     * Generated from protobuf field <code>.google.type.Interval diagnosis_interval = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Type\Interval|null
     */
    public function getDiagnosisInterval()
    {
        return $this->diagnosis_interval;
    }

    public function hasDiagnosisInterval()
    {
        return isset($this->diagnosis_interval);
    }

    public function clearDiagnosisInterval()
    {
        unset($this->diagnosis_interval);
    }

    /**
     * Optional. Time interval in which diagnosis should be carried out on the
     * cluster.
     *
     * Generated from protobuf field <code>.google.type.Interval diagnosis_interval = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Type\Interval $var
     * @return $this
     */
    public function setDiagnosisInterval($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Interval::class);
        $this->diagnosis_interval = $var;

        return $this;
    }

    /**
     * Optional. Specifies a list of jobs on which diagnosis is to be performed.
     * Format: projects/{project}/regions/{region}/jobs/{job}
     *
     * Generated from protobuf field <code>repeated string jobs = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getJobs()
    {
        return $this->jobs;
    }

    /**
     * Optional. Specifies a list of jobs on which diagnosis is to be performed.
     * Format: projects/{project}/regions/{region}/jobs/{job}
     *
     * Generated from protobuf field <code>repeated string jobs = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setJobs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->jobs = $arr;

        return $this;
    }

    /**
     * Optional. Specifies a list of yarn applications on which diagnosis is to be
     * performed.
     *
     * Generated from protobuf field <code>repeated string yarn_application_ids = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getYarnApplicationIds()
    {
        return $this->yarn_application_ids;
    }

    /**
     * Optional. Specifies a list of yarn applications on which diagnosis is to be
     * performed.
     *
     * Generated from protobuf field <code>repeated string yarn_application_ids = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setYarnApplicationIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->yarn_application_ids = $arr;

        return $this;
    }

}

