<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/apihub/v1/common_fields.proto

namespace Google\Cloud\ApiHub\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * ConfigVariableTemplate represents a configuration variable template present
 * in a Plugin Config.
 *
 * Generated from protobuf message <code>google.cloud.apihub.v1.ConfigVariableTemplate</code>
 */
class ConfigVariableTemplate extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. ID of the config variable. Must be unique within the
     * configuration.
     *
     * Generated from protobuf field <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $id = '';
    /**
     * Required. Type of the parameter: string, int, bool etc.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.ConfigVariableTemplate.ValueType value_type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $value_type = 0;
    /**
     * Optional. Description.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Optional. Regular expression in RE2 syntax used for validating the `value`
     * of a `ConfigVariable`.
     *
     * Generated from protobuf field <code>string validation_regex = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $validation_regex = '';
    /**
     * Optional. Flag represents that this `ConfigVariable` must be provided for a
     * PluginInstance.
     *
     * Generated from protobuf field <code>bool required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $required = false;
    /**
     * Optional. Enum options. To be populated if `ValueType` is `ENUM`.
     *
     * Generated from protobuf field <code>repeated .google.cloud.apihub.v1.ConfigValueOption enum_options = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $enum_options;
    /**
     * Optional. Multi select options. To be populated if `ValueType` is
     * `MULTI_SELECT`.
     *
     * Generated from protobuf field <code>repeated .google.cloud.apihub.v1.ConfigValueOption multi_select_options = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $multi_select_options;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $id
     *           Required. ID of the config variable. Must be unique within the
     *           configuration.
     *     @type int $value_type
     *           Required. Type of the parameter: string, int, bool etc.
     *     @type string $description
     *           Optional. Description.
     *     @type string $validation_regex
     *           Optional. Regular expression in RE2 syntax used for validating the `value`
     *           of a `ConfigVariable`.
     *     @type bool $required
     *           Optional. Flag represents that this `ConfigVariable` must be provided for a
     *           PluginInstance.
     *     @type array<\Google\Cloud\ApiHub\V1\ConfigValueOption>|\Google\Protobuf\Internal\RepeatedField $enum_options
     *           Optional. Enum options. To be populated if `ValueType` is `ENUM`.
     *     @type array<\Google\Cloud\ApiHub\V1\ConfigValueOption>|\Google\Protobuf\Internal\RepeatedField $multi_select_options
     *           Optional. Multi select options. To be populated if `ValueType` is
     *           `MULTI_SELECT`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Apihub\V1\CommonFields::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. ID of the config variable. Must be unique within the
     * configuration.
     *
     * Generated from protobuf field <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Required. ID of the config variable. Must be unique within the
     * configuration.
     *
     * Generated from protobuf field <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * Required. Type of the parameter: string, int, bool etc.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.ConfigVariableTemplate.ValueType value_type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getValueType()
    {
        return $this->value_type;
    }

    /**
     * Required. Type of the parameter: string, int, bool etc.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.ConfigVariableTemplate.ValueType value_type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setValueType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\ApiHub\V1\ConfigVariableTemplate\ValueType::class);
        $this->value_type = $var;

        return $this;
    }

    /**
     * Optional. Description.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. Description.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Optional. Regular expression in RE2 syntax used for validating the `value`
     * of a `ConfigVariable`.
     *
     * Generated from protobuf field <code>string validation_regex = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getValidationRegex()
    {
        return $this->validation_regex;
    }

    /**
     * Optional. Regular expression in RE2 syntax used for validating the `value`
     * of a `ConfigVariable`.
     *
     * Generated from protobuf field <code>string validation_regex = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setValidationRegex($var)
    {
        GPBUtil::checkString($var, True);
        $this->validation_regex = $var;

        return $this;
    }

    /**
     * Optional. Flag represents that this `ConfigVariable` must be provided for a
     * PluginInstance.
     *
     * Generated from protobuf field <code>bool required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getRequired()
    {
        return $this->required;
    }

    /**
     * Optional. Flag represents that this `ConfigVariable` must be provided for a
     * PluginInstance.
     *
     * Generated from protobuf field <code>bool required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setRequired($var)
    {
        GPBUtil::checkBool($var);
        $this->required = $var;

        return $this;
    }

    /**
     * Optional. Enum options. To be populated if `ValueType` is `ENUM`.
     *
     * Generated from protobuf field <code>repeated .google.cloud.apihub.v1.ConfigValueOption enum_options = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEnumOptions()
    {
        return $this->enum_options;
    }

    /**
     * Optional. Enum options. To be populated if `ValueType` is `ENUM`.
     *
     * Generated from protobuf field <code>repeated .google.cloud.apihub.v1.ConfigValueOption enum_options = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\ApiHub\V1\ConfigValueOption>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEnumOptions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\ApiHub\V1\ConfigValueOption::class);
        $this->enum_options = $arr;

        return $this;
    }

    /**
     * Optional. Multi select options. To be populated if `ValueType` is
     * `MULTI_SELECT`.
     *
     * Generated from protobuf field <code>repeated .google.cloud.apihub.v1.ConfigValueOption multi_select_options = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMultiSelectOptions()
    {
        return $this->multi_select_options;
    }

    /**
     * Optional. Multi select options. To be populated if `ValueType` is
     * `MULTI_SELECT`.
     *
     * Generated from protobuf field <code>repeated .google.cloud.apihub.v1.ConfigValueOption multi_select_options = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\ApiHub\V1\ConfigValueOption>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMultiSelectOptions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\ApiHub\V1\ConfigValueOption::class);
        $this->multi_select_options = $arr;

        return $this;
    }

}

