<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/storagetransfer/v1/transfer_types.proto

namespace Google\Cloud\StorageTransfer\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * This resource represents the configuration of a transfer job that runs
 * periodically.
 *
 * Generated from protobuf message <code>google.storagetransfer.v1.TransferJob</code>
 */
class TransferJob extends \Google\Protobuf\Internal\Message
{
    /**
     * A unique name (within the transfer project) assigned when the job is
     * created.  If this field is empty in a CreateTransferJobRequest, Storage
     * Transfer Service assigns a unique name. Otherwise, the specified name
     * is used as the unique name for this job.
     * If the specified name is in use by a job, the creation request fails with
     * an [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS] error.
     * This name must start with `"transferJobs/"` prefix and end with a letter or
     * a number, and should be no more than 128 characters. For transfers
     * involving PosixFilesystem, this name must start with `transferJobs/OPI`
     * specifically. For all other transfer types, this name must not start with
     * `transferJobs/OPI`.
     * Non-PosixFilesystem example:
     * `"transferJobs/^(?!OPI)[A-Za-z0-9-._~]*[A-Za-z0-9]$"`
     * PosixFilesystem example:
     * `"transferJobs/OPI^[A-Za-z0-9-._~]*[A-Za-z0-9]$"`
     * Applications must not rely on the enforcement of naming requirements
     * involving OPI.
     * Invalid job names fail with an
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * A description provided by the user for the job. Its max length is 1024
     * bytes when Unicode-encoded.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     */
    protected $description = '';
    /**
     * The ID of the Google Cloud project that owns the job.
     *
     * Generated from protobuf field <code>string project_id = 3;</code>
     */
    protected $project_id = '';
    /**
     * Transfer specification.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.TransferSpec transfer_spec = 4;</code>
     */
    protected $transfer_spec = null;
    /**
     * Replication specification.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.ReplicationSpec replication_spec = 17;</code>
     */
    protected $replication_spec = null;
    /**
     * Notification configuration.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.NotificationConfig notification_config = 11;</code>
     */
    protected $notification_config = null;
    /**
     * Logging configuration.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.LoggingConfig logging_config = 14;</code>
     */
    protected $logging_config = null;
    /**
     * Specifies schedule for the transfer job.
     * This is an optional field. When the field is not set, the job never
     * executes a transfer, unless you invoke RunTransferJob or update the job to
     * have a non-empty schedule.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.Schedule schedule = 5;</code>
     */
    protected $schedule = null;
    /**
     * Specifies the event stream for the transfer job for event-driven transfers.
     * When EventStream is specified, the Schedule fields are ignored.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.EventStream event_stream = 15;</code>
     */
    protected $event_stream = null;
    /**
     * Status of the job. This value MUST be specified for
     * `CreateTransferJobRequests`.
     * **Note:** The effect of the new job status takes place during a subsequent
     * job run. For example, if you change the job status from
     * [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED] to
     * [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], and an
     * operation spawned by the transfer is running, the status change would not
     * affect the current operation.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.TransferJob.Status status = 6;</code>
     */
    protected $status = 0;
    /**
     * Output only. The time that the transfer job was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp creation_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $creation_time = null;
    /**
     * Output only. The time that the transfer job was last modified.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_modification_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_modification_time = null;
    /**
     * Output only. The time that the transfer job was deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp deletion_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $deletion_time = null;
    /**
     * The name of the most recently started TransferOperation of this JobConfig.
     * Present if a TransferOperation has been created for this JobConfig.
     *
     * Generated from protobuf field <code>string latest_operation_name = 12;</code>
     */
    protected $latest_operation_name = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           A unique name (within the transfer project) assigned when the job is
     *           created.  If this field is empty in a CreateTransferJobRequest, Storage
     *           Transfer Service assigns a unique name. Otherwise, the specified name
     *           is used as the unique name for this job.
     *           If the specified name is in use by a job, the creation request fails with
     *           an [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS] error.
     *           This name must start with `"transferJobs/"` prefix and end with a letter or
     *           a number, and should be no more than 128 characters. For transfers
     *           involving PosixFilesystem, this name must start with `transferJobs/OPI`
     *           specifically. For all other transfer types, this name must not start with
     *           `transferJobs/OPI`.
     *           Non-PosixFilesystem example:
     *           `"transferJobs/^(?!OPI)[A-Za-z0-9-._~]*[A-Za-z0-9]$"`
     *           PosixFilesystem example:
     *           `"transferJobs/OPI^[A-Za-z0-9-._~]*[A-Za-z0-9]$"`
     *           Applications must not rely on the enforcement of naming requirements
     *           involving OPI.
     *           Invalid job names fail with an
     *           [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
     *     @type string $description
     *           A description provided by the user for the job. Its max length is 1024
     *           bytes when Unicode-encoded.
     *     @type string $project_id
     *           The ID of the Google Cloud project that owns the job.
     *     @type \Google\Cloud\StorageTransfer\V1\TransferSpec $transfer_spec
     *           Transfer specification.
     *     @type \Google\Cloud\StorageTransfer\V1\ReplicationSpec $replication_spec
     *           Replication specification.
     *     @type \Google\Cloud\StorageTransfer\V1\NotificationConfig $notification_config
     *           Notification configuration.
     *     @type \Google\Cloud\StorageTransfer\V1\LoggingConfig $logging_config
     *           Logging configuration.
     *     @type \Google\Cloud\StorageTransfer\V1\Schedule $schedule
     *           Specifies schedule for the transfer job.
     *           This is an optional field. When the field is not set, the job never
     *           executes a transfer, unless you invoke RunTransferJob or update the job to
     *           have a non-empty schedule.
     *     @type \Google\Cloud\StorageTransfer\V1\EventStream $event_stream
     *           Specifies the event stream for the transfer job for event-driven transfers.
     *           When EventStream is specified, the Schedule fields are ignored.
     *     @type int $status
     *           Status of the job. This value MUST be specified for
     *           `CreateTransferJobRequests`.
     *           **Note:** The effect of the new job status takes place during a subsequent
     *           job run. For example, if you change the job status from
     *           [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED] to
     *           [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], and an
     *           operation spawned by the transfer is running, the status change would not
     *           affect the current operation.
     *     @type \Google\Protobuf\Timestamp $creation_time
     *           Output only. The time that the transfer job was created.
     *     @type \Google\Protobuf\Timestamp $last_modification_time
     *           Output only. The time that the transfer job was last modified.
     *     @type \Google\Protobuf\Timestamp $deletion_time
     *           Output only. The time that the transfer job was deleted.
     *     @type string $latest_operation_name
     *           The name of the most recently started TransferOperation of this JobConfig.
     *           Present if a TransferOperation has been created for this JobConfig.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Storagetransfer\V1\TransferTypes::initOnce();
        parent::__construct($data);
    }

    /**
     * A unique name (within the transfer project) assigned when the job is
     * created.  If this field is empty in a CreateTransferJobRequest, Storage
     * Transfer Service assigns a unique name. Otherwise, the specified name
     * is used as the unique name for this job.
     * If the specified name is in use by a job, the creation request fails with
     * an [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS] error.
     * This name must start with `"transferJobs/"` prefix and end with a letter or
     * a number, and should be no more than 128 characters. For transfers
     * involving PosixFilesystem, this name must start with `transferJobs/OPI`
     * specifically. For all other transfer types, this name must not start with
     * `transferJobs/OPI`.
     * Non-PosixFilesystem example:
     * `"transferJobs/^(?!OPI)[A-Za-z0-9-._~]*[A-Za-z0-9]$"`
     * PosixFilesystem example:
     * `"transferJobs/OPI^[A-Za-z0-9-._~]*[A-Za-z0-9]$"`
     * Applications must not rely on the enforcement of naming requirements
     * involving OPI.
     * Invalid job names fail with an
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * A unique name (within the transfer project) assigned when the job is
     * created.  If this field is empty in a CreateTransferJobRequest, Storage
     * Transfer Service assigns a unique name. Otherwise, the specified name
     * is used as the unique name for this job.
     * If the specified name is in use by a job, the creation request fails with
     * an [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS] error.
     * This name must start with `"transferJobs/"` prefix and end with a letter or
     * a number, and should be no more than 128 characters. For transfers
     * involving PosixFilesystem, this name must start with `transferJobs/OPI`
     * specifically. For all other transfer types, this name must not start with
     * `transferJobs/OPI`.
     * Non-PosixFilesystem example:
     * `"transferJobs/^(?!OPI)[A-Za-z0-9-._~]*[A-Za-z0-9]$"`
     * PosixFilesystem example:
     * `"transferJobs/OPI^[A-Za-z0-9-._~]*[A-Za-z0-9]$"`
     * Applications must not rely on the enforcement of naming requirements
     * involving OPI.
     * Invalid job names fail with an
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * A description provided by the user for the job. Its max length is 1024
     * bytes when Unicode-encoded.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * A description provided by the user for the job. Its max length is 1024
     * bytes when Unicode-encoded.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * The ID of the Google Cloud project that owns the job.
     *
     * Generated from protobuf field <code>string project_id = 3;</code>
     * @return string
     */
    public function getProjectId()
    {
        return $this->project_id;
    }

    /**
     * The ID of the Google Cloud project that owns the job.
     *
     * Generated from protobuf field <code>string project_id = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setProjectId($var)
    {
        GPBUtil::checkString($var, True);
        $this->project_id = $var;

        return $this;
    }

    /**
     * Transfer specification.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.TransferSpec transfer_spec = 4;</code>
     * @return \Google\Cloud\StorageTransfer\V1\TransferSpec|null
     */
    public function getTransferSpec()
    {
        return $this->transfer_spec;
    }

    public function hasTransferSpec()
    {
        return isset($this->transfer_spec);
    }

    public function clearTransferSpec()
    {
        unset($this->transfer_spec);
    }

    /**
     * Transfer specification.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.TransferSpec transfer_spec = 4;</code>
     * @param \Google\Cloud\StorageTransfer\V1\TransferSpec $var
     * @return $this
     */
    public function setTransferSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageTransfer\V1\TransferSpec::class);
        $this->transfer_spec = $var;

        return $this;
    }

    /**
     * Replication specification.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.ReplicationSpec replication_spec = 17;</code>
     * @return \Google\Cloud\StorageTransfer\V1\ReplicationSpec|null
     */
    public function getReplicationSpec()
    {
        return $this->replication_spec;
    }

    public function hasReplicationSpec()
    {
        return isset($this->replication_spec);
    }

    public function clearReplicationSpec()
    {
        unset($this->replication_spec);
    }

    /**
     * Replication specification.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.ReplicationSpec replication_spec = 17;</code>
     * @param \Google\Cloud\StorageTransfer\V1\ReplicationSpec $var
     * @return $this
     */
    public function setReplicationSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageTransfer\V1\ReplicationSpec::class);
        $this->replication_spec = $var;

        return $this;
    }

    /**
     * Notification configuration.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.NotificationConfig notification_config = 11;</code>
     * @return \Google\Cloud\StorageTransfer\V1\NotificationConfig|null
     */
    public function getNotificationConfig()
    {
        return $this->notification_config;
    }

    public function hasNotificationConfig()
    {
        return isset($this->notification_config);
    }

    public function clearNotificationConfig()
    {
        unset($this->notification_config);
    }

    /**
     * Notification configuration.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.NotificationConfig notification_config = 11;</code>
     * @param \Google\Cloud\StorageTransfer\V1\NotificationConfig $var
     * @return $this
     */
    public function setNotificationConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageTransfer\V1\NotificationConfig::class);
        $this->notification_config = $var;

        return $this;
    }

    /**
     * Logging configuration.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.LoggingConfig logging_config = 14;</code>
     * @return \Google\Cloud\StorageTransfer\V1\LoggingConfig|null
     */
    public function getLoggingConfig()
    {
        return $this->logging_config;
    }

    public function hasLoggingConfig()
    {
        return isset($this->logging_config);
    }

    public function clearLoggingConfig()
    {
        unset($this->logging_config);
    }

    /**
     * Logging configuration.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.LoggingConfig logging_config = 14;</code>
     * @param \Google\Cloud\StorageTransfer\V1\LoggingConfig $var
     * @return $this
     */
    public function setLoggingConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageTransfer\V1\LoggingConfig::class);
        $this->logging_config = $var;

        return $this;
    }

    /**
     * Specifies schedule for the transfer job.
     * This is an optional field. When the field is not set, the job never
     * executes a transfer, unless you invoke RunTransferJob or update the job to
     * have a non-empty schedule.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.Schedule schedule = 5;</code>
     * @return \Google\Cloud\StorageTransfer\V1\Schedule|null
     */
    public function getSchedule()
    {
        return $this->schedule;
    }

    public function hasSchedule()
    {
        return isset($this->schedule);
    }

    public function clearSchedule()
    {
        unset($this->schedule);
    }

    /**
     * Specifies schedule for the transfer job.
     * This is an optional field. When the field is not set, the job never
     * executes a transfer, unless you invoke RunTransferJob or update the job to
     * have a non-empty schedule.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.Schedule schedule = 5;</code>
     * @param \Google\Cloud\StorageTransfer\V1\Schedule $var
     * @return $this
     */
    public function setSchedule($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageTransfer\V1\Schedule::class);
        $this->schedule = $var;

        return $this;
    }

    /**
     * Specifies the event stream for the transfer job for event-driven transfers.
     * When EventStream is specified, the Schedule fields are ignored.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.EventStream event_stream = 15;</code>
     * @return \Google\Cloud\StorageTransfer\V1\EventStream|null
     */
    public function getEventStream()
    {
        return $this->event_stream;
    }

    public function hasEventStream()
    {
        return isset($this->event_stream);
    }

    public function clearEventStream()
    {
        unset($this->event_stream);
    }

    /**
     * Specifies the event stream for the transfer job for event-driven transfers.
     * When EventStream is specified, the Schedule fields are ignored.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.EventStream event_stream = 15;</code>
     * @param \Google\Cloud\StorageTransfer\V1\EventStream $var
     * @return $this
     */
    public function setEventStream($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageTransfer\V1\EventStream::class);
        $this->event_stream = $var;

        return $this;
    }

    /**
     * Status of the job. This value MUST be specified for
     * `CreateTransferJobRequests`.
     * **Note:** The effect of the new job status takes place during a subsequent
     * job run. For example, if you change the job status from
     * [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED] to
     * [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], and an
     * operation spawned by the transfer is running, the status change would not
     * affect the current operation.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.TransferJob.Status status = 6;</code>
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Status of the job. This value MUST be specified for
     * `CreateTransferJobRequests`.
     * **Note:** The effect of the new job status takes place during a subsequent
     * job run. For example, if you change the job status from
     * [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED] to
     * [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], and an
     * operation spawned by the transfer is running, the status change would not
     * affect the current operation.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.TransferJob.Status status = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\StorageTransfer\V1\TransferJob\Status::class);
        $this->status = $var;

        return $this;
    }

    /**
     * Output only. The time that the transfer job was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp creation_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreationTime()
    {
        return $this->creation_time;
    }

    public function hasCreationTime()
    {
        return isset($this->creation_time);
    }

    public function clearCreationTime()
    {
        unset($this->creation_time);
    }

    /**
     * Output only. The time that the transfer job was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp creation_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreationTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->creation_time = $var;

        return $this;
    }

    /**
     * Output only. The time that the transfer job was last modified.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_modification_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getLastModificationTime()
    {
        return $this->last_modification_time;
    }

    public function hasLastModificationTime()
    {
        return isset($this->last_modification_time);
    }

    public function clearLastModificationTime()
    {
        unset($this->last_modification_time);
    }

    /**
     * Output only. The time that the transfer job was last modified.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_modification_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLastModificationTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->last_modification_time = $var;

        return $this;
    }

    /**
     * Output only. The time that the transfer job was deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp deletion_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getDeletionTime()
    {
        return $this->deletion_time;
    }

    public function hasDeletionTime()
    {
        return isset($this->deletion_time);
    }

    public function clearDeletionTime()
    {
        unset($this->deletion_time);
    }

    /**
     * Output only. The time that the transfer job was deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp deletion_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setDeletionTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->deletion_time = $var;

        return $this;
    }

    /**
     * The name of the most recently started TransferOperation of this JobConfig.
     * Present if a TransferOperation has been created for this JobConfig.
     *
     * Generated from protobuf field <code>string latest_operation_name = 12;</code>
     * @return string
     */
    public function getLatestOperationName()
    {
        return $this->latest_operation_name;
    }

    /**
     * The name of the most recently started TransferOperation of this JobConfig.
     * Present if a TransferOperation has been created for this JobConfig.
     *
     * Generated from protobuf field <code>string latest_operation_name = 12;</code>
     * @param string $var
     * @return $this
     */
    public function setLatestOperationName($var)
    {
        GPBUtil::checkString($var, True);
        $this->latest_operation_name = $var;

        return $this;
    }

}

