<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/networkservices/v1/gateway.proto

namespace Google\Cloud\NetworkServices\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Gateway represents the configuration for a proxy, typically a load balancer.
 * It captures the ip:port over which the services are exposed by the proxy,
 * along with any policy configurations. Routes have reference to to Gateways to
 * dictate how requests should be routed by this Gateway.
 *
 * Generated from protobuf message <code>google.cloud.networkservices.v1.Gateway</code>
 */
class Gateway extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Name of the Gateway resource. It matches pattern
     * `projects/&#42;&#47;locations/&#42;&#47;gateways/<gateway_name>`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $name = '';
    /**
     * Output only. Server-defined URL of this resource
     *
     * Generated from protobuf field <code>string self_link = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $self_link = '';
    /**
     * Output only. The timestamp when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The timestamp when the resource was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. Set of label tags associated with the Gateway resource.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Optional. A free-text description of the resource. Max length 1024
     * characters.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Immutable. The type of the customer managed gateway.
     * This field is required. If unspecified, an error is returned.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.Gateway.Type type = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $type = 0;
    /**
     * Required. One or more ports that the Gateway must receive traffic on. The
     * proxy binds to the ports specified. Gateway listen on 0.0.0.0 on the ports
     * specified below.
     *
     * Generated from protobuf field <code>repeated int32 ports = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $ports;
    /**
     * Required. Immutable. Scope determines how configuration across multiple
     * Gateway instances are merged. The configuration for multiple Gateway
     * instances with the same scope will be merged as presented as a single
     * coniguration to the proxy/load balancer.
     * Max length 64 characters.
     * Scope should start with a letter and can only have letters, numbers,
     * hyphens.
     *
     * Generated from protobuf field <code>string scope = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $scope = '';
    /**
     * Optional. A fully-qualified ServerTLSPolicy URL reference. Specifies how
     * TLS traffic is terminated. If empty, TLS termination is disabled.
     *
     * Generated from protobuf field <code>string server_tls_policy = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $server_tls_policy = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. Name of the Gateway resource. It matches pattern
     *           `projects/&#42;&#47;locations/&#42;&#47;gateways/<gateway_name>`.
     *     @type string $self_link
     *           Output only. Server-defined URL of this resource
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The timestamp when the resource was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The timestamp when the resource was updated.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. Set of label tags associated with the Gateway resource.
     *     @type string $description
     *           Optional. A free-text description of the resource. Max length 1024
     *           characters.
     *     @type int $type
     *           Immutable. The type of the customer managed gateway.
     *           This field is required. If unspecified, an error is returned.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $ports
     *           Required. One or more ports that the Gateway must receive traffic on. The
     *           proxy binds to the ports specified. Gateway listen on 0.0.0.0 on the ports
     *           specified below.
     *     @type string $scope
     *           Required. Immutable. Scope determines how configuration across multiple
     *           Gateway instances are merged. The configuration for multiple Gateway
     *           instances with the same scope will be merged as presented as a single
     *           coniguration to the proxy/load balancer.
     *           Max length 64 characters.
     *           Scope should start with a letter and can only have letters, numbers,
     *           hyphens.
     *     @type string $server_tls_policy
     *           Optional. A fully-qualified ServerTLSPolicy URL reference. Specifies how
     *           TLS traffic is terminated. If empty, TLS termination is disabled.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Networkservices\V1\Gateway::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Name of the Gateway resource. It matches pattern
     * `projects/&#42;&#47;locations/&#42;&#47;gateways/<gateway_name>`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. Name of the Gateway resource. It matches pattern
     * `projects/&#42;&#47;locations/&#42;&#47;gateways/<gateway_name>`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Server-defined URL of this resource
     *
     * Generated from protobuf field <code>string self_link = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getSelfLink()
    {
        return $this->self_link;
    }

    /**
     * Output only. Server-defined URL of this resource
     *
     * Generated from protobuf field <code>string self_link = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The timestamp when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the resource was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The timestamp when the resource was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. Set of label tags associated with the Gateway resource.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. Set of label tags associated with the Gateway resource.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Optional. A free-text description of the resource. Max length 1024
     * characters.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. A free-text description of the resource. Max length 1024
     * characters.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Immutable. The type of the customer managed gateway.
     * This field is required. If unspecified, an error is returned.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.Gateway.Type type = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Immutable. The type of the customer managed gateway.
     * This field is required. If unspecified, an error is returned.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.Gateway.Type type = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkServices\V1\Gateway\Type::class);
        $this->type = $var;

        return $this;
    }

    /**
     * Required. One or more ports that the Gateway must receive traffic on. The
     * proxy binds to the ports specified. Gateway listen on 0.0.0.0 on the ports
     * specified below.
     *
     * Generated from protobuf field <code>repeated int32 ports = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPorts()
    {
        return $this->ports;
    }

    /**
     * Required. One or more ports that the Gateway must receive traffic on. The
     * proxy binds to the ports specified. Gateway listen on 0.0.0.0 on the ports
     * specified below.
     *
     * Generated from protobuf field <code>repeated int32 ports = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPorts($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::INT32);
        $this->ports = $arr;

        return $this;
    }

    /**
     * Required. Immutable. Scope determines how configuration across multiple
     * Gateway instances are merged. The configuration for multiple Gateway
     * instances with the same scope will be merged as presented as a single
     * coniguration to the proxy/load balancer.
     * Max length 64 characters.
     * Scope should start with a letter and can only have letters, numbers,
     * hyphens.
     *
     * Generated from protobuf field <code>string scope = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getScope()
    {
        return $this->scope;
    }

    /**
     * Required. Immutable. Scope determines how configuration across multiple
     * Gateway instances are merged. The configuration for multiple Gateway
     * instances with the same scope will be merged as presented as a single
     * coniguration to the proxy/load balancer.
     * Max length 64 characters.
     * Scope should start with a letter and can only have letters, numbers,
     * hyphens.
     *
     * Generated from protobuf field <code>string scope = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setScope($var)
    {
        GPBUtil::checkString($var, True);
        $this->scope = $var;

        return $this;
    }

    /**
     * Optional. A fully-qualified ServerTLSPolicy URL reference. Specifies how
     * TLS traffic is terminated. If empty, TLS termination is disabled.
     *
     * Generated from protobuf field <code>string server_tls_policy = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getServerTlsPolicy()
    {
        return $this->server_tls_policy;
    }

    /**
     * Optional. A fully-qualified ServerTLSPolicy URL reference. Specifies how
     * TLS traffic is terminated. If empty, TLS termination is disabled.
     *
     * Generated from protobuf field <code>string server_tls_policy = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setServerTlsPolicy($var)
    {
        GPBUtil::checkString($var, True);
        $this->server_tls_policy = $var;

        return $this;
    }

}

