<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/deploy/v1/cloud_deploy.proto

namespace Google\Cloud\Deploy\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A `DeployPolicy` resource in the Cloud Deploy API.
 * A `DeployPolicy` inhibits manual or automation-driven actions within a
 * Delivery Pipeline or Target.
 *
 * Generated from protobuf message <code>google.cloud.deploy.v1.DeployPolicy</code>
 */
class DeployPolicy extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. Name of the `DeployPolicy`. Format is
     * `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
     * The `deployPolicy` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * Output only. Unique identifier of the `DeployPolicy`.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $uid = '';
    /**
     * Optional. Description of the `DeployPolicy`. Max length is 255 characters.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Optional. User annotations. These attributes can only be set and used by
     * the user, and not by Cloud Deploy. Annotations must meet the following
     * constraints:
     * * Annotations are key/value pairs.
     * * Valid annotation keys have two segments: an optional prefix and name,
     * separated by a slash (`/`).
     * * The name segment is required and must be 63 characters or less,
     * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
     * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
     * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
     * a series of DNS labels separated by dots(`.`), not longer than 253
     * characters in total, followed by a slash (`/`).
     * See
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
     * for more details.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $annotations;
    /**
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     * Both keys and values are additionally constrained to be <= 128 bytes.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5;</code>
     */
    private $labels;
    /**
     * Output only. Time at which the deploy policy was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. Most recent time at which the deploy policy was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. When suspended, the policy will not prevent actions from
     * occurring, even if the action violates the policy.
     *
     * Generated from protobuf field <code>bool suspended = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $suspended = false;
    /**
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     *
     * Generated from protobuf field <code>repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $selectors;
    /**
     * Required. Rules to apply. At least one rule must be present.
     *
     * Generated from protobuf field <code>repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $rules;
    /**
     * The weak etag of the `Automation` resource.
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     *
     * Generated from protobuf field <code>string etag = 11;</code>
     */
    protected $etag = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. Name of the `DeployPolicy`. Format is
     *           `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
     *           The `deployPolicy` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
     *     @type string $uid
     *           Output only. Unique identifier of the `DeployPolicy`.
     *     @type string $description
     *           Optional. Description of the `DeployPolicy`. Max length is 255 characters.
     *     @type array|\Google\Protobuf\Internal\MapField $annotations
     *           Optional. User annotations. These attributes can only be set and used by
     *           the user, and not by Cloud Deploy. Annotations must meet the following
     *           constraints:
     *           * Annotations are key/value pairs.
     *           * Valid annotation keys have two segments: an optional prefix and name,
     *           separated by a slash (`/`).
     *           * The name segment is required and must be 63 characters or less,
     *           beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
     *           dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
     *           * The prefix is optional. If specified, the prefix must be a DNS subdomain:
     *           a series of DNS labels separated by dots(`.`), not longer than 253
     *           characters in total, followed by a slash (`/`).
     *           See
     *           https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
     *           for more details.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels are attributes that can be set and used by both the
     *           user and by Cloud Deploy. Labels must meet the following constraints:
     *           * Keys and values can contain only lowercase letters, numeric characters,
     *           underscores, and dashes.
     *           * All characters must use UTF-8 encoding, and international characters are
     *           allowed.
     *           * Keys must start with a lowercase letter or international character.
     *           * Each resource is limited to a maximum of 64 labels.
     *           Both keys and values are additionally constrained to be <= 128 bytes.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Time at which the deploy policy was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Most recent time at which the deploy policy was updated.
     *     @type bool $suspended
     *           Optional. When suspended, the policy will not prevent actions from
     *           occurring, even if the action violates the policy.
     *     @type array<\Google\Cloud\Deploy\V1\DeployPolicyResourceSelector>|\Google\Protobuf\Internal\RepeatedField $selectors
     *           Required. Selected resources to which the policy will be applied. At least
     *           one selector is required. If one selector matches the resource the policy
     *           applies. For example, if there are two selectors and the action being
     *           attempted matches one of them, the policy will apply to that action.
     *     @type array<\Google\Cloud\Deploy\V1\PolicyRule>|\Google\Protobuf\Internal\RepeatedField $rules
     *           Required. Rules to apply. At least one rule must be present.
     *     @type string $etag
     *           The weak etag of the `Automation` resource.
     *           This checksum is computed by the server based on the value of other
     *           fields, and may be sent on update and delete requests to ensure the
     *           client has an up-to-date value before proceeding.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Deploy\V1\CloudDeploy::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. Name of the `DeployPolicy`. Format is
     * `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
     * The `deployPolicy` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. Name of the `DeployPolicy`. Format is
     * `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
     * The `deployPolicy` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Unique identifier of the `DeployPolicy`.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. Unique identifier of the `DeployPolicy`.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * Optional. Description of the `DeployPolicy`. Max length is 255 characters.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. Description of the `DeployPolicy`. Max length is 255 characters.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Optional. User annotations. These attributes can only be set and used by
     * the user, and not by Cloud Deploy. Annotations must meet the following
     * constraints:
     * * Annotations are key/value pairs.
     * * Valid annotation keys have two segments: an optional prefix and name,
     * separated by a slash (`/`).
     * * The name segment is required and must be 63 characters or less,
     * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
     * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
     * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
     * a series of DNS labels separated by dots(`.`), not longer than 253
     * characters in total, followed by a slash (`/`).
     * See
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
     * for more details.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAnnotations()
    {
        return $this->annotations;
    }

    /**
     * Optional. User annotations. These attributes can only be set and used by
     * the user, and not by Cloud Deploy. Annotations must meet the following
     * constraints:
     * * Annotations are key/value pairs.
     * * Valid annotation keys have two segments: an optional prefix and name,
     * separated by a slash (`/`).
     * * The name segment is required and must be 63 characters or less,
     * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
     * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
     * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
     * a series of DNS labels separated by dots(`.`), not longer than 253
     * characters in total, followed by a slash (`/`).
     * See
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
     * for more details.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAnnotations($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->annotations = $arr;

        return $this;
    }

    /**
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     * Both keys and values are additionally constrained to be <= 128 bytes.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     * Both keys and values are additionally constrained to be <= 128 bytes.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. Time at which the deploy policy was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Time at which the deploy policy was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Most recent time at which the deploy policy was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Most recent time at which the deploy policy was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. When suspended, the policy will not prevent actions from
     * occurring, even if the action violates the policy.
     *
     * Generated from protobuf field <code>bool suspended = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getSuspended()
    {
        return $this->suspended;
    }

    /**
     * Optional. When suspended, the policy will not prevent actions from
     * occurring, even if the action violates the policy.
     *
     * Generated from protobuf field <code>bool suspended = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setSuspended($var)
    {
        GPBUtil::checkBool($var);
        $this->suspended = $var;

        return $this;
    }

    /**
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     *
     * Generated from protobuf field <code>repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSelectors()
    {
        return $this->selectors;
    }

    /**
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     *
     * Generated from protobuf field <code>repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Cloud\Deploy\V1\DeployPolicyResourceSelector>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSelectors($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Deploy\V1\DeployPolicyResourceSelector::class);
        $this->selectors = $arr;

        return $this;
    }

    /**
     * Required. Rules to apply. At least one rule must be present.
     *
     * Generated from protobuf field <code>repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRules()
    {
        return $this->rules;
    }

    /**
     * Required. Rules to apply. At least one rule must be present.
     *
     * Generated from protobuf field <code>repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Cloud\Deploy\V1\PolicyRule>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRules($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Deploy\V1\PolicyRule::class);
        $this->rules = $arr;

        return $this;
    }

    /**
     * The weak etag of the `Automation` resource.
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     *
     * Generated from protobuf field <code>string etag = 11;</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * The weak etag of the `Automation` resource.
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     *
     * Generated from protobuf field <code>string etag = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

}

