<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Specifies settings for an HTTP redirect.
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.HttpRedirectAction</code>
 */
class HttpRedirectAction extends \Google\Protobuf\Internal\Message
{
    /**
     * The host that will be used in the redirect response instead of the one that was supplied in the request.
     * The value must be between 1 and 255 characters.
     *
     * Generated from protobuf field <code>string host_redirect = 107417747;</code>
     */
    private $host_redirect = '';
    /**
     * If set to true, the URL scheme in the redirected request is set to https. If set to false, the URL scheme of the redirected request will remain the same as that of the request.
     * This must only be set for UrlMaps used in TargetHttpProxys. Setting this true for TargetHttpsProxy is not permitted.
     * The default is set to false.
     *
     * Generated from protobuf field <code>bool https_redirect = 170260656;</code>
     */
    private $https_redirect = false;
    /**
     * The path that will be used in the redirect response instead of the one that was supplied in the request.
     * pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
     * The value must be between 1 and 1024 characters.
     *
     * Generated from protobuf field <code>string path_redirect = 3907254;</code>
     */
    private $path_redirect = '';
    /**
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request.
     * prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
     * The value must be between 1 and 1024 characters.
     *
     * Generated from protobuf field <code>string prefix_redirect = 177748713;</code>
     */
    private $prefix_redirect = '';
    /**
     * The HTTP Status code to use for this RedirectAction.
     * Supported values are:
     * - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
     * - FOUND, which corresponds to 302.
     * - SEE_OTHER which corresponds to 303.
     * - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method will be retained.
     * - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method will be retained.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.HttpRedirectAction.RedirectResponseCode redirect_response_code = 168274952;</code>
     */
    private $redirect_response_code = 0;
    /**
     * If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request. If set to false, the query portion of the original URL is retained.
     * The default is set to false.
     *
     * Generated from protobuf field <code>bool strip_query = 52284641;</code>
     */
    private $strip_query = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $host_redirect
     *           The host that will be used in the redirect response instead of the one that was supplied in the request.
     *           The value must be between 1 and 255 characters.
     *     @type bool $https_redirect
     *           If set to true, the URL scheme in the redirected request is set to https. If set to false, the URL scheme of the redirected request will remain the same as that of the request.
     *           This must only be set for UrlMaps used in TargetHttpProxys. Setting this true for TargetHttpsProxy is not permitted.
     *           The default is set to false.
     *     @type string $path_redirect
     *           The path that will be used in the redirect response instead of the one that was supplied in the request.
     *           pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
     *           The value must be between 1 and 1024 characters.
     *     @type string $prefix_redirect
     *           The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request.
     *           prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
     *           The value must be between 1 and 1024 characters.
     *     @type int $redirect_response_code
     *           The HTTP Status code to use for this RedirectAction.
     *           Supported values are:
     *           - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
     *           - FOUND, which corresponds to 302.
     *           - SEE_OTHER which corresponds to 303.
     *           - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method will be retained.
     *           - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method will be retained.
     *     @type bool $strip_query
     *           If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request. If set to false, the query portion of the original URL is retained.
     *           The default is set to false.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * The host that will be used in the redirect response instead of the one that was supplied in the request.
     * The value must be between 1 and 255 characters.
     *
     * Generated from protobuf field <code>string host_redirect = 107417747;</code>
     * @return string
     */
    public function getHostRedirect()
    {
        return $this->host_redirect;
    }

    /**
     * The host that will be used in the redirect response instead of the one that was supplied in the request.
     * The value must be between 1 and 255 characters.
     *
     * Generated from protobuf field <code>string host_redirect = 107417747;</code>
     * @param string $var
     * @return $this
     */
    public function setHostRedirect($var)
    {
        GPBUtil::checkString($var, True);
        $this->host_redirect = $var;

        return $this;
    }

    /**
     * If set to true, the URL scheme in the redirected request is set to https. If set to false, the URL scheme of the redirected request will remain the same as that of the request.
     * This must only be set for UrlMaps used in TargetHttpProxys. Setting this true for TargetHttpsProxy is not permitted.
     * The default is set to false.
     *
     * Generated from protobuf field <code>bool https_redirect = 170260656;</code>
     * @return bool
     */
    public function getHttpsRedirect()
    {
        return $this->https_redirect;
    }

    /**
     * If set to true, the URL scheme in the redirected request is set to https. If set to false, the URL scheme of the redirected request will remain the same as that of the request.
     * This must only be set for UrlMaps used in TargetHttpProxys. Setting this true for TargetHttpsProxy is not permitted.
     * The default is set to false.
     *
     * Generated from protobuf field <code>bool https_redirect = 170260656;</code>
     * @param bool $var
     * @return $this
     */
    public function setHttpsRedirect($var)
    {
        GPBUtil::checkBool($var);
        $this->https_redirect = $var;

        return $this;
    }

    /**
     * The path that will be used in the redirect response instead of the one that was supplied in the request.
     * pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
     * The value must be between 1 and 1024 characters.
     *
     * Generated from protobuf field <code>string path_redirect = 3907254;</code>
     * @return string
     */
    public function getPathRedirect()
    {
        return $this->path_redirect;
    }

    /**
     * The path that will be used in the redirect response instead of the one that was supplied in the request.
     * pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
     * The value must be between 1 and 1024 characters.
     *
     * Generated from protobuf field <code>string path_redirect = 3907254;</code>
     * @param string $var
     * @return $this
     */
    public function setPathRedirect($var)
    {
        GPBUtil::checkString($var, True);
        $this->path_redirect = $var;

        return $this;
    }

    /**
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request.
     * prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
     * The value must be between 1 and 1024 characters.
     *
     * Generated from protobuf field <code>string prefix_redirect = 177748713;</code>
     * @return string
     */
    public function getPrefixRedirect()
    {
        return $this->prefix_redirect;
    }

    /**
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request.
     * prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
     * The value must be between 1 and 1024 characters.
     *
     * Generated from protobuf field <code>string prefix_redirect = 177748713;</code>
     * @param string $var
     * @return $this
     */
    public function setPrefixRedirect($var)
    {
        GPBUtil::checkString($var, True);
        $this->prefix_redirect = $var;

        return $this;
    }

    /**
     * The HTTP Status code to use for this RedirectAction.
     * Supported values are:
     * - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
     * - FOUND, which corresponds to 302.
     * - SEE_OTHER which corresponds to 303.
     * - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method will be retained.
     * - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method will be retained.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.HttpRedirectAction.RedirectResponseCode redirect_response_code = 168274952;</code>
     * @return int
     */
    public function getRedirectResponseCode()
    {
        return $this->redirect_response_code;
    }

    /**
     * The HTTP Status code to use for this RedirectAction.
     * Supported values are:
     * - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
     * - FOUND, which corresponds to 302.
     * - SEE_OTHER which corresponds to 303.
     * - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method will be retained.
     * - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method will be retained.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.HttpRedirectAction.RedirectResponseCode redirect_response_code = 168274952;</code>
     * @param int $var
     * @return $this
     */
    public function setRedirectResponseCode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\HttpRedirectAction\RedirectResponseCode::class);
        $this->redirect_response_code = $var;

        return $this;
    }

    /**
     * If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request. If set to false, the query portion of the original URL is retained.
     * The default is set to false.
     *
     * Generated from protobuf field <code>bool strip_query = 52284641;</code>
     * @return bool
     */
    public function getStripQuery()
    {
        return $this->strip_query;
    }

    /**
     * If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request. If set to false, the query portion of the original URL is retained.
     * The default is set to false.
     *
     * Generated from protobuf field <code>bool strip_query = 52284641;</code>
     * @param bool $var
     * @return $this
     */
    public function setStripQuery($var)
    {
        GPBUtil::checkBool($var);
        $this->strip_query = $var;

        return $this;
    }

}

