<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/admin/database/v1/spanner_database_admin.proto

namespace Google\Cloud\Spanner\Admin\Database\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Enqueues the given DDL statements to be applied, in order but not
 * necessarily all at once, to the database schema at some point (or
 * points) in the future. The server checks that the statements
 * are executable (syntactically valid, name tables that exist, etc.)
 * before enqueueing them, but they may still fail upon
 * later execution (e.g., if a statement from another batch of
 * statements is applied first and it conflicts in some way, or if
 * there is some data-related problem like a `NULL` value in a column to
 * which `NOT NULL` would be added). If a statement fails, all
 * subsequent statements in the batch are automatically cancelled.
 * Each batch of statements is assigned a name which can be used with
 * the [Operations][google.longrunning.Operations] API to monitor
 * progress. See the
 * [operation_id][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.operation_id]
 * field for more details.
 *
 * Generated from protobuf message <code>google.spanner.admin.database.v1.UpdateDatabaseDdlRequest</code>
 */
class UpdateDatabaseDdlRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The database to update.
     *
     * Generated from protobuf field <code>string database = 1;</code>
     */
    private $database = '';
    /**
     * DDL statements to be applied to the database.
     *
     * Generated from protobuf field <code>repeated string statements = 2;</code>
     */
    private $statements;
    /**
     * If empty, the new update request is assigned an
     * automatically-generated operation ID. Otherwise, `operation_id`
     * is used to construct the name of the resulting
     * [Operation][google.longrunning.Operation].
     * Specifying an explicit operation ID simplifies determining
     * whether the statements were executed in the event that the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * call is replayed, or the return value is otherwise lost: the
     * [database][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.database]
     * and `operation_id` fields can be combined to form the
     * [name][google.longrunning.Operation.name] of the resulting
     * [longrunning.Operation][google.longrunning.Operation]:
     * `<database>/operations/<operation_id>`.
     * `operation_id` should be unique within the database, and must be
     * a valid identifier: `[a-z][a-z0-9_]*`. Note that
     * automatically-generated operation IDs always begin with an
     * underscore. If the named operation already exists,
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * returns `ALREADY_EXISTS`.
     *
     * Generated from protobuf field <code>string operation_id = 3;</code>
     */
    private $operation_id = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $database
     *           Required. The database to update.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $statements
     *           DDL statements to be applied to the database.
     *     @type string $operation_id
     *           If empty, the new update request is assigned an
     *           automatically-generated operation ID. Otherwise, `operation_id`
     *           is used to construct the name of the resulting
     *           [Operation][google.longrunning.Operation].
     *           Specifying an explicit operation ID simplifies determining
     *           whether the statements were executed in the event that the
     *           [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     *           call is replayed, or the return value is otherwise lost: the
     *           [database][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.database]
     *           and `operation_id` fields can be combined to form the
     *           [name][google.longrunning.Operation.name] of the resulting
     *           [longrunning.Operation][google.longrunning.Operation]:
     *           `<database>/operations/<operation_id>`.
     *           `operation_id` should be unique within the database, and must be
     *           a valid identifier: `[a-z][a-z0-9_]*`. Note that
     *           automatically-generated operation IDs always begin with an
     *           underscore. If the named operation already exists,
     *           [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     *           returns `ALREADY_EXISTS`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\Admin\Database\V1\SpannerDatabaseAdmin::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The database to update.
     *
     * Generated from protobuf field <code>string database = 1;</code>
     * @return string
     */
    public function getDatabase()
    {
        return $this->database;
    }

    /**
     * Required. The database to update.
     *
     * Generated from protobuf field <code>string database = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setDatabase($var)
    {
        GPBUtil::checkString($var, True);
        $this->database = $var;

        return $this;
    }

    /**
     * DDL statements to be applied to the database.
     *
     * Generated from protobuf field <code>repeated string statements = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getStatements()
    {
        return $this->statements;
    }

    /**
     * DDL statements to be applied to the database.
     *
     * Generated from protobuf field <code>repeated string statements = 2;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setStatements($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->statements = $arr;

        return $this;
    }

    /**
     * If empty, the new update request is assigned an
     * automatically-generated operation ID. Otherwise, `operation_id`
     * is used to construct the name of the resulting
     * [Operation][google.longrunning.Operation].
     * Specifying an explicit operation ID simplifies determining
     * whether the statements were executed in the event that the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * call is replayed, or the return value is otherwise lost: the
     * [database][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.database]
     * and `operation_id` fields can be combined to form the
     * [name][google.longrunning.Operation.name] of the resulting
     * [longrunning.Operation][google.longrunning.Operation]:
     * `<database>/operations/<operation_id>`.
     * `operation_id` should be unique within the database, and must be
     * a valid identifier: `[a-z][a-z0-9_]*`. Note that
     * automatically-generated operation IDs always begin with an
     * underscore. If the named operation already exists,
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * returns `ALREADY_EXISTS`.
     *
     * Generated from protobuf field <code>string operation_id = 3;</code>
     * @return string
     */
    public function getOperationId()
    {
        return $this->operation_id;
    }

    /**
     * If empty, the new update request is assigned an
     * automatically-generated operation ID. Otherwise, `operation_id`
     * is used to construct the name of the resulting
     * [Operation][google.longrunning.Operation].
     * Specifying an explicit operation ID simplifies determining
     * whether the statements were executed in the event that the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * call is replayed, or the return value is otherwise lost: the
     * [database][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.database]
     * and `operation_id` fields can be combined to form the
     * [name][google.longrunning.Operation.name] of the resulting
     * [longrunning.Operation][google.longrunning.Operation]:
     * `<database>/operations/<operation_id>`.
     * `operation_id` should be unique within the database, and must be
     * a valid identifier: `[a-z][a-z0-9_]*`. Note that
     * automatically-generated operation IDs always begin with an
     * underscore. If the named operation already exists,
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * returns `ALREADY_EXISTS`.
     *
     * Generated from protobuf field <code>string operation_id = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setOperationId($var)
    {
        GPBUtil::checkString($var, True);
        $this->operation_id = $var;

        return $this;
    }

}

