<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/product_service.proto

namespace Google\Cloud\Retail\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for
 * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
 * method.
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.AddLocalInventoriesRequest</code>
 */
class AddLocalInventoriesRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Full resource name of [Product][google.cloud.retail.v2.Product],
     * such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
     * If the caller does not have permission to access the
     * [Product][google.cloud.retail.v2.Product], regardless of whether or not it
     * exists, a PERMISSION_DENIED error is returned.
     *
     * Generated from protobuf field <code>string product = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $product = '';
    /**
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $local_inventories;
    /**
     * Indicates which inventory fields in the provided list of
     * [LocalInventory][google.cloud.retail.v2.LocalInventory] to update. The
     * field is updated to the provided value.
     * If a field is set while the place does not have a previous local inventory,
     * the local inventory at that store is created.
     * If a field is set while the value of that field is not provided, the
     * original field value, if it exists, is deleted.
     * If the mask is not set or set with empty paths, all inventory fields will
     * be updated.
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask add_mask = 4;</code>
     */
    private $add_mask = null;
    /**
     * The time when the inventory updates are issued. Used to prevent
     * out-of-order updates on local inventory fields. If not provided, the
     * internal system time will be used.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp add_time = 5;</code>
     */
    private $add_time = null;
    /**
     * If set to true, and the [Product][google.cloud.retail.v2.Product] is not
     * found, the local inventory will still be processed and retained for at most
     * 1 day and processed once the [Product][google.cloud.retail.v2.Product] is
     * created. If set to false, a NOT_FOUND error is returned if the
     * [Product][google.cloud.retail.v2.Product] is not found.
     *
     * Generated from protobuf field <code>bool allow_missing = 6;</code>
     */
    private $allow_missing = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $product
     *           Required. Full resource name of [Product][google.cloud.retail.v2.Product],
     *           such as
     *           `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
     *           If the caller does not have permission to access the
     *           [Product][google.cloud.retail.v2.Product], regardless of whether or not it
     *           exists, a PERMISSION_DENIED error is returned.
     *     @type \Google\Cloud\Retail\V2\LocalInventory[]|\Google\Protobuf\Internal\RepeatedField $local_inventories
     *           Required. A list of inventory information at difference places. Each place
     *           is identified by its place ID. At most 3000 inventories are allowed per
     *           request.
     *     @type \Google\Protobuf\FieldMask $add_mask
     *           Indicates which inventory fields in the provided list of
     *           [LocalInventory][google.cloud.retail.v2.LocalInventory] to update. The
     *           field is updated to the provided value.
     *           If a field is set while the place does not have a previous local inventory,
     *           the local inventory at that store is created.
     *           If a field is set while the value of that field is not provided, the
     *           original field value, if it exists, is deleted.
     *           If the mask is not set or set with empty paths, all inventory fields will
     *           be updated.
     *           If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     *           is returned and the entire update will be ignored.
     *     @type \Google\Protobuf\Timestamp $add_time
     *           The time when the inventory updates are issued. Used to prevent
     *           out-of-order updates on local inventory fields. If not provided, the
     *           internal system time will be used.
     *     @type bool $allow_missing
     *           If set to true, and the [Product][google.cloud.retail.v2.Product] is not
     *           found, the local inventory will still be processed and retained for at most
     *           1 day and processed once the [Product][google.cloud.retail.v2.Product] is
     *           created. If set to false, a NOT_FOUND error is returned if the
     *           [Product][google.cloud.retail.v2.Product] is not found.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\ProductService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Full resource name of [Product][google.cloud.retail.v2.Product],
     * such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
     * If the caller does not have permission to access the
     * [Product][google.cloud.retail.v2.Product], regardless of whether or not it
     * exists, a PERMISSION_DENIED error is returned.
     *
     * Generated from protobuf field <code>string product = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }

    /**
     * Required. Full resource name of [Product][google.cloud.retail.v2.Product],
     * such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
     * If the caller does not have permission to access the
     * [Product][google.cloud.retail.v2.Product], regardless of whether or not it
     * exists, a PERMISSION_DENIED error is returned.
     *
     * Generated from protobuf field <code>string product = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setProduct($var)
    {
        GPBUtil::checkString($var, True);
        $this->product = $var;

        return $this;
    }

    /**
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLocalInventories()
    {
        return $this->local_inventories;
    }

    /**
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Retail\V2\LocalInventory[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLocalInventories($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Retail\V2\LocalInventory::class);
        $this->local_inventories = $arr;

        return $this;
    }

    /**
     * Indicates which inventory fields in the provided list of
     * [LocalInventory][google.cloud.retail.v2.LocalInventory] to update. The
     * field is updated to the provided value.
     * If a field is set while the place does not have a previous local inventory,
     * the local inventory at that store is created.
     * If a field is set while the value of that field is not provided, the
     * original field value, if it exists, is deleted.
     * If the mask is not set or set with empty paths, all inventory fields will
     * be updated.
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask add_mask = 4;</code>
     * @return \Google\Protobuf\FieldMask|null
     */
    public function getAddMask()
    {
        return $this->add_mask;
    }

    public function hasAddMask()
    {
        return isset($this->add_mask);
    }

    public function clearAddMask()
    {
        unset($this->add_mask);
    }

    /**
     * Indicates which inventory fields in the provided list of
     * [LocalInventory][google.cloud.retail.v2.LocalInventory] to update. The
     * field is updated to the provided value.
     * If a field is set while the place does not have a previous local inventory,
     * the local inventory at that store is created.
     * If a field is set while the value of that field is not provided, the
     * original field value, if it exists, is deleted.
     * If the mask is not set or set with empty paths, all inventory fields will
     * be updated.
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask add_mask = 4;</code>
     * @param \Google\Protobuf\FieldMask $var
     * @return $this
     */
    public function setAddMask($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\FieldMask::class);
        $this->add_mask = $var;

        return $this;
    }

    /**
     * The time when the inventory updates are issued. Used to prevent
     * out-of-order updates on local inventory fields. If not provided, the
     * internal system time will be used.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp add_time = 5;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getAddTime()
    {
        return $this->add_time;
    }

    public function hasAddTime()
    {
        return isset($this->add_time);
    }

    public function clearAddTime()
    {
        unset($this->add_time);
    }

    /**
     * The time when the inventory updates are issued. Used to prevent
     * out-of-order updates on local inventory fields. If not provided, the
     * internal system time will be used.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp add_time = 5;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setAddTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->add_time = $var;

        return $this;
    }

    /**
     * If set to true, and the [Product][google.cloud.retail.v2.Product] is not
     * found, the local inventory will still be processed and retained for at most
     * 1 day and processed once the [Product][google.cloud.retail.v2.Product] is
     * created. If set to false, a NOT_FOUND error is returned if the
     * [Product][google.cloud.retail.v2.Product] is not found.
     *
     * Generated from protobuf field <code>bool allow_missing = 6;</code>
     * @return bool
     */
    public function getAllowMissing()
    {
        return $this->allow_missing;
    }

    /**
     * If set to true, and the [Product][google.cloud.retail.v2.Product] is not
     * found, the local inventory will still be processed and retained for at most
     * 1 day and processed once the [Product][google.cloud.retail.v2.Product] is
     * created. If set to false, a NOT_FOUND error is returned if the
     * [Product][google.cloud.retail.v2.Product] is not found.
     *
     * Generated from protobuf field <code>bool allow_missing = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setAllowMissing($var)
    {
        GPBUtil::checkBool($var);
        $this->allow_missing = $var;

        return $this;
    }

}

