<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/dataflow/v1beta3/snapshots.proto
 * Updates to the above are reflected here through a refresh process.
 *
 * @experimental
 */

namespace Google\Cloud\Dataflow\V1beta3\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;

use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dataflow\V1beta3\DeleteSnapshotRequest;
use Google\Cloud\Dataflow\V1beta3\DeleteSnapshotResponse;
use Google\Cloud\Dataflow\V1beta3\GetSnapshotRequest;
use Google\Cloud\Dataflow\V1beta3\ListSnapshotsRequest;
use Google\Cloud\Dataflow\V1beta3\ListSnapshotsResponse;
use Google\Cloud\Dataflow\V1beta3\Snapshot;

/**
 * Service Description: Provides methods to manage snapshots of Google Cloud Dataflow jobs.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $snapshotsV1Beta3Client = new SnapshotsV1Beta3Client();
 * try {
 *     $response = $snapshotsV1Beta3Client->deleteSnapshot();
 * } finally {
 *     $snapshotsV1Beta3Client->close();
 * }
 * ```
 *
 * @experimental
 */
class SnapshotsV1Beta3GapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.dataflow.v1beta3.SnapshotsV1Beta3';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'dataflow.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/compute',
        'https://www.googleapis.com/auth/compute.readonly',
        'https://www.googleapis.com/auth/userinfo.email',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/snapshots_v1_beta3_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/snapshots_v1_beta3_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/snapshots_v1_beta3_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/snapshots_v1_beta3_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dataflow.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     *
     * @experimental
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Deletes a snapshot.
     *
     * Sample code:
     * ```
     * $snapshotsV1Beta3Client = new SnapshotsV1Beta3Client();
     * try {
     *     $response = $snapshotsV1Beta3Client->deleteSnapshot();
     * } finally {
     *     $snapshotsV1Beta3Client->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $projectId
     *           The ID of the Cloud Platform project that the snapshot belongs to.
     *     @type string $snapshotId
     *           The ID of the snapshot.
     *     @type string $location
     *           The location that contains this snapshot.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataflow\V1beta3\DeleteSnapshotResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteSnapshot(array $optionalArgs = [])
    {
        $request = new DeleteSnapshotRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['projectId'])) {
            $request->setProjectId($optionalArgs['projectId']);
            $requestParamHeaders['project_id'] = $optionalArgs['projectId'];
        }

        if (isset($optionalArgs['snapshotId'])) {
            $request->setSnapshotId($optionalArgs['snapshotId']);
            $requestParamHeaders['snapshot_id'] = $optionalArgs['snapshotId'];
        }

        if (isset($optionalArgs['location'])) {
            $request->setLocation($optionalArgs['location']);
            $requestParamHeaders['location'] = $optionalArgs['location'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteSnapshot',
            DeleteSnapshotResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets information about a snapshot.
     *
     * Sample code:
     * ```
     * $snapshotsV1Beta3Client = new SnapshotsV1Beta3Client();
     * try {
     *     $response = $snapshotsV1Beta3Client->getSnapshot();
     * } finally {
     *     $snapshotsV1Beta3Client->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $projectId
     *           The ID of the Cloud Platform project that the snapshot belongs to.
     *     @type string $snapshotId
     *           The ID of the snapshot.
     *     @type string $location
     *           The location that contains this snapshot.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataflow\V1beta3\Snapshot
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getSnapshot(array $optionalArgs = [])
    {
        $request = new GetSnapshotRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['projectId'])) {
            $request->setProjectId($optionalArgs['projectId']);
            $requestParamHeaders['project_id'] = $optionalArgs['projectId'];
        }

        if (isset($optionalArgs['snapshotId'])) {
            $request->setSnapshotId($optionalArgs['snapshotId']);
            $requestParamHeaders['snapshot_id'] = $optionalArgs['snapshotId'];
        }

        if (isset($optionalArgs['location'])) {
            $request->setLocation($optionalArgs['location']);
            $requestParamHeaders['location'] = $optionalArgs['location'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetSnapshot',
            Snapshot::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists snapshots.
     *
     * Sample code:
     * ```
     * $snapshotsV1Beta3Client = new SnapshotsV1Beta3Client();
     * try {
     *     $response = $snapshotsV1Beta3Client->listSnapshots();
     * } finally {
     *     $snapshotsV1Beta3Client->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $projectId
     *           The project ID to list snapshots for.
     *     @type string $jobId
     *           If specified, list snapshots created from this job.
     *     @type string $location
     *           The location to list snapshots in.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataflow\V1beta3\ListSnapshotsResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listSnapshots(array $optionalArgs = [])
    {
        $request = new ListSnapshotsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['projectId'])) {
            $request->setProjectId($optionalArgs['projectId']);
            $requestParamHeaders['project_id'] = $optionalArgs['projectId'];
        }

        if (isset($optionalArgs['jobId'])) {
            $request->setJobId($optionalArgs['jobId']);
            $requestParamHeaders['job_id'] = $optionalArgs['jobId'];
        }

        if (isset($optionalArgs['location'])) {
            $request->setLocation($optionalArgs['location']);
            $requestParamHeaders['location'] = $optionalArgs['location'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ListSnapshots',
            ListSnapshotsResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }
}
