<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/aiplatform/v1/pipeline_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AIPlatform\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;

use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;

use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AIPlatform\V1\CancelPipelineJobRequest;
use Google\Cloud\AIPlatform\V1\CancelTrainingPipelineRequest;
use Google\Cloud\AIPlatform\V1\CreatePipelineJobRequest;
use Google\Cloud\AIPlatform\V1\CreateTrainingPipelineRequest;
use Google\Cloud\AIPlatform\V1\DeletePipelineJobRequest;
use Google\Cloud\AIPlatform\V1\DeleteTrainingPipelineRequest;
use Google\Cloud\AIPlatform\V1\GetPipelineJobRequest;
use Google\Cloud\AIPlatform\V1\GetTrainingPipelineRequest;
use Google\Cloud\AIPlatform\V1\ListPipelineJobsRequest;
use Google\Cloud\AIPlatform\V1\ListPipelineJobsResponse;
use Google\Cloud\AIPlatform\V1\ListTrainingPipelinesRequest;
use Google\Cloud\AIPlatform\V1\ListTrainingPipelinesResponse;
use Google\Cloud\AIPlatform\V1\PipelineJob;
use Google\Cloud\AIPlatform\V1\TrainingPipeline;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: A service for creating and managing Vertex AI's pipelines. This includes both
 * `TrainingPipeline` resources (used for AutoML and custom training) and
 * `PipelineJob` resources (used for Vertex AI Pipelines).
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $pipelineServiceClient = new PipelineServiceClient();
 * try {
 *     $formattedName = $pipelineServiceClient->pipelineJobName('[PROJECT]', '[LOCATION]', '[PIPELINE_JOB]');
 *     $pipelineServiceClient->cancelPipelineJob($formattedName);
 * } finally {
 *     $pipelineServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class PipelineServiceGapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.cloud.aiplatform.v1.PipelineService';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'aiplatform.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $locationNameTemplate;

    private static $networkNameTemplate;

    private static $pipelineJobNameTemplate;

    private static $trainingPipelineNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/pipeline_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/pipeline_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/pipeline_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/pipeline_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getNetworkNameTemplate()
    {
        if (self::$networkNameTemplate == null) {
            self::$networkNameTemplate = new PathTemplate(
                'projects/{project}/global/networks/{network}'
            );
        }

        return self::$networkNameTemplate;
    }

    private static function getPipelineJobNameTemplate()
    {
        if (self::$pipelineJobNameTemplate == null) {
            self::$pipelineJobNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}'
            );
        }

        return self::$pipelineJobNameTemplate;
    }

    private static function getTrainingPipelineNameTemplate()
    {
        if (self::$trainingPipelineNameTemplate == null) {
            self::$trainingPipelineNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}'
            );
        }

        return self::$trainingPipelineNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'location' => self::getLocationNameTemplate(),
                'network' => self::getNetworkNameTemplate(),
                'pipelineJob' => self::getPipelineJobNameTemplate(),
                'trainingPipeline' => self::getTrainingPipelineNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $network
     *
     * @return string The formatted network resource.
     */
    public static function networkName($project, $network)
    {
        return self::getNetworkNameTemplate()->render([
            'project' => $project,
            'network' => $network,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a pipeline_job
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $pipelineJob
     *
     * @return string The formatted pipeline_job resource.
     */
    public static function pipelineJobName($project, $location, $pipelineJob)
    {
        return self::getPipelineJobNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'pipeline_job' => $pipelineJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * training_pipeline resource.
     *
     * @param string $project
     * @param string $location
     * @param string $trainingPipeline
     *
     * @return string The formatted training_pipeline resource.
     */
    public static function trainingPipelineName(
        $project,
        $location,
        $trainingPipeline
    ) {
        return self::getTrainingPipelineNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'training_pipeline' => $trainingPipeline,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - location: projects/{project}/locations/{location}
     * - network: projects/{project}/global/networks/{network}
     * - pipelineJob: projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}
     * - trainingPipeline: projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'aiplatform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Cancels a PipelineJob.
     * Starts asynchronous cancellation on the PipelineJob. The server
     * makes a best effort to cancel the pipeline, but success is not
     * guaranteed. Clients can use [PipelineService.GetPipelineJob][google.cloud.aiplatform.v1.PipelineService.GetPipelineJob] or
     * other methods to check whether the cancellation succeeded or whether the
     * pipeline completed despite cancellation. On successful cancellation,
     * the PipelineJob is not deleted; instead it becomes a pipeline with
     * a [PipelineJob.error][google.cloud.aiplatform.v1.PipelineJob.error] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
     * corresponding to `Code.CANCELLED`, and [PipelineJob.state][google.cloud.aiplatform.v1.PipelineJob.state] is set to
     * `CANCELLED`.
     *
     * Sample code:
     * ```
     * $pipelineServiceClient = new PipelineServiceClient();
     * try {
     *     $formattedName = $pipelineServiceClient->pipelineJobName('[PROJECT]', '[LOCATION]', '[PIPELINE_JOB]');
     *     $pipelineServiceClient->cancelPipelineJob($formattedName);
     * } finally {
     *     $pipelineServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the PipelineJob to cancel.
     *                             Format:
     *                             `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function cancelPipelineJob($name, array $optionalArgs = [])
    {
        $request = new CancelPipelineJobRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CancelPipelineJob',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Cancels a TrainingPipeline.
     * Starts asynchronous cancellation on the TrainingPipeline. The server
     * makes a best effort to cancel the pipeline, but success is not
     * guaranteed. Clients can use [PipelineService.GetTrainingPipeline][google.cloud.aiplatform.v1.PipelineService.GetTrainingPipeline] or
     * other methods to check whether the cancellation succeeded or whether the
     * pipeline completed despite cancellation. On successful cancellation,
     * the TrainingPipeline is not deleted; instead it becomes a pipeline with
     * a [TrainingPipeline.error][google.cloud.aiplatform.v1.TrainingPipeline.error] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
     * corresponding to `Code.CANCELLED`, and [TrainingPipeline.state][google.cloud.aiplatform.v1.TrainingPipeline.state] is set to
     * `CANCELLED`.
     *
     * Sample code:
     * ```
     * $pipelineServiceClient = new PipelineServiceClient();
     * try {
     *     $formattedName = $pipelineServiceClient->trainingPipelineName('[PROJECT]', '[LOCATION]', '[TRAINING_PIPELINE]');
     *     $pipelineServiceClient->cancelTrainingPipeline($formattedName);
     * } finally {
     *     $pipelineServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the TrainingPipeline to cancel.
     *                             Format:
     *                             `projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function cancelTrainingPipeline($name, array $optionalArgs = [])
    {
        $request = new CancelTrainingPipelineRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CancelTrainingPipeline',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a PipelineJob. A PipelineJob will run immediately when created.
     *
     * Sample code:
     * ```
     * $pipelineServiceClient = new PipelineServiceClient();
     * try {
     *     $formattedParent = $pipelineServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $pipelineJob = new PipelineJob();
     *     $response = $pipelineServiceClient->createPipelineJob($formattedParent, $pipelineJob);
     * } finally {
     *     $pipelineServiceClient->close();
     * }
     * ```
     *
     * @param string      $parent       Required. The resource name of the Location to create the PipelineJob in.
     *                                  Format: `projects/{project}/locations/{location}`
     * @param PipelineJob $pipelineJob  Required. The PipelineJob to create.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type string $pipelineJobId
     *           The ID to use for the PipelineJob, which will become the final component of
     *           the PipelineJob name. If not provided, an ID will be automatically
     *           generated.
     *
     *           This value should be less than 128 characters, and valid characters
     *           are /[a-z][0-9]-/.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\PipelineJob
     *
     * @throws ApiException if the remote call fails
     */
    public function createPipelineJob(
        $parent,
        $pipelineJob,
        array $optionalArgs = []
    ) {
        $request = new CreatePipelineJobRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setPipelineJob($pipelineJob);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pipelineJobId'])) {
            $request->setPipelineJobId($optionalArgs['pipelineJobId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreatePipelineJob',
            PipelineJob::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a TrainingPipeline. A created TrainingPipeline right away will be
     * attempted to be run.
     *
     * Sample code:
     * ```
     * $pipelineServiceClient = new PipelineServiceClient();
     * try {
     *     $formattedParent = $pipelineServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $trainingPipeline = new TrainingPipeline();
     *     $response = $pipelineServiceClient->createTrainingPipeline($formattedParent, $trainingPipeline);
     * } finally {
     *     $pipelineServiceClient->close();
     * }
     * ```
     *
     * @param string           $parent           Required. The resource name of the Location to create the TrainingPipeline in.
     *                                           Format: `projects/{project}/locations/{location}`
     * @param TrainingPipeline $trainingPipeline Required. The TrainingPipeline to create.
     * @param array            $optionalArgs     {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\TrainingPipeline
     *
     * @throws ApiException if the remote call fails
     */
    public function createTrainingPipeline(
        $parent,
        $trainingPipeline,
        array $optionalArgs = []
    ) {
        $request = new CreateTrainingPipelineRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setTrainingPipeline($trainingPipeline);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateTrainingPipeline',
            TrainingPipeline::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a PipelineJob.
     *
     * Sample code:
     * ```
     * $pipelineServiceClient = new PipelineServiceClient();
     * try {
     *     $formattedName = $pipelineServiceClient->pipelineJobName('[PROJECT]', '[LOCATION]', '[PIPELINE_JOB]');
     *     $operationResponse = $pipelineServiceClient->deletePipelineJob($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $pipelineServiceClient->deletePipelineJob($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $pipelineServiceClient->resumeOperation($operationName, 'deletePipelineJob');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $pipelineServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the PipelineJob resource to be deleted.
     *                             Format:
     *                             `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deletePipelineJob($name, array $optionalArgs = [])
    {
        $request = new DeletePipelineJobRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeletePipelineJob',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a TrainingPipeline.
     *
     * Sample code:
     * ```
     * $pipelineServiceClient = new PipelineServiceClient();
     * try {
     *     $formattedName = $pipelineServiceClient->trainingPipelineName('[PROJECT]', '[LOCATION]', '[TRAINING_PIPELINE]');
     *     $operationResponse = $pipelineServiceClient->deleteTrainingPipeline($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $pipelineServiceClient->deleteTrainingPipeline($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $pipelineServiceClient->resumeOperation($operationName, 'deleteTrainingPipeline');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $pipelineServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the TrainingPipeline resource to be deleted.
     *                             Format:
     *                             `projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteTrainingPipeline($name, array $optionalArgs = [])
    {
        $request = new DeleteTrainingPipelineRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteTrainingPipeline',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets a PipelineJob.
     *
     * Sample code:
     * ```
     * $pipelineServiceClient = new PipelineServiceClient();
     * try {
     *     $formattedName = $pipelineServiceClient->pipelineJobName('[PROJECT]', '[LOCATION]', '[PIPELINE_JOB]');
     *     $response = $pipelineServiceClient->getPipelineJob($formattedName);
     * } finally {
     *     $pipelineServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the PipelineJob resource.
     *                             Format:
     *                             `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\PipelineJob
     *
     * @throws ApiException if the remote call fails
     */
    public function getPipelineJob($name, array $optionalArgs = [])
    {
        $request = new GetPipelineJobRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetPipelineJob',
            PipelineJob::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a TrainingPipeline.
     *
     * Sample code:
     * ```
     * $pipelineServiceClient = new PipelineServiceClient();
     * try {
     *     $formattedName = $pipelineServiceClient->trainingPipelineName('[PROJECT]', '[LOCATION]', '[TRAINING_PIPELINE]');
     *     $response = $pipelineServiceClient->getTrainingPipeline($formattedName);
     * } finally {
     *     $pipelineServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the TrainingPipeline resource.
     *                             Format:
     *                             `projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\TrainingPipeline
     *
     * @throws ApiException if the remote call fails
     */
    public function getTrainingPipeline($name, array $optionalArgs = [])
    {
        $request = new GetTrainingPipelineRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetTrainingPipeline',
            TrainingPipeline::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists PipelineJobs in a Location.
     *
     * Sample code:
     * ```
     * $pipelineServiceClient = new PipelineServiceClient();
     * try {
     *     $formattedParent = $pipelineServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $pipelineServiceClient->listPipelineJobs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $pipelineServiceClient->listPipelineJobs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $pipelineServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Location to list the PipelineJobs from.
     *                             Format: `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Lists the PipelineJobs that match the filter expression. The following
     *           fields are supported:
     *
     *           * `pipeline_name`: Supports `=` and `!=` comparisons.
     *           * `display_name`: Supports `=`, `!=` comparisons, and `:` wildcard.
     *           * `pipeline_job_user_id`: Supports `=`, `!=` comparisons, and `:` wildcard.
     *           for example, can check if pipeline's display_name contains *step* by doing
     *           display_name:\"*step*\"
     *           * `state`: Supports `=` and `!=` comparisons.
     *           * `create_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
     *           Values must be in RFC 3339 format.
     *           * `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
     *           Values must be in RFC 3339 format.
     *           * `end_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
     *           Values must be in RFC 3339 format.
     *           * `labels`: Supports key-value equality and key presence.
     *           * `template_uri`: Supports `=`, `!=` comparisons, and `:` wildcard.
     *           * `template_metadata.version`: Supports `=`, `!=` comparisons, and `:`
     *           wildcard.
     *
     *           Filter expressions can be combined together using logical operators
     *           (`AND` & `OR`).
     *           For example: `pipeline_name="test" AND create_time>"2020-05-18T13:30:00Z"`.
     *
     *           The syntax to define filter expression is based on
     *           https://google.aip.dev/160.
     *
     *           Examples:
     *
     *           * `create_time>"2021-05-18T00:00:00Z" OR
     *           update_time>"2020-05-18T00:00:00Z"` PipelineJobs created or updated
     *           after 2020-05-18 00:00:00 UTC.
     *           * `labels.env = "prod"`
     *           PipelineJobs with label "env" set to "prod".
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           A comma-separated list of fields to order by. The default sort order is in
     *           ascending order. Use "desc" after a field name for descending. You can have
     *           multiple order_by fields provided e.g. "create_time desc, end_time",
     *           "end_time, start_time, update_time" For example, using "create_time desc,
     *           end_time" will order results by create time in descending order, and if
     *           there are multiple jobs having the same create time, order them by the end
     *           time in ascending order. if order_by is not specified, it will order by
     *           default order is create time in descending order. Supported fields:
     *           * `create_time`
     *           * `update_time`
     *           * `end_time`
     *           * `start_time`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listPipelineJobs($parent, array $optionalArgs = [])
    {
        $request = new ListPipelineJobsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListPipelineJobs',
            $optionalArgs,
            ListPipelineJobsResponse::class,
            $request
        );
    }

    /**
     * Lists TrainingPipelines in a Location.
     *
     * Sample code:
     * ```
     * $pipelineServiceClient = new PipelineServiceClient();
     * try {
     *     $formattedParent = $pipelineServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $pipelineServiceClient->listTrainingPipelines($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $pipelineServiceClient->listTrainingPipelines($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $pipelineServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Location to list the TrainingPipelines from.
     *                             Format: `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           The standard list filter.
     *           Supported fields:
     *
     *           * `display_name` supports = and !=.
     *
     *           * `state` supports = and !=.
     *
     *           Some examples of using the filter are:
     *
     *           * `state="PIPELINE_STATE_SUCCEEDED" AND display_name="my_pipeline"`
     *
     *           * `state="PIPELINE_STATE_RUNNING" OR display_name="my_pipeline"`
     *
     *           * `NOT display_name="my_pipeline"`
     *
     *           * `state="PIPELINE_STATE_FAILED"`
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type FieldMask $readMask
     *           Mask specifying which fields to read.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTrainingPipelines($parent, array $optionalArgs = [])
    {
        $request = new ListTrainingPipelinesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['readMask'])) {
            $request->setReadMask($optionalArgs['readMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListTrainingPipelines',
            $optionalArgs,
            ListTrainingPipelinesResponse::class,
            $request
        );
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $pipelineServiceClient = new PipelineServiceClient();
     * try {
     *     $response = $pipelineServiceClient->getLocation();
     * } finally {
     *     $pipelineServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $pipelineServiceClient = new PipelineServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $pipelineServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $pipelineServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $pipelineServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $pipelineServiceClient = new PipelineServiceClient();
     * try {
     *     $resource = 'resource';
     *     $response = $pipelineServiceClient->getIamPolicy($resource);
     * } finally {
     *     $pipelineServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $pipelineServiceClient = new PipelineServiceClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $pipelineServiceClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $pipelineServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $pipelineServiceClient = new PipelineServiceClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $pipelineServiceClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $pipelineServiceClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }
}
