<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/orchestration/airflow/service/v1/environments.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Orchestration\Airflow\Service\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Orchestration\Airflow\Service\V1\CheckUpgradeRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\CreateEnvironmentRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\CreateUserWorkloadsConfigMapRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\CreateUserWorkloadsSecretRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\DatabaseFailoverRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\DeleteEnvironmentRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\DeleteUserWorkloadsConfigMapRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\DeleteUserWorkloadsSecretRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\Environment;
use Google\Cloud\Orchestration\Airflow\Service\V1\ExecuteAirflowCommandRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\ExecuteAirflowCommandResponse;
use Google\Cloud\Orchestration\Airflow\Service\V1\FetchDatabasePropertiesRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\FetchDatabasePropertiesResponse;
use Google\Cloud\Orchestration\Airflow\Service\V1\GetEnvironmentRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\GetUserWorkloadsConfigMapRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\GetUserWorkloadsSecretRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\ListEnvironmentsRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\ListUserWorkloadsConfigMapsRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\ListUserWorkloadsSecretsRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\ListWorkloadsRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\LoadSnapshotRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\PollAirflowCommandRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\PollAirflowCommandResponse;
use Google\Cloud\Orchestration\Airflow\Service\V1\SaveSnapshotRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\StopAirflowCommandRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\StopAirflowCommandResponse;
use Google\Cloud\Orchestration\Airflow\Service\V1\UpdateEnvironmentRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\UpdateUserWorkloadsConfigMapRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\UpdateUserWorkloadsSecretRequest;
use Google\Cloud\Orchestration\Airflow\Service\V1\UserWorkloadsConfigMap;
use Google\Cloud\Orchestration\Airflow\Service\V1\UserWorkloadsSecret;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Managed Apache Airflow Environments.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> checkUpgradeAsync(CheckUpgradeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createEnvironmentAsync(CreateEnvironmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<UserWorkloadsConfigMap> createUserWorkloadsConfigMapAsync(CreateUserWorkloadsConfigMapRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<UserWorkloadsSecret> createUserWorkloadsSecretAsync(CreateUserWorkloadsSecretRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> databaseFailoverAsync(DatabaseFailoverRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteEnvironmentAsync(DeleteEnvironmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteUserWorkloadsConfigMapAsync(DeleteUserWorkloadsConfigMapRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteUserWorkloadsSecretAsync(DeleteUserWorkloadsSecretRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ExecuteAirflowCommandResponse> executeAirflowCommandAsync(ExecuteAirflowCommandRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<FetchDatabasePropertiesResponse> fetchDatabasePropertiesAsync(FetchDatabasePropertiesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Environment> getEnvironmentAsync(GetEnvironmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<UserWorkloadsConfigMap> getUserWorkloadsConfigMapAsync(GetUserWorkloadsConfigMapRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<UserWorkloadsSecret> getUserWorkloadsSecretAsync(GetUserWorkloadsSecretRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listEnvironmentsAsync(ListEnvironmentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listUserWorkloadsConfigMapsAsync(ListUserWorkloadsConfigMapsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listUserWorkloadsSecretsAsync(ListUserWorkloadsSecretsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listWorkloadsAsync(ListWorkloadsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> loadSnapshotAsync(LoadSnapshotRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PollAirflowCommandResponse> pollAirflowCommandAsync(PollAirflowCommandRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> saveSnapshotAsync(SaveSnapshotRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<StopAirflowCommandResponse> stopAirflowCommandAsync(StopAirflowCommandRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateEnvironmentAsync(UpdateEnvironmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<UserWorkloadsConfigMap> updateUserWorkloadsConfigMapAsync(UpdateUserWorkloadsConfigMapRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<UserWorkloadsSecret> updateUserWorkloadsSecretAsync(UpdateUserWorkloadsSecretRequest $request, array $optionalArgs = [])
 */
final class EnvironmentsClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.orchestration.airflow.service.v1.Environments';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'composer.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'composer.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/environments_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/environments_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/environments_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/environments_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a environment
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $environment
     *
     * @return string The formatted environment resource.
     */
    public static function environmentName(string $project, string $location, string $environment): string
    {
        return self::getPathTemplate('environment')->render([
            'project' => $project,
            'location' => $location,
            'environment' => $environment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * user_workloads_config_map resource.
     *
     * @param string $project
     * @param string $location
     * @param string $environment
     * @param string $userWorkloadsConfigMap
     *
     * @return string The formatted user_workloads_config_map resource.
     */
    public static function userWorkloadsConfigMapName(
        string $project,
        string $location,
        string $environment,
        string $userWorkloadsConfigMap
    ): string {
        return self::getPathTemplate('userWorkloadsConfigMap')->render([
            'project' => $project,
            'location' => $location,
            'environment' => $environment,
            'user_workloads_config_map' => $userWorkloadsConfigMap,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * user_workloads_secret resource.
     *
     * @param string $project
     * @param string $location
     * @param string $environment
     * @param string $userWorkloadsSecret
     *
     * @return string The formatted user_workloads_secret resource.
     */
    public static function userWorkloadsSecretName(
        string $project,
        string $location,
        string $environment,
        string $userWorkloadsSecret
    ): string {
        return self::getPathTemplate('userWorkloadsSecret')->render([
            'project' => $project,
            'location' => $location,
            'environment' => $environment,
            'user_workloads_secret' => $userWorkloadsSecret,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - environment: projects/{project}/locations/{location}/environments/{environment}
     * - userWorkloadsConfigMap: projects/{project}/locations/{location}/environments/{environment}/userWorkloadsConfigMaps/{user_workloads_config_map}
     * - userWorkloadsSecret: projects/{project}/locations/{location}/environments/{environment}/userWorkloadsSecrets/{user_workloads_secret}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'composer.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Check if an upgrade operation on the environment will succeed.
     *
     * In case of problems detailed info can be found in the returned Operation.
     *
     * The async variant is {@see EnvironmentsClient::checkUpgradeAsync()} .
     *
     * @example samples/V1/EnvironmentsClient/check_upgrade.php
     *
     * @param CheckUpgradeRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function checkUpgrade(CheckUpgradeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CheckUpgrade', $request, $callOptions)->wait();
    }

    /**
     * Create a new environment.
     *
     * The async variant is {@see EnvironmentsClient::createEnvironmentAsync()} .
     *
     * @example samples/V1/EnvironmentsClient/create_environment.php
     *
     * @param CreateEnvironmentRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createEnvironment(CreateEnvironmentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateEnvironment', $request, $callOptions)->wait();
    }

    /**
     * Creates a user workloads ConfigMap.
     *
     * This method is supported for Cloud Composer environments in versions
     * composer-3.*.*-airflow-*.*.* and newer.
     *
     * The async variant is
     * {@see EnvironmentsClient::createUserWorkloadsConfigMapAsync()} .
     *
     * @example samples/V1/EnvironmentsClient/create_user_workloads_config_map.php
     *
     * @param CreateUserWorkloadsConfigMapRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return UserWorkloadsConfigMap
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createUserWorkloadsConfigMap(
        CreateUserWorkloadsConfigMapRequest $request,
        array $callOptions = []
    ): UserWorkloadsConfigMap {
        return $this->startApiCall('CreateUserWorkloadsConfigMap', $request, $callOptions)->wait();
    }

    /**
     * Creates a user workloads Secret.
     *
     * This method is supported for Cloud Composer environments in versions
     * composer-3.*.*-airflow-*.*.* and newer.
     *
     * The async variant is {@see EnvironmentsClient::createUserWorkloadsSecretAsync()}
     * .
     *
     * @example samples/V1/EnvironmentsClient/create_user_workloads_secret.php
     *
     * @param CreateUserWorkloadsSecretRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return UserWorkloadsSecret
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createUserWorkloadsSecret(
        CreateUserWorkloadsSecretRequest $request,
        array $callOptions = []
    ): UserWorkloadsSecret {
        return $this->startApiCall('CreateUserWorkloadsSecret', $request, $callOptions)->wait();
    }

    /**
     * Triggers database failover (only for highly resilient environments).
     *
     * The async variant is {@see EnvironmentsClient::databaseFailoverAsync()} .
     *
     * @example samples/V1/EnvironmentsClient/database_failover.php
     *
     * @param DatabaseFailoverRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function databaseFailover(DatabaseFailoverRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DatabaseFailover', $request, $callOptions)->wait();
    }

    /**
     * Delete an environment.
     *
     * The async variant is {@see EnvironmentsClient::deleteEnvironmentAsync()} .
     *
     * @example samples/V1/EnvironmentsClient/delete_environment.php
     *
     * @param DeleteEnvironmentRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteEnvironment(DeleteEnvironmentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteEnvironment', $request, $callOptions)->wait();
    }

    /**
     * Deletes a user workloads ConfigMap.
     *
     * This method is supported for Cloud Composer environments in versions
     * composer-3.*.*-airflow-*.*.* and newer.
     *
     * The async variant is
     * {@see EnvironmentsClient::deleteUserWorkloadsConfigMapAsync()} .
     *
     * @example samples/V1/EnvironmentsClient/delete_user_workloads_config_map.php
     *
     * @param DeleteUserWorkloadsConfigMapRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteUserWorkloadsConfigMap(
        DeleteUserWorkloadsConfigMapRequest $request,
        array $callOptions = []
    ): void {
        $this->startApiCall('DeleteUserWorkloadsConfigMap', $request, $callOptions)->wait();
    }

    /**
     * Deletes a user workloads Secret.
     *
     * This method is supported for Cloud Composer environments in versions
     * composer-3.*.*-airflow-*.*.* and newer.
     *
     * The async variant is {@see EnvironmentsClient::deleteUserWorkloadsSecretAsync()}
     * .
     *
     * @example samples/V1/EnvironmentsClient/delete_user_workloads_secret.php
     *
     * @param DeleteUserWorkloadsSecretRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteUserWorkloadsSecret(DeleteUserWorkloadsSecretRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteUserWorkloadsSecret', $request, $callOptions)->wait();
    }

    /**
     * Executes Airflow CLI command.
     *
     * The async variant is {@see EnvironmentsClient::executeAirflowCommandAsync()} .
     *
     * @example samples/V1/EnvironmentsClient/execute_airflow_command.php
     *
     * @param ExecuteAirflowCommandRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ExecuteAirflowCommandResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function executeAirflowCommand(
        ExecuteAirflowCommandRequest $request,
        array $callOptions = []
    ): ExecuteAirflowCommandResponse {
        return $this->startApiCall('ExecuteAirflowCommand', $request, $callOptions)->wait();
    }

    /**
     * Fetches database properties.
     *
     * The async variant is {@see EnvironmentsClient::fetchDatabasePropertiesAsync()} .
     *
     * @example samples/V1/EnvironmentsClient/fetch_database_properties.php
     *
     * @param FetchDatabasePropertiesRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FetchDatabasePropertiesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function fetchDatabaseProperties(
        FetchDatabasePropertiesRequest $request,
        array $callOptions = []
    ): FetchDatabasePropertiesResponse {
        return $this->startApiCall('FetchDatabaseProperties', $request, $callOptions)->wait();
    }

    /**
     * Get an existing environment.
     *
     * The async variant is {@see EnvironmentsClient::getEnvironmentAsync()} .
     *
     * @example samples/V1/EnvironmentsClient/get_environment.php
     *
     * @param GetEnvironmentRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Environment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEnvironment(GetEnvironmentRequest $request, array $callOptions = []): Environment
    {
        return $this->startApiCall('GetEnvironment', $request, $callOptions)->wait();
    }

    /**
     * Gets an existing user workloads ConfigMap.
     *
     * This method is supported for Cloud Composer environments in versions
     * composer-3.*.*-airflow-*.*.* and newer.
     *
     * The async variant is {@see EnvironmentsClient::getUserWorkloadsConfigMapAsync()}
     * .
     *
     * @example samples/V1/EnvironmentsClient/get_user_workloads_config_map.php
     *
     * @param GetUserWorkloadsConfigMapRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return UserWorkloadsConfigMap
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getUserWorkloadsConfigMap(
        GetUserWorkloadsConfigMapRequest $request,
        array $callOptions = []
    ): UserWorkloadsConfigMap {
        return $this->startApiCall('GetUserWorkloadsConfigMap', $request, $callOptions)->wait();
    }

    /**
     * Gets an existing user workloads Secret.
     * Values of the "data" field in the response are cleared.
     *
     * This method is supported for Cloud Composer environments in versions
     * composer-3.*.*-airflow-*.*.* and newer.
     *
     * The async variant is {@see EnvironmentsClient::getUserWorkloadsSecretAsync()} .
     *
     * @example samples/V1/EnvironmentsClient/get_user_workloads_secret.php
     *
     * @param GetUserWorkloadsSecretRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return UserWorkloadsSecret
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getUserWorkloadsSecret(
        GetUserWorkloadsSecretRequest $request,
        array $callOptions = []
    ): UserWorkloadsSecret {
        return $this->startApiCall('GetUserWorkloadsSecret', $request, $callOptions)->wait();
    }

    /**
     * List environments.
     *
     * The async variant is {@see EnvironmentsClient::listEnvironmentsAsync()} .
     *
     * @example samples/V1/EnvironmentsClient/list_environments.php
     *
     * @param ListEnvironmentsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEnvironments(ListEnvironmentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEnvironments', $request, $callOptions);
    }

    /**
     * Lists user workloads ConfigMaps.
     *
     * This method is supported for Cloud Composer environments in versions
     * composer-3.*.*-airflow-*.*.* and newer.
     *
     * The async variant is
     * {@see EnvironmentsClient::listUserWorkloadsConfigMapsAsync()} .
     *
     * @example samples/V1/EnvironmentsClient/list_user_workloads_config_maps.php
     *
     * @param ListUserWorkloadsConfigMapsRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listUserWorkloadsConfigMaps(
        ListUserWorkloadsConfigMapsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListUserWorkloadsConfigMaps', $request, $callOptions);
    }

    /**
     * Lists user workloads Secrets.
     *
     * This method is supported for Cloud Composer environments in versions
     * composer-3.*.*-airflow-*.*.* and newer.
     *
     * The async variant is {@see EnvironmentsClient::listUserWorkloadsSecretsAsync()}
     * .
     *
     * @example samples/V1/EnvironmentsClient/list_user_workloads_secrets.php
     *
     * @param ListUserWorkloadsSecretsRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listUserWorkloadsSecrets(
        ListUserWorkloadsSecretsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListUserWorkloadsSecrets', $request, $callOptions);
    }

    /**
     * Lists workloads in a Cloud Composer environment. Workload is a unit that
     * runs a single Composer component.
     *
     * This method is supported for Cloud Composer environments in versions
     * composer-3.*.*-airflow-*.*.* and newer.
     *
     * The async variant is {@see EnvironmentsClient::listWorkloadsAsync()} .
     *
     * @example samples/V1/EnvironmentsClient/list_workloads.php
     *
     * @param ListWorkloadsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listWorkloads(ListWorkloadsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListWorkloads', $request, $callOptions);
    }

    /**
     * Loads a snapshot of a Cloud Composer environment.
     *
     * As a result of this operation, a snapshot of environment's specified in
     * LoadSnapshotRequest is loaded into the environment.
     *
     * The async variant is {@see EnvironmentsClient::loadSnapshotAsync()} .
     *
     * @example samples/V1/EnvironmentsClient/load_snapshot.php
     *
     * @param LoadSnapshotRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function loadSnapshot(LoadSnapshotRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('LoadSnapshot', $request, $callOptions)->wait();
    }

    /**
     * Polls Airflow CLI command execution and fetches logs.
     *
     * The async variant is {@see EnvironmentsClient::pollAirflowCommandAsync()} .
     *
     * @example samples/V1/EnvironmentsClient/poll_airflow_command.php
     *
     * @param PollAirflowCommandRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PollAirflowCommandResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function pollAirflowCommand(
        PollAirflowCommandRequest $request,
        array $callOptions = []
    ): PollAirflowCommandResponse {
        return $this->startApiCall('PollAirflowCommand', $request, $callOptions)->wait();
    }

    /**
     * Creates a snapshots of a Cloud Composer environment.
     *
     * As a result of this operation, snapshot of environment's state is stored
     * in a location specified in the SaveSnapshotRequest.
     *
     * The async variant is {@see EnvironmentsClient::saveSnapshotAsync()} .
     *
     * @example samples/V1/EnvironmentsClient/save_snapshot.php
     *
     * @param SaveSnapshotRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function saveSnapshot(SaveSnapshotRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SaveSnapshot', $request, $callOptions)->wait();
    }

    /**
     * Stops Airflow CLI command execution.
     *
     * The async variant is {@see EnvironmentsClient::stopAirflowCommandAsync()} .
     *
     * @example samples/V1/EnvironmentsClient/stop_airflow_command.php
     *
     * @param StopAirflowCommandRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return StopAirflowCommandResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function stopAirflowCommand(
        StopAirflowCommandRequest $request,
        array $callOptions = []
    ): StopAirflowCommandResponse {
        return $this->startApiCall('StopAirflowCommand', $request, $callOptions)->wait();
    }

    /**
     * Update an environment.
     *
     * The async variant is {@see EnvironmentsClient::updateEnvironmentAsync()} .
     *
     * @example samples/V1/EnvironmentsClient/update_environment.php
     *
     * @param UpdateEnvironmentRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateEnvironment(UpdateEnvironmentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateEnvironment', $request, $callOptions)->wait();
    }

    /**
     * Updates a user workloads ConfigMap.
     *
     * This method is supported for Cloud Composer environments in versions
     * composer-3.*.*-airflow-*.*.* and newer.
     *
     * The async variant is
     * {@see EnvironmentsClient::updateUserWorkloadsConfigMapAsync()} .
     *
     * @example samples/V1/EnvironmentsClient/update_user_workloads_config_map.php
     *
     * @param UpdateUserWorkloadsConfigMapRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return UserWorkloadsConfigMap
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateUserWorkloadsConfigMap(
        UpdateUserWorkloadsConfigMapRequest $request,
        array $callOptions = []
    ): UserWorkloadsConfigMap {
        return $this->startApiCall('UpdateUserWorkloadsConfigMap', $request, $callOptions)->wait();
    }

    /**
     * Updates a user workloads Secret.
     *
     * This method is supported for Cloud Composer environments in versions
     * composer-3.*.*-airflow-*.*.* and newer.
     *
     * The async variant is {@see EnvironmentsClient::updateUserWorkloadsSecretAsync()}
     * .
     *
     * @example samples/V1/EnvironmentsClient/update_user_workloads_secret.php
     *
     * @param UpdateUserWorkloadsSecretRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return UserWorkloadsSecret
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateUserWorkloadsSecret(
        UpdateUserWorkloadsSecretRequest $request,
        array $callOptions = []
    ): UserWorkloadsSecret {
        return $this->startApiCall('UpdateUserWorkloadsSecret', $request, $callOptions)->wait();
    }
}
