<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/managedidentities/v1/resource.proto

namespace Google\Cloud\ManagedIdentities\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a relationship between two domains. This allows a controller in
 * one domain to authenticate a user in another domain.
 *
 * Generated from protobuf message <code>google.cloud.managedidentities.v1.Trust</code>
 */
class Trust extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The fully qualified target domain name which will be in trust with the
     * current domain.
     *
     * Generated from protobuf field <code>string target_domain_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $target_domain_name = '';
    /**
     * Required. The type of trust represented by the trust resource.
     *
     * Generated from protobuf field <code>.google.cloud.managedidentities.v1.Trust.TrustType trust_type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $trust_type = 0;
    /**
     * Required. The trust direction, which decides if the current domain is trusted,
     * trusting, or both.
     *
     * Generated from protobuf field <code>.google.cloud.managedidentities.v1.Trust.TrustDirection trust_direction = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $trust_direction = 0;
    /**
     * Optional. The trust authentication type, which decides whether the trusted side has
     * forest/domain wide access or selective access to an approved set of
     * resources.
     *
     * Generated from protobuf field <code>bool selective_authentication = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $selective_authentication = false;
    /**
     * Required. The target DNS server IP addresses which can resolve the remote domain
     * involved in the trust.
     *
     * Generated from protobuf field <code>repeated string target_dns_ip_addresses = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $target_dns_ip_addresses;
    /**
     * Required. The trust secret used for the handshake with the target domain. This will
     * not be stored.
     *
     * Generated from protobuf field <code>string trust_handshake_secret = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $trust_handshake_secret = '';
    /**
     * Output only. The time the instance was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The last update time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Output only. The current state of the trust.
     *
     * Generated from protobuf field <code>.google.cloud.managedidentities.v1.Trust.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. Additional information about the current state of the trust, if available.
     *
     * Generated from protobuf field <code>string state_description = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state_description = '';
    /**
     * Output only. The last heartbeat time when the trust was known to be connected.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_trust_heartbeat_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_trust_heartbeat_time = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $target_domain_name
     *           Required. The fully qualified target domain name which will be in trust with the
     *           current domain.
     *     @type int $trust_type
     *           Required. The type of trust represented by the trust resource.
     *     @type int $trust_direction
     *           Required. The trust direction, which decides if the current domain is trusted,
     *           trusting, or both.
     *     @type bool $selective_authentication
     *           Optional. The trust authentication type, which decides whether the trusted side has
     *           forest/domain wide access or selective access to an approved set of
     *           resources.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $target_dns_ip_addresses
     *           Required. The target DNS server IP addresses which can resolve the remote domain
     *           involved in the trust.
     *     @type string $trust_handshake_secret
     *           Required. The trust secret used for the handshake with the target domain. This will
     *           not be stored.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time the instance was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The last update time.
     *     @type int $state
     *           Output only. The current state of the trust.
     *     @type string $state_description
     *           Output only. Additional information about the current state of the trust, if available.
     *     @type \Google\Protobuf\Timestamp $last_trust_heartbeat_time
     *           Output only. The last heartbeat time when the trust was known to be connected.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Managedidentities\V1\Resource::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The fully qualified target domain name which will be in trust with the
     * current domain.
     *
     * Generated from protobuf field <code>string target_domain_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getTargetDomainName()
    {
        return $this->target_domain_name;
    }

    /**
     * Required. The fully qualified target domain name which will be in trust with the
     * current domain.
     *
     * Generated from protobuf field <code>string target_domain_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setTargetDomainName($var)
    {
        GPBUtil::checkString($var, True);
        $this->target_domain_name = $var;

        return $this;
    }

    /**
     * Required. The type of trust represented by the trust resource.
     *
     * Generated from protobuf field <code>.google.cloud.managedidentities.v1.Trust.TrustType trust_type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getTrustType()
    {
        return $this->trust_type;
    }

    /**
     * Required. The type of trust represented by the trust resource.
     *
     * Generated from protobuf field <code>.google.cloud.managedidentities.v1.Trust.TrustType trust_type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setTrustType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\ManagedIdentities\V1\Trust\TrustType::class);
        $this->trust_type = $var;

        return $this;
    }

    /**
     * Required. The trust direction, which decides if the current domain is trusted,
     * trusting, or both.
     *
     * Generated from protobuf field <code>.google.cloud.managedidentities.v1.Trust.TrustDirection trust_direction = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getTrustDirection()
    {
        return $this->trust_direction;
    }

    /**
     * Required. The trust direction, which decides if the current domain is trusted,
     * trusting, or both.
     *
     * Generated from protobuf field <code>.google.cloud.managedidentities.v1.Trust.TrustDirection trust_direction = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setTrustDirection($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\ManagedIdentities\V1\Trust\TrustDirection::class);
        $this->trust_direction = $var;

        return $this;
    }

    /**
     * Optional. The trust authentication type, which decides whether the trusted side has
     * forest/domain wide access or selective access to an approved set of
     * resources.
     *
     * Generated from protobuf field <code>bool selective_authentication = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getSelectiveAuthentication()
    {
        return $this->selective_authentication;
    }

    /**
     * Optional. The trust authentication type, which decides whether the trusted side has
     * forest/domain wide access or selective access to an approved set of
     * resources.
     *
     * Generated from protobuf field <code>bool selective_authentication = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setSelectiveAuthentication($var)
    {
        GPBUtil::checkBool($var);
        $this->selective_authentication = $var;

        return $this;
    }

    /**
     * Required. The target DNS server IP addresses which can resolve the remote domain
     * involved in the trust.
     *
     * Generated from protobuf field <code>repeated string target_dns_ip_addresses = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTargetDnsIpAddresses()
    {
        return $this->target_dns_ip_addresses;
    }

    /**
     * Required. The target DNS server IP addresses which can resolve the remote domain
     * involved in the trust.
     *
     * Generated from protobuf field <code>repeated string target_dns_ip_addresses = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTargetDnsIpAddresses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->target_dns_ip_addresses = $arr;

        return $this;
    }

    /**
     * Required. The trust secret used for the handshake with the target domain. This will
     * not be stored.
     *
     * Generated from protobuf field <code>string trust_handshake_secret = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getTrustHandshakeSecret()
    {
        return $this->trust_handshake_secret;
    }

    /**
     * Required. The trust secret used for the handshake with the target domain. This will
     * not be stored.
     *
     * Generated from protobuf field <code>string trust_handshake_secret = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setTrustHandshakeSecret($var)
    {
        GPBUtil::checkString($var, True);
        $this->trust_handshake_secret = $var;

        return $this;
    }

    /**
     * Output only. The time the instance was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time the instance was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The last update time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The last update time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. The current state of the trust.
     *
     * Generated from protobuf field <code>.google.cloud.managedidentities.v1.Trust.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The current state of the trust.
     *
     * Generated from protobuf field <code>.google.cloud.managedidentities.v1.Trust.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\ManagedIdentities\V1\Trust\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. Additional information about the current state of the trust, if available.
     *
     * Generated from protobuf field <code>string state_description = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getStateDescription()
    {
        return $this->state_description;
    }

    /**
     * Output only. Additional information about the current state of the trust, if available.
     *
     * Generated from protobuf field <code>string state_description = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setStateDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->state_description = $var;

        return $this;
    }

    /**
     * Output only. The last heartbeat time when the trust was known to be connected.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_trust_heartbeat_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getLastTrustHeartbeatTime()
    {
        return $this->last_trust_heartbeat_time;
    }

    public function hasLastTrustHeartbeatTime()
    {
        return isset($this->last_trust_heartbeat_time);
    }

    public function clearLastTrustHeartbeatTime()
    {
        unset($this->last_trust_heartbeat_time);
    }

    /**
     * Output only. The last heartbeat time when the trust was known to be connected.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_trust_heartbeat_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLastTrustHeartbeatTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->last_trust_heartbeat_time = $var;

        return $this;
    }

}

