<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/firestore/admin/v1/firestore_admin.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Firestore\Admin\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Firestore\Admin\V1\Backup;
use Google\Cloud\Firestore\Admin\V1\BackupSchedule;
use Google\Cloud\Firestore\Admin\V1\BulkDeleteDocumentsRequest;
use Google\Cloud\Firestore\Admin\V1\CreateBackupScheduleRequest;
use Google\Cloud\Firestore\Admin\V1\CreateDatabaseRequest;
use Google\Cloud\Firestore\Admin\V1\CreateIndexRequest;
use Google\Cloud\Firestore\Admin\V1\Database;
use Google\Cloud\Firestore\Admin\V1\DeleteBackupRequest;
use Google\Cloud\Firestore\Admin\V1\DeleteBackupScheduleRequest;
use Google\Cloud\Firestore\Admin\V1\DeleteDatabaseRequest;
use Google\Cloud\Firestore\Admin\V1\DeleteIndexRequest;
use Google\Cloud\Firestore\Admin\V1\ExportDocumentsRequest;
use Google\Cloud\Firestore\Admin\V1\Field;
use Google\Cloud\Firestore\Admin\V1\FieldOperationMetadata;
use Google\Cloud\Firestore\Admin\V1\GetBackupRequest;
use Google\Cloud\Firestore\Admin\V1\GetBackupScheduleRequest;
use Google\Cloud\Firestore\Admin\V1\GetDatabaseRequest;
use Google\Cloud\Firestore\Admin\V1\GetFieldRequest;
use Google\Cloud\Firestore\Admin\V1\GetIndexRequest;
use Google\Cloud\Firestore\Admin\V1\ImportDocumentsRequest;
use Google\Cloud\Firestore\Admin\V1\Index;
use Google\Cloud\Firestore\Admin\V1\IndexOperationMetadata;
use Google\Cloud\Firestore\Admin\V1\ListBackupSchedulesRequest;
use Google\Cloud\Firestore\Admin\V1\ListBackupSchedulesResponse;
use Google\Cloud\Firestore\Admin\V1\ListBackupsRequest;
use Google\Cloud\Firestore\Admin\V1\ListBackupsResponse;
use Google\Cloud\Firestore\Admin\V1\ListDatabasesRequest;
use Google\Cloud\Firestore\Admin\V1\ListDatabasesResponse;
use Google\Cloud\Firestore\Admin\V1\ListFieldsRequest;
use Google\Cloud\Firestore\Admin\V1\ListIndexesRequest;
use Google\Cloud\Firestore\Admin\V1\RestoreDatabaseMetadata;
use Google\Cloud\Firestore\Admin\V1\RestoreDatabaseRequest;
use Google\Cloud\Firestore\Admin\V1\UpdateBackupScheduleRequest;
use Google\Cloud\Firestore\Admin\V1\UpdateDatabaseRequest;
use Google\Cloud\Firestore\Admin\V1\UpdateFieldRequest;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: The Cloud Firestore Admin API.
 *
 * This API provides several administrative services for Cloud Firestore.
 *
 * Project, Database, Namespace, Collection, Collection Group, and Document are
 * used as defined in the Google Cloud Firestore API.
 *
 * Operation: An Operation represents work being performed in the background.
 *
 * The index service manages Cloud Firestore indexes.
 *
 * Index creation is performed asynchronously.
 * An Operation resource is created for each such asynchronous operation.
 * The state of the operation (including any errors encountered)
 * may be queried via the Operation resource.
 *
 * The Operations collection provides a record of actions performed for the
 * specified Project (including any Operations in progress). Operations are not
 * created directly but through calls on other collections or resources.
 *
 * An Operation that is done may be deleted so that it is no longer listed as
 * part of the Operation collection. Operations are garbage collected after
 * 30 days. By default, ListOperations will only return in progress and failed
 * operations. To list completed operation, issue a ListOperations request with
 * the filter `done: true`.
 *
 * Operations are created by service `FirestoreAdmin`, but are accessed via
 * service `google.longrunning.Operations`.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> bulkDeleteDocumentsAsync(BulkDeleteDocumentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BackupSchedule> createBackupScheduleAsync(CreateBackupScheduleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createDatabaseAsync(CreateDatabaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createIndexAsync(CreateIndexRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteBackupAsync(DeleteBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteBackupScheduleAsync(DeleteBackupScheduleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteDatabaseAsync(DeleteDatabaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteIndexAsync(DeleteIndexRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> exportDocumentsAsync(ExportDocumentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Backup> getBackupAsync(GetBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BackupSchedule> getBackupScheduleAsync(GetBackupScheduleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Database> getDatabaseAsync(GetDatabaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Field> getFieldAsync(GetFieldRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Index> getIndexAsync(GetIndexRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> importDocumentsAsync(ImportDocumentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ListBackupSchedulesResponse> listBackupSchedulesAsync(ListBackupSchedulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ListBackupsResponse> listBackupsAsync(ListBackupsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ListDatabasesResponse> listDatabasesAsync(ListDatabasesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listFieldsAsync(ListFieldsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listIndexesAsync(ListIndexesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> restoreDatabaseAsync(RestoreDatabaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BackupSchedule> updateBackupScheduleAsync(UpdateBackupScheduleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateDatabaseAsync(UpdateDatabaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateFieldAsync(UpdateFieldRequest $request, array $optionalArgs = [])
 */
final class FirestoreAdminClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.firestore.admin.v1.FirestoreAdmin';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'firestore.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'firestore.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/datastore',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/firestore_admin_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/firestore_admin_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/firestore_admin_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/firestore_admin_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a backup
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backup
     *
     * @return string The formatted backup resource.
     */
    public static function backupName(string $project, string $location, string $backup): string
    {
        return self::getPathTemplate('backup')->render([
            'project' => $project,
            'location' => $location,
            'backup' => $backup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * backup_schedule resource.
     *
     * @param string $project
     * @param string $database
     * @param string $backupSchedule
     *
     * @return string The formatted backup_schedule resource.
     */
    public static function backupScheduleName(string $project, string $database, string $backupSchedule): string
    {
        return self::getPathTemplate('backupSchedule')->render([
            'project' => $project,
            'database' => $database,
            'backup_schedule' => $backupSchedule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * collection_group resource.
     *
     * @param string $project
     * @param string $database
     * @param string $collection
     *
     * @return string The formatted collection_group resource.
     */
    public static function collectionGroupName(string $project, string $database, string $collection): string
    {
        return self::getPathTemplate('collectionGroup')->render([
            'project' => $project,
            'database' => $database,
            'collection' => $collection,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a database
     * resource.
     *
     * @param string $project
     * @param string $database
     *
     * @return string The formatted database resource.
     */
    public static function databaseName(string $project, string $database): string
    {
        return self::getPathTemplate('database')->render([
            'project' => $project,
            'database' => $database,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a field
     * resource.
     *
     * @param string $project
     * @param string $database
     * @param string $collection
     * @param string $field
     *
     * @return string The formatted field resource.
     */
    public static function fieldName(string $project, string $database, string $collection, string $field): string
    {
        return self::getPathTemplate('field')->render([
            'project' => $project,
            'database' => $database,
            'collection' => $collection,
            'field' => $field,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a index
     * resource.
     *
     * @param string $project
     * @param string $database
     * @param string $collection
     * @param string $index
     *
     * @return string The formatted index resource.
     */
    public static function indexName(string $project, string $database, string $collection, string $index): string
    {
        return self::getPathTemplate('index')->render([
            'project' => $project,
            'database' => $database,
            'collection' => $collection,
            'index' => $index,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a operation
     * resource.
     *
     * @param string $project
     * @param string $database
     * @param string $operation
     *
     * @return string The formatted operation resource.
     */
    public static function operationName(string $project, string $database, string $operation): string
    {
        return self::getPathTemplate('operation')->render([
            'project' => $project,
            'database' => $database,
            'operation' => $operation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName(string $project): string
    {
        return self::getPathTemplate('project')->render([
            'project' => $project,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - backup: projects/{project}/locations/{location}/backups/{backup}
     * - backupSchedule: projects/{project}/databases/{database}/backupSchedules/{backup_schedule}
     * - collectionGroup: projects/{project}/databases/{database}/collectionGroups/{collection}
     * - database: projects/{project}/databases/{database}
     * - field: projects/{project}/databases/{database}/collectionGroups/{collection}/fields/{field}
     * - index: projects/{project}/databases/{database}/collectionGroups/{collection}/indexes/{index}
     * - location: projects/{project}/locations/{location}
     * - operation: projects/{project}/databases/{database}/operations/{operation}
     * - project: projects/{project}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'firestore.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Bulk deletes a subset of documents from Google Cloud Firestore.
     * Documents created or updated after the underlying system starts to process
     * the request will not be deleted. The bulk delete occurs in the background
     * and its progress can be monitored and managed via the Operation resource
     * that is created.
     *
     * For more details on bulk delete behavior, refer to:
     * https://cloud.google.com/firestore/docs/manage-data/bulk-delete
     *
     * The async variant is {@see FirestoreAdminClient::bulkDeleteDocumentsAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/bulk_delete_documents.php
     *
     * @param BulkDeleteDocumentsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function bulkDeleteDocuments(BulkDeleteDocumentsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('BulkDeleteDocuments', $request, $callOptions)->wait();
    }

    /**
     * Creates a backup schedule on a database.
     * At most two backup schedules can be configured on a database, one daily
     * backup schedule and one weekly backup schedule.
     *
     * The async variant is {@see FirestoreAdminClient::createBackupScheduleAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/create_backup_schedule.php
     *
     * @param CreateBackupScheduleRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BackupSchedule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBackupSchedule(CreateBackupScheduleRequest $request, array $callOptions = []): BackupSchedule
    {
        return $this->startApiCall('CreateBackupSchedule', $request, $callOptions)->wait();
    }

    /**
     * Create a database.
     *
     * The async variant is {@see FirestoreAdminClient::createDatabaseAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/create_database.php
     *
     * @param CreateDatabaseRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDatabase(CreateDatabaseRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateDatabase', $request, $callOptions)->wait();
    }

    /**
     * Creates a composite index. This returns a
     * [google.longrunning.Operation][google.longrunning.Operation] which may be
     * used to track the status of the creation. The metadata for the operation
     * will be the type
     * [IndexOperationMetadata][google.firestore.admin.v1.IndexOperationMetadata].
     *
     * The async variant is {@see FirestoreAdminClient::createIndexAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/create_index.php
     *
     * @param CreateIndexRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createIndex(CreateIndexRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateIndex', $request, $callOptions)->wait();
    }

    /**
     * Deletes a backup.
     *
     * The async variant is {@see FirestoreAdminClient::deleteBackupAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/delete_backup.php
     *
     * @param DeleteBackupRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBackup(DeleteBackupRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteBackup', $request, $callOptions)->wait();
    }

    /**
     * Deletes a backup schedule.
     *
     * The async variant is {@see FirestoreAdminClient::deleteBackupScheduleAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/delete_backup_schedule.php
     *
     * @param DeleteBackupScheduleRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBackupSchedule(DeleteBackupScheduleRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteBackupSchedule', $request, $callOptions)->wait();
    }

    /**
     * Deletes a database.
     *
     * The async variant is {@see FirestoreAdminClient::deleteDatabaseAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/delete_database.php
     *
     * @param DeleteDatabaseRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteDatabase(DeleteDatabaseRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteDatabase', $request, $callOptions)->wait();
    }

    /**
     * Deletes a composite index.
     *
     * The async variant is {@see FirestoreAdminClient::deleteIndexAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/delete_index.php
     *
     * @param DeleteIndexRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteIndex(DeleteIndexRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteIndex', $request, $callOptions)->wait();
    }

    /**
     * Exports a copy of all or a subset of documents from Google Cloud Firestore
     * to another storage system, such as Google Cloud Storage. Recent updates to
     * documents may not be reflected in the export. The export occurs in the
     * background and its progress can be monitored and managed via the
     * Operation resource that is created. The output of an export may only be
     * used once the associated operation is done. If an export operation is
     * cancelled before completion it may leave partial data behind in Google
     * Cloud Storage.
     *
     * For more details on export behavior and output format, refer to:
     * https://cloud.google.com/firestore/docs/manage-data/export-import
     *
     * The async variant is {@see FirestoreAdminClient::exportDocumentsAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/export_documents.php
     *
     * @param ExportDocumentsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function exportDocuments(ExportDocumentsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ExportDocuments', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a backup.
     *
     * The async variant is {@see FirestoreAdminClient::getBackupAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/get_backup.php
     *
     * @param GetBackupRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Backup
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBackup(GetBackupRequest $request, array $callOptions = []): Backup
    {
        return $this->startApiCall('GetBackup', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a backup schedule.
     *
     * The async variant is {@see FirestoreAdminClient::getBackupScheduleAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/get_backup_schedule.php
     *
     * @param GetBackupScheduleRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BackupSchedule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBackupSchedule(GetBackupScheduleRequest $request, array $callOptions = []): BackupSchedule
    {
        return $this->startApiCall('GetBackupSchedule', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a database.
     *
     * The async variant is {@see FirestoreAdminClient::getDatabaseAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/get_database.php
     *
     * @param GetDatabaseRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Database
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDatabase(GetDatabaseRequest $request, array $callOptions = []): Database
    {
        return $this->startApiCall('GetDatabase', $request, $callOptions)->wait();
    }

    /**
     * Gets the metadata and configuration for a Field.
     *
     * The async variant is {@see FirestoreAdminClient::getFieldAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/get_field.php
     *
     * @param GetFieldRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Field
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getField(GetFieldRequest $request, array $callOptions = []): Field
    {
        return $this->startApiCall('GetField', $request, $callOptions)->wait();
    }

    /**
     * Gets a composite index.
     *
     * The async variant is {@see FirestoreAdminClient::getIndexAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/get_index.php
     *
     * @param GetIndexRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Index
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIndex(GetIndexRequest $request, array $callOptions = []): Index
    {
        return $this->startApiCall('GetIndex', $request, $callOptions)->wait();
    }

    /**
     * Imports documents into Google Cloud Firestore. Existing documents with the
     * same name are overwritten. The import occurs in the background and its
     * progress can be monitored and managed via the Operation resource that is
     * created. If an ImportDocuments operation is cancelled, it is possible
     * that a subset of the data has already been imported to Cloud Firestore.
     *
     * The async variant is {@see FirestoreAdminClient::importDocumentsAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/import_documents.php
     *
     * @param ImportDocumentsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function importDocuments(ImportDocumentsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ImportDocuments', $request, $callOptions)->wait();
    }

    /**
     * List backup schedules.
     *
     * The async variant is {@see FirestoreAdminClient::listBackupSchedulesAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/list_backup_schedules.php
     *
     * @param ListBackupSchedulesRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ListBackupSchedulesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBackupSchedules(ListBackupSchedulesRequest $request, array $callOptions = []): ListBackupSchedulesResponse
    {
        return $this->startApiCall('ListBackupSchedules', $request, $callOptions)->wait();
    }

    /**
     * Lists all the backups.
     *
     * The async variant is {@see FirestoreAdminClient::listBackupsAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/list_backups.php
     *
     * @param ListBackupsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ListBackupsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBackups(ListBackupsRequest $request, array $callOptions = []): ListBackupsResponse
    {
        return $this->startApiCall('ListBackups', $request, $callOptions)->wait();
    }

    /**
     * List all the databases in the project.
     *
     * The async variant is {@see FirestoreAdminClient::listDatabasesAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/list_databases.php
     *
     * @param ListDatabasesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ListDatabasesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDatabases(ListDatabasesRequest $request, array $callOptions = []): ListDatabasesResponse
    {
        return $this->startApiCall('ListDatabases', $request, $callOptions)->wait();
    }

    /**
     * Lists the field configuration and metadata for this database.
     *
     * Currently,
     * [FirestoreAdmin.ListFields][google.firestore.admin.v1.FirestoreAdmin.ListFields]
     * only supports listing fields that have been explicitly overridden. To issue
     * this query, call
     * [FirestoreAdmin.ListFields][google.firestore.admin.v1.FirestoreAdmin.ListFields]
     * with the filter set to `indexConfig.usesAncestorConfig:false` or
     * `ttlConfig:*`.
     *
     * The async variant is {@see FirestoreAdminClient::listFieldsAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/list_fields.php
     *
     * @param ListFieldsRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listFields(ListFieldsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListFields', $request, $callOptions);
    }

    /**
     * Lists composite indexes.
     *
     * The async variant is {@see FirestoreAdminClient::listIndexesAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/list_indexes.php
     *
     * @param ListIndexesRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listIndexes(ListIndexesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListIndexes', $request, $callOptions);
    }

    /**
     * Creates a new database by restoring from an existing backup.
     *
     * The new database must be in the same cloud region or multi-region location
     * as the existing backup. This behaves similar to
     * [FirestoreAdmin.CreateDatabase][google.firestore.admin.v1.FirestoreAdmin.CreateDatabase]
     * except instead of creating a new empty database, a new database is created
     * with the database type, index configuration, and documents from an existing
     * backup.
     *
     * The [long-running operation][google.longrunning.Operation] can be used to
     * track the progress of the restore, with the Operation's
     * [metadata][google.longrunning.Operation.metadata] field type being the
     * [RestoreDatabaseMetadata][google.firestore.admin.v1.RestoreDatabaseMetadata].
     * The [response][google.longrunning.Operation.response] type is the
     * [Database][google.firestore.admin.v1.Database] if the restore was
     * successful. The new database is not readable or writeable until the LRO has
     * completed.
     *
     * The async variant is {@see FirestoreAdminClient::restoreDatabaseAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/restore_database.php
     *
     * @param RestoreDatabaseRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function restoreDatabase(RestoreDatabaseRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RestoreDatabase', $request, $callOptions)->wait();
    }

    /**
     * Updates a backup schedule.
     *
     * The async variant is {@see FirestoreAdminClient::updateBackupScheduleAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/update_backup_schedule.php
     *
     * @param UpdateBackupScheduleRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BackupSchedule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBackupSchedule(UpdateBackupScheduleRequest $request, array $callOptions = []): BackupSchedule
    {
        return $this->startApiCall('UpdateBackupSchedule', $request, $callOptions)->wait();
    }

    /**
     * Updates a database.
     *
     * The async variant is {@see FirestoreAdminClient::updateDatabaseAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/update_database.php
     *
     * @param UpdateDatabaseRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDatabase(UpdateDatabaseRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateDatabase', $request, $callOptions)->wait();
    }

    /**
     * Updates a field configuration. Currently, field updates apply only to
     * single field index configuration. However, calls to
     * [FirestoreAdmin.UpdateField][google.firestore.admin.v1.FirestoreAdmin.UpdateField]
     * should provide a field mask to avoid changing any configuration that the
     * caller isn't aware of. The field mask should be specified as: `{ paths:
     * "index_config" }`.
     *
     * This call returns a
     * [google.longrunning.Operation][google.longrunning.Operation] which may be
     * used to track the status of the field update. The metadata for the
     * operation will be the type
     * [FieldOperationMetadata][google.firestore.admin.v1.FieldOperationMetadata].
     *
     * To configure the default field settings for the database, use
     * the special `Field` with resource name:
     * `projects/{project_id}/databases/{database_id}/collectionGroups/__default__/fields/*`.
     *
     * The async variant is {@see FirestoreAdminClient::updateFieldAsync()} .
     *
     * @example samples/V1/FirestoreAdminClient/update_field.php
     *
     * @param UpdateFieldRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateField(UpdateFieldRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateField', $request, $callOptions)->wait();
    }
}
