<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/dataform/v1beta1/dataform.proto
 * Updates to the above are reflected here through a refresh process.
 *
 * @experimental
 */

namespace Google\Cloud\Dataform\V1beta1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dataform\V1beta1\CancelWorkflowInvocationRequest;
use Google\Cloud\Dataform\V1beta1\CommitRepositoryChangesRequest;
use Google\Cloud\Dataform\V1beta1\CommitWorkspaceChangesRequest;
use Google\Cloud\Dataform\V1beta1\CompilationResult;
use Google\Cloud\Dataform\V1beta1\ComputeRepositoryAccessTokenStatusRequest;
use Google\Cloud\Dataform\V1beta1\ComputeRepositoryAccessTokenStatusResponse;
use Google\Cloud\Dataform\V1beta1\CreateCompilationResultRequest;
use Google\Cloud\Dataform\V1beta1\CreateReleaseConfigRequest;
use Google\Cloud\Dataform\V1beta1\CreateRepositoryRequest;
use Google\Cloud\Dataform\V1beta1\CreateWorkflowConfigRequest;
use Google\Cloud\Dataform\V1beta1\CreateWorkflowInvocationRequest;
use Google\Cloud\Dataform\V1beta1\CreateWorkspaceRequest;
use Google\Cloud\Dataform\V1beta1\DeleteReleaseConfigRequest;
use Google\Cloud\Dataform\V1beta1\DeleteRepositoryRequest;
use Google\Cloud\Dataform\V1beta1\DeleteWorkflowConfigRequest;
use Google\Cloud\Dataform\V1beta1\DeleteWorkflowInvocationRequest;
use Google\Cloud\Dataform\V1beta1\DeleteWorkspaceRequest;
use Google\Cloud\Dataform\V1beta1\FetchFileDiffRequest;
use Google\Cloud\Dataform\V1beta1\FetchFileDiffResponse;
use Google\Cloud\Dataform\V1beta1\FetchFileGitStatusesRequest;
use Google\Cloud\Dataform\V1beta1\FetchFileGitStatusesResponse;
use Google\Cloud\Dataform\V1beta1\FetchGitAheadBehindRequest;
use Google\Cloud\Dataform\V1beta1\FetchGitAheadBehindResponse;
use Google\Cloud\Dataform\V1beta1\FetchRemoteBranchesRequest;
use Google\Cloud\Dataform\V1beta1\FetchRemoteBranchesResponse;
use Google\Cloud\Dataform\V1beta1\FetchRepositoryHistoryRequest;
use Google\Cloud\Dataform\V1beta1\GetCompilationResultRequest;
use Google\Cloud\Dataform\V1beta1\GetReleaseConfigRequest;
use Google\Cloud\Dataform\V1beta1\GetRepositoryRequest;
use Google\Cloud\Dataform\V1beta1\GetWorkflowConfigRequest;
use Google\Cloud\Dataform\V1beta1\GetWorkflowInvocationRequest;
use Google\Cloud\Dataform\V1beta1\GetWorkspaceRequest;
use Google\Cloud\Dataform\V1beta1\InstallNpmPackagesRequest;
use Google\Cloud\Dataform\V1beta1\InstallNpmPackagesResponse;
use Google\Cloud\Dataform\V1beta1\ListCompilationResultsRequest;
use Google\Cloud\Dataform\V1beta1\ListReleaseConfigsRequest;
use Google\Cloud\Dataform\V1beta1\ListRepositoriesRequest;
use Google\Cloud\Dataform\V1beta1\ListWorkflowConfigsRequest;
use Google\Cloud\Dataform\V1beta1\ListWorkflowInvocationsRequest;
use Google\Cloud\Dataform\V1beta1\ListWorkspacesRequest;
use Google\Cloud\Dataform\V1beta1\MakeDirectoryRequest;
use Google\Cloud\Dataform\V1beta1\MakeDirectoryResponse;
use Google\Cloud\Dataform\V1beta1\MoveDirectoryRequest;
use Google\Cloud\Dataform\V1beta1\MoveDirectoryResponse;
use Google\Cloud\Dataform\V1beta1\MoveFileRequest;
use Google\Cloud\Dataform\V1beta1\MoveFileResponse;
use Google\Cloud\Dataform\V1beta1\PullGitCommitsRequest;
use Google\Cloud\Dataform\V1beta1\PushGitCommitsRequest;
use Google\Cloud\Dataform\V1beta1\QueryCompilationResultActionsRequest;
use Google\Cloud\Dataform\V1beta1\QueryDirectoryContentsRequest;
use Google\Cloud\Dataform\V1beta1\QueryRepositoryDirectoryContentsRequest;
use Google\Cloud\Dataform\V1beta1\QueryWorkflowInvocationActionsRequest;
use Google\Cloud\Dataform\V1beta1\ReadFileRequest;
use Google\Cloud\Dataform\V1beta1\ReadFileResponse;
use Google\Cloud\Dataform\V1beta1\ReadRepositoryFileRequest;
use Google\Cloud\Dataform\V1beta1\ReadRepositoryFileResponse;
use Google\Cloud\Dataform\V1beta1\ReleaseConfig;
use Google\Cloud\Dataform\V1beta1\RemoveDirectoryRequest;
use Google\Cloud\Dataform\V1beta1\RemoveFileRequest;
use Google\Cloud\Dataform\V1beta1\Repository;
use Google\Cloud\Dataform\V1beta1\ResetWorkspaceChangesRequest;
use Google\Cloud\Dataform\V1beta1\UpdateReleaseConfigRequest;
use Google\Cloud\Dataform\V1beta1\UpdateRepositoryRequest;
use Google\Cloud\Dataform\V1beta1\UpdateWorkflowConfigRequest;
use Google\Cloud\Dataform\V1beta1\WorkflowConfig;
use Google\Cloud\Dataform\V1beta1\WorkflowInvocation;
use Google\Cloud\Dataform\V1beta1\Workspace;
use Google\Cloud\Dataform\V1beta1\WriteFileRequest;
use Google\Cloud\Dataform\V1beta1\WriteFileResponse;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Dataform is a service to develop, create, document, test, and update curated
 * tables in BigQuery.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @experimental
 *
 * @method PromiseInterface<void> cancelWorkflowInvocationAsync(CancelWorkflowInvocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> commitRepositoryChangesAsync(CommitRepositoryChangesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> commitWorkspaceChangesAsync(CommitWorkspaceChangesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ComputeRepositoryAccessTokenStatusResponse> computeRepositoryAccessTokenStatusAsync(ComputeRepositoryAccessTokenStatusRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CompilationResult> createCompilationResultAsync(CreateCompilationResultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ReleaseConfig> createReleaseConfigAsync(CreateReleaseConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Repository> createRepositoryAsync(CreateRepositoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<WorkflowConfig> createWorkflowConfigAsync(CreateWorkflowConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<WorkflowInvocation> createWorkflowInvocationAsync(CreateWorkflowInvocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Workspace> createWorkspaceAsync(CreateWorkspaceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteReleaseConfigAsync(DeleteReleaseConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteRepositoryAsync(DeleteRepositoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteWorkflowConfigAsync(DeleteWorkflowConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteWorkflowInvocationAsync(DeleteWorkflowInvocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteWorkspaceAsync(DeleteWorkspaceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<FetchFileDiffResponse> fetchFileDiffAsync(FetchFileDiffRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<FetchFileGitStatusesResponse> fetchFileGitStatusesAsync(FetchFileGitStatusesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<FetchGitAheadBehindResponse> fetchGitAheadBehindAsync(FetchGitAheadBehindRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<FetchRemoteBranchesResponse> fetchRemoteBranchesAsync(FetchRemoteBranchesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> fetchRepositoryHistoryAsync(FetchRepositoryHistoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CompilationResult> getCompilationResultAsync(GetCompilationResultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ReleaseConfig> getReleaseConfigAsync(GetReleaseConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Repository> getRepositoryAsync(GetRepositoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<WorkflowConfig> getWorkflowConfigAsync(GetWorkflowConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<WorkflowInvocation> getWorkflowInvocationAsync(GetWorkflowInvocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Workspace> getWorkspaceAsync(GetWorkspaceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<InstallNpmPackagesResponse> installNpmPackagesAsync(InstallNpmPackagesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listCompilationResultsAsync(ListCompilationResultsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listReleaseConfigsAsync(ListReleaseConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listRepositoriesAsync(ListRepositoriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listWorkflowConfigsAsync(ListWorkflowConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listWorkflowInvocationsAsync(ListWorkflowInvocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listWorkspacesAsync(ListWorkspacesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<MakeDirectoryResponse> makeDirectoryAsync(MakeDirectoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<MoveDirectoryResponse> moveDirectoryAsync(MoveDirectoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<MoveFileResponse> moveFileAsync(MoveFileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> pullGitCommitsAsync(PullGitCommitsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> pushGitCommitsAsync(PushGitCommitsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> queryCompilationResultActionsAsync(QueryCompilationResultActionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> queryDirectoryContentsAsync(QueryDirectoryContentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> queryRepositoryDirectoryContentsAsync(QueryRepositoryDirectoryContentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> queryWorkflowInvocationActionsAsync(QueryWorkflowInvocationActionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ReadFileResponse> readFileAsync(ReadFileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ReadRepositoryFileResponse> readRepositoryFileAsync(ReadRepositoryFileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> removeDirectoryAsync(RemoveDirectoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> removeFileAsync(RemoveFileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> resetWorkspaceChangesAsync(ResetWorkspaceChangesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ReleaseConfig> updateReleaseConfigAsync(UpdateReleaseConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Repository> updateRepositoryAsync(UpdateRepositoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<WorkflowConfig> updateWorkflowConfigAsync(UpdateWorkflowConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<WriteFileResponse> writeFileAsync(WriteFileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class DataformClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.dataform.v1beta1.Dataform';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'dataform.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'dataform.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/dataform_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/dataform_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/dataform_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/dataform_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * compilation_result resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $compilationResult
     *
     * @return string The formatted compilation_result resource.
     *
     * @experimental
     */
    public static function compilationResultName(string $project, string $location, string $repository, string $compilationResult): string
    {
        return self::getPathTemplate('compilationResult')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'compilation_result' => $compilationResult,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     *
     * @experimental
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * release_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $releaseConfig
     *
     * @return string The formatted release_config resource.
     *
     * @experimental
     */
    public static function releaseConfigName(string $project, string $location, string $repository, string $releaseConfig): string
    {
        return self::getPathTemplate('releaseConfig')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'release_config' => $releaseConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a repository
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     *
     * @return string The formatted repository resource.
     *
     * @experimental
     */
    public static function repositoryName(string $project, string $location, string $repository): string
    {
        return self::getPathTemplate('repository')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * secret_version resource.
     *
     * @param string $project
     * @param string $secret
     * @param string $version
     *
     * @return string The formatted secret_version resource.
     *
     * @experimental
     */
    public static function secretVersionName(string $project, string $secret, string $version): string
    {
        return self::getPathTemplate('secretVersion')->render([
            'project' => $project,
            'secret' => $secret,
            'version' => $version,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * workflow_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $workflowConfig
     *
     * @return string The formatted workflow_config resource.
     *
     * @experimental
     */
    public static function workflowConfigName(string $project, string $location, string $repository, string $workflowConfig): string
    {
        return self::getPathTemplate('workflowConfig')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'workflow_config' => $workflowConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * workflow_invocation resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $workflowInvocation
     *
     * @return string The formatted workflow_invocation resource.
     *
     * @experimental
     */
    public static function workflowInvocationName(string $project, string $location, string $repository, string $workflowInvocation): string
    {
        return self::getPathTemplate('workflowInvocation')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'workflow_invocation' => $workflowInvocation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a workspace
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $workspace
     *
     * @return string The formatted workspace resource.
     *
     * @experimental
     */
    public static function workspaceName(string $project, string $location, string $repository, string $workspace): string
    {
        return self::getPathTemplate('workspace')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'workspace' => $workspace,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - compilationResult: projects/{project}/locations/{location}/repositories/{repository}/compilationResults/{compilation_result}
     * - location: projects/{project}/locations/{location}
     * - releaseConfig: projects/{project}/locations/{location}/repositories/{repository}/releaseConfigs/{release_config}
     * - repository: projects/{project}/locations/{location}/repositories/{repository}
     * - secretVersion: projects/{project}/secrets/{secret}/versions/{version}
     * - workflowConfig: projects/{project}/locations/{location}/repositories/{repository}/workflowConfigs/{workflow_config}
     * - workflowInvocation: projects/{project}/locations/{location}/repositories/{repository}/workflowInvocations/{workflow_invocation}
     * - workspace: projects/{project}/locations/{location}/repositories/{repository}/workspaces/{workspace}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     *
     * @experimental
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dataform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     *
     * @experimental
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Requests cancellation of a running WorkflowInvocation.
     *
     * The async variant is {@see DataformClient::cancelWorkflowInvocationAsync()} .
     *
     * @example samples/V1beta1/DataformClient/cancel_workflow_invocation.php
     *
     * @param CancelWorkflowInvocationRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function cancelWorkflowInvocation(CancelWorkflowInvocationRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('CancelWorkflowInvocation', $request, $callOptions)->wait();
    }

    /**
     * Applies a Git commit to a Repository. The Repository must not have a value
     * for `git_remote_settings.url`.
     *
     * The async variant is {@see DataformClient::commitRepositoryChangesAsync()} .
     *
     * @example samples/V1beta1/DataformClient/commit_repository_changes.php
     *
     * @param CommitRepositoryChangesRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function commitRepositoryChanges(CommitRepositoryChangesRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('CommitRepositoryChanges', $request, $callOptions)->wait();
    }

    /**
     * Applies a Git commit for uncommitted files in a Workspace.
     *
     * The async variant is {@see DataformClient::commitWorkspaceChangesAsync()} .
     *
     * @example samples/V1beta1/DataformClient/commit_workspace_changes.php
     *
     * @param CommitWorkspaceChangesRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function commitWorkspaceChanges(CommitWorkspaceChangesRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('CommitWorkspaceChanges', $request, $callOptions)->wait();
    }

    /**
     * Computes a Repository's Git access token status.
     *
     * The async variant is
     * {@see DataformClient::computeRepositoryAccessTokenStatusAsync()} .
     *
     * @example samples/V1beta1/DataformClient/compute_repository_access_token_status.php
     *
     * @param ComputeRepositoryAccessTokenStatusRequest $request     A request to house fields associated with the call.
     * @param array                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ComputeRepositoryAccessTokenStatusResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function computeRepositoryAccessTokenStatus(ComputeRepositoryAccessTokenStatusRequest $request, array $callOptions = []): ComputeRepositoryAccessTokenStatusResponse
    {
        return $this->startApiCall('ComputeRepositoryAccessTokenStatus', $request, $callOptions)->wait();
    }

    /**
     * Creates a new CompilationResult in a given project and location.
     *
     * The async variant is {@see DataformClient::createCompilationResultAsync()} .
     *
     * @example samples/V1beta1/DataformClient/create_compilation_result.php
     *
     * @param CreateCompilationResultRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CompilationResult
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createCompilationResult(CreateCompilationResultRequest $request, array $callOptions = []): CompilationResult
    {
        return $this->startApiCall('CreateCompilationResult', $request, $callOptions)->wait();
    }

    /**
     * Creates a new ReleaseConfig in a given Repository.
     *
     * The async variant is {@see DataformClient::createReleaseConfigAsync()} .
     *
     * @example samples/V1beta1/DataformClient/create_release_config.php
     *
     * @param CreateReleaseConfigRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ReleaseConfig
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createReleaseConfig(CreateReleaseConfigRequest $request, array $callOptions = []): ReleaseConfig
    {
        return $this->startApiCall('CreateReleaseConfig', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Repository in a given project and location.
     *
     * The async variant is {@see DataformClient::createRepositoryAsync()} .
     *
     * @example samples/V1beta1/DataformClient/create_repository.php
     *
     * @param CreateRepositoryRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Repository
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createRepository(CreateRepositoryRequest $request, array $callOptions = []): Repository
    {
        return $this->startApiCall('CreateRepository', $request, $callOptions)->wait();
    }

    /**
     * Creates a new WorkflowConfig in a given Repository.
     *
     * The async variant is {@see DataformClient::createWorkflowConfigAsync()} .
     *
     * @example samples/V1beta1/DataformClient/create_workflow_config.php
     *
     * @param CreateWorkflowConfigRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return WorkflowConfig
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createWorkflowConfig(CreateWorkflowConfigRequest $request, array $callOptions = []): WorkflowConfig
    {
        return $this->startApiCall('CreateWorkflowConfig', $request, $callOptions)->wait();
    }

    /**
     * Creates a new WorkflowInvocation in a given Repository.
     *
     * The async variant is {@see DataformClient::createWorkflowInvocationAsync()} .
     *
     * @example samples/V1beta1/DataformClient/create_workflow_invocation.php
     *
     * @param CreateWorkflowInvocationRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return WorkflowInvocation
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createWorkflowInvocation(CreateWorkflowInvocationRequest $request, array $callOptions = []): WorkflowInvocation
    {
        return $this->startApiCall('CreateWorkflowInvocation', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Workspace in a given Repository.
     *
     * The async variant is {@see DataformClient::createWorkspaceAsync()} .
     *
     * @example samples/V1beta1/DataformClient/create_workspace.php
     *
     * @param CreateWorkspaceRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Workspace
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createWorkspace(CreateWorkspaceRequest $request, array $callOptions = []): Workspace
    {
        return $this->startApiCall('CreateWorkspace', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single ReleaseConfig.
     *
     * The async variant is {@see DataformClient::deleteReleaseConfigAsync()} .
     *
     * @example samples/V1beta1/DataformClient/delete_release_config.php
     *
     * @param DeleteReleaseConfigRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteReleaseConfig(DeleteReleaseConfigRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteReleaseConfig', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Repository.
     *
     * The async variant is {@see DataformClient::deleteRepositoryAsync()} .
     *
     * @example samples/V1beta1/DataformClient/delete_repository.php
     *
     * @param DeleteRepositoryRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteRepository(DeleteRepositoryRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteRepository', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single WorkflowConfig.
     *
     * The async variant is {@see DataformClient::deleteWorkflowConfigAsync()} .
     *
     * @example samples/V1beta1/DataformClient/delete_workflow_config.php
     *
     * @param DeleteWorkflowConfigRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteWorkflowConfig(DeleteWorkflowConfigRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteWorkflowConfig', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single WorkflowInvocation.
     *
     * The async variant is {@see DataformClient::deleteWorkflowInvocationAsync()} .
     *
     * @example samples/V1beta1/DataformClient/delete_workflow_invocation.php
     *
     * @param DeleteWorkflowInvocationRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteWorkflowInvocation(DeleteWorkflowInvocationRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteWorkflowInvocation', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Workspace.
     *
     * The async variant is {@see DataformClient::deleteWorkspaceAsync()} .
     *
     * @example samples/V1beta1/DataformClient/delete_workspace.php
     *
     * @param DeleteWorkspaceRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteWorkspace(DeleteWorkspaceRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteWorkspace', $request, $callOptions)->wait();
    }

    /**
     * Fetches Git diff for an uncommitted file in a Workspace.
     *
     * The async variant is {@see DataformClient::fetchFileDiffAsync()} .
     *
     * @example samples/V1beta1/DataformClient/fetch_file_diff.php
     *
     * @param FetchFileDiffRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FetchFileDiffResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function fetchFileDiff(FetchFileDiffRequest $request, array $callOptions = []): FetchFileDiffResponse
    {
        return $this->startApiCall('FetchFileDiff', $request, $callOptions)->wait();
    }

    /**
     * Fetches Git statuses for the files in a Workspace.
     *
     * The async variant is {@see DataformClient::fetchFileGitStatusesAsync()} .
     *
     * @example samples/V1beta1/DataformClient/fetch_file_git_statuses.php
     *
     * @param FetchFileGitStatusesRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FetchFileGitStatusesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function fetchFileGitStatuses(FetchFileGitStatusesRequest $request, array $callOptions = []): FetchFileGitStatusesResponse
    {
        return $this->startApiCall('FetchFileGitStatuses', $request, $callOptions)->wait();
    }

    /**
     * Fetches Git ahead/behind against a remote branch.
     *
     * The async variant is {@see DataformClient::fetchGitAheadBehindAsync()} .
     *
     * @example samples/V1beta1/DataformClient/fetch_git_ahead_behind.php
     *
     * @param FetchGitAheadBehindRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FetchGitAheadBehindResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function fetchGitAheadBehind(FetchGitAheadBehindRequest $request, array $callOptions = []): FetchGitAheadBehindResponse
    {
        return $this->startApiCall('FetchGitAheadBehind', $request, $callOptions)->wait();
    }

    /**
     * Fetches a Repository's remote branches.
     *
     * The async variant is {@see DataformClient::fetchRemoteBranchesAsync()} .
     *
     * @example samples/V1beta1/DataformClient/fetch_remote_branches.php
     *
     * @param FetchRemoteBranchesRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FetchRemoteBranchesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function fetchRemoteBranches(FetchRemoteBranchesRequest $request, array $callOptions = []): FetchRemoteBranchesResponse
    {
        return $this->startApiCall('FetchRemoteBranches', $request, $callOptions)->wait();
    }

    /**
     * Fetches a Repository's history of commits.  The Repository must not have a
     * value for `git_remote_settings.url`.
     *
     * The async variant is {@see DataformClient::fetchRepositoryHistoryAsync()} .
     *
     * @example samples/V1beta1/DataformClient/fetch_repository_history.php
     *
     * @param FetchRepositoryHistoryRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function fetchRepositoryHistory(FetchRepositoryHistoryRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('FetchRepositoryHistory', $request, $callOptions);
    }

    /**
     * Fetches a single CompilationResult.
     *
     * The async variant is {@see DataformClient::getCompilationResultAsync()} .
     *
     * @example samples/V1beta1/DataformClient/get_compilation_result.php
     *
     * @param GetCompilationResultRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CompilationResult
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getCompilationResult(GetCompilationResultRequest $request, array $callOptions = []): CompilationResult
    {
        return $this->startApiCall('GetCompilationResult', $request, $callOptions)->wait();
    }

    /**
     * Fetches a single ReleaseConfig.
     *
     * The async variant is {@see DataformClient::getReleaseConfigAsync()} .
     *
     * @example samples/V1beta1/DataformClient/get_release_config.php
     *
     * @param GetReleaseConfigRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ReleaseConfig
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getReleaseConfig(GetReleaseConfigRequest $request, array $callOptions = []): ReleaseConfig
    {
        return $this->startApiCall('GetReleaseConfig', $request, $callOptions)->wait();
    }

    /**
     * Fetches a single Repository.
     *
     * The async variant is {@see DataformClient::getRepositoryAsync()} .
     *
     * @example samples/V1beta1/DataformClient/get_repository.php
     *
     * @param GetRepositoryRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Repository
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getRepository(GetRepositoryRequest $request, array $callOptions = []): Repository
    {
        return $this->startApiCall('GetRepository', $request, $callOptions)->wait();
    }

    /**
     * Fetches a single WorkflowConfig.
     *
     * The async variant is {@see DataformClient::getWorkflowConfigAsync()} .
     *
     * @example samples/V1beta1/DataformClient/get_workflow_config.php
     *
     * @param GetWorkflowConfigRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return WorkflowConfig
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getWorkflowConfig(GetWorkflowConfigRequest $request, array $callOptions = []): WorkflowConfig
    {
        return $this->startApiCall('GetWorkflowConfig', $request, $callOptions)->wait();
    }

    /**
     * Fetches a single WorkflowInvocation.
     *
     * The async variant is {@see DataformClient::getWorkflowInvocationAsync()} .
     *
     * @example samples/V1beta1/DataformClient/get_workflow_invocation.php
     *
     * @param GetWorkflowInvocationRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return WorkflowInvocation
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getWorkflowInvocation(GetWorkflowInvocationRequest $request, array $callOptions = []): WorkflowInvocation
    {
        return $this->startApiCall('GetWorkflowInvocation', $request, $callOptions)->wait();
    }

    /**
     * Fetches a single Workspace.
     *
     * The async variant is {@see DataformClient::getWorkspaceAsync()} .
     *
     * @example samples/V1beta1/DataformClient/get_workspace.php
     *
     * @param GetWorkspaceRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Workspace
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getWorkspace(GetWorkspaceRequest $request, array $callOptions = []): Workspace
    {
        return $this->startApiCall('GetWorkspace', $request, $callOptions)->wait();
    }

    /**
     * Installs dependency NPM packages (inside a Workspace).
     *
     * The async variant is {@see DataformClient::installNpmPackagesAsync()} .
     *
     * @example samples/V1beta1/DataformClient/install_npm_packages.php
     *
     * @param InstallNpmPackagesRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return InstallNpmPackagesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function installNpmPackages(InstallNpmPackagesRequest $request, array $callOptions = []): InstallNpmPackagesResponse
    {
        return $this->startApiCall('InstallNpmPackages', $request, $callOptions)->wait();
    }

    /**
     * Lists CompilationResults in a given Repository.
     *
     * The async variant is {@see DataformClient::listCompilationResultsAsync()} .
     *
     * @example samples/V1beta1/DataformClient/list_compilation_results.php
     *
     * @param ListCompilationResultsRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listCompilationResults(ListCompilationResultsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCompilationResults', $request, $callOptions);
    }

    /**
     * Lists ReleaseConfigs in a given Repository.
     *
     * The async variant is {@see DataformClient::listReleaseConfigsAsync()} .
     *
     * @example samples/V1beta1/DataformClient/list_release_configs.php
     *
     * @param ListReleaseConfigsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listReleaseConfigs(ListReleaseConfigsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListReleaseConfigs', $request, $callOptions);
    }

    /**
     * Lists Repositories in a given project and location.
     *
     * The async variant is {@see DataformClient::listRepositoriesAsync()} .
     *
     * @example samples/V1beta1/DataformClient/list_repositories.php
     *
     * @param ListRepositoriesRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listRepositories(ListRepositoriesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRepositories', $request, $callOptions);
    }

    /**
     * Lists WorkflowConfigs in a given Repository.
     *
     * The async variant is {@see DataformClient::listWorkflowConfigsAsync()} .
     *
     * @example samples/V1beta1/DataformClient/list_workflow_configs.php
     *
     * @param ListWorkflowConfigsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listWorkflowConfigs(ListWorkflowConfigsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListWorkflowConfigs', $request, $callOptions);
    }

    /**
     * Lists WorkflowInvocations in a given Repository.
     *
     * The async variant is {@see DataformClient::listWorkflowInvocationsAsync()} .
     *
     * @example samples/V1beta1/DataformClient/list_workflow_invocations.php
     *
     * @param ListWorkflowInvocationsRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listWorkflowInvocations(ListWorkflowInvocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListWorkflowInvocations', $request, $callOptions);
    }

    /**
     * Lists Workspaces in a given Repository.
     *
     * The async variant is {@see DataformClient::listWorkspacesAsync()} .
     *
     * @example samples/V1beta1/DataformClient/list_workspaces.php
     *
     * @param ListWorkspacesRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listWorkspaces(ListWorkspacesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListWorkspaces', $request, $callOptions);
    }

    /**
     * Creates a directory inside a Workspace.
     *
     * The async variant is {@see DataformClient::makeDirectoryAsync()} .
     *
     * @example samples/V1beta1/DataformClient/make_directory.php
     *
     * @param MakeDirectoryRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MakeDirectoryResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function makeDirectory(MakeDirectoryRequest $request, array $callOptions = []): MakeDirectoryResponse
    {
        return $this->startApiCall('MakeDirectory', $request, $callOptions)->wait();
    }

    /**
     * Moves a directory (inside a Workspace), and all of its contents, to a new
     * location.
     *
     * The async variant is {@see DataformClient::moveDirectoryAsync()} .
     *
     * @example samples/V1beta1/DataformClient/move_directory.php
     *
     * @param MoveDirectoryRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MoveDirectoryResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function moveDirectory(MoveDirectoryRequest $request, array $callOptions = []): MoveDirectoryResponse
    {
        return $this->startApiCall('MoveDirectory', $request, $callOptions)->wait();
    }

    /**
     * Moves a file (inside a Workspace) to a new location.
     *
     * The async variant is {@see DataformClient::moveFileAsync()} .
     *
     * @example samples/V1beta1/DataformClient/move_file.php
     *
     * @param MoveFileRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MoveFileResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function moveFile(MoveFileRequest $request, array $callOptions = []): MoveFileResponse
    {
        return $this->startApiCall('MoveFile', $request, $callOptions)->wait();
    }

    /**
     * Pulls Git commits from the Repository's remote into a Workspace.
     *
     * The async variant is {@see DataformClient::pullGitCommitsAsync()} .
     *
     * @example samples/V1beta1/DataformClient/pull_git_commits.php
     *
     * @param PullGitCommitsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function pullGitCommits(PullGitCommitsRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('PullGitCommits', $request, $callOptions)->wait();
    }

    /**
     * Pushes Git commits from a Workspace to the Repository's remote.
     *
     * The async variant is {@see DataformClient::pushGitCommitsAsync()} .
     *
     * @example samples/V1beta1/DataformClient/push_git_commits.php
     *
     * @param PushGitCommitsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function pushGitCommits(PushGitCommitsRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('PushGitCommits', $request, $callOptions)->wait();
    }

    /**
     * Returns CompilationResultActions in a given CompilationResult.
     *
     * The async variant is {@see DataformClient::queryCompilationResultActionsAsync()}
     * .
     *
     * @example samples/V1beta1/DataformClient/query_compilation_result_actions.php
     *
     * @param QueryCompilationResultActionsRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function queryCompilationResultActions(QueryCompilationResultActionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('QueryCompilationResultActions', $request, $callOptions);
    }

    /**
     * Returns the contents of a given Workspace directory.
     *
     * The async variant is {@see DataformClient::queryDirectoryContentsAsync()} .
     *
     * @example samples/V1beta1/DataformClient/query_directory_contents.php
     *
     * @param QueryDirectoryContentsRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function queryDirectoryContents(QueryDirectoryContentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('QueryDirectoryContents', $request, $callOptions);
    }

    /**
     * Returns the contents of a given Repository directory. The Repository must
     * not have a value for `git_remote_settings.url`.
     *
     * The async variant is
     * {@see DataformClient::queryRepositoryDirectoryContentsAsync()} .
     *
     * @example samples/V1beta1/DataformClient/query_repository_directory_contents.php
     *
     * @param QueryRepositoryDirectoryContentsRequest $request     A request to house fields associated with the call.
     * @param array                                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function queryRepositoryDirectoryContents(QueryRepositoryDirectoryContentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('QueryRepositoryDirectoryContents', $request, $callOptions);
    }

    /**
     * Returns WorkflowInvocationActions in a given WorkflowInvocation.
     *
     * The async variant is
     * {@see DataformClient::queryWorkflowInvocationActionsAsync()} .
     *
     * @example samples/V1beta1/DataformClient/query_workflow_invocation_actions.php
     *
     * @param QueryWorkflowInvocationActionsRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function queryWorkflowInvocationActions(QueryWorkflowInvocationActionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('QueryWorkflowInvocationActions', $request, $callOptions);
    }

    /**
     * Returns the contents of a file (inside a Workspace).
     *
     * The async variant is {@see DataformClient::readFileAsync()} .
     *
     * @example samples/V1beta1/DataformClient/read_file.php
     *
     * @param ReadFileRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ReadFileResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function readFile(ReadFileRequest $request, array $callOptions = []): ReadFileResponse
    {
        return $this->startApiCall('ReadFile', $request, $callOptions)->wait();
    }

    /**
     * Returns the contents of a file (inside a Repository). The Repository
     * must not have a value for `git_remote_settings.url`.
     *
     * The async variant is {@see DataformClient::readRepositoryFileAsync()} .
     *
     * @example samples/V1beta1/DataformClient/read_repository_file.php
     *
     * @param ReadRepositoryFileRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ReadRepositoryFileResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function readRepositoryFile(ReadRepositoryFileRequest $request, array $callOptions = []): ReadRepositoryFileResponse
    {
        return $this->startApiCall('ReadRepositoryFile', $request, $callOptions)->wait();
    }

    /**
     * Deletes a directory (inside a Workspace) and all of its contents.
     *
     * The async variant is {@see DataformClient::removeDirectoryAsync()} .
     *
     * @example samples/V1beta1/DataformClient/remove_directory.php
     *
     * @param RemoveDirectoryRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function removeDirectory(RemoveDirectoryRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('RemoveDirectory', $request, $callOptions)->wait();
    }

    /**
     * Deletes a file (inside a Workspace).
     *
     * The async variant is {@see DataformClient::removeFileAsync()} .
     *
     * @example samples/V1beta1/DataformClient/remove_file.php
     *
     * @param RemoveFileRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function removeFile(RemoveFileRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('RemoveFile', $request, $callOptions)->wait();
    }

    /**
     * Performs a Git reset for uncommitted files in a Workspace.
     *
     * The async variant is {@see DataformClient::resetWorkspaceChangesAsync()} .
     *
     * @example samples/V1beta1/DataformClient/reset_workspace_changes.php
     *
     * @param ResetWorkspaceChangesRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function resetWorkspaceChanges(ResetWorkspaceChangesRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('ResetWorkspaceChanges', $request, $callOptions)->wait();
    }

    /**
     * Updates a single ReleaseConfig.
     *
     * The async variant is {@see DataformClient::updateReleaseConfigAsync()} .
     *
     * @example samples/V1beta1/DataformClient/update_release_config.php
     *
     * @param UpdateReleaseConfigRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ReleaseConfig
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateReleaseConfig(UpdateReleaseConfigRequest $request, array $callOptions = []): ReleaseConfig
    {
        return $this->startApiCall('UpdateReleaseConfig', $request, $callOptions)->wait();
    }

    /**
     * Updates a single Repository.
     *
     * The async variant is {@see DataformClient::updateRepositoryAsync()} .
     *
     * @example samples/V1beta1/DataformClient/update_repository.php
     *
     * @param UpdateRepositoryRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Repository
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateRepository(UpdateRepositoryRequest $request, array $callOptions = []): Repository
    {
        return $this->startApiCall('UpdateRepository', $request, $callOptions)->wait();
    }

    /**
     * Updates a single WorkflowConfig.
     *
     * The async variant is {@see DataformClient::updateWorkflowConfigAsync()} .
     *
     * @example samples/V1beta1/DataformClient/update_workflow_config.php
     *
     * @param UpdateWorkflowConfigRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return WorkflowConfig
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateWorkflowConfig(UpdateWorkflowConfigRequest $request, array $callOptions = []): WorkflowConfig
    {
        return $this->startApiCall('UpdateWorkflowConfig', $request, $callOptions)->wait();
    }

    /**
     * Writes to a file (inside a Workspace).
     *
     * The async variant is {@see DataformClient::writeFileAsync()} .
     *
     * @example samples/V1beta1/DataformClient/write_file.php
     *
     * @param WriteFileRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return WriteFileResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function writeFile(WriteFileRequest $request, array $callOptions = []): WriteFileResponse
    {
        return $this->startApiCall('WriteFile', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see DataformClient::getLocationAsync()} .
     *
     * @example samples/V1beta1/DataformClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see DataformClient::listLocationsAsync()} .
     *
     * @example samples/V1beta1/DataformClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see DataformClient::getIamPolicyAsync()} .
     *
     * @example samples/V1beta1/DataformClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see DataformClient::setIamPolicyAsync()} .
     *
     * @example samples/V1beta1/DataformClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see DataformClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1beta1/DataformClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function testIamPermissions(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
