<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/analytics/admin/v1beta/analytics_admin.proto
 * Updates to the above are reflected here through a refresh process.
 *
 * @experimental
 */

namespace Google\Analytics\Admin\V1beta\Client;

use Google\Analytics\Admin\V1beta\Account;
use Google\Analytics\Admin\V1beta\AcknowledgeUserDataCollectionRequest;
use Google\Analytics\Admin\V1beta\AcknowledgeUserDataCollectionResponse;
use Google\Analytics\Admin\V1beta\ArchiveCustomDimensionRequest;
use Google\Analytics\Admin\V1beta\ArchiveCustomMetricRequest;
use Google\Analytics\Admin\V1beta\ConversionEvent;
use Google\Analytics\Admin\V1beta\CreateConversionEventRequest;
use Google\Analytics\Admin\V1beta\CreateCustomDimensionRequest;
use Google\Analytics\Admin\V1beta\CreateCustomMetricRequest;
use Google\Analytics\Admin\V1beta\CreateDataStreamRequest;
use Google\Analytics\Admin\V1beta\CreateFirebaseLinkRequest;
use Google\Analytics\Admin\V1beta\CreateGoogleAdsLinkRequest;
use Google\Analytics\Admin\V1beta\CreateKeyEventRequest;
use Google\Analytics\Admin\V1beta\CreateMeasurementProtocolSecretRequest;
use Google\Analytics\Admin\V1beta\CreatePropertyRequest;
use Google\Analytics\Admin\V1beta\CustomDimension;
use Google\Analytics\Admin\V1beta\CustomMetric;
use Google\Analytics\Admin\V1beta\DataRetentionSettings;
use Google\Analytics\Admin\V1beta\DataSharingSettings;
use Google\Analytics\Admin\V1beta\DataStream;
use Google\Analytics\Admin\V1beta\DeleteAccountRequest;
use Google\Analytics\Admin\V1beta\DeleteConversionEventRequest;
use Google\Analytics\Admin\V1beta\DeleteDataStreamRequest;
use Google\Analytics\Admin\V1beta\DeleteFirebaseLinkRequest;
use Google\Analytics\Admin\V1beta\DeleteGoogleAdsLinkRequest;
use Google\Analytics\Admin\V1beta\DeleteKeyEventRequest;
use Google\Analytics\Admin\V1beta\DeleteMeasurementProtocolSecretRequest;
use Google\Analytics\Admin\V1beta\DeletePropertyRequest;
use Google\Analytics\Admin\V1beta\FirebaseLink;
use Google\Analytics\Admin\V1beta\GetAccountRequest;
use Google\Analytics\Admin\V1beta\GetConversionEventRequest;
use Google\Analytics\Admin\V1beta\GetCustomDimensionRequest;
use Google\Analytics\Admin\V1beta\GetCustomMetricRequest;
use Google\Analytics\Admin\V1beta\GetDataRetentionSettingsRequest;
use Google\Analytics\Admin\V1beta\GetDataSharingSettingsRequest;
use Google\Analytics\Admin\V1beta\GetDataStreamRequest;
use Google\Analytics\Admin\V1beta\GetKeyEventRequest;
use Google\Analytics\Admin\V1beta\GetMeasurementProtocolSecretRequest;
use Google\Analytics\Admin\V1beta\GetPropertyRequest;
use Google\Analytics\Admin\V1beta\GoogleAdsLink;
use Google\Analytics\Admin\V1beta\KeyEvent;
use Google\Analytics\Admin\V1beta\ListAccountSummariesRequest;
use Google\Analytics\Admin\V1beta\ListAccountsRequest;
use Google\Analytics\Admin\V1beta\ListConversionEventsRequest;
use Google\Analytics\Admin\V1beta\ListCustomDimensionsRequest;
use Google\Analytics\Admin\V1beta\ListCustomMetricsRequest;
use Google\Analytics\Admin\V1beta\ListDataStreamsRequest;
use Google\Analytics\Admin\V1beta\ListFirebaseLinksRequest;
use Google\Analytics\Admin\V1beta\ListGoogleAdsLinksRequest;
use Google\Analytics\Admin\V1beta\ListKeyEventsRequest;
use Google\Analytics\Admin\V1beta\ListMeasurementProtocolSecretsRequest;
use Google\Analytics\Admin\V1beta\ListPropertiesRequest;
use Google\Analytics\Admin\V1beta\MeasurementProtocolSecret;
use Google\Analytics\Admin\V1beta\Property;
use Google\Analytics\Admin\V1beta\ProvisionAccountTicketRequest;
use Google\Analytics\Admin\V1beta\ProvisionAccountTicketResponse;
use Google\Analytics\Admin\V1beta\RunAccessReportRequest;
use Google\Analytics\Admin\V1beta\RunAccessReportResponse;
use Google\Analytics\Admin\V1beta\SearchChangeHistoryEventsRequest;
use Google\Analytics\Admin\V1beta\UpdateAccountRequest;
use Google\Analytics\Admin\V1beta\UpdateConversionEventRequest;
use Google\Analytics\Admin\V1beta\UpdateCustomDimensionRequest;
use Google\Analytics\Admin\V1beta\UpdateCustomMetricRequest;
use Google\Analytics\Admin\V1beta\UpdateDataRetentionSettingsRequest;
use Google\Analytics\Admin\V1beta\UpdateDataStreamRequest;
use Google\Analytics\Admin\V1beta\UpdateGoogleAdsLinkRequest;
use Google\Analytics\Admin\V1beta\UpdateKeyEventRequest;
use Google\Analytics\Admin\V1beta\UpdateMeasurementProtocolSecretRequest;
use Google\Analytics\Admin\V1beta\UpdatePropertyRequest;
use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Service Interface for the Analytics Admin API (GA4).
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @experimental
 *
 * @method PromiseInterface<AcknowledgeUserDataCollectionResponse> acknowledgeUserDataCollectionAsync(AcknowledgeUserDataCollectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> archiveCustomDimensionAsync(ArchiveCustomDimensionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> archiveCustomMetricAsync(ArchiveCustomMetricRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ConversionEvent> createConversionEventAsync(CreateConversionEventRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CustomDimension> createCustomDimensionAsync(CreateCustomDimensionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CustomMetric> createCustomMetricAsync(CreateCustomMetricRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DataStream> createDataStreamAsync(CreateDataStreamRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<FirebaseLink> createFirebaseLinkAsync(CreateFirebaseLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<GoogleAdsLink> createGoogleAdsLinkAsync(CreateGoogleAdsLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<KeyEvent> createKeyEventAsync(CreateKeyEventRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<MeasurementProtocolSecret> createMeasurementProtocolSecretAsync(CreateMeasurementProtocolSecretRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Property> createPropertyAsync(CreatePropertyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteAccountAsync(DeleteAccountRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteConversionEventAsync(DeleteConversionEventRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteDataStreamAsync(DeleteDataStreamRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteFirebaseLinkAsync(DeleteFirebaseLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteGoogleAdsLinkAsync(DeleteGoogleAdsLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteKeyEventAsync(DeleteKeyEventRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteMeasurementProtocolSecretAsync(DeleteMeasurementProtocolSecretRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Property> deletePropertyAsync(DeletePropertyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Account> getAccountAsync(GetAccountRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ConversionEvent> getConversionEventAsync(GetConversionEventRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CustomDimension> getCustomDimensionAsync(GetCustomDimensionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CustomMetric> getCustomMetricAsync(GetCustomMetricRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DataRetentionSettings> getDataRetentionSettingsAsync(GetDataRetentionSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DataSharingSettings> getDataSharingSettingsAsync(GetDataSharingSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DataStream> getDataStreamAsync(GetDataStreamRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<KeyEvent> getKeyEventAsync(GetKeyEventRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<MeasurementProtocolSecret> getMeasurementProtocolSecretAsync(GetMeasurementProtocolSecretRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Property> getPropertyAsync(GetPropertyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAccountSummariesAsync(ListAccountSummariesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAccountsAsync(ListAccountsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listConversionEventsAsync(ListConversionEventsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listCustomDimensionsAsync(ListCustomDimensionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listCustomMetricsAsync(ListCustomMetricsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listDataStreamsAsync(ListDataStreamsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listFirebaseLinksAsync(ListFirebaseLinksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listGoogleAdsLinksAsync(ListGoogleAdsLinksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listKeyEventsAsync(ListKeyEventsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listMeasurementProtocolSecretsAsync(ListMeasurementProtocolSecretsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listPropertiesAsync(ListPropertiesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ProvisionAccountTicketResponse> provisionAccountTicketAsync(ProvisionAccountTicketRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<RunAccessReportResponse> runAccessReportAsync(RunAccessReportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> searchChangeHistoryEventsAsync(SearchChangeHistoryEventsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Account> updateAccountAsync(UpdateAccountRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ConversionEvent> updateConversionEventAsync(UpdateConversionEventRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CustomDimension> updateCustomDimensionAsync(UpdateCustomDimensionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CustomMetric> updateCustomMetricAsync(UpdateCustomMetricRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DataRetentionSettings> updateDataRetentionSettingsAsync(UpdateDataRetentionSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DataStream> updateDataStreamAsync(UpdateDataStreamRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<GoogleAdsLink> updateGoogleAdsLinkAsync(UpdateGoogleAdsLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<KeyEvent> updateKeyEventAsync(UpdateKeyEventRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<MeasurementProtocolSecret> updateMeasurementProtocolSecretAsync(UpdateMeasurementProtocolSecretRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Property> updatePropertyAsync(UpdatePropertyRequest $request, array $optionalArgs = [])
 */
final class AnalyticsAdminServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.analytics.admin.v1beta.AnalyticsAdminService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'analyticsadmin.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'analyticsadmin.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/analytics.edit',
        'https://www.googleapis.com/auth/analytics.readonly',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/analytics_admin_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/analytics_admin_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/analytics_admin_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/analytics_admin_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a account
     * resource.
     *
     * @param string $account
     *
     * @return string The formatted account resource.
     *
     * @experimental
     */
    public static function accountName(string $account): string
    {
        return self::getPathTemplate('account')->render([
            'account' => $account,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * conversion_event resource.
     *
     * @param string $property
     * @param string $conversionEvent
     *
     * @return string The formatted conversion_event resource.
     *
     * @experimental
     */
    public static function conversionEventName(string $property, string $conversionEvent): string
    {
        return self::getPathTemplate('conversionEvent')->render([
            'property' => $property,
            'conversion_event' => $conversionEvent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * custom_dimension resource.
     *
     * @param string $property
     * @param string $customDimension
     *
     * @return string The formatted custom_dimension resource.
     *
     * @experimental
     */
    public static function customDimensionName(string $property, string $customDimension): string
    {
        return self::getPathTemplate('customDimension')->render([
            'property' => $property,
            'custom_dimension' => $customDimension,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * custom_metric resource.
     *
     * @param string $property
     * @param string $customMetric
     *
     * @return string The formatted custom_metric resource.
     *
     * @experimental
     */
    public static function customMetricName(string $property, string $customMetric): string
    {
        return self::getPathTemplate('customMetric')->render([
            'property' => $property,
            'custom_metric' => $customMetric,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * data_retention_settings resource.
     *
     * @param string $property
     *
     * @return string The formatted data_retention_settings resource.
     *
     * @experimental
     */
    public static function dataRetentionSettingsName(string $property): string
    {
        return self::getPathTemplate('dataRetentionSettings')->render([
            'property' => $property,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * data_sharing_settings resource.
     *
     * @param string $account
     *
     * @return string The formatted data_sharing_settings resource.
     *
     * @experimental
     */
    public static function dataSharingSettingsName(string $account): string
    {
        return self::getPathTemplate('dataSharingSettings')->render([
            'account' => $account,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a data_stream
     * resource.
     *
     * @param string $property
     * @param string $dataStream
     *
     * @return string The formatted data_stream resource.
     *
     * @experimental
     */
    public static function dataStreamName(string $property, string $dataStream): string
    {
        return self::getPathTemplate('dataStream')->render([
            'property' => $property,
            'data_stream' => $dataStream,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * firebase_link resource.
     *
     * @param string $property
     * @param string $firebaseLink
     *
     * @return string The formatted firebase_link resource.
     *
     * @experimental
     */
    public static function firebaseLinkName(string $property, string $firebaseLink): string
    {
        return self::getPathTemplate('firebaseLink')->render([
            'property' => $property,
            'firebase_link' => $firebaseLink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * google_ads_link resource.
     *
     * @param string $property
     * @param string $googleAdsLink
     *
     * @return string The formatted google_ads_link resource.
     *
     * @experimental
     */
    public static function googleAdsLinkName(string $property, string $googleAdsLink): string
    {
        return self::getPathTemplate('googleAdsLink')->render([
            'property' => $property,
            'google_ads_link' => $googleAdsLink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a key_event
     * resource.
     *
     * @param string $property
     * @param string $keyEvent
     *
     * @return string The formatted key_event resource.
     *
     * @experimental
     */
    public static function keyEventName(string $property, string $keyEvent): string
    {
        return self::getPathTemplate('keyEvent')->render([
            'property' => $property,
            'key_event' => $keyEvent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * measurement_protocol_secret resource.
     *
     * @param string $property
     * @param string $dataStream
     * @param string $measurementProtocolSecret
     *
     * @return string The formatted measurement_protocol_secret resource.
     *
     * @experimental
     */
    public static function measurementProtocolSecretName(string $property, string $dataStream, string $measurementProtocolSecret): string
    {
        return self::getPathTemplate('measurementProtocolSecret')->render([
            'property' => $property,
            'data_stream' => $dataStream,
            'measurement_protocol_secret' => $measurementProtocolSecret,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a organization
     * resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization resource.
     *
     * @experimental
     */
    public static function organizationName(string $organization): string
    {
        return self::getPathTemplate('organization')->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a property
     * resource.
     *
     * @param string $property
     *
     * @return string The formatted property resource.
     *
     * @experimental
     */
    public static function propertyName(string $property): string
    {
        return self::getPathTemplate('property')->render([
            'property' => $property,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - account: accounts/{account}
     * - conversionEvent: properties/{property}/conversionEvents/{conversion_event}
     * - customDimension: properties/{property}/customDimensions/{custom_dimension}
     * - customMetric: properties/{property}/customMetrics/{custom_metric}
     * - dataRetentionSettings: properties/{property}/dataRetentionSettings
     * - dataSharingSettings: accounts/{account}/dataSharingSettings
     * - dataStream: properties/{property}/dataStreams/{data_stream}
     * - firebaseLink: properties/{property}/firebaseLinks/{firebase_link}
     * - googleAdsLink: properties/{property}/googleAdsLinks/{google_ads_link}
     * - keyEvent: properties/{property}/keyEvents/{key_event}
     * - measurementProtocolSecret: properties/{property}/dataStreams/{data_stream}/measurementProtocolSecrets/{measurement_protocol_secret}
     * - organization: organizations/{organization}
     * - property: properties/{property}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     *
     * @experimental
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'analyticsadmin.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     *
     * @experimental
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Acknowledges the terms of user data collection for the specified property.
     *
     * This acknowledgement must be completed (either in the Google Analytics UI
     * or through this API) before MeasurementProtocolSecret resources may be
     * created.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::acknowledgeUserDataCollectionAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/acknowledge_user_data_collection.php
     *
     * @param AcknowledgeUserDataCollectionRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AcknowledgeUserDataCollectionResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function acknowledgeUserDataCollection(AcknowledgeUserDataCollectionRequest $request, array $callOptions = []): AcknowledgeUserDataCollectionResponse
    {
        return $this->startApiCall('AcknowledgeUserDataCollection', $request, $callOptions)->wait();
    }

    /**
     * Archives a CustomDimension on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::archiveCustomDimensionAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/archive_custom_dimension.php
     *
     * @param ArchiveCustomDimensionRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function archiveCustomDimension(ArchiveCustomDimensionRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('ArchiveCustomDimension', $request, $callOptions)->wait();
    }

    /**
     * Archives a CustomMetric on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::archiveCustomMetricAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/archive_custom_metric.php
     *
     * @param ArchiveCustomMetricRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function archiveCustomMetric(ArchiveCustomMetricRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('ArchiveCustomMetric', $request, $callOptions)->wait();
    }

    /**
     * Deprecated: Use `CreateKeyEvent` instead.
     * Creates a conversion event with the specified attributes.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createConversionEventAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/create_conversion_event.php
     *
     * @param CreateConversionEventRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ConversionEvent
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     *
     * @deprecated This method will be removed in the next major version update.
     */
    public function createConversionEvent(CreateConversionEventRequest $request, array $callOptions = []): ConversionEvent
    {
        return $this->startApiCall('CreateConversionEvent', $request, $callOptions)->wait();
    }

    /**
     * Creates a CustomDimension.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createCustomDimensionAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/create_custom_dimension.php
     *
     * @param CreateCustomDimensionRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomDimension
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createCustomDimension(CreateCustomDimensionRequest $request, array $callOptions = []): CustomDimension
    {
        return $this->startApiCall('CreateCustomDimension', $request, $callOptions)->wait();
    }

    /**
     * Creates a CustomMetric.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createCustomMetricAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/create_custom_metric.php
     *
     * @param CreateCustomMetricRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomMetric
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createCustomMetric(CreateCustomMetricRequest $request, array $callOptions = []): CustomMetric
    {
        return $this->startApiCall('CreateCustomMetric', $request, $callOptions)->wait();
    }

    /**
     * Creates a DataStream.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::createDataStreamAsync()}
     * .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/create_data_stream.php
     *
     * @param CreateDataStreamRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataStream
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createDataStream(CreateDataStreamRequest $request, array $callOptions = []): DataStream
    {
        return $this->startApiCall('CreateDataStream', $request, $callOptions)->wait();
    }

    /**
     * Creates a FirebaseLink.
     *
     * Properties can have at most one FirebaseLink.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createFirebaseLinkAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/create_firebase_link.php
     *
     * @param CreateFirebaseLinkRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FirebaseLink
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createFirebaseLink(CreateFirebaseLinkRequest $request, array $callOptions = []): FirebaseLink
    {
        return $this->startApiCall('CreateFirebaseLink', $request, $callOptions)->wait();
    }

    /**
     * Creates a GoogleAdsLink.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createGoogleAdsLinkAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/create_google_ads_link.php
     *
     * @param CreateGoogleAdsLinkRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GoogleAdsLink
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createGoogleAdsLink(CreateGoogleAdsLinkRequest $request, array $callOptions = []): GoogleAdsLink
    {
        return $this->startApiCall('CreateGoogleAdsLink', $request, $callOptions)->wait();
    }

    /**
     * Creates a Key Event.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::createKeyEventAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/create_key_event.php
     *
     * @param CreateKeyEventRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return KeyEvent
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createKeyEvent(CreateKeyEventRequest $request, array $callOptions = []): KeyEvent
    {
        return $this->startApiCall('CreateKeyEvent', $request, $callOptions)->wait();
    }

    /**
     * Creates a measurement protocol secret.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createMeasurementProtocolSecretAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/create_measurement_protocol_secret.php
     *
     * @param CreateMeasurementProtocolSecretRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MeasurementProtocolSecret
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createMeasurementProtocolSecret(CreateMeasurementProtocolSecretRequest $request, array $callOptions = []): MeasurementProtocolSecret
    {
        return $this->startApiCall('CreateMeasurementProtocolSecret', $request, $callOptions)->wait();
    }

    /**
     * Creates an "GA4" property with the specified location and attributes.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::createPropertyAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/create_property.php
     *
     * @param CreatePropertyRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Property
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createProperty(CreatePropertyRequest $request, array $callOptions = []): Property
    {
        return $this->startApiCall('CreateProperty', $request, $callOptions)->wait();
    }

    /**
     * Marks target Account as soft-deleted (ie: "trashed") and returns it.
     *
     * This API does not have a method to restore soft-deleted accounts.
     * However, they can be restored using the Trash Can UI.
     *
     * If the accounts are not restored before the expiration time, the account
     * and all child resources (eg: Properties, GoogleAdsLinks, Streams,
     * AccessBindings) will be permanently purged.
     * https://support.google.com/analytics/answer/6154772
     *
     * Returns an error if the target is not found.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::deleteAccountAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/delete_account.php
     *
     * @param DeleteAccountRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteAccount(DeleteAccountRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteAccount', $request, $callOptions)->wait();
    }

    /**
     * Deprecated: Use `DeleteKeyEvent` instead.
     * Deletes a conversion event in a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteConversionEventAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/delete_conversion_event.php
     *
     * @param DeleteConversionEventRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     *
     * @deprecated This method will be removed in the next major version update.
     */
    public function deleteConversionEvent(DeleteConversionEventRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteConversionEvent', $request, $callOptions)->wait();
    }

    /**
     * Deletes a DataStream on a property.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::deleteDataStreamAsync()}
     * .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/delete_data_stream.php
     *
     * @param DeleteDataStreamRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteDataStream(DeleteDataStreamRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteDataStream', $request, $callOptions)->wait();
    }

    /**
     * Deletes a FirebaseLink on a property
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteFirebaseLinkAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/delete_firebase_link.php
     *
     * @param DeleteFirebaseLinkRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteFirebaseLink(DeleteFirebaseLinkRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteFirebaseLink', $request, $callOptions)->wait();
    }

    /**
     * Deletes a GoogleAdsLink on a property
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteGoogleAdsLinkAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/delete_google_ads_link.php
     *
     * @param DeleteGoogleAdsLinkRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteGoogleAdsLink(DeleteGoogleAdsLinkRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteGoogleAdsLink', $request, $callOptions)->wait();
    }

    /**
     * Deletes a Key Event.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::deleteKeyEventAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/delete_key_event.php
     *
     * @param DeleteKeyEventRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteKeyEvent(DeleteKeyEventRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteKeyEvent', $request, $callOptions)->wait();
    }

    /**
     * Deletes target MeasurementProtocolSecret.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteMeasurementProtocolSecretAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/delete_measurement_protocol_secret.php
     *
     * @param DeleteMeasurementProtocolSecretRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteMeasurementProtocolSecret(DeleteMeasurementProtocolSecretRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteMeasurementProtocolSecret', $request, $callOptions)->wait();
    }

    /**
     * Marks target Property as soft-deleted (ie: "trashed") and returns it.
     *
     * This API does not have a method to restore soft-deleted properties.
     * However, they can be restored using the Trash Can UI.
     *
     * If the properties are not restored before the expiration time, the Property
     * and all child resources (eg: GoogleAdsLinks, Streams, AccessBindings)
     * will be permanently purged.
     * https://support.google.com/analytics/answer/6154772
     *
     * Returns an error if the target is not found, or is not a GA4 Property.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::deletePropertyAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/delete_property.php
     *
     * @param DeletePropertyRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Property
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteProperty(DeletePropertyRequest $request, array $callOptions = []): Property
    {
        return $this->startApiCall('DeleteProperty', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single Account.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::getAccountAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/get_account.php
     *
     * @param GetAccountRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Account
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getAccount(GetAccountRequest $request, array $callOptions = []): Account
    {
        return $this->startApiCall('GetAccount', $request, $callOptions)->wait();
    }

    /**
     * Deprecated: Use `GetKeyEvent` instead.
     * Retrieve a single conversion event.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getConversionEventAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/get_conversion_event.php
     *
     * @param GetConversionEventRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ConversionEvent
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     *
     * @deprecated This method will be removed in the next major version update.
     */
    public function getConversionEvent(GetConversionEventRequest $request, array $callOptions = []): ConversionEvent
    {
        return $this->startApiCall('GetConversionEvent', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single CustomDimension.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getCustomDimensionAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/get_custom_dimension.php
     *
     * @param GetCustomDimensionRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomDimension
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getCustomDimension(GetCustomDimensionRequest $request, array $callOptions = []): CustomDimension
    {
        return $this->startApiCall('GetCustomDimension', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single CustomMetric.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::getCustomMetricAsync()}
     * .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/get_custom_metric.php
     *
     * @param GetCustomMetricRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomMetric
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getCustomMetric(GetCustomMetricRequest $request, array $callOptions = []): CustomMetric
    {
        return $this->startApiCall('GetCustomMetric', $request, $callOptions)->wait();
    }

    /**
     * Returns the singleton data retention settings for this property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getDataRetentionSettingsAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/get_data_retention_settings.php
     *
     * @param GetDataRetentionSettingsRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataRetentionSettings
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getDataRetentionSettings(GetDataRetentionSettingsRequest $request, array $callOptions = []): DataRetentionSettings
    {
        return $this->startApiCall('GetDataRetentionSettings', $request, $callOptions)->wait();
    }

    /**
     * Get data sharing settings on an account.
     * Data sharing settings are singletons.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getDataSharingSettingsAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/get_data_sharing_settings.php
     *
     * @param GetDataSharingSettingsRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataSharingSettings
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getDataSharingSettings(GetDataSharingSettingsRequest $request, array $callOptions = []): DataSharingSettings
    {
        return $this->startApiCall('GetDataSharingSettings', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single DataStream.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::getDataStreamAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/get_data_stream.php
     *
     * @param GetDataStreamRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataStream
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getDataStream(GetDataStreamRequest $request, array $callOptions = []): DataStream
    {
        return $this->startApiCall('GetDataStream', $request, $callOptions)->wait();
    }

    /**
     * Retrieve a single Key Event.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::getKeyEventAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/get_key_event.php
     *
     * @param GetKeyEventRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return KeyEvent
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getKeyEvent(GetKeyEventRequest $request, array $callOptions = []): KeyEvent
    {
        return $this->startApiCall('GetKeyEvent', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single "GA4" MeasurementProtocolSecret.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getMeasurementProtocolSecretAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/get_measurement_protocol_secret.php
     *
     * @param GetMeasurementProtocolSecretRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MeasurementProtocolSecret
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getMeasurementProtocolSecret(GetMeasurementProtocolSecretRequest $request, array $callOptions = []): MeasurementProtocolSecret
    {
        return $this->startApiCall('GetMeasurementProtocolSecret', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single "GA4" Property.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::getPropertyAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/get_property.php
     *
     * @param GetPropertyRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Property
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getProperty(GetPropertyRequest $request, array $callOptions = []): Property
    {
        return $this->startApiCall('GetProperty', $request, $callOptions)->wait();
    }

    /**
     * Returns summaries of all accounts accessible by the caller.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listAccountSummariesAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/list_account_summaries.php
     *
     * @param ListAccountSummariesRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listAccountSummaries(ListAccountSummariesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAccountSummaries', $request, $callOptions);
    }

    /**
     * Returns all accounts accessible by the caller.
     *
     * Note that these accounts might not currently have GA4 properties.
     * Soft-deleted (ie: "trashed") accounts are excluded by default.
     * Returns an empty list if no relevant accounts are found.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::listAccountsAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/list_accounts.php
     *
     * @param ListAccountsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listAccounts(ListAccountsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAccounts', $request, $callOptions);
    }

    /**
     * Deprecated: Use `ListKeyEvents` instead.
     * Returns a list of conversion events in the specified parent property.
     *
     * Returns an empty list if no conversion events are found.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listConversionEventsAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/list_conversion_events.php
     *
     * @param ListConversionEventsRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     *
     * @deprecated This method will be removed in the next major version update.
     */
    public function listConversionEvents(ListConversionEventsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListConversionEvents', $request, $callOptions);
    }

    /**
     * Lists CustomDimensions on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listCustomDimensionsAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/list_custom_dimensions.php
     *
     * @param ListCustomDimensionsRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listCustomDimensions(ListCustomDimensionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCustomDimensions', $request, $callOptions);
    }

    /**
     * Lists CustomMetrics on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listCustomMetricsAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/list_custom_metrics.php
     *
     * @param ListCustomMetricsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listCustomMetrics(ListCustomMetricsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCustomMetrics', $request, $callOptions);
    }

    /**
     * Lists DataStreams on a property.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::listDataStreamsAsync()}
     * .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/list_data_streams.php
     *
     * @param ListDataStreamsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listDataStreams(ListDataStreamsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDataStreams', $request, $callOptions);
    }

    /**
     * Lists FirebaseLinks on a property.
     * Properties can have at most one FirebaseLink.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listFirebaseLinksAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/list_firebase_links.php
     *
     * @param ListFirebaseLinksRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listFirebaseLinks(ListFirebaseLinksRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListFirebaseLinks', $request, $callOptions);
    }

    /**
     * Lists GoogleAdsLinks on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listGoogleAdsLinksAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/list_google_ads_links.php
     *
     * @param ListGoogleAdsLinksRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listGoogleAdsLinks(ListGoogleAdsLinksRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListGoogleAdsLinks', $request, $callOptions);
    }

    /**
     * Returns a list of Key Events in the specified parent property.
     * Returns an empty list if no Key Events are found.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::listKeyEventsAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/list_key_events.php
     *
     * @param ListKeyEventsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listKeyEvents(ListKeyEventsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListKeyEvents', $request, $callOptions);
    }

    /**
     * Returns child MeasurementProtocolSecrets under the specified parent
     * Property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listMeasurementProtocolSecretsAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/list_measurement_protocol_secrets.php
     *
     * @param ListMeasurementProtocolSecretsRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listMeasurementProtocolSecrets(ListMeasurementProtocolSecretsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListMeasurementProtocolSecrets', $request, $callOptions);
    }

    /**
     * Returns child Properties under the specified parent Account.
     *
     * Only "GA4" properties will be returned.
     * Properties will be excluded if the caller does not have access.
     * Soft-deleted (ie: "trashed") properties are excluded by default.
     * Returns an empty list if no relevant properties are found.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::listPropertiesAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/list_properties.php
     *
     * @param ListPropertiesRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listProperties(ListPropertiesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListProperties', $request, $callOptions);
    }

    /**
     * Requests a ticket for creating an account.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::provisionAccountTicketAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/provision_account_ticket.php
     *
     * @param ProvisionAccountTicketRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ProvisionAccountTicketResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function provisionAccountTicket(ProvisionAccountTicketRequest $request, array $callOptions = []): ProvisionAccountTicketResponse
    {
        return $this->startApiCall('ProvisionAccountTicket', $request, $callOptions)->wait();
    }

    /**
     * Returns a customized report of data access records. The report provides
     * records of each time a user reads Google Analytics reporting data. Access
     * records are retained for up to 2 years.
     *
     * Data Access Reports can be requested for a property. Reports may be
     * requested for any property, but dimensions that aren't related to quota can
     * only be requested on Google Analytics 360 properties. This method is only
     * available to Administrators.
     *
     * These data access records include GA4 UI Reporting, GA4 UI Explorations,
     * GA4 Data API, and other products like Firebase & Admob that can retrieve
     * data from Google Analytics through a linkage. These records don't include
     * property configuration changes like adding a stream or changing a
     * property's time zone. For configuration change history, see
     * [searchChangeHistoryEvents](https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1alpha/accounts/searchChangeHistoryEvents).
     *
     * The async variant is {@see AnalyticsAdminServiceClient::runAccessReportAsync()}
     * .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/run_access_report.php
     *
     * @param RunAccessReportRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RunAccessReportResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function runAccessReport(RunAccessReportRequest $request, array $callOptions = []): RunAccessReportResponse
    {
        return $this->startApiCall('RunAccessReport', $request, $callOptions)->wait();
    }

    /**
     * Searches through all changes to an account or its children given the
     * specified set of filters.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::searchChangeHistoryEventsAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/search_change_history_events.php
     *
     * @param SearchChangeHistoryEventsRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function searchChangeHistoryEvents(SearchChangeHistoryEventsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('SearchChangeHistoryEvents', $request, $callOptions);
    }

    /**
     * Updates an account.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::updateAccountAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/update_account.php
     *
     * @param UpdateAccountRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Account
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateAccount(UpdateAccountRequest $request, array $callOptions = []): Account
    {
        return $this->startApiCall('UpdateAccount', $request, $callOptions)->wait();
    }

    /**
     * Deprecated: Use `UpdateKeyEvent` instead.
     * Updates a conversion event with the specified attributes.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateConversionEventAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/update_conversion_event.php
     *
     * @param UpdateConversionEventRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ConversionEvent
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     *
     * @deprecated This method will be removed in the next major version update.
     */
    public function updateConversionEvent(UpdateConversionEventRequest $request, array $callOptions = []): ConversionEvent
    {
        return $this->startApiCall('UpdateConversionEvent', $request, $callOptions)->wait();
    }

    /**
     * Updates a CustomDimension on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateCustomDimensionAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/update_custom_dimension.php
     *
     * @param UpdateCustomDimensionRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomDimension
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateCustomDimension(UpdateCustomDimensionRequest $request, array $callOptions = []): CustomDimension
    {
        return $this->startApiCall('UpdateCustomDimension', $request, $callOptions)->wait();
    }

    /**
     * Updates a CustomMetric on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateCustomMetricAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/update_custom_metric.php
     *
     * @param UpdateCustomMetricRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomMetric
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateCustomMetric(UpdateCustomMetricRequest $request, array $callOptions = []): CustomMetric
    {
        return $this->startApiCall('UpdateCustomMetric', $request, $callOptions)->wait();
    }

    /**
     * Updates the singleton data retention settings for this property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateDataRetentionSettingsAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/update_data_retention_settings.php
     *
     * @param UpdateDataRetentionSettingsRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataRetentionSettings
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateDataRetentionSettings(UpdateDataRetentionSettingsRequest $request, array $callOptions = []): DataRetentionSettings
    {
        return $this->startApiCall('UpdateDataRetentionSettings', $request, $callOptions)->wait();
    }

    /**
     * Updates a DataStream on a property.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::updateDataStreamAsync()}
     * .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/update_data_stream.php
     *
     * @param UpdateDataStreamRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataStream
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateDataStream(UpdateDataStreamRequest $request, array $callOptions = []): DataStream
    {
        return $this->startApiCall('UpdateDataStream', $request, $callOptions)->wait();
    }

    /**
     * Updates a GoogleAdsLink on a property
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateGoogleAdsLinkAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/update_google_ads_link.php
     *
     * @param UpdateGoogleAdsLinkRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GoogleAdsLink
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateGoogleAdsLink(UpdateGoogleAdsLinkRequest $request, array $callOptions = []): GoogleAdsLink
    {
        return $this->startApiCall('UpdateGoogleAdsLink', $request, $callOptions)->wait();
    }

    /**
     * Updates a Key Event.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::updateKeyEventAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/update_key_event.php
     *
     * @param UpdateKeyEventRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return KeyEvent
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateKeyEvent(UpdateKeyEventRequest $request, array $callOptions = []): KeyEvent
    {
        return $this->startApiCall('UpdateKeyEvent', $request, $callOptions)->wait();
    }

    /**
     * Updates a measurement protocol secret.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateMeasurementProtocolSecretAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/update_measurement_protocol_secret.php
     *
     * @param UpdateMeasurementProtocolSecretRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MeasurementProtocolSecret
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateMeasurementProtocolSecret(UpdateMeasurementProtocolSecretRequest $request, array $callOptions = []): MeasurementProtocolSecret
    {
        return $this->startApiCall('UpdateMeasurementProtocolSecret', $request, $callOptions)->wait();
    }

    /**
     * Updates a property.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::updatePropertyAsync()} .
     *
     * @example samples/V1beta/AnalyticsAdminServiceClient/update_property.php
     *
     * @param UpdatePropertyRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Property
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateProperty(UpdatePropertyRequest $request, array $callOptions = []): Property
    {
        return $this->startApiCall('UpdateProperty', $request, $callOptions)->wait();
    }
}
