<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1/cluster_service.proto

namespace Google\Cloud\Container\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Google Kubernetes Engine cluster.
 *
 * Generated from protobuf message <code>google.container.v1.Cluster</code>
 */
class Cluster extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of this cluster. The name must be unique within this project
     * and location (e.g. zone or region), and can be up to 40 characters with
     * the following restrictions:
     * * Lowercase letters, numbers, and hyphens only.
     * * Must start with a letter.
     * * Must end with a number or a letter.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * An optional description of this cluster.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     */
    private $description = '';
    /**
     * The number of nodes to create in this cluster. You must ensure that your
     * Compute Engine [resource quota](https://cloud.google.com/compute/quotas)
     * is sufficient for this number of instances. You must also have available
     * firewall and routes quota.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "node_config") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     * This field is deprecated, use node_pool.initial_node_count instead.
     *
     * Generated from protobuf field <code>int32 initial_node_count = 3 [deprecated = true];</code>
     * @deprecated
     */
    protected $initial_node_count = 0;
    /**
     * Parameters used in creating the cluster's nodes.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "initial_node_count") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     * For responses, this field will be populated with the node configuration of
     * the first node pool. (For configuration of each node pool, see
     * `node_pool.config`)
     * If unspecified, the defaults are used.
     * This field is deprecated, use node_pool.config instead.
     *
     * Generated from protobuf field <code>.google.container.v1.NodeConfig node_config = 4 [deprecated = true];</code>
     * @deprecated
     */
    protected $node_config = null;
    /**
     * The authentication information for accessing the master endpoint.
     * If unspecified, the defaults are used:
     * For clusters before v1.12, if master_auth is unspecified, `username` will
     * be set to "admin", a random password will be generated, and a client
     * certificate will be issued.
     *
     * Generated from protobuf field <code>.google.container.v1.MasterAuth master_auth = 5;</code>
     */
    private $master_auth = null;
    /**
     * The logging service the cluster should use to write logs.
     * Currently available options:
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     *
     * Generated from protobuf field <code>string logging_service = 6;</code>
     */
    private $logging_service = '';
    /**
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     * service with a Kubernetes-native resource model
     * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *   longer available as of GKE 1.15).
     * * `none` - No metrics will be exported from the cluster.
     * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     *
     * Generated from protobuf field <code>string monitoring_service = 7;</code>
     */
    private $monitoring_service = '';
    /**
     * The name of the Google Compute Engine
     * [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     * to which the cluster is connected. If left unspecified, the `default`
     * network will be used.
     *
     * Generated from protobuf field <code>string network = 8;</code>
     */
    private $network = '';
    /**
     * The IP address range of the container pods in this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`). Leave blank to have
     * one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
     *
     * Generated from protobuf field <code>string cluster_ipv4_cidr = 9;</code>
     */
    private $cluster_ipv4_cidr = '';
    /**
     * Configurations for the various addons available to run in the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.AddonsConfig addons_config = 10;</code>
     */
    private $addons_config = null;
    /**
     * The name of the Google Compute Engine
     * [subnetwork](https://cloud.google.com/compute/docs/subnetworks) to which
     * the cluster is connected.
     *
     * Generated from protobuf field <code>string subnetwork = 11;</code>
     */
    private $subnetwork = '';
    /**
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     */
    private $node_pools;
    /**
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     * This field provides a default value if
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * are not specified during node pool creation.
     * Warning: changing cluster locations will update the
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * of all node pools and will result in nodes being added and/or removed.
     *
     * Generated from protobuf field <code>repeated string locations = 13;</code>
     */
    private $locations;
    /**
     * Kubernetes alpha features are enabled on this cluster. This includes alpha
     * API groups (e.g. v1alpha1) and features that may not be production ready in
     * the kubernetes version of the master and nodes.
     * The cluster has no SLA for uptime and master/node upgrades are disabled.
     * Alpha enabled clusters are automatically deleted thirty days after
     * creation.
     *
     * Generated from protobuf field <code>bool enable_kubernetes_alpha = 14;</code>
     */
    private $enable_kubernetes_alpha = false;
    /**
     * The resource labels for the cluster to use to annotate any related
     * Google Compute Engine resources.
     *
     * Generated from protobuf field <code>map<string, string> resource_labels = 15;</code>
     */
    private $resource_labels;
    /**
     * The fingerprint of the set of labels for this cluster.
     *
     * Generated from protobuf field <code>string label_fingerprint = 16;</code>
     */
    private $label_fingerprint = '';
    /**
     * Configuration for the legacy ABAC authorization mode.
     *
     * Generated from protobuf field <code>.google.container.v1.LegacyAbac legacy_abac = 18;</code>
     */
    private $legacy_abac = null;
    /**
     * Configuration options for the NetworkPolicy feature.
     *
     * Generated from protobuf field <code>.google.container.v1.NetworkPolicy network_policy = 19;</code>
     */
    private $network_policy = null;
    /**
     * Configuration for cluster IP allocation.
     *
     * Generated from protobuf field <code>.google.container.v1.IPAllocationPolicy ip_allocation_policy = 20;</code>
     */
    private $ip_allocation_policy = null;
    /**
     * The configuration options for master authorized networks feature.
     *
     * Generated from protobuf field <code>.google.container.v1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22;</code>
     */
    private $master_authorized_networks_config = null;
    /**
     * Configure the maintenance policy for this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.MaintenancePolicy maintenance_policy = 23;</code>
     */
    private $maintenance_policy = null;
    /**
     * Configuration for Binary Authorization.
     *
     * Generated from protobuf field <code>.google.container.v1.BinaryAuthorization binary_authorization = 24;</code>
     */
    private $binary_authorization = null;
    /**
     * Cluster-level autoscaling configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ClusterAutoscaling autoscaling = 26;</code>
     */
    private $autoscaling = null;
    /**
     * Configuration for cluster networking.
     *
     * Generated from protobuf field <code>.google.container.v1.NetworkConfig network_config = 27;</code>
     */
    private $network_config = null;
    /**
     * The default constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool of this cluster. Only honored
     * if cluster created with IP Alias support.
     *
     * Generated from protobuf field <code>.google.container.v1.MaxPodsConstraint default_max_pods_constraint = 30;</code>
     */
    private $default_max_pods_constraint = null;
    /**
     * Configuration for exporting resource usages. Resource usage export is
     * disabled when this config is unspecified.
     *
     * Generated from protobuf field <code>.google.container.v1.ResourceUsageExportConfig resource_usage_export_config = 33;</code>
     */
    private $resource_usage_export_config = null;
    /**
     * Configuration controlling RBAC group membership information.
     *
     * Generated from protobuf field <code>.google.container.v1.AuthenticatorGroupsConfig authenticator_groups_config = 34;</code>
     */
    private $authenticator_groups_config = null;
    /**
     * Configuration for private cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.PrivateClusterConfig private_cluster_config = 37;</code>
     */
    private $private_cluster_config = null;
    /**
     * Configuration of etcd encryption.
     *
     * Generated from protobuf field <code>.google.container.v1.DatabaseEncryption database_encryption = 38;</code>
     */
    private $database_encryption = null;
    /**
     * Cluster-level Vertical Pod Autoscaling configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.VerticalPodAutoscaling vertical_pod_autoscaling = 39;</code>
     */
    private $vertical_pod_autoscaling = null;
    /**
     * Shielded Nodes configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ShieldedNodes shielded_nodes = 40;</code>
     */
    private $shielded_nodes = null;
    /**
     * Release channel configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ReleaseChannel release_channel = 41;</code>
     */
    private $release_channel = null;
    /**
     * Configuration for the use of Kubernetes Service Accounts in GCP IAM
     * policies.
     *
     * Generated from protobuf field <code>.google.container.v1.WorkloadIdentityConfig workload_identity_config = 43;</code>
     */
    private $workload_identity_config = null;
    /**
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     *
     * Generated from protobuf field <code>.google.container.v1.MeshCertificates mesh_certificates = 67;</code>
     */
    private $mesh_certificates = null;
    /**
     * Configuration for the fine-grained cost management feature.
     *
     * Generated from protobuf field <code>.google.container.v1.CostManagementConfig cost_management_config = 45;</code>
     */
    private $cost_management_config = null;
    /**
     * Notification configuration of the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.NotificationConfig notification_config = 49;</code>
     */
    private $notification_config = null;
    /**
     * Configuration of Confidential Nodes.
     * All the nodes in the cluster will be Confidential VM once enabled.
     *
     * Generated from protobuf field <code>.google.container.v1.ConfidentialNodes confidential_nodes = 50;</code>
     */
    private $confidential_nodes = null;
    /**
     * Configuration for Identity Service component.
     *
     * Generated from protobuf field <code>.google.container.v1.IdentityServiceConfig identity_service_config = 54;</code>
     */
    private $identity_service_config = null;
    /**
     * [Output only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 100;</code>
     */
    private $self_link = '';
    /**
     * [Output only] The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field is deprecated, use location instead.
     *
     * Generated from protobuf field <code>string zone = 101 [deprecated = true];</code>
     * @deprecated
     */
    protected $zone = '';
    /**
     * [Output only] The IP address of this cluster's master endpoint.
     * The endpoint can be accessed from the internet at
     * `https://username:password&#64;endpoint/`.
     * See the `masterAuth` property of this resource for username and
     * password information.
     *
     * Generated from protobuf field <code>string endpoint = 102;</code>
     */
    private $endpoint = '';
    /**
     * The initial Kubernetes version for this cluster.  Valid versions are those
     * found in validMasterVersions returned by getServerConfig.  The version can
     * be upgraded over time; such upgrades are reflected in
     * currentMasterVersion and currentNodeVersion.
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "","-": picks the default Kubernetes version
     *
     * Generated from protobuf field <code>string initial_cluster_version = 103;</code>
     */
    private $initial_cluster_version = '';
    /**
     * [Output only] The current software version of the master endpoint.
     *
     * Generated from protobuf field <code>string current_master_version = 104;</code>
     */
    private $current_master_version = '';
    /**
     * [Output only] Deprecated, use
     * [NodePools.version](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools)
     * instead. The current version of the node software components. If they are
     * currently at multiple versions because they're in the process of being
     * upgraded, this reflects the minimum version of all nodes.
     *
     * Generated from protobuf field <code>string current_node_version = 105 [deprecated = true];</code>
     * @deprecated
     */
    protected $current_node_version = '';
    /**
     * [Output only] The time the cluster was created, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     *
     * Generated from protobuf field <code>string create_time = 106;</code>
     */
    private $create_time = '';
    /**
     * [Output only] The current status of this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.Cluster.Status status = 107;</code>
     */
    private $status = 0;
    /**
     * [Output only] Deprecated. Use conditions instead.
     * Additional information about the current status of this
     * cluster, if available.
     *
     * Generated from protobuf field <code>string status_message = 108 [deprecated = true];</code>
     * @deprecated
     */
    protected $status_message = '';
    /**
     * [Output only] The size of the address space on each node for hosting
     * containers. This is provisioned from within the `container_ipv4_cidr`
     * range. This field will only be set when cluster is in route-based network
     * mode.
     *
     * Generated from protobuf field <code>int32 node_ipv4_cidr_size = 109;</code>
     */
    private $node_ipv4_cidr_size = 0;
    /**
     * [Output only] The IP address range of the Kubernetes services in
     * this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `1.2.3.4/29`). Service addresses are
     * typically put in the last `/16` from the container CIDR.
     *
     * Generated from protobuf field <code>string services_ipv4_cidr = 110;</code>
     */
    private $services_ipv4_cidr = '';
    /**
     * Deprecated. Use node_pools.instance_group_urls.
     *
     * Generated from protobuf field <code>repeated string instance_group_urls = 111 [deprecated = true];</code>
     * @deprecated
     */
    private $instance_group_urls;
    /**
     * [Output only]  The number of nodes currently in the cluster. Deprecated.
     * Call Kubernetes API directly to retrieve node information.
     *
     * Generated from protobuf field <code>int32 current_node_count = 112 [deprecated = true];</code>
     * @deprecated
     */
    protected $current_node_count = 0;
    /**
     * [Output only] The time the cluster will be automatically
     * deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     *
     * Generated from protobuf field <code>string expire_time = 113;</code>
     */
    private $expire_time = '';
    /**
     * [Output only] The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * or
     * [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * in which the cluster resides.
     *
     * Generated from protobuf field <code>string location = 114;</code>
     */
    private $location = '';
    /**
     * Enable the ability to use Cloud TPUs in this cluster.
     *
     * Generated from protobuf field <code>bool enable_tpu = 115;</code>
     */
    private $enable_tpu = false;
    /**
     * [Output only] The IP address range of the Cloud TPUs in this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `1.2.3.4/29`).
     *
     * Generated from protobuf field <code>string tpu_ipv4_cidr_block = 116;</code>
     */
    private $tpu_ipv4_cidr_block = '';
    /**
     * Which conditions caused the current cluster state.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     */
    private $conditions;
    /**
     * Autopilot configuration for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.Autopilot autopilot = 128;</code>
     */
    private $autopilot = null;
    /**
     * Output only. Unique id for the cluster.
     *
     * Generated from protobuf field <code>string id = 129 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $id = '';
    /**
     * Default NodePool settings for the entire cluster. These settings are
     * overridden if specified on the specific NodePool object.
     *
     * Generated from protobuf field <code>optional .google.container.v1.NodePoolDefaults node_pool_defaults = 131;</code>
     */
    private $node_pool_defaults = null;
    /**
     * Logging configuration for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.LoggingConfig logging_config = 132;</code>
     */
    private $logging_config = null;
    /**
     * Monitoring configuration for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.MonitoringConfig monitoring_config = 133;</code>
     */
    private $monitoring_config = null;
    /**
     * Node pool configs that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     *
     * Generated from protobuf field <code>.google.container.v1.NodePoolAutoConfig node_pool_auto_config = 136;</code>
     */
    private $node_pool_auto_config = null;
    /**
     * This checksum is computed by the server based on the value of cluster
     * fields, and may be sent on update requests to ensure the client has an
     * up-to-date value before proceeding.
     *
     * Generated from protobuf field <code>string etag = 139;</code>
     */
    private $etag = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The name of this cluster. The name must be unique within this project
     *           and location (e.g. zone or region), and can be up to 40 characters with
     *           the following restrictions:
     *           * Lowercase letters, numbers, and hyphens only.
     *           * Must start with a letter.
     *           * Must end with a number or a letter.
     *     @type string $description
     *           An optional description of this cluster.
     *     @type int $initial_node_count
     *           The number of nodes to create in this cluster. You must ensure that your
     *           Compute Engine [resource quota](https://cloud.google.com/compute/quotas)
     *           is sufficient for this number of instances. You must also have available
     *           firewall and routes quota.
     *           For requests, this field should only be used in lieu of a
     *           "node_pool" object, since this configuration (along with the
     *           "node_config") will be used to create a "NodePool" object with an
     *           auto-generated name. Do not use this and a node_pool at the same time.
     *           This field is deprecated, use node_pool.initial_node_count instead.
     *     @type \Google\Cloud\Container\V1\NodeConfig $node_config
     *           Parameters used in creating the cluster's nodes.
     *           For requests, this field should only be used in lieu of a
     *           "node_pool" object, since this configuration (along with the
     *           "initial_node_count") will be used to create a "NodePool" object with an
     *           auto-generated name. Do not use this and a node_pool at the same time.
     *           For responses, this field will be populated with the node configuration of
     *           the first node pool. (For configuration of each node pool, see
     *           `node_pool.config`)
     *           If unspecified, the defaults are used.
     *           This field is deprecated, use node_pool.config instead.
     *     @type \Google\Cloud\Container\V1\MasterAuth $master_auth
     *           The authentication information for accessing the master endpoint.
     *           If unspecified, the defaults are used:
     *           For clusters before v1.12, if master_auth is unspecified, `username` will
     *           be set to "admin", a random password will be generated, and a client
     *           certificate will be issued.
     *     @type string $logging_service
     *           The logging service the cluster should use to write logs.
     *           Currently available options:
     *           * `logging.googleapis.com/kubernetes` - The Cloud Logging
     *           service with a Kubernetes-native resource model
     *           * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *             available as of GKE 1.15).
     *           * `none` - no logs will be exported from the cluster.
     *           If left as an empty string,`logging.googleapis.com/kubernetes` will be
     *           used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     *     @type string $monitoring_service
     *           The monitoring service the cluster should use to write metrics.
     *           Currently available options:
     *           * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     *           service with a Kubernetes-native resource model
     *           * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *             longer available as of GKE 1.15).
     *           * `none` - No metrics will be exported from the cluster.
     *           If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     *           used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     *     @type string $network
     *           The name of the Google Compute Engine
     *           [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     *           to which the cluster is connected. If left unspecified, the `default`
     *           network will be used.
     *     @type string $cluster_ipv4_cidr
     *           The IP address range of the container pods in this cluster, in
     *           [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     *           notation (e.g. `10.96.0.0/14`). Leave blank to have
     *           one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
     *     @type \Google\Cloud\Container\V1\AddonsConfig $addons_config
     *           Configurations for the various addons available to run in the cluster.
     *     @type string $subnetwork
     *           The name of the Google Compute Engine
     *           [subnetwork](https://cloud.google.com/compute/docs/subnetworks) to which
     *           the cluster is connected.
     *     @type array<\Google\Cloud\Container\V1\NodePool>|\Google\Protobuf\Internal\RepeatedField $node_pools
     *           The node pools associated with this cluster.
     *           This field should not be set if "node_config" or "initial_node_count" are
     *           specified.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $locations
     *           The list of Google Compute Engine
     *           [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     *           cluster's nodes should be located.
     *           This field provides a default value if
     *           [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     *           are not specified during node pool creation.
     *           Warning: changing cluster locations will update the
     *           [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     *           of all node pools and will result in nodes being added and/or removed.
     *     @type bool $enable_kubernetes_alpha
     *           Kubernetes alpha features are enabled on this cluster. This includes alpha
     *           API groups (e.g. v1alpha1) and features that may not be production ready in
     *           the kubernetes version of the master and nodes.
     *           The cluster has no SLA for uptime and master/node upgrades are disabled.
     *           Alpha enabled clusters are automatically deleted thirty days after
     *           creation.
     *     @type array|\Google\Protobuf\Internal\MapField $resource_labels
     *           The resource labels for the cluster to use to annotate any related
     *           Google Compute Engine resources.
     *     @type string $label_fingerprint
     *           The fingerprint of the set of labels for this cluster.
     *     @type \Google\Cloud\Container\V1\LegacyAbac $legacy_abac
     *           Configuration for the legacy ABAC authorization mode.
     *     @type \Google\Cloud\Container\V1\NetworkPolicy $network_policy
     *           Configuration options for the NetworkPolicy feature.
     *     @type \Google\Cloud\Container\V1\IPAllocationPolicy $ip_allocation_policy
     *           Configuration for cluster IP allocation.
     *     @type \Google\Cloud\Container\V1\MasterAuthorizedNetworksConfig $master_authorized_networks_config
     *           The configuration options for master authorized networks feature.
     *     @type \Google\Cloud\Container\V1\MaintenancePolicy $maintenance_policy
     *           Configure the maintenance policy for this cluster.
     *     @type \Google\Cloud\Container\V1\BinaryAuthorization $binary_authorization
     *           Configuration for Binary Authorization.
     *     @type \Google\Cloud\Container\V1\ClusterAutoscaling $autoscaling
     *           Cluster-level autoscaling configuration.
     *     @type \Google\Cloud\Container\V1\NetworkConfig $network_config
     *           Configuration for cluster networking.
     *     @type \Google\Cloud\Container\V1\MaxPodsConstraint $default_max_pods_constraint
     *           The default constraint on the maximum number of pods that can be run
     *           simultaneously on a node in the node pool of this cluster. Only honored
     *           if cluster created with IP Alias support.
     *     @type \Google\Cloud\Container\V1\ResourceUsageExportConfig $resource_usage_export_config
     *           Configuration for exporting resource usages. Resource usage export is
     *           disabled when this config is unspecified.
     *     @type \Google\Cloud\Container\V1\AuthenticatorGroupsConfig $authenticator_groups_config
     *           Configuration controlling RBAC group membership information.
     *     @type \Google\Cloud\Container\V1\PrivateClusterConfig $private_cluster_config
     *           Configuration for private cluster.
     *     @type \Google\Cloud\Container\V1\DatabaseEncryption $database_encryption
     *           Configuration of etcd encryption.
     *     @type \Google\Cloud\Container\V1\VerticalPodAutoscaling $vertical_pod_autoscaling
     *           Cluster-level Vertical Pod Autoscaling configuration.
     *     @type \Google\Cloud\Container\V1\ShieldedNodes $shielded_nodes
     *           Shielded Nodes configuration.
     *     @type \Google\Cloud\Container\V1\ReleaseChannel $release_channel
     *           Release channel configuration.
     *     @type \Google\Cloud\Container\V1\WorkloadIdentityConfig $workload_identity_config
     *           Configuration for the use of Kubernetes Service Accounts in GCP IAM
     *           policies.
     *     @type \Google\Cloud\Container\V1\MeshCertificates $mesh_certificates
     *           Configuration for issuance of mTLS keys and certificates to Kubernetes
     *           pods.
     *     @type \Google\Cloud\Container\V1\CostManagementConfig $cost_management_config
     *           Configuration for the fine-grained cost management feature.
     *     @type \Google\Cloud\Container\V1\NotificationConfig $notification_config
     *           Notification configuration of the cluster.
     *     @type \Google\Cloud\Container\V1\ConfidentialNodes $confidential_nodes
     *           Configuration of Confidential Nodes.
     *           All the nodes in the cluster will be Confidential VM once enabled.
     *     @type \Google\Cloud\Container\V1\IdentityServiceConfig $identity_service_config
     *           Configuration for Identity Service component.
     *     @type string $self_link
     *           [Output only] Server-defined URL for the resource.
     *     @type string $zone
     *           [Output only] The name of the Google Compute Engine
     *           [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     *           cluster resides. This field is deprecated, use location instead.
     *     @type string $endpoint
     *           [Output only] The IP address of this cluster's master endpoint.
     *           The endpoint can be accessed from the internet at
     *           `https://username:password&#64;endpoint/`.
     *           See the `masterAuth` property of this resource for username and
     *           password information.
     *     @type string $initial_cluster_version
     *           The initial Kubernetes version for this cluster.  Valid versions are those
     *           found in validMasterVersions returned by getServerConfig.  The version can
     *           be upgraded over time; such upgrades are reflected in
     *           currentMasterVersion and currentNodeVersion.
     *           Users may specify either explicit versions offered by
     *           Kubernetes Engine or version aliases, which have the following behavior:
     *           - "latest": picks the highest valid Kubernetes version
     *           - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     *           - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     *           - "1.X.Y-gke.N": picks an explicit Kubernetes version
     *           - "","-": picks the default Kubernetes version
     *     @type string $current_master_version
     *           [Output only] The current software version of the master endpoint.
     *     @type string $current_node_version
     *           [Output only] Deprecated, use
     *           [NodePools.version](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools)
     *           instead. The current version of the node software components. If they are
     *           currently at multiple versions because they're in the process of being
     *           upgraded, this reflects the minimum version of all nodes.
     *     @type string $create_time
     *           [Output only] The time the cluster was created, in
     *           [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     *     @type int $status
     *           [Output only] The current status of this cluster.
     *     @type string $status_message
     *           [Output only] Deprecated. Use conditions instead.
     *           Additional information about the current status of this
     *           cluster, if available.
     *     @type int $node_ipv4_cidr_size
     *           [Output only] The size of the address space on each node for hosting
     *           containers. This is provisioned from within the `container_ipv4_cidr`
     *           range. This field will only be set when cluster is in route-based network
     *           mode.
     *     @type string $services_ipv4_cidr
     *           [Output only] The IP address range of the Kubernetes services in
     *           this cluster, in
     *           [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     *           notation (e.g. `1.2.3.4/29`). Service addresses are
     *           typically put in the last `/16` from the container CIDR.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $instance_group_urls
     *           Deprecated. Use node_pools.instance_group_urls.
     *     @type int $current_node_count
     *           [Output only]  The number of nodes currently in the cluster. Deprecated.
     *           Call Kubernetes API directly to retrieve node information.
     *     @type string $expire_time
     *           [Output only] The time the cluster will be automatically
     *           deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     *     @type string $location
     *           [Output only] The name of the Google Compute Engine
     *           [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     *           or
     *           [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     *           in which the cluster resides.
     *     @type bool $enable_tpu
     *           Enable the ability to use Cloud TPUs in this cluster.
     *     @type string $tpu_ipv4_cidr_block
     *           [Output only] The IP address range of the Cloud TPUs in this cluster, in
     *           [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     *           notation (e.g. `1.2.3.4/29`).
     *     @type array<\Google\Cloud\Container\V1\StatusCondition>|\Google\Protobuf\Internal\RepeatedField $conditions
     *           Which conditions caused the current cluster state.
     *     @type \Google\Cloud\Container\V1\Autopilot $autopilot
     *           Autopilot configuration for the cluster.
     *     @type string $id
     *           Output only. Unique id for the cluster.
     *     @type \Google\Cloud\Container\V1\NodePoolDefaults $node_pool_defaults
     *           Default NodePool settings for the entire cluster. These settings are
     *           overridden if specified on the specific NodePool object.
     *     @type \Google\Cloud\Container\V1\LoggingConfig $logging_config
     *           Logging configuration for the cluster.
     *     @type \Google\Cloud\Container\V1\MonitoringConfig $monitoring_config
     *           Monitoring configuration for the cluster.
     *     @type \Google\Cloud\Container\V1\NodePoolAutoConfig $node_pool_auto_config
     *           Node pool configs that apply to all auto-provisioned node pools
     *           in autopilot clusters and node auto-provisioning enabled clusters.
     *     @type string $etag
     *           This checksum is computed by the server based on the value of cluster
     *           fields, and may be sent on update requests to ensure the client has an
     *           up-to-date value before proceeding.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Container\V1\ClusterService::initOnce();
        parent::__construct($data);
    }

    /**
     * The name of this cluster. The name must be unique within this project
     * and location (e.g. zone or region), and can be up to 40 characters with
     * the following restrictions:
     * * Lowercase letters, numbers, and hyphens only.
     * * Must start with a letter.
     * * Must end with a number or a letter.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The name of this cluster. The name must be unique within this project
     * and location (e.g. zone or region), and can be up to 40 characters with
     * the following restrictions:
     * * Lowercase letters, numbers, and hyphens only.
     * * Must start with a letter.
     * * Must end with a number or a letter.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * An optional description of this cluster.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * An optional description of this cluster.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * The number of nodes to create in this cluster. You must ensure that your
     * Compute Engine [resource quota](https://cloud.google.com/compute/quotas)
     * is sufficient for this number of instances. You must also have available
     * firewall and routes quota.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "node_config") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     * This field is deprecated, use node_pool.initial_node_count instead.
     *
     * Generated from protobuf field <code>int32 initial_node_count = 3 [deprecated = true];</code>
     * @return int
     * @deprecated
     */
    public function getInitialNodeCount()
    {
        @trigger_error('initial_node_count is deprecated.', E_USER_DEPRECATED);
        return $this->initial_node_count;
    }

    /**
     * The number of nodes to create in this cluster. You must ensure that your
     * Compute Engine [resource quota](https://cloud.google.com/compute/quotas)
     * is sufficient for this number of instances. You must also have available
     * firewall and routes quota.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "node_config") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     * This field is deprecated, use node_pool.initial_node_count instead.
     *
     * Generated from protobuf field <code>int32 initial_node_count = 3 [deprecated = true];</code>
     * @param int $var
     * @return $this
     * @deprecated
     */
    public function setInitialNodeCount($var)
    {
        @trigger_error('initial_node_count is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkInt32($var);
        $this->initial_node_count = $var;

        return $this;
    }

    /**
     * Parameters used in creating the cluster's nodes.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "initial_node_count") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     * For responses, this field will be populated with the node configuration of
     * the first node pool. (For configuration of each node pool, see
     * `node_pool.config`)
     * If unspecified, the defaults are used.
     * This field is deprecated, use node_pool.config instead.
     *
     * Generated from protobuf field <code>.google.container.v1.NodeConfig node_config = 4 [deprecated = true];</code>
     * @return \Google\Cloud\Container\V1\NodeConfig|null
     * @deprecated
     */
    public function getNodeConfig()
    {
        @trigger_error('node_config is deprecated.', E_USER_DEPRECATED);
        return $this->node_config;
    }

    public function hasNodeConfig()
    {
        @trigger_error('node_config is deprecated.', E_USER_DEPRECATED);
        return isset($this->node_config);
    }

    public function clearNodeConfig()
    {
        @trigger_error('node_config is deprecated.', E_USER_DEPRECATED);
        unset($this->node_config);
    }

    /**
     * Parameters used in creating the cluster's nodes.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "initial_node_count") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     * For responses, this field will be populated with the node configuration of
     * the first node pool. (For configuration of each node pool, see
     * `node_pool.config`)
     * If unspecified, the defaults are used.
     * This field is deprecated, use node_pool.config instead.
     *
     * Generated from protobuf field <code>.google.container.v1.NodeConfig node_config = 4 [deprecated = true];</code>
     * @param \Google\Cloud\Container\V1\NodeConfig $var
     * @return $this
     * @deprecated
     */
    public function setNodeConfig($var)
    {
        @trigger_error('node_config is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\NodeConfig::class);
        $this->node_config = $var;

        return $this;
    }

    /**
     * The authentication information for accessing the master endpoint.
     * If unspecified, the defaults are used:
     * For clusters before v1.12, if master_auth is unspecified, `username` will
     * be set to "admin", a random password will be generated, and a client
     * certificate will be issued.
     *
     * Generated from protobuf field <code>.google.container.v1.MasterAuth master_auth = 5;</code>
     * @return \Google\Cloud\Container\V1\MasterAuth|null
     */
    public function getMasterAuth()
    {
        return $this->master_auth;
    }

    public function hasMasterAuth()
    {
        return isset($this->master_auth);
    }

    public function clearMasterAuth()
    {
        unset($this->master_auth);
    }

    /**
     * The authentication information for accessing the master endpoint.
     * If unspecified, the defaults are used:
     * For clusters before v1.12, if master_auth is unspecified, `username` will
     * be set to "admin", a random password will be generated, and a client
     * certificate will be issued.
     *
     * Generated from protobuf field <code>.google.container.v1.MasterAuth master_auth = 5;</code>
     * @param \Google\Cloud\Container\V1\MasterAuth $var
     * @return $this
     */
    public function setMasterAuth($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\MasterAuth::class);
        $this->master_auth = $var;

        return $this;
    }

    /**
     * The logging service the cluster should use to write logs.
     * Currently available options:
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     *
     * Generated from protobuf field <code>string logging_service = 6;</code>
     * @return string
     */
    public function getLoggingService()
    {
        return $this->logging_service;
    }

    /**
     * The logging service the cluster should use to write logs.
     * Currently available options:
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     *
     * Generated from protobuf field <code>string logging_service = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setLoggingService($var)
    {
        GPBUtil::checkString($var, True);
        $this->logging_service = $var;

        return $this;
    }

    /**
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     * service with a Kubernetes-native resource model
     * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *   longer available as of GKE 1.15).
     * * `none` - No metrics will be exported from the cluster.
     * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     *
     * Generated from protobuf field <code>string monitoring_service = 7;</code>
     * @return string
     */
    public function getMonitoringService()
    {
        return $this->monitoring_service;
    }

    /**
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     * service with a Kubernetes-native resource model
     * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *   longer available as of GKE 1.15).
     * * `none` - No metrics will be exported from the cluster.
     * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     *
     * Generated from protobuf field <code>string monitoring_service = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setMonitoringService($var)
    {
        GPBUtil::checkString($var, True);
        $this->monitoring_service = $var;

        return $this;
    }

    /**
     * The name of the Google Compute Engine
     * [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     * to which the cluster is connected. If left unspecified, the `default`
     * network will be used.
     *
     * Generated from protobuf field <code>string network = 8;</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * The name of the Google Compute Engine
     * [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     * to which the cluster is connected. If left unspecified, the `default`
     * network will be used.
     *
     * Generated from protobuf field <code>string network = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * The IP address range of the container pods in this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`). Leave blank to have
     * one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
     *
     * Generated from protobuf field <code>string cluster_ipv4_cidr = 9;</code>
     * @return string
     */
    public function getClusterIpv4Cidr()
    {
        return $this->cluster_ipv4_cidr;
    }

    /**
     * The IP address range of the container pods in this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`). Leave blank to have
     * one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
     *
     * Generated from protobuf field <code>string cluster_ipv4_cidr = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setClusterIpv4Cidr($var)
    {
        GPBUtil::checkString($var, True);
        $this->cluster_ipv4_cidr = $var;

        return $this;
    }

    /**
     * Configurations for the various addons available to run in the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.AddonsConfig addons_config = 10;</code>
     * @return \Google\Cloud\Container\V1\AddonsConfig|null
     */
    public function getAddonsConfig()
    {
        return $this->addons_config;
    }

    public function hasAddonsConfig()
    {
        return isset($this->addons_config);
    }

    public function clearAddonsConfig()
    {
        unset($this->addons_config);
    }

    /**
     * Configurations for the various addons available to run in the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.AddonsConfig addons_config = 10;</code>
     * @param \Google\Cloud\Container\V1\AddonsConfig $var
     * @return $this
     */
    public function setAddonsConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\AddonsConfig::class);
        $this->addons_config = $var;

        return $this;
    }

    /**
     * The name of the Google Compute Engine
     * [subnetwork](https://cloud.google.com/compute/docs/subnetworks) to which
     * the cluster is connected.
     *
     * Generated from protobuf field <code>string subnetwork = 11;</code>
     * @return string
     */
    public function getSubnetwork()
    {
        return $this->subnetwork;
    }

    /**
     * The name of the Google Compute Engine
     * [subnetwork](https://cloud.google.com/compute/docs/subnetworks) to which
     * the cluster is connected.
     *
     * Generated from protobuf field <code>string subnetwork = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setSubnetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->subnetwork = $var;

        return $this;
    }

    /**
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getNodePools()
    {
        return $this->node_pools;
    }

    /**
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     * @param array<\Google\Cloud\Container\V1\NodePool>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setNodePools($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Container\V1\NodePool::class);
        $this->node_pools = $arr;

        return $this;
    }

    /**
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     * This field provides a default value if
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * are not specified during node pool creation.
     * Warning: changing cluster locations will update the
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * of all node pools and will result in nodes being added and/or removed.
     *
     * Generated from protobuf field <code>repeated string locations = 13;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLocations()
    {
        return $this->locations;
    }

    /**
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     * This field provides a default value if
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * are not specified during node pool creation.
     * Warning: changing cluster locations will update the
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * of all node pools and will result in nodes being added and/or removed.
     *
     * Generated from protobuf field <code>repeated string locations = 13;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLocations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->locations = $arr;

        return $this;
    }

    /**
     * Kubernetes alpha features are enabled on this cluster. This includes alpha
     * API groups (e.g. v1alpha1) and features that may not be production ready in
     * the kubernetes version of the master and nodes.
     * The cluster has no SLA for uptime and master/node upgrades are disabled.
     * Alpha enabled clusters are automatically deleted thirty days after
     * creation.
     *
     * Generated from protobuf field <code>bool enable_kubernetes_alpha = 14;</code>
     * @return bool
     */
    public function getEnableKubernetesAlpha()
    {
        return $this->enable_kubernetes_alpha;
    }

    /**
     * Kubernetes alpha features are enabled on this cluster. This includes alpha
     * API groups (e.g. v1alpha1) and features that may not be production ready in
     * the kubernetes version of the master and nodes.
     * The cluster has no SLA for uptime and master/node upgrades are disabled.
     * Alpha enabled clusters are automatically deleted thirty days after
     * creation.
     *
     * Generated from protobuf field <code>bool enable_kubernetes_alpha = 14;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableKubernetesAlpha($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_kubernetes_alpha = $var;

        return $this;
    }

    /**
     * The resource labels for the cluster to use to annotate any related
     * Google Compute Engine resources.
     *
     * Generated from protobuf field <code>map<string, string> resource_labels = 15;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getResourceLabels()
    {
        return $this->resource_labels;
    }

    /**
     * The resource labels for the cluster to use to annotate any related
     * Google Compute Engine resources.
     *
     * Generated from protobuf field <code>map<string, string> resource_labels = 15;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setResourceLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->resource_labels = $arr;

        return $this;
    }

    /**
     * The fingerprint of the set of labels for this cluster.
     *
     * Generated from protobuf field <code>string label_fingerprint = 16;</code>
     * @return string
     */
    public function getLabelFingerprint()
    {
        return $this->label_fingerprint;
    }

    /**
     * The fingerprint of the set of labels for this cluster.
     *
     * Generated from protobuf field <code>string label_fingerprint = 16;</code>
     * @param string $var
     * @return $this
     */
    public function setLabelFingerprint($var)
    {
        GPBUtil::checkString($var, True);
        $this->label_fingerprint = $var;

        return $this;
    }

    /**
     * Configuration for the legacy ABAC authorization mode.
     *
     * Generated from protobuf field <code>.google.container.v1.LegacyAbac legacy_abac = 18;</code>
     * @return \Google\Cloud\Container\V1\LegacyAbac|null
     */
    public function getLegacyAbac()
    {
        return $this->legacy_abac;
    }

    public function hasLegacyAbac()
    {
        return isset($this->legacy_abac);
    }

    public function clearLegacyAbac()
    {
        unset($this->legacy_abac);
    }

    /**
     * Configuration for the legacy ABAC authorization mode.
     *
     * Generated from protobuf field <code>.google.container.v1.LegacyAbac legacy_abac = 18;</code>
     * @param \Google\Cloud\Container\V1\LegacyAbac $var
     * @return $this
     */
    public function setLegacyAbac($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\LegacyAbac::class);
        $this->legacy_abac = $var;

        return $this;
    }

    /**
     * Configuration options for the NetworkPolicy feature.
     *
     * Generated from protobuf field <code>.google.container.v1.NetworkPolicy network_policy = 19;</code>
     * @return \Google\Cloud\Container\V1\NetworkPolicy|null
     */
    public function getNetworkPolicy()
    {
        return $this->network_policy;
    }

    public function hasNetworkPolicy()
    {
        return isset($this->network_policy);
    }

    public function clearNetworkPolicy()
    {
        unset($this->network_policy);
    }

    /**
     * Configuration options for the NetworkPolicy feature.
     *
     * Generated from protobuf field <code>.google.container.v1.NetworkPolicy network_policy = 19;</code>
     * @param \Google\Cloud\Container\V1\NetworkPolicy $var
     * @return $this
     */
    public function setNetworkPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\NetworkPolicy::class);
        $this->network_policy = $var;

        return $this;
    }

    /**
     * Configuration for cluster IP allocation.
     *
     * Generated from protobuf field <code>.google.container.v1.IPAllocationPolicy ip_allocation_policy = 20;</code>
     * @return \Google\Cloud\Container\V1\IPAllocationPolicy|null
     */
    public function getIpAllocationPolicy()
    {
        return $this->ip_allocation_policy;
    }

    public function hasIpAllocationPolicy()
    {
        return isset($this->ip_allocation_policy);
    }

    public function clearIpAllocationPolicy()
    {
        unset($this->ip_allocation_policy);
    }

    /**
     * Configuration for cluster IP allocation.
     *
     * Generated from protobuf field <code>.google.container.v1.IPAllocationPolicy ip_allocation_policy = 20;</code>
     * @param \Google\Cloud\Container\V1\IPAllocationPolicy $var
     * @return $this
     */
    public function setIpAllocationPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\IPAllocationPolicy::class);
        $this->ip_allocation_policy = $var;

        return $this;
    }

    /**
     * The configuration options for master authorized networks feature.
     *
     * Generated from protobuf field <code>.google.container.v1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22;</code>
     * @return \Google\Cloud\Container\V1\MasterAuthorizedNetworksConfig|null
     */
    public function getMasterAuthorizedNetworksConfig()
    {
        return $this->master_authorized_networks_config;
    }

    public function hasMasterAuthorizedNetworksConfig()
    {
        return isset($this->master_authorized_networks_config);
    }

    public function clearMasterAuthorizedNetworksConfig()
    {
        unset($this->master_authorized_networks_config);
    }

    /**
     * The configuration options for master authorized networks feature.
     *
     * Generated from protobuf field <code>.google.container.v1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22;</code>
     * @param \Google\Cloud\Container\V1\MasterAuthorizedNetworksConfig $var
     * @return $this
     */
    public function setMasterAuthorizedNetworksConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\MasterAuthorizedNetworksConfig::class);
        $this->master_authorized_networks_config = $var;

        return $this;
    }

    /**
     * Configure the maintenance policy for this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.MaintenancePolicy maintenance_policy = 23;</code>
     * @return \Google\Cloud\Container\V1\MaintenancePolicy|null
     */
    public function getMaintenancePolicy()
    {
        return $this->maintenance_policy;
    }

    public function hasMaintenancePolicy()
    {
        return isset($this->maintenance_policy);
    }

    public function clearMaintenancePolicy()
    {
        unset($this->maintenance_policy);
    }

    /**
     * Configure the maintenance policy for this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.MaintenancePolicy maintenance_policy = 23;</code>
     * @param \Google\Cloud\Container\V1\MaintenancePolicy $var
     * @return $this
     */
    public function setMaintenancePolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\MaintenancePolicy::class);
        $this->maintenance_policy = $var;

        return $this;
    }

    /**
     * Configuration for Binary Authorization.
     *
     * Generated from protobuf field <code>.google.container.v1.BinaryAuthorization binary_authorization = 24;</code>
     * @return \Google\Cloud\Container\V1\BinaryAuthorization|null
     */
    public function getBinaryAuthorization()
    {
        return $this->binary_authorization;
    }

    public function hasBinaryAuthorization()
    {
        return isset($this->binary_authorization);
    }

    public function clearBinaryAuthorization()
    {
        unset($this->binary_authorization);
    }

    /**
     * Configuration for Binary Authorization.
     *
     * Generated from protobuf field <code>.google.container.v1.BinaryAuthorization binary_authorization = 24;</code>
     * @param \Google\Cloud\Container\V1\BinaryAuthorization $var
     * @return $this
     */
    public function setBinaryAuthorization($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\BinaryAuthorization::class);
        $this->binary_authorization = $var;

        return $this;
    }

    /**
     * Cluster-level autoscaling configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ClusterAutoscaling autoscaling = 26;</code>
     * @return \Google\Cloud\Container\V1\ClusterAutoscaling|null
     */
    public function getAutoscaling()
    {
        return $this->autoscaling;
    }

    public function hasAutoscaling()
    {
        return isset($this->autoscaling);
    }

    public function clearAutoscaling()
    {
        unset($this->autoscaling);
    }

    /**
     * Cluster-level autoscaling configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ClusterAutoscaling autoscaling = 26;</code>
     * @param \Google\Cloud\Container\V1\ClusterAutoscaling $var
     * @return $this
     */
    public function setAutoscaling($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ClusterAutoscaling::class);
        $this->autoscaling = $var;

        return $this;
    }

    /**
     * Configuration for cluster networking.
     *
     * Generated from protobuf field <code>.google.container.v1.NetworkConfig network_config = 27;</code>
     * @return \Google\Cloud\Container\V1\NetworkConfig|null
     */
    public function getNetworkConfig()
    {
        return $this->network_config;
    }

    public function hasNetworkConfig()
    {
        return isset($this->network_config);
    }

    public function clearNetworkConfig()
    {
        unset($this->network_config);
    }

    /**
     * Configuration for cluster networking.
     *
     * Generated from protobuf field <code>.google.container.v1.NetworkConfig network_config = 27;</code>
     * @param \Google\Cloud\Container\V1\NetworkConfig $var
     * @return $this
     */
    public function setNetworkConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\NetworkConfig::class);
        $this->network_config = $var;

        return $this;
    }

    /**
     * The default constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool of this cluster. Only honored
     * if cluster created with IP Alias support.
     *
     * Generated from protobuf field <code>.google.container.v1.MaxPodsConstraint default_max_pods_constraint = 30;</code>
     * @return \Google\Cloud\Container\V1\MaxPodsConstraint|null
     */
    public function getDefaultMaxPodsConstraint()
    {
        return $this->default_max_pods_constraint;
    }

    public function hasDefaultMaxPodsConstraint()
    {
        return isset($this->default_max_pods_constraint);
    }

    public function clearDefaultMaxPodsConstraint()
    {
        unset($this->default_max_pods_constraint);
    }

    /**
     * The default constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool of this cluster. Only honored
     * if cluster created with IP Alias support.
     *
     * Generated from protobuf field <code>.google.container.v1.MaxPodsConstraint default_max_pods_constraint = 30;</code>
     * @param \Google\Cloud\Container\V1\MaxPodsConstraint $var
     * @return $this
     */
    public function setDefaultMaxPodsConstraint($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\MaxPodsConstraint::class);
        $this->default_max_pods_constraint = $var;

        return $this;
    }

    /**
     * Configuration for exporting resource usages. Resource usage export is
     * disabled when this config is unspecified.
     *
     * Generated from protobuf field <code>.google.container.v1.ResourceUsageExportConfig resource_usage_export_config = 33;</code>
     * @return \Google\Cloud\Container\V1\ResourceUsageExportConfig|null
     */
    public function getResourceUsageExportConfig()
    {
        return $this->resource_usage_export_config;
    }

    public function hasResourceUsageExportConfig()
    {
        return isset($this->resource_usage_export_config);
    }

    public function clearResourceUsageExportConfig()
    {
        unset($this->resource_usage_export_config);
    }

    /**
     * Configuration for exporting resource usages. Resource usage export is
     * disabled when this config is unspecified.
     *
     * Generated from protobuf field <code>.google.container.v1.ResourceUsageExportConfig resource_usage_export_config = 33;</code>
     * @param \Google\Cloud\Container\V1\ResourceUsageExportConfig $var
     * @return $this
     */
    public function setResourceUsageExportConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ResourceUsageExportConfig::class);
        $this->resource_usage_export_config = $var;

        return $this;
    }

    /**
     * Configuration controlling RBAC group membership information.
     *
     * Generated from protobuf field <code>.google.container.v1.AuthenticatorGroupsConfig authenticator_groups_config = 34;</code>
     * @return \Google\Cloud\Container\V1\AuthenticatorGroupsConfig|null
     */
    public function getAuthenticatorGroupsConfig()
    {
        return $this->authenticator_groups_config;
    }

    public function hasAuthenticatorGroupsConfig()
    {
        return isset($this->authenticator_groups_config);
    }

    public function clearAuthenticatorGroupsConfig()
    {
        unset($this->authenticator_groups_config);
    }

    /**
     * Configuration controlling RBAC group membership information.
     *
     * Generated from protobuf field <code>.google.container.v1.AuthenticatorGroupsConfig authenticator_groups_config = 34;</code>
     * @param \Google\Cloud\Container\V1\AuthenticatorGroupsConfig $var
     * @return $this
     */
    public function setAuthenticatorGroupsConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\AuthenticatorGroupsConfig::class);
        $this->authenticator_groups_config = $var;

        return $this;
    }

    /**
     * Configuration for private cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.PrivateClusterConfig private_cluster_config = 37;</code>
     * @return \Google\Cloud\Container\V1\PrivateClusterConfig|null
     */
    public function getPrivateClusterConfig()
    {
        return $this->private_cluster_config;
    }

    public function hasPrivateClusterConfig()
    {
        return isset($this->private_cluster_config);
    }

    public function clearPrivateClusterConfig()
    {
        unset($this->private_cluster_config);
    }

    /**
     * Configuration for private cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.PrivateClusterConfig private_cluster_config = 37;</code>
     * @param \Google\Cloud\Container\V1\PrivateClusterConfig $var
     * @return $this
     */
    public function setPrivateClusterConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\PrivateClusterConfig::class);
        $this->private_cluster_config = $var;

        return $this;
    }

    /**
     * Configuration of etcd encryption.
     *
     * Generated from protobuf field <code>.google.container.v1.DatabaseEncryption database_encryption = 38;</code>
     * @return \Google\Cloud\Container\V1\DatabaseEncryption|null
     */
    public function getDatabaseEncryption()
    {
        return $this->database_encryption;
    }

    public function hasDatabaseEncryption()
    {
        return isset($this->database_encryption);
    }

    public function clearDatabaseEncryption()
    {
        unset($this->database_encryption);
    }

    /**
     * Configuration of etcd encryption.
     *
     * Generated from protobuf field <code>.google.container.v1.DatabaseEncryption database_encryption = 38;</code>
     * @param \Google\Cloud\Container\V1\DatabaseEncryption $var
     * @return $this
     */
    public function setDatabaseEncryption($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\DatabaseEncryption::class);
        $this->database_encryption = $var;

        return $this;
    }

    /**
     * Cluster-level Vertical Pod Autoscaling configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.VerticalPodAutoscaling vertical_pod_autoscaling = 39;</code>
     * @return \Google\Cloud\Container\V1\VerticalPodAutoscaling|null
     */
    public function getVerticalPodAutoscaling()
    {
        return $this->vertical_pod_autoscaling;
    }

    public function hasVerticalPodAutoscaling()
    {
        return isset($this->vertical_pod_autoscaling);
    }

    public function clearVerticalPodAutoscaling()
    {
        unset($this->vertical_pod_autoscaling);
    }

    /**
     * Cluster-level Vertical Pod Autoscaling configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.VerticalPodAutoscaling vertical_pod_autoscaling = 39;</code>
     * @param \Google\Cloud\Container\V1\VerticalPodAutoscaling $var
     * @return $this
     */
    public function setVerticalPodAutoscaling($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\VerticalPodAutoscaling::class);
        $this->vertical_pod_autoscaling = $var;

        return $this;
    }

    /**
     * Shielded Nodes configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ShieldedNodes shielded_nodes = 40;</code>
     * @return \Google\Cloud\Container\V1\ShieldedNodes|null
     */
    public function getShieldedNodes()
    {
        return $this->shielded_nodes;
    }

    public function hasShieldedNodes()
    {
        return isset($this->shielded_nodes);
    }

    public function clearShieldedNodes()
    {
        unset($this->shielded_nodes);
    }

    /**
     * Shielded Nodes configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ShieldedNodes shielded_nodes = 40;</code>
     * @param \Google\Cloud\Container\V1\ShieldedNodes $var
     * @return $this
     */
    public function setShieldedNodes($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ShieldedNodes::class);
        $this->shielded_nodes = $var;

        return $this;
    }

    /**
     * Release channel configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ReleaseChannel release_channel = 41;</code>
     * @return \Google\Cloud\Container\V1\ReleaseChannel|null
     */
    public function getReleaseChannel()
    {
        return $this->release_channel;
    }

    public function hasReleaseChannel()
    {
        return isset($this->release_channel);
    }

    public function clearReleaseChannel()
    {
        unset($this->release_channel);
    }

    /**
     * Release channel configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ReleaseChannel release_channel = 41;</code>
     * @param \Google\Cloud\Container\V1\ReleaseChannel $var
     * @return $this
     */
    public function setReleaseChannel($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ReleaseChannel::class);
        $this->release_channel = $var;

        return $this;
    }

    /**
     * Configuration for the use of Kubernetes Service Accounts in GCP IAM
     * policies.
     *
     * Generated from protobuf field <code>.google.container.v1.WorkloadIdentityConfig workload_identity_config = 43;</code>
     * @return \Google\Cloud\Container\V1\WorkloadIdentityConfig|null
     */
    public function getWorkloadIdentityConfig()
    {
        return $this->workload_identity_config;
    }

    public function hasWorkloadIdentityConfig()
    {
        return isset($this->workload_identity_config);
    }

    public function clearWorkloadIdentityConfig()
    {
        unset($this->workload_identity_config);
    }

    /**
     * Configuration for the use of Kubernetes Service Accounts in GCP IAM
     * policies.
     *
     * Generated from protobuf field <code>.google.container.v1.WorkloadIdentityConfig workload_identity_config = 43;</code>
     * @param \Google\Cloud\Container\V1\WorkloadIdentityConfig $var
     * @return $this
     */
    public function setWorkloadIdentityConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\WorkloadIdentityConfig::class);
        $this->workload_identity_config = $var;

        return $this;
    }

    /**
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     *
     * Generated from protobuf field <code>.google.container.v1.MeshCertificates mesh_certificates = 67;</code>
     * @return \Google\Cloud\Container\V1\MeshCertificates|null
     */
    public function getMeshCertificates()
    {
        return $this->mesh_certificates;
    }

    public function hasMeshCertificates()
    {
        return isset($this->mesh_certificates);
    }

    public function clearMeshCertificates()
    {
        unset($this->mesh_certificates);
    }

    /**
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     *
     * Generated from protobuf field <code>.google.container.v1.MeshCertificates mesh_certificates = 67;</code>
     * @param \Google\Cloud\Container\V1\MeshCertificates $var
     * @return $this
     */
    public function setMeshCertificates($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\MeshCertificates::class);
        $this->mesh_certificates = $var;

        return $this;
    }

    /**
     * Configuration for the fine-grained cost management feature.
     *
     * Generated from protobuf field <code>.google.container.v1.CostManagementConfig cost_management_config = 45;</code>
     * @return \Google\Cloud\Container\V1\CostManagementConfig|null
     */
    public function getCostManagementConfig()
    {
        return $this->cost_management_config;
    }

    public function hasCostManagementConfig()
    {
        return isset($this->cost_management_config);
    }

    public function clearCostManagementConfig()
    {
        unset($this->cost_management_config);
    }

    /**
     * Configuration for the fine-grained cost management feature.
     *
     * Generated from protobuf field <code>.google.container.v1.CostManagementConfig cost_management_config = 45;</code>
     * @param \Google\Cloud\Container\V1\CostManagementConfig $var
     * @return $this
     */
    public function setCostManagementConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\CostManagementConfig::class);
        $this->cost_management_config = $var;

        return $this;
    }

    /**
     * Notification configuration of the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.NotificationConfig notification_config = 49;</code>
     * @return \Google\Cloud\Container\V1\NotificationConfig|null
     */
    public function getNotificationConfig()
    {
        return $this->notification_config;
    }

    public function hasNotificationConfig()
    {
        return isset($this->notification_config);
    }

    public function clearNotificationConfig()
    {
        unset($this->notification_config);
    }

    /**
     * Notification configuration of the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.NotificationConfig notification_config = 49;</code>
     * @param \Google\Cloud\Container\V1\NotificationConfig $var
     * @return $this
     */
    public function setNotificationConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\NotificationConfig::class);
        $this->notification_config = $var;

        return $this;
    }

    /**
     * Configuration of Confidential Nodes.
     * All the nodes in the cluster will be Confidential VM once enabled.
     *
     * Generated from protobuf field <code>.google.container.v1.ConfidentialNodes confidential_nodes = 50;</code>
     * @return \Google\Cloud\Container\V1\ConfidentialNodes|null
     */
    public function getConfidentialNodes()
    {
        return $this->confidential_nodes;
    }

    public function hasConfidentialNodes()
    {
        return isset($this->confidential_nodes);
    }

    public function clearConfidentialNodes()
    {
        unset($this->confidential_nodes);
    }

    /**
     * Configuration of Confidential Nodes.
     * All the nodes in the cluster will be Confidential VM once enabled.
     *
     * Generated from protobuf field <code>.google.container.v1.ConfidentialNodes confidential_nodes = 50;</code>
     * @param \Google\Cloud\Container\V1\ConfidentialNodes $var
     * @return $this
     */
    public function setConfidentialNodes($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ConfidentialNodes::class);
        $this->confidential_nodes = $var;

        return $this;
    }

    /**
     * Configuration for Identity Service component.
     *
     * Generated from protobuf field <code>.google.container.v1.IdentityServiceConfig identity_service_config = 54;</code>
     * @return \Google\Cloud\Container\V1\IdentityServiceConfig|null
     */
    public function getIdentityServiceConfig()
    {
        return $this->identity_service_config;
    }

    public function hasIdentityServiceConfig()
    {
        return isset($this->identity_service_config);
    }

    public function clearIdentityServiceConfig()
    {
        unset($this->identity_service_config);
    }

    /**
     * Configuration for Identity Service component.
     *
     * Generated from protobuf field <code>.google.container.v1.IdentityServiceConfig identity_service_config = 54;</code>
     * @param \Google\Cloud\Container\V1\IdentityServiceConfig $var
     * @return $this
     */
    public function setIdentityServiceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\IdentityServiceConfig::class);
        $this->identity_service_config = $var;

        return $this;
    }

    /**
     * [Output only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 100;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return $this->self_link;
    }

    /**
     * [Output only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 100;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * [Output only] The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field is deprecated, use location instead.
     *
     * Generated from protobuf field <code>string zone = 101 [deprecated = true];</code>
     * @return string
     * @deprecated
     */
    public function getZone()
    {
        @trigger_error('zone is deprecated.', E_USER_DEPRECATED);
        return $this->zone;
    }

    /**
     * [Output only] The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field is deprecated, use location instead.
     *
     * Generated from protobuf field <code>string zone = 101 [deprecated = true];</code>
     * @param string $var
     * @return $this
     * @deprecated
     */
    public function setZone($var)
    {
        @trigger_error('zone is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkString($var, True);
        $this->zone = $var;

        return $this;
    }

    /**
     * [Output only] The IP address of this cluster's master endpoint.
     * The endpoint can be accessed from the internet at
     * `https://username:password&#64;endpoint/`.
     * See the `masterAuth` property of this resource for username and
     * password information.
     *
     * Generated from protobuf field <code>string endpoint = 102;</code>
     * @return string
     */
    public function getEndpoint()
    {
        return $this->endpoint;
    }

    /**
     * [Output only] The IP address of this cluster's master endpoint.
     * The endpoint can be accessed from the internet at
     * `https://username:password&#64;endpoint/`.
     * See the `masterAuth` property of this resource for username and
     * password information.
     *
     * Generated from protobuf field <code>string endpoint = 102;</code>
     * @param string $var
     * @return $this
     */
    public function setEndpoint($var)
    {
        GPBUtil::checkString($var, True);
        $this->endpoint = $var;

        return $this;
    }

    /**
     * The initial Kubernetes version for this cluster.  Valid versions are those
     * found in validMasterVersions returned by getServerConfig.  The version can
     * be upgraded over time; such upgrades are reflected in
     * currentMasterVersion and currentNodeVersion.
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "","-": picks the default Kubernetes version
     *
     * Generated from protobuf field <code>string initial_cluster_version = 103;</code>
     * @return string
     */
    public function getInitialClusterVersion()
    {
        return $this->initial_cluster_version;
    }

    /**
     * The initial Kubernetes version for this cluster.  Valid versions are those
     * found in validMasterVersions returned by getServerConfig.  The version can
     * be upgraded over time; such upgrades are reflected in
     * currentMasterVersion and currentNodeVersion.
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "","-": picks the default Kubernetes version
     *
     * Generated from protobuf field <code>string initial_cluster_version = 103;</code>
     * @param string $var
     * @return $this
     */
    public function setInitialClusterVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->initial_cluster_version = $var;

        return $this;
    }

    /**
     * [Output only] The current software version of the master endpoint.
     *
     * Generated from protobuf field <code>string current_master_version = 104;</code>
     * @return string
     */
    public function getCurrentMasterVersion()
    {
        return $this->current_master_version;
    }

    /**
     * [Output only] The current software version of the master endpoint.
     *
     * Generated from protobuf field <code>string current_master_version = 104;</code>
     * @param string $var
     * @return $this
     */
    public function setCurrentMasterVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->current_master_version = $var;

        return $this;
    }

    /**
     * [Output only] Deprecated, use
     * [NodePools.version](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools)
     * instead. The current version of the node software components. If they are
     * currently at multiple versions because they're in the process of being
     * upgraded, this reflects the minimum version of all nodes.
     *
     * Generated from protobuf field <code>string current_node_version = 105 [deprecated = true];</code>
     * @return string
     * @deprecated
     */
    public function getCurrentNodeVersion()
    {
        @trigger_error('current_node_version is deprecated.', E_USER_DEPRECATED);
        return $this->current_node_version;
    }

    /**
     * [Output only] Deprecated, use
     * [NodePools.version](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools)
     * instead. The current version of the node software components. If they are
     * currently at multiple versions because they're in the process of being
     * upgraded, this reflects the minimum version of all nodes.
     *
     * Generated from protobuf field <code>string current_node_version = 105 [deprecated = true];</code>
     * @param string $var
     * @return $this
     * @deprecated
     */
    public function setCurrentNodeVersion($var)
    {
        @trigger_error('current_node_version is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkString($var, True);
        $this->current_node_version = $var;

        return $this;
    }

    /**
     * [Output only] The time the cluster was created, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     *
     * Generated from protobuf field <code>string create_time = 106;</code>
     * @return string
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    /**
     * [Output only] The time the cluster was created, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     *
     * Generated from protobuf field <code>string create_time = 106;</code>
     * @param string $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkString($var, True);
        $this->create_time = $var;

        return $this;
    }

    /**
     * [Output only] The current status of this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.Cluster.Status status = 107;</code>
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * [Output only] The current status of this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.Cluster.Status status = 107;</code>
     * @param int $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Container\V1\Cluster\Status::class);
        $this->status = $var;

        return $this;
    }

    /**
     * [Output only] Deprecated. Use conditions instead.
     * Additional information about the current status of this
     * cluster, if available.
     *
     * Generated from protobuf field <code>string status_message = 108 [deprecated = true];</code>
     * @return string
     * @deprecated
     */
    public function getStatusMessage()
    {
        @trigger_error('status_message is deprecated.', E_USER_DEPRECATED);
        return $this->status_message;
    }

    /**
     * [Output only] Deprecated. Use conditions instead.
     * Additional information about the current status of this
     * cluster, if available.
     *
     * Generated from protobuf field <code>string status_message = 108 [deprecated = true];</code>
     * @param string $var
     * @return $this
     * @deprecated
     */
    public function setStatusMessage($var)
    {
        @trigger_error('status_message is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkString($var, True);
        $this->status_message = $var;

        return $this;
    }

    /**
     * [Output only] The size of the address space on each node for hosting
     * containers. This is provisioned from within the `container_ipv4_cidr`
     * range. This field will only be set when cluster is in route-based network
     * mode.
     *
     * Generated from protobuf field <code>int32 node_ipv4_cidr_size = 109;</code>
     * @return int
     */
    public function getNodeIpv4CidrSize()
    {
        return $this->node_ipv4_cidr_size;
    }

    /**
     * [Output only] The size of the address space on each node for hosting
     * containers. This is provisioned from within the `container_ipv4_cidr`
     * range. This field will only be set when cluster is in route-based network
     * mode.
     *
     * Generated from protobuf field <code>int32 node_ipv4_cidr_size = 109;</code>
     * @param int $var
     * @return $this
     */
    public function setNodeIpv4CidrSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->node_ipv4_cidr_size = $var;

        return $this;
    }

    /**
     * [Output only] The IP address range of the Kubernetes services in
     * this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `1.2.3.4/29`). Service addresses are
     * typically put in the last `/16` from the container CIDR.
     *
     * Generated from protobuf field <code>string services_ipv4_cidr = 110;</code>
     * @return string
     */
    public function getServicesIpv4Cidr()
    {
        return $this->services_ipv4_cidr;
    }

    /**
     * [Output only] The IP address range of the Kubernetes services in
     * this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `1.2.3.4/29`). Service addresses are
     * typically put in the last `/16` from the container CIDR.
     *
     * Generated from protobuf field <code>string services_ipv4_cidr = 110;</code>
     * @param string $var
     * @return $this
     */
    public function setServicesIpv4Cidr($var)
    {
        GPBUtil::checkString($var, True);
        $this->services_ipv4_cidr = $var;

        return $this;
    }

    /**
     * Deprecated. Use node_pools.instance_group_urls.
     *
     * Generated from protobuf field <code>repeated string instance_group_urls = 111 [deprecated = true];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     * @deprecated
     */
    public function getInstanceGroupUrls()
    {
        @trigger_error('instance_group_urls is deprecated.', E_USER_DEPRECATED);
        return $this->instance_group_urls;
    }

    /**
     * Deprecated. Use node_pools.instance_group_urls.
     *
     * Generated from protobuf field <code>repeated string instance_group_urls = 111 [deprecated = true];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     * @deprecated
     */
    public function setInstanceGroupUrls($var)
    {
        @trigger_error('instance_group_urls is deprecated.', E_USER_DEPRECATED);
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->instance_group_urls = $arr;

        return $this;
    }

    /**
     * [Output only]  The number of nodes currently in the cluster. Deprecated.
     * Call Kubernetes API directly to retrieve node information.
     *
     * Generated from protobuf field <code>int32 current_node_count = 112 [deprecated = true];</code>
     * @return int
     * @deprecated
     */
    public function getCurrentNodeCount()
    {
        @trigger_error('current_node_count is deprecated.', E_USER_DEPRECATED);
        return $this->current_node_count;
    }

    /**
     * [Output only]  The number of nodes currently in the cluster. Deprecated.
     * Call Kubernetes API directly to retrieve node information.
     *
     * Generated from protobuf field <code>int32 current_node_count = 112 [deprecated = true];</code>
     * @param int $var
     * @return $this
     * @deprecated
     */
    public function setCurrentNodeCount($var)
    {
        @trigger_error('current_node_count is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkInt32($var);
        $this->current_node_count = $var;

        return $this;
    }

    /**
     * [Output only] The time the cluster will be automatically
     * deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     *
     * Generated from protobuf field <code>string expire_time = 113;</code>
     * @return string
     */
    public function getExpireTime()
    {
        return $this->expire_time;
    }

    /**
     * [Output only] The time the cluster will be automatically
     * deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     *
     * Generated from protobuf field <code>string expire_time = 113;</code>
     * @param string $var
     * @return $this
     */
    public function setExpireTime($var)
    {
        GPBUtil::checkString($var, True);
        $this->expire_time = $var;

        return $this;
    }

    /**
     * [Output only] The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * or
     * [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * in which the cluster resides.
     *
     * Generated from protobuf field <code>string location = 114;</code>
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * [Output only] The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * or
     * [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * in which the cluster resides.
     *
     * Generated from protobuf field <code>string location = 114;</code>
     * @param string $var
     * @return $this
     */
    public function setLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->location = $var;

        return $this;
    }

    /**
     * Enable the ability to use Cloud TPUs in this cluster.
     *
     * Generated from protobuf field <code>bool enable_tpu = 115;</code>
     * @return bool
     */
    public function getEnableTpu()
    {
        return $this->enable_tpu;
    }

    /**
     * Enable the ability to use Cloud TPUs in this cluster.
     *
     * Generated from protobuf field <code>bool enable_tpu = 115;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableTpu($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_tpu = $var;

        return $this;
    }

    /**
     * [Output only] The IP address range of the Cloud TPUs in this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `1.2.3.4/29`).
     *
     * Generated from protobuf field <code>string tpu_ipv4_cidr_block = 116;</code>
     * @return string
     */
    public function getTpuIpv4CidrBlock()
    {
        return $this->tpu_ipv4_cidr_block;
    }

    /**
     * [Output only] The IP address range of the Cloud TPUs in this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `1.2.3.4/29`).
     *
     * Generated from protobuf field <code>string tpu_ipv4_cidr_block = 116;</code>
     * @param string $var
     * @return $this
     */
    public function setTpuIpv4CidrBlock($var)
    {
        GPBUtil::checkString($var, True);
        $this->tpu_ipv4_cidr_block = $var;

        return $this;
    }

    /**
     * Which conditions caused the current cluster state.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getConditions()
    {
        return $this->conditions;
    }

    /**
     * Which conditions caused the current cluster state.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     * @param array<\Google\Cloud\Container\V1\StatusCondition>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setConditions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Container\V1\StatusCondition::class);
        $this->conditions = $arr;

        return $this;
    }

    /**
     * Autopilot configuration for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.Autopilot autopilot = 128;</code>
     * @return \Google\Cloud\Container\V1\Autopilot|null
     */
    public function getAutopilot()
    {
        return $this->autopilot;
    }

    public function hasAutopilot()
    {
        return isset($this->autopilot);
    }

    public function clearAutopilot()
    {
        unset($this->autopilot);
    }

    /**
     * Autopilot configuration for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.Autopilot autopilot = 128;</code>
     * @param \Google\Cloud\Container\V1\Autopilot $var
     * @return $this
     */
    public function setAutopilot($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\Autopilot::class);
        $this->autopilot = $var;

        return $this;
    }

    /**
     * Output only. Unique id for the cluster.
     *
     * Generated from protobuf field <code>string id = 129 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Output only. Unique id for the cluster.
     *
     * Generated from protobuf field <code>string id = 129 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * Default NodePool settings for the entire cluster. These settings are
     * overridden if specified on the specific NodePool object.
     *
     * Generated from protobuf field <code>optional .google.container.v1.NodePoolDefaults node_pool_defaults = 131;</code>
     * @return \Google\Cloud\Container\V1\NodePoolDefaults|null
     */
    public function getNodePoolDefaults()
    {
        return $this->node_pool_defaults;
    }

    public function hasNodePoolDefaults()
    {
        return isset($this->node_pool_defaults);
    }

    public function clearNodePoolDefaults()
    {
        unset($this->node_pool_defaults);
    }

    /**
     * Default NodePool settings for the entire cluster. These settings are
     * overridden if specified on the specific NodePool object.
     *
     * Generated from protobuf field <code>optional .google.container.v1.NodePoolDefaults node_pool_defaults = 131;</code>
     * @param \Google\Cloud\Container\V1\NodePoolDefaults $var
     * @return $this
     */
    public function setNodePoolDefaults($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\NodePoolDefaults::class);
        $this->node_pool_defaults = $var;

        return $this;
    }

    /**
     * Logging configuration for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.LoggingConfig logging_config = 132;</code>
     * @return \Google\Cloud\Container\V1\LoggingConfig|null
     */
    public function getLoggingConfig()
    {
        return $this->logging_config;
    }

    public function hasLoggingConfig()
    {
        return isset($this->logging_config);
    }

    public function clearLoggingConfig()
    {
        unset($this->logging_config);
    }

    /**
     * Logging configuration for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.LoggingConfig logging_config = 132;</code>
     * @param \Google\Cloud\Container\V1\LoggingConfig $var
     * @return $this
     */
    public function setLoggingConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\LoggingConfig::class);
        $this->logging_config = $var;

        return $this;
    }

    /**
     * Monitoring configuration for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.MonitoringConfig monitoring_config = 133;</code>
     * @return \Google\Cloud\Container\V1\MonitoringConfig|null
     */
    public function getMonitoringConfig()
    {
        return $this->monitoring_config;
    }

    public function hasMonitoringConfig()
    {
        return isset($this->monitoring_config);
    }

    public function clearMonitoringConfig()
    {
        unset($this->monitoring_config);
    }

    /**
     * Monitoring configuration for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.MonitoringConfig monitoring_config = 133;</code>
     * @param \Google\Cloud\Container\V1\MonitoringConfig $var
     * @return $this
     */
    public function setMonitoringConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\MonitoringConfig::class);
        $this->monitoring_config = $var;

        return $this;
    }

    /**
     * Node pool configs that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     *
     * Generated from protobuf field <code>.google.container.v1.NodePoolAutoConfig node_pool_auto_config = 136;</code>
     * @return \Google\Cloud\Container\V1\NodePoolAutoConfig|null
     */
    public function getNodePoolAutoConfig()
    {
        return $this->node_pool_auto_config;
    }

    public function hasNodePoolAutoConfig()
    {
        return isset($this->node_pool_auto_config);
    }

    public function clearNodePoolAutoConfig()
    {
        unset($this->node_pool_auto_config);
    }

    /**
     * Node pool configs that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     *
     * Generated from protobuf field <code>.google.container.v1.NodePoolAutoConfig node_pool_auto_config = 136;</code>
     * @param \Google\Cloud\Container\V1\NodePoolAutoConfig $var
     * @return $this
     */
    public function setNodePoolAutoConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\NodePoolAutoConfig::class);
        $this->node_pool_auto_config = $var;

        return $this;
    }

    /**
     * This checksum is computed by the server based on the value of cluster
     * fields, and may be sent on update requests to ensure the client has an
     * up-to-date value before proceeding.
     *
     * Generated from protobuf field <code>string etag = 139;</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * This checksum is computed by the server based on the value of cluster
     * fields, and may be sent on update requests to ensure the client has an
     * up-to-date value before proceeding.
     *
     * Generated from protobuf field <code>string etag = 139;</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

}

