<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/accounts/v1/programs.proto

namespace Google\Shopping\Merchant\Accounts\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Defines participation in a given program for the specified account.
 * Programs provide a mechanism for adding functionality to a Merchant Center
 * accounts. A typical example of this is the [Free product
 * listings](https://support.google.com/merchants/answer/13889434)
 * program, which enables products from a business's store to be shown across
 * Google for free.
 * The following list is the available set of program resource IDs accessible
 * through the API:
 * * `free-listings`
 * * `shopping-ads`
 * * `youtube-shopping-checkout`
 *
 * Generated from protobuf message <code>google.shopping.merchant.accounts.v1.Program</code>
 */
class Program extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name of the program.
     * Format: `accounts/{account}/programs/{program}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. The URL of a Merchant Center help page describing the program.
     *
     * Generated from protobuf field <code>string documentation_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $documentation_uri = '';
    /**
     * Output only. The participation state of the account in the program.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.Program.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. The regions in which the account is actively participating in
     * the program. Active regions are defined as those where all program
     * requirements affecting the regions have been met.
     * Region codes are defined by [CLDR](https://cldr.unicode.org/). This is
     * either a country where the program applies specifically to that country or
     * `001` when the program applies globally.
     *
     * Generated from protobuf field <code>repeated string active_region_codes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $active_region_codes;
    /**
     * Output only. The requirements that the account has not yet satisfied that
     * are affecting participation in the program.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.accounts.v1.Program.Requirement unmet_requirements = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $unmet_requirements;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The resource name of the program.
     *           Format: `accounts/{account}/programs/{program}`
     *     @type string $documentation_uri
     *           Output only. The URL of a Merchant Center help page describing the program.
     *     @type int $state
     *           Output only. The participation state of the account in the program.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $active_region_codes
     *           Output only. The regions in which the account is actively participating in
     *           the program. Active regions are defined as those where all program
     *           requirements affecting the regions have been met.
     *           Region codes are defined by [CLDR](https://cldr.unicode.org/). This is
     *           either a country where the program applies specifically to that country or
     *           `001` when the program applies globally.
     *     @type array<\Google\Shopping\Merchant\Accounts\V1\Program\Requirement>|\Google\Protobuf\Internal\RepeatedField $unmet_requirements
     *           Output only. The requirements that the account has not yet satisfied that
     *           are affecting participation in the program.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Accounts\V1\Programs::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The resource name of the program.
     * Format: `accounts/{account}/programs/{program}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name of the program.
     * Format: `accounts/{account}/programs/{program}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The URL of a Merchant Center help page describing the program.
     *
     * Generated from protobuf field <code>string documentation_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getDocumentationUri()
    {
        return $this->documentation_uri;
    }

    /**
     * Output only. The URL of a Merchant Center help page describing the program.
     *
     * Generated from protobuf field <code>string documentation_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setDocumentationUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->documentation_uri = $var;

        return $this;
    }

    /**
     * Output only. The participation state of the account in the program.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.Program.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The participation state of the account in the program.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.Program.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Accounts\V1\Program\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The regions in which the account is actively participating in
     * the program. Active regions are defined as those where all program
     * requirements affecting the regions have been met.
     * Region codes are defined by [CLDR](https://cldr.unicode.org/). This is
     * either a country where the program applies specifically to that country or
     * `001` when the program applies globally.
     *
     * Generated from protobuf field <code>repeated string active_region_codes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getActiveRegionCodes()
    {
        return $this->active_region_codes;
    }

    /**
     * Output only. The regions in which the account is actively participating in
     * the program. Active regions are defined as those where all program
     * requirements affecting the regions have been met.
     * Region codes are defined by [CLDR](https://cldr.unicode.org/). This is
     * either a country where the program applies specifically to that country or
     * `001` when the program applies globally.
     *
     * Generated from protobuf field <code>repeated string active_region_codes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setActiveRegionCodes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->active_region_codes = $arr;

        return $this;
    }

    /**
     * Output only. The requirements that the account has not yet satisfied that
     * are affecting participation in the program.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.accounts.v1.Program.Requirement unmet_requirements = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getUnmetRequirements()
    {
        return $this->unmet_requirements;
    }

    /**
     * Output only. The requirements that the account has not yet satisfied that
     * are affecting participation in the program.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.accounts.v1.Program.Requirement unmet_requirements = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Shopping\Merchant\Accounts\V1\Program\Requirement>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setUnmetRequirements($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Shopping\Merchant\Accounts\V1\Program\Requirement::class);
        $this->unmet_requirements = $arr;

        return $this;
    }

}

