<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/run/v2/worker_pool.proto

namespace Google\Cloud\Run\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for creating a WorkerPool.
 *
 * Generated from protobuf message <code>google.cloud.run.v2.CreateWorkerPoolRequest</code>
 */
class CreateWorkerPoolRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The location and project in which this worker pool should be
     * created. Format: `projects/{project}/locations/{location}`, where
     * `{project}` can be project id or number. Only lowercase characters, digits,
     * and hyphens.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. The WorkerPool instance to create.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.WorkerPool worker_pool = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $worker_pool = null;
    /**
     * Required. The unique identifier for the WorkerPool. It must begin with
     * letter, and cannot end with hyphen; must contain fewer than 50 characters.
     * The name of the worker pool becomes
     * `{parent}/workerPools/{worker_pool_id}`.
     *
     * Generated from protobuf field <code>string worker_pool_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $worker_pool_id = '';
    /**
     * Optional. Indicates that the request should be validated and default values
     * populated, without persisting the request or creating any resources.
     *
     * Generated from protobuf field <code>bool validate_only = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $validate_only = false;

    /**
     * @param string                          $parent       Required. The location and project in which this worker pool should be
     *                                                      created. Format: `projects/{project}/locations/{location}`, where
     *                                                      `{project}` can be project id or number. Only lowercase characters, digits,
     *                                                      and hyphens. Please see
     *                                                      {@see WorkerPoolsClient::locationName()} for help formatting this field.
     * @param \Google\Cloud\Run\V2\WorkerPool $workerPool   Required. The WorkerPool instance to create.
     * @param string                          $workerPoolId Required. The unique identifier for the WorkerPool. It must begin with
     *                                                      letter, and cannot end with hyphen; must contain fewer than 50 characters.
     *                                                      The name of the worker pool becomes
     *                                                      `{parent}/workerPools/{worker_pool_id}`.
     *
     * @return \Google\Cloud\Run\V2\CreateWorkerPoolRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\Run\V2\WorkerPool $workerPool, string $workerPoolId): self
    {
        return (new self())
            ->setParent($parent)
            ->setWorkerPool($workerPool)
            ->setWorkerPoolId($workerPoolId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The location and project in which this worker pool should be
     *           created. Format: `projects/{project}/locations/{location}`, where
     *           `{project}` can be project id or number. Only lowercase characters, digits,
     *           and hyphens.
     *     @type \Google\Cloud\Run\V2\WorkerPool $worker_pool
     *           Required. The WorkerPool instance to create.
     *     @type string $worker_pool_id
     *           Required. The unique identifier for the WorkerPool. It must begin with
     *           letter, and cannot end with hyphen; must contain fewer than 50 characters.
     *           The name of the worker pool becomes
     *           `{parent}/workerPools/{worker_pool_id}`.
     *     @type bool $validate_only
     *           Optional. Indicates that the request should be validated and default values
     *           populated, without persisting the request or creating any resources.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Run\V2\WorkerPool::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The location and project in which this worker pool should be
     * created. Format: `projects/{project}/locations/{location}`, where
     * `{project}` can be project id or number. Only lowercase characters, digits,
     * and hyphens.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The location and project in which this worker pool should be
     * created. Format: `projects/{project}/locations/{location}`, where
     * `{project}` can be project id or number. Only lowercase characters, digits,
     * and hyphens.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The WorkerPool instance to create.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.WorkerPool worker_pool = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Run\V2\WorkerPool|null
     */
    public function getWorkerPool()
    {
        return $this->worker_pool;
    }

    public function hasWorkerPool()
    {
        return isset($this->worker_pool);
    }

    public function clearWorkerPool()
    {
        unset($this->worker_pool);
    }

    /**
     * Required. The WorkerPool instance to create.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.WorkerPool worker_pool = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Run\V2\WorkerPool $var
     * @return $this
     */
    public function setWorkerPool($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\WorkerPool::class);
        $this->worker_pool = $var;

        return $this;
    }

    /**
     * Required. The unique identifier for the WorkerPool. It must begin with
     * letter, and cannot end with hyphen; must contain fewer than 50 characters.
     * The name of the worker pool becomes
     * `{parent}/workerPools/{worker_pool_id}`.
     *
     * Generated from protobuf field <code>string worker_pool_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getWorkerPoolId()
    {
        return $this->worker_pool_id;
    }

    /**
     * Required. The unique identifier for the WorkerPool. It must begin with
     * letter, and cannot end with hyphen; must contain fewer than 50 characters.
     * The name of the worker pool becomes
     * `{parent}/workerPools/{worker_pool_id}`.
     *
     * Generated from protobuf field <code>string worker_pool_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setWorkerPoolId($var)
    {
        GPBUtil::checkString($var, True);
        $this->worker_pool_id = $var;

        return $this;
    }

    /**
     * Optional. Indicates that the request should be validated and default values
     * populated, without persisting the request or creating any resources.
     *
     * Generated from protobuf field <code>bool validate_only = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getValidateOnly()
    {
        return $this->validate_only;
    }

    /**
     * Optional. Indicates that the request should be validated and default values
     * populated, without persisting the request or creating any resources.
     *
     * Generated from protobuf field <code>bool validate_only = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setValidateOnly($var)
    {
        GPBUtil::checkBool($var);
        $this->validate_only = $var;

        return $this;
    }

}

