<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/networkconnectivity/v1/cross_network_automation.proto

namespace Google\Cloud\NetworkConnectivity\V1\ServiceConnectionMap;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Allow the producer to specify which consumers can connect to it.
 *
 * Generated from protobuf message <code>google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConfig</code>
 */
class ConsumerPscConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * The consumer project where PSC connections are allowed to be created in.
     *
     * Generated from protobuf field <code>string project = 1;</code>
     */
    protected $project = '';
    /**
     * The resource path of the consumer network where PSC connections are
     * allowed to be created in. Note, this network does not need be in the
     * ConsumerPscConfig.project in the case of SharedVPC.
     * Example:
     * projects/{projectNumOrId}/global/networks/{networkId}.
     *
     * Generated from protobuf field <code>string network = 2 [(.google.api.resource_reference) = {</code>
     */
    protected $network = '';
    /**
     * This is used in PSC consumer ForwardingRule to control whether the PSC
     * endpoint can be accessed from another region.
     *
     * Generated from protobuf field <code>bool disable_global_access = 3;</code>
     */
    protected $disable_global_access = false;
    /**
     * Output only. Overall state of PSC Connections management for this
     * consumer psc config.
     *
     * Generated from protobuf field <code>.google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConfig.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Immutable. Deprecated. Use producer_instance_metadata instead.
     * An immutable identifier for the producer instance.
     *
     * Generated from protobuf field <code>string producer_instance_id = 5 [deprecated = true, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @deprecated
     */
    protected $producer_instance_id = '';
    /**
     * Output only. A map to store mapping between customer vip and target
     * service attachment. Only service attachment with producer specified ip
     * addresses are stored here.
     *
     * Generated from protobuf field <code>map<string, string> service_attachment_ip_address_map = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $service_attachment_ip_address_map;
    /**
     * Required. The project ID or project number of the consumer project. This
     * project is the one that the consumer uses to interact with the producer
     * instance. From the perspective of a consumer who's created a producer
     * instance, this is the project of the producer instance. Format:
     * 'projects/<project_id_or_number>' Eg. 'projects/consumer-project' or
     * 'projects/1234'
     *
     * Generated from protobuf field <code>string consumer_instance_project = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $consumer_instance_project = '';
    /**
     * Immutable. An immutable map for the producer instance metadata.
     *
     * Generated from protobuf field <code>map<string, string> producer_instance_metadata = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $producer_instance_metadata;
    /**
     * The requested IP version for the PSC connection.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkconnectivity.v1.IPVersion ip_version = 9;</code>
     */
    protected $ip_version = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $project
     *           The consumer project where PSC connections are allowed to be created in.
     *     @type string $network
     *           The resource path of the consumer network where PSC connections are
     *           allowed to be created in. Note, this network does not need be in the
     *           ConsumerPscConfig.project in the case of SharedVPC.
     *           Example:
     *           projects/{projectNumOrId}/global/networks/{networkId}.
     *     @type bool $disable_global_access
     *           This is used in PSC consumer ForwardingRule to control whether the PSC
     *           endpoint can be accessed from another region.
     *     @type int $state
     *           Output only. Overall state of PSC Connections management for this
     *           consumer psc config.
     *     @type string $producer_instance_id
     *           Immutable. Deprecated. Use producer_instance_metadata instead.
     *           An immutable identifier for the producer instance.
     *     @type array|\Google\Protobuf\Internal\MapField $service_attachment_ip_address_map
     *           Output only. A map to store mapping between customer vip and target
     *           service attachment. Only service attachment with producer specified ip
     *           addresses are stored here.
     *     @type string $consumer_instance_project
     *           Required. The project ID or project number of the consumer project. This
     *           project is the one that the consumer uses to interact with the producer
     *           instance. From the perspective of a consumer who's created a producer
     *           instance, this is the project of the producer instance. Format:
     *           'projects/<project_id_or_number>' Eg. 'projects/consumer-project' or
     *           'projects/1234'
     *     @type array|\Google\Protobuf\Internal\MapField $producer_instance_metadata
     *           Immutable. An immutable map for the producer instance metadata.
     *     @type int $ip_version
     *           The requested IP version for the PSC connection.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Networkconnectivity\V1\CrossNetworkAutomation::initOnce();
        parent::__construct($data);
    }

    /**
     * The consumer project where PSC connections are allowed to be created in.
     *
     * Generated from protobuf field <code>string project = 1;</code>
     * @return string
     */
    public function getProject()
    {
        return $this->project;
    }

    /**
     * The consumer project where PSC connections are allowed to be created in.
     *
     * Generated from protobuf field <code>string project = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setProject($var)
    {
        GPBUtil::checkString($var, True);
        $this->project = $var;

        return $this;
    }

    /**
     * The resource path of the consumer network where PSC connections are
     * allowed to be created in. Note, this network does not need be in the
     * ConsumerPscConfig.project in the case of SharedVPC.
     * Example:
     * projects/{projectNumOrId}/global/networks/{networkId}.
     *
     * Generated from protobuf field <code>string network = 2 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * The resource path of the consumer network where PSC connections are
     * allowed to be created in. Note, this network does not need be in the
     * ConsumerPscConfig.project in the case of SharedVPC.
     * Example:
     * projects/{projectNumOrId}/global/networks/{networkId}.
     *
     * Generated from protobuf field <code>string network = 2 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * This is used in PSC consumer ForwardingRule to control whether the PSC
     * endpoint can be accessed from another region.
     *
     * Generated from protobuf field <code>bool disable_global_access = 3;</code>
     * @return bool
     */
    public function getDisableGlobalAccess()
    {
        return $this->disable_global_access;
    }

    /**
     * This is used in PSC consumer ForwardingRule to control whether the PSC
     * endpoint can be accessed from another region.
     *
     * Generated from protobuf field <code>bool disable_global_access = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setDisableGlobalAccess($var)
    {
        GPBUtil::checkBool($var);
        $this->disable_global_access = $var;

        return $this;
    }

    /**
     * Output only. Overall state of PSC Connections management for this
     * consumer psc config.
     *
     * Generated from protobuf field <code>.google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConfig.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. Overall state of PSC Connections management for this
     * consumer psc config.
     *
     * Generated from protobuf field <code>.google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConfig.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkConnectivity\V1\ServiceConnectionMap\ConsumerPscConfig\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Immutable. Deprecated. Use producer_instance_metadata instead.
     * An immutable identifier for the producer instance.
     *
     * Generated from protobuf field <code>string producer_instance_id = 5 [deprecated = true, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     * @deprecated
     */
    public function getProducerInstanceId()
    {
        if ($this->producer_instance_id !== '') {
            @trigger_error('producer_instance_id is deprecated.', E_USER_DEPRECATED);
        }
        return $this->producer_instance_id;
    }

    /**
     * Immutable. Deprecated. Use producer_instance_metadata instead.
     * An immutable identifier for the producer instance.
     *
     * Generated from protobuf field <code>string producer_instance_id = 5 [deprecated = true, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     * @deprecated
     */
    public function setProducerInstanceId($var)
    {
        @trigger_error('producer_instance_id is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkString($var, True);
        $this->producer_instance_id = $var;

        return $this;
    }

    /**
     * Output only. A map to store mapping between customer vip and target
     * service attachment. Only service attachment with producer specified ip
     * addresses are stored here.
     *
     * Generated from protobuf field <code>map<string, string> service_attachment_ip_address_map = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getServiceAttachmentIpAddressMap()
    {
        return $this->service_attachment_ip_address_map;
    }

    /**
     * Output only. A map to store mapping between customer vip and target
     * service attachment. Only service attachment with producer specified ip
     * addresses are stored here.
     *
     * Generated from protobuf field <code>map<string, string> service_attachment_ip_address_map = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setServiceAttachmentIpAddressMap($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->service_attachment_ip_address_map = $arr;

        return $this;
    }

    /**
     * Required. The project ID or project number of the consumer project. This
     * project is the one that the consumer uses to interact with the producer
     * instance. From the perspective of a consumer who's created a producer
     * instance, this is the project of the producer instance. Format:
     * 'projects/<project_id_or_number>' Eg. 'projects/consumer-project' or
     * 'projects/1234'
     *
     * Generated from protobuf field <code>string consumer_instance_project = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getConsumerInstanceProject()
    {
        return $this->consumer_instance_project;
    }

    /**
     * Required. The project ID or project number of the consumer project. This
     * project is the one that the consumer uses to interact with the producer
     * instance. From the perspective of a consumer who's created a producer
     * instance, this is the project of the producer instance. Format:
     * 'projects/<project_id_or_number>' Eg. 'projects/consumer-project' or
     * 'projects/1234'
     *
     * Generated from protobuf field <code>string consumer_instance_project = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setConsumerInstanceProject($var)
    {
        GPBUtil::checkString($var, True);
        $this->consumer_instance_project = $var;

        return $this;
    }

    /**
     * Immutable. An immutable map for the producer instance metadata.
     *
     * Generated from protobuf field <code>map<string, string> producer_instance_metadata = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getProducerInstanceMetadata()
    {
        return $this->producer_instance_metadata;
    }

    /**
     * Immutable. An immutable map for the producer instance metadata.
     *
     * Generated from protobuf field <code>map<string, string> producer_instance_metadata = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setProducerInstanceMetadata($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->producer_instance_metadata = $arr;

        return $this;
    }

    /**
     * The requested IP version for the PSC connection.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkconnectivity.v1.IPVersion ip_version = 9;</code>
     * @return int
     */
    public function getIpVersion()
    {
        return isset($this->ip_version) ? $this->ip_version : 0;
    }

    public function hasIpVersion()
    {
        return isset($this->ip_version);
    }

    public function clearIpVersion()
    {
        unset($this->ip_version);
    }

    /**
     * The requested IP version for the PSC connection.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkconnectivity.v1.IPVersion ip_version = 9;</code>
     * @param int $var
     * @return $this
     */
    public function setIpVersion($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkConnectivity\V1\IPVersion::class);
        $this->ip_version = $var;

        return $this;
    }

}


