<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/bigquery/reservation/v1/reservation.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\BigQuery\Reservation\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\BigQuery\Reservation\V1\Assignment;
use Google\Cloud\BigQuery\Reservation\V1\BiReservation;
use Google\Cloud\BigQuery\Reservation\V1\CapacityCommitment;
use Google\Cloud\BigQuery\Reservation\V1\CreateAssignmentRequest;
use Google\Cloud\BigQuery\Reservation\V1\CreateCapacityCommitmentRequest;
use Google\Cloud\BigQuery\Reservation\V1\CreateReservationRequest;
use Google\Cloud\BigQuery\Reservation\V1\DeleteAssignmentRequest;
use Google\Cloud\BigQuery\Reservation\V1\DeleteCapacityCommitmentRequest;
use Google\Cloud\BigQuery\Reservation\V1\DeleteReservationRequest;
use Google\Cloud\BigQuery\Reservation\V1\FailoverReservationRequest;
use Google\Cloud\BigQuery\Reservation\V1\GetBiReservationRequest;
use Google\Cloud\BigQuery\Reservation\V1\GetCapacityCommitmentRequest;
use Google\Cloud\BigQuery\Reservation\V1\GetReservationRequest;
use Google\Cloud\BigQuery\Reservation\V1\ListAssignmentsRequest;
use Google\Cloud\BigQuery\Reservation\V1\ListCapacityCommitmentsRequest;
use Google\Cloud\BigQuery\Reservation\V1\ListReservationsRequest;
use Google\Cloud\BigQuery\Reservation\V1\MergeCapacityCommitmentsRequest;
use Google\Cloud\BigQuery\Reservation\V1\MoveAssignmentRequest;
use Google\Cloud\BigQuery\Reservation\V1\Reservation;
use Google\Cloud\BigQuery\Reservation\V1\SearchAllAssignmentsRequest;
use Google\Cloud\BigQuery\Reservation\V1\SearchAssignmentsRequest;
use Google\Cloud\BigQuery\Reservation\V1\SplitCapacityCommitmentRequest;
use Google\Cloud\BigQuery\Reservation\V1\SplitCapacityCommitmentResponse;
use Google\Cloud\BigQuery\Reservation\V1\UpdateAssignmentRequest;
use Google\Cloud\BigQuery\Reservation\V1\UpdateBiReservationRequest;
use Google\Cloud\BigQuery\Reservation\V1\UpdateCapacityCommitmentRequest;
use Google\Cloud\BigQuery\Reservation\V1\UpdateReservationRequest;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: This API allows users to manage their BigQuery reservations.
 *
 * A reservation provides computational resource guarantees, in the form of
 * [slots](https://cloud.google.com/bigquery/docs/slots), to users. A slot is a
 * unit of computational power in BigQuery, and serves as the basic unit of
 * parallelism. In a scan of a multi-partitioned table, a single slot operates
 * on a single partition of the table. A reservation resource exists as a child
 * resource of the admin project and location, e.g.:
 * `projects/myproject/locations/US/reservations/reservationName`.
 *
 * A capacity commitment is a way to purchase compute capacity for BigQuery jobs
 * (in the form of slots) with some committed period of usage. A capacity
 * commitment resource exists as a child resource of the admin project and
 * location, e.g.:
 * `projects/myproject/locations/US/capacityCommitments/id`.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<Assignment> createAssignmentAsync(CreateAssignmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CapacityCommitment> createCapacityCommitmentAsync(CreateCapacityCommitmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Reservation> createReservationAsync(CreateReservationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteAssignmentAsync(DeleteAssignmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteCapacityCommitmentAsync(DeleteCapacityCommitmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteReservationAsync(DeleteReservationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Reservation> failoverReservationAsync(FailoverReservationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BiReservation> getBiReservationAsync(GetBiReservationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CapacityCommitment> getCapacityCommitmentAsync(GetCapacityCommitmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Reservation> getReservationAsync(GetReservationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAssignmentsAsync(ListAssignmentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listCapacityCommitmentsAsync(ListCapacityCommitmentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listReservationsAsync(ListReservationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CapacityCommitment> mergeCapacityCommitmentsAsync(MergeCapacityCommitmentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Assignment> moveAssignmentAsync(MoveAssignmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> searchAllAssignmentsAsync(SearchAllAssignmentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> searchAssignmentsAsync(SearchAssignmentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SplitCapacityCommitmentResponse> splitCapacityCommitmentAsync(SplitCapacityCommitmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Assignment> updateAssignmentAsync(UpdateAssignmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BiReservation> updateBiReservationAsync(UpdateBiReservationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CapacityCommitment> updateCapacityCommitmentAsync(UpdateCapacityCommitmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Reservation> updateReservationAsync(UpdateReservationRequest $request, array $optionalArgs = [])
 */
final class ReservationServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.bigquery.reservation.v1.ReservationService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'bigqueryreservation.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'bigqueryreservation.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/bigquery',
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/reservation_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/reservation_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/reservation_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/reservation_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a assignment
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $reservation
     * @param string $assignment
     *
     * @return string The formatted assignment resource.
     */
    public static function assignmentName(string $project, string $location, string $reservation, string $assignment): string
    {
        return self::getPathTemplate('assignment')->render([
            'project' => $project,
            'location' => $location,
            'reservation' => $reservation,
            'assignment' => $assignment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * bi_reservation resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted bi_reservation resource.
     */
    public static function biReservationName(string $project, string $location): string
    {
        return self::getPathTemplate('biReservation')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * capacity_commitment resource.
     *
     * @param string $project
     * @param string $location
     * @param string $capacityCommitment
     *
     * @return string The formatted capacity_commitment resource.
     */
    public static function capacityCommitmentName(string $project, string $location, string $capacityCommitment): string
    {
        return self::getPathTemplate('capacityCommitment')->render([
            'project' => $project,
            'location' => $location,
            'capacity_commitment' => $capacityCommitment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a reservation
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $reservation
     *
     * @return string The formatted reservation resource.
     */
    public static function reservationName(string $project, string $location, string $reservation): string
    {
        return self::getPathTemplate('reservation')->render([
            'project' => $project,
            'location' => $location,
            'reservation' => $reservation,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - assignment: projects/{project}/locations/{location}/reservations/{reservation}/assignments/{assignment}
     * - biReservation: projects/{project}/locations/{location}/biReservation
     * - capacityCommitment: projects/{project}/locations/{location}/capacityCommitments/{capacity_commitment}
     * - location: projects/{project}/locations/{location}
     * - reservation: projects/{project}/locations/{location}/reservations/{reservation}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'bigqueryreservation.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\BigQuery\Reservation\V1\ReservationServiceClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new ReservationServiceClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates an assignment object which allows the given project to submit jobs
     * of a certain type using slots from the specified reservation.
     *
     * Currently a
     * resource (project, folder, organization) can only have one assignment per
     * each (job_type, location) combination, and that reservation will be used
     * for all jobs of the matching type.
     *
     * Different assignments can be created on different levels of the
     * projects, folders or organization hierarchy.  During query execution,
     * the assignment is looked up at the project, folder and organization levels
     * in that order. The first assignment found is applied to the query.
     *
     * When creating assignments, it does not matter if other assignments exist at
     * higher levels.
     *
     * Example:
     *
     * * The organization `organizationA` contains two projects, `project1`
     * and `project2`.
     * * Assignments for all three entities (`organizationA`, `project1`, and
     * `project2`) could all be created and mapped to the same or different
     * reservations.
     *
     * "None" assignments represent an absence of the assignment. Projects
     * assigned to None use on-demand pricing. To create a "None" assignment, use
     * "none" as a reservation_id in the parent. Example parent:
     * `projects/myproject/locations/US/reservations/none`.
     *
     * Returns `google.rpc.Code.PERMISSION_DENIED` if user does not have
     * 'bigquery.admin' permissions on the project using the reservation
     * and the project that owns this reservation.
     *
     * Returns `google.rpc.Code.INVALID_ARGUMENT` when location of the assignment
     * does not match location of the reservation.
     *
     * The async variant is {@see ReservationServiceClient::createAssignmentAsync()} .
     *
     * @example samples/V1/ReservationServiceClient/create_assignment.php
     *
     * @param CreateAssignmentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Assignment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createAssignment(CreateAssignmentRequest $request, array $callOptions = []): Assignment
    {
        return $this->startApiCall('CreateAssignment', $request, $callOptions)->wait();
    }

    /**
     * Creates a new capacity commitment resource.
     *
     * The async variant is
     * {@see ReservationServiceClient::createCapacityCommitmentAsync()} .
     *
     * @example samples/V1/ReservationServiceClient/create_capacity_commitment.php
     *
     * @param CreateCapacityCommitmentRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CapacityCommitment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCapacityCommitment(CreateCapacityCommitmentRequest $request, array $callOptions = []): CapacityCommitment
    {
        return $this->startApiCall('CreateCapacityCommitment', $request, $callOptions)->wait();
    }

    /**
     * Creates a new reservation resource.
     *
     * The async variant is {@see ReservationServiceClient::createReservationAsync()} .
     *
     * @example samples/V1/ReservationServiceClient/create_reservation.php
     *
     * @param CreateReservationRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Reservation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createReservation(CreateReservationRequest $request, array $callOptions = []): Reservation
    {
        return $this->startApiCall('CreateReservation', $request, $callOptions)->wait();
    }

    /**
     * Deletes a assignment. No expansion will happen.
     *
     * Example:
     *
     * * Organization `organizationA` contains two projects, `project1` and
     * `project2`.
     * * Reservation `res1` exists and was created previously.
     * * CreateAssignment was used previously to define the following
     * associations between entities and reservations: `<organizationA, res1>`
     * and `<project1, res1>`
     *
     * In this example, deletion of the `<organizationA, res1>` assignment won't
     * affect the other assignment `<project1, res1>`. After said deletion,
     * queries from `project1` will still use `res1` while queries from
     * `project2` will switch to use on-demand mode.
     *
     * The async variant is {@see ReservationServiceClient::deleteAssignmentAsync()} .
     *
     * @example samples/V1/ReservationServiceClient/delete_assignment.php
     *
     * @param DeleteAssignmentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteAssignment(DeleteAssignmentRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteAssignment', $request, $callOptions)->wait();
    }

    /**
     * Deletes a capacity commitment. Attempting to delete capacity commitment
     * before its commitment_end_time will fail with the error code
     * `google.rpc.Code.FAILED_PRECONDITION`.
     *
     * The async variant is
     * {@see ReservationServiceClient::deleteCapacityCommitmentAsync()} .
     *
     * @example samples/V1/ReservationServiceClient/delete_capacity_commitment.php
     *
     * @param DeleteCapacityCommitmentRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteCapacityCommitment(DeleteCapacityCommitmentRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteCapacityCommitment', $request, $callOptions)->wait();
    }

    /**
     * Deletes a reservation.
     * Returns `google.rpc.Code.FAILED_PRECONDITION` when reservation has
     * assignments.
     *
     * The async variant is {@see ReservationServiceClient::deleteReservationAsync()} .
     *
     * @example samples/V1/ReservationServiceClient/delete_reservation.php
     *
     * @param DeleteReservationRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteReservation(DeleteReservationRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteReservation', $request, $callOptions)->wait();
    }

    /**
     * Fail over a reservation to the secondary location. The operation should be
     * done in the current secondary location, which will be promoted to the
     * new primary location for the reservation.
     * Attempting to failover a reservation in the current primary location will
     * fail with the error code `google.rpc.Code.FAILED_PRECONDITION`.
     *
     * The async variant is {@see ReservationServiceClient::failoverReservationAsync()}
     * .
     *
     * @example samples/V1/ReservationServiceClient/failover_reservation.php
     *
     * @param FailoverReservationRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Reservation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function failoverReservation(FailoverReservationRequest $request, array $callOptions = []): Reservation
    {
        return $this->startApiCall('FailoverReservation', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a BI reservation.
     *
     * The async variant is {@see ReservationServiceClient::getBiReservationAsync()} .
     *
     * @example samples/V1/ReservationServiceClient/get_bi_reservation.php
     *
     * @param GetBiReservationRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BiReservation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBiReservation(GetBiReservationRequest $request, array $callOptions = []): BiReservation
    {
        return $this->startApiCall('GetBiReservation', $request, $callOptions)->wait();
    }

    /**
     * Returns information about the capacity commitment.
     *
     * The async variant is
     * {@see ReservationServiceClient::getCapacityCommitmentAsync()} .
     *
     * @example samples/V1/ReservationServiceClient/get_capacity_commitment.php
     *
     * @param GetCapacityCommitmentRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CapacityCommitment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCapacityCommitment(GetCapacityCommitmentRequest $request, array $callOptions = []): CapacityCommitment
    {
        return $this->startApiCall('GetCapacityCommitment', $request, $callOptions)->wait();
    }

    /**
     * Returns information about the reservation.
     *
     * The async variant is {@see ReservationServiceClient::getReservationAsync()} .
     *
     * @example samples/V1/ReservationServiceClient/get_reservation.php
     *
     * @param GetReservationRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Reservation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getReservation(GetReservationRequest $request, array $callOptions = []): Reservation
    {
        return $this->startApiCall('GetReservation', $request, $callOptions)->wait();
    }

    /**
     * Lists assignments.
     *
     * Only explicitly created assignments will be returned.
     *
     * Example:
     *
     * * Organization `organizationA` contains two projects, `project1` and
     * `project2`.
     * * Reservation `res1` exists and was created previously.
     * * CreateAssignment was used previously to define the following
     * associations between entities and reservations: `<organizationA, res1>`
     * and `<project1, res1>`
     *
     * In this example, ListAssignments will just return the above two assignments
     * for reservation `res1`, and no expansion/merge will happen.
     *
     * The wildcard "-" can be used for
     * reservations in the request. In that case all assignments belongs to the
     * specified project and location will be listed.
     *
     * **Note** "-" cannot be used for projects nor locations.
     *
     * The async variant is {@see ReservationServiceClient::listAssignmentsAsync()} .
     *
     * @example samples/V1/ReservationServiceClient/list_assignments.php
     *
     * @param ListAssignmentsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAssignments(ListAssignmentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAssignments', $request, $callOptions);
    }

    /**
     * Lists all the capacity commitments for the admin project.
     *
     * The async variant is
     * {@see ReservationServiceClient::listCapacityCommitmentsAsync()} .
     *
     * @example samples/V1/ReservationServiceClient/list_capacity_commitments.php
     *
     * @param ListCapacityCommitmentsRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCapacityCommitments(ListCapacityCommitmentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCapacityCommitments', $request, $callOptions);
    }

    /**
     * Lists all the reservations for the project in the specified location.
     *
     * The async variant is {@see ReservationServiceClient::listReservationsAsync()} .
     *
     * @example samples/V1/ReservationServiceClient/list_reservations.php
     *
     * @param ListReservationsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listReservations(ListReservationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListReservations', $request, $callOptions);
    }

    /**
     * Merges capacity commitments of the same plan into a single commitment.
     *
     * The resulting capacity commitment has the greater commitment_end_time
     * out of the to-be-merged capacity commitments.
     *
     * Attempting to merge capacity commitments of different plan will fail
     * with the error code `google.rpc.Code.FAILED_PRECONDITION`.
     *
     * The async variant is
     * {@see ReservationServiceClient::mergeCapacityCommitmentsAsync()} .
     *
     * @example samples/V1/ReservationServiceClient/merge_capacity_commitments.php
     *
     * @param MergeCapacityCommitmentsRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CapacityCommitment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function mergeCapacityCommitments(MergeCapacityCommitmentsRequest $request, array $callOptions = []): CapacityCommitment
    {
        return $this->startApiCall('MergeCapacityCommitments', $request, $callOptions)->wait();
    }

    /**
     * Moves an assignment under a new reservation.
     *
     * This differs from removing an existing assignment and recreating a new one
     * by providing a transactional change that ensures an assignee always has an
     * associated reservation.
     *
     * The async variant is {@see ReservationServiceClient::moveAssignmentAsync()} .
     *
     * @example samples/V1/ReservationServiceClient/move_assignment.php
     *
     * @param MoveAssignmentRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Assignment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function moveAssignment(MoveAssignmentRequest $request, array $callOptions = []): Assignment
    {
        return $this->startApiCall('MoveAssignment', $request, $callOptions)->wait();
    }

    /**
     * Looks up assignments for a specified resource for a particular region.
     * If the request is about a project:
     *
     * 1. Assignments created on the project will be returned if they exist.
     * 2. Otherwise assignments created on the closest ancestor will be
     * returned.
     * 3. Assignments for different JobTypes will all be returned.
     *
     * The same logic applies if the request is about a folder.
     *
     * If the request is about an organization, then assignments created on the
     * organization will be returned (organization doesn't have ancestors).
     *
     * Comparing to ListAssignments, there are some behavior
     * differences:
     *
     * 1. permission on the assignee will be verified in this API.
     * 2. Hierarchy lookup (project->folder->organization) happens in this API.
     * 3. Parent here is `projects/&#42;/locations/*`, instead of
     * `projects/&#42;/locations/*reservations/*`.
     *
     * The async variant is
     * {@see ReservationServiceClient::searchAllAssignmentsAsync()} .
     *
     * @example samples/V1/ReservationServiceClient/search_all_assignments.php
     *
     * @param SearchAllAssignmentsRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function searchAllAssignments(SearchAllAssignmentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('SearchAllAssignments', $request, $callOptions);
    }

    /**
     * Deprecated: Looks up assignments for a specified resource for a particular
     * region. If the request is about a project:
     *
     * 1. Assignments created on the project will be returned if they exist.
     * 2. Otherwise assignments created on the closest ancestor will be
     * returned.
     * 3. Assignments for different JobTypes will all be returned.
     *
     * The same logic applies if the request is about a folder.
     *
     * If the request is about an organization, then assignments created on the
     * organization will be returned (organization doesn't have ancestors).
     *
     * Comparing to ListAssignments, there are some behavior
     * differences:
     *
     * 1. permission on the assignee will be verified in this API.
     * 2. Hierarchy lookup (project->folder->organization) happens in this API.
     * 3. Parent here is `projects/&#42;/locations/*`, instead of
     * `projects/&#42;/locations/*reservations/*`.
     *
     * **Note** "-" cannot be used for projects
     * nor locations.
     *
     * The async variant is {@see ReservationServiceClient::searchAssignmentsAsync()} .
     *
     * @example samples/V1/ReservationServiceClient/search_assignments.php
     *
     * @param SearchAssignmentsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @deprecated This method will be removed in the next major version update.
     */
    public function searchAssignments(SearchAssignmentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('SearchAssignments', $request, $callOptions);
    }

    /**
     * Splits capacity commitment to two commitments of the same plan and
     * `commitment_end_time`.
     *
     * A common use case is to enable downgrading commitments.
     *
     * For example, in order to downgrade from 10000 slots to 8000, you might
     * split a 10000 capacity commitment into commitments of 2000 and 8000. Then,
     * you delete the first one after the commitment end time passes.
     *
     * The async variant is
     * {@see ReservationServiceClient::splitCapacityCommitmentAsync()} .
     *
     * @example samples/V1/ReservationServiceClient/split_capacity_commitment.php
     *
     * @param SplitCapacityCommitmentRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SplitCapacityCommitmentResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function splitCapacityCommitment(SplitCapacityCommitmentRequest $request, array $callOptions = []): SplitCapacityCommitmentResponse
    {
        return $this->startApiCall('SplitCapacityCommitment', $request, $callOptions)->wait();
    }

    /**
     * Updates an existing assignment.
     *
     * Only the `priority` field can be updated.
     *
     * The async variant is {@see ReservationServiceClient::updateAssignmentAsync()} .
     *
     * @example samples/V1/ReservationServiceClient/update_assignment.php
     *
     * @param UpdateAssignmentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Assignment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateAssignment(UpdateAssignmentRequest $request, array $callOptions = []): Assignment
    {
        return $this->startApiCall('UpdateAssignment', $request, $callOptions)->wait();
    }

    /**
     * Updates a BI reservation.
     *
     * Only fields specified in the `field_mask` are updated.
     *
     * A singleton BI reservation always exists with default size 0.
     * In order to reserve BI capacity it needs to be updated to an amount
     * greater than 0. In order to release BI capacity reservation size
     * must be set to 0.
     *
     * The async variant is {@see ReservationServiceClient::updateBiReservationAsync()}
     * .
     *
     * @example samples/V1/ReservationServiceClient/update_bi_reservation.php
     *
     * @param UpdateBiReservationRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BiReservation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBiReservation(UpdateBiReservationRequest $request, array $callOptions = []): BiReservation
    {
        return $this->startApiCall('UpdateBiReservation', $request, $callOptions)->wait();
    }

    /**
     * Updates an existing capacity commitment.
     *
     * Only `plan` and `renewal_plan` fields can be updated.
     *
     * Plan can only be changed to a plan of a longer commitment period.
     * Attempting to change to a plan with shorter commitment period will fail
     * with the error code `google.rpc.Code.FAILED_PRECONDITION`.
     *
     * The async variant is
     * {@see ReservationServiceClient::updateCapacityCommitmentAsync()} .
     *
     * @example samples/V1/ReservationServiceClient/update_capacity_commitment.php
     *
     * @param UpdateCapacityCommitmentRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CapacityCommitment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCapacityCommitment(UpdateCapacityCommitmentRequest $request, array $callOptions = []): CapacityCommitment
    {
        return $this->startApiCall('UpdateCapacityCommitment', $request, $callOptions)->wait();
    }

    /**
     * Updates an existing reservation resource.
     *
     * The async variant is {@see ReservationServiceClient::updateReservationAsync()} .
     *
     * @example samples/V1/ReservationServiceClient/update_reservation.php
     *
     * @param UpdateReservationRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Reservation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateReservation(UpdateReservationRequest $request, array $callOptions = []): Reservation
    {
        return $this->startApiCall('UpdateReservation', $request, $callOptions)->wait();
    }
}
