<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/bigquery/analyticshub/v1/pubsub.proto

namespace Google\Cloud\BigQuery\AnalyticsHub\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration for a BigQuery subscription.
 *
 * Generated from protobuf message <code>google.cloud.bigquery.analyticshub.v1.BigQueryConfig</code>
 */
class BigQueryConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. The name of the table to which to write data, of the form
     * {projectId}.{datasetId}.{tableId}
     *
     * Generated from protobuf field <code>string table = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $table = '';
    /**
     * Optional. When true, use the topic's schema as the columns to write to in
     * BigQuery, if it exists. `use_topic_schema` and `use_table_schema` cannot be
     * enabled at the same time.
     *
     * Generated from protobuf field <code>bool use_topic_schema = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $use_topic_schema = false;
    /**
     * Optional. When true, write the subscription name, message_id, publish_time,
     * attributes, and ordering_key to additional columns in the table. The
     * subscription name, message_id, and publish_time fields are put in their own
     * columns while all other message properties (other than data) are written to
     * a JSON object in the attributes column.
     *
     * Generated from protobuf field <code>bool write_metadata = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $write_metadata = false;
    /**
     * Optional. When true and use_topic_schema is true, any fields that are a
     * part of the topic schema that are not part of the BigQuery table schema are
     * dropped when writing to BigQuery. Otherwise, the schemas must be kept in
     * sync and any messages with extra fields are not written and remain in the
     * subscription's backlog.
     *
     * Generated from protobuf field <code>bool drop_unknown_fields = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $drop_unknown_fields = false;
    /**
     * Optional. When true, use the BigQuery table's schema as the columns to
     * write to in BigQuery. `use_table_schema` and `use_topic_schema` cannot be
     * enabled at the same time.
     *
     * Generated from protobuf field <code>bool use_table_schema = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $use_table_schema = false;
    /**
     * Optional. The service account to use to write to BigQuery. The subscription
     * creator or updater that specifies this field must have
     * `iam.serviceAccounts.actAs` permission on the service account. If not
     * specified, the Pub/Sub [service
     * agent](https://cloud.google.com/iam/docs/service-agents),
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com, is used.
     *
     * Generated from protobuf field <code>string service_account_email = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $service_account_email = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $table
     *           Optional. The name of the table to which to write data, of the form
     *           {projectId}.{datasetId}.{tableId}
     *     @type bool $use_topic_schema
     *           Optional. When true, use the topic's schema as the columns to write to in
     *           BigQuery, if it exists. `use_topic_schema` and `use_table_schema` cannot be
     *           enabled at the same time.
     *     @type bool $write_metadata
     *           Optional. When true, write the subscription name, message_id, publish_time,
     *           attributes, and ordering_key to additional columns in the table. The
     *           subscription name, message_id, and publish_time fields are put in their own
     *           columns while all other message properties (other than data) are written to
     *           a JSON object in the attributes column.
     *     @type bool $drop_unknown_fields
     *           Optional. When true and use_topic_schema is true, any fields that are a
     *           part of the topic schema that are not part of the BigQuery table schema are
     *           dropped when writing to BigQuery. Otherwise, the schemas must be kept in
     *           sync and any messages with extra fields are not written and remain in the
     *           subscription's backlog.
     *     @type bool $use_table_schema
     *           Optional. When true, use the BigQuery table's schema as the columns to
     *           write to in BigQuery. `use_table_schema` and `use_topic_schema` cannot be
     *           enabled at the same time.
     *     @type string $service_account_email
     *           Optional. The service account to use to write to BigQuery. The subscription
     *           creator or updater that specifies this field must have
     *           `iam.serviceAccounts.actAs` permission on the service account. If not
     *           specified, the Pub/Sub [service
     *           agent](https://cloud.google.com/iam/docs/service-agents),
     *           service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com, is used.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Bigquery\Analyticshub\V1\Pubsub::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. The name of the table to which to write data, of the form
     * {projectId}.{datasetId}.{tableId}
     *
     * Generated from protobuf field <code>string table = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getTable()
    {
        return $this->table;
    }

    /**
     * Optional. The name of the table to which to write data, of the form
     * {projectId}.{datasetId}.{tableId}
     *
     * Generated from protobuf field <code>string table = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setTable($var)
    {
        GPBUtil::checkString($var, True);
        $this->table = $var;

        return $this;
    }

    /**
     * Optional. When true, use the topic's schema as the columns to write to in
     * BigQuery, if it exists. `use_topic_schema` and `use_table_schema` cannot be
     * enabled at the same time.
     *
     * Generated from protobuf field <code>bool use_topic_schema = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getUseTopicSchema()
    {
        return $this->use_topic_schema;
    }

    /**
     * Optional. When true, use the topic's schema as the columns to write to in
     * BigQuery, if it exists. `use_topic_schema` and `use_table_schema` cannot be
     * enabled at the same time.
     *
     * Generated from protobuf field <code>bool use_topic_schema = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setUseTopicSchema($var)
    {
        GPBUtil::checkBool($var);
        $this->use_topic_schema = $var;

        return $this;
    }

    /**
     * Optional. When true, write the subscription name, message_id, publish_time,
     * attributes, and ordering_key to additional columns in the table. The
     * subscription name, message_id, and publish_time fields are put in their own
     * columns while all other message properties (other than data) are written to
     * a JSON object in the attributes column.
     *
     * Generated from protobuf field <code>bool write_metadata = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getWriteMetadata()
    {
        return $this->write_metadata;
    }

    /**
     * Optional. When true, write the subscription name, message_id, publish_time,
     * attributes, and ordering_key to additional columns in the table. The
     * subscription name, message_id, and publish_time fields are put in their own
     * columns while all other message properties (other than data) are written to
     * a JSON object in the attributes column.
     *
     * Generated from protobuf field <code>bool write_metadata = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setWriteMetadata($var)
    {
        GPBUtil::checkBool($var);
        $this->write_metadata = $var;

        return $this;
    }

    /**
     * Optional. When true and use_topic_schema is true, any fields that are a
     * part of the topic schema that are not part of the BigQuery table schema are
     * dropped when writing to BigQuery. Otherwise, the schemas must be kept in
     * sync and any messages with extra fields are not written and remain in the
     * subscription's backlog.
     *
     * Generated from protobuf field <code>bool drop_unknown_fields = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getDropUnknownFields()
    {
        return $this->drop_unknown_fields;
    }

    /**
     * Optional. When true and use_topic_schema is true, any fields that are a
     * part of the topic schema that are not part of the BigQuery table schema are
     * dropped when writing to BigQuery. Otherwise, the schemas must be kept in
     * sync and any messages with extra fields are not written and remain in the
     * subscription's backlog.
     *
     * Generated from protobuf field <code>bool drop_unknown_fields = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setDropUnknownFields($var)
    {
        GPBUtil::checkBool($var);
        $this->drop_unknown_fields = $var;

        return $this;
    }

    /**
     * Optional. When true, use the BigQuery table's schema as the columns to
     * write to in BigQuery. `use_table_schema` and `use_topic_schema` cannot be
     * enabled at the same time.
     *
     * Generated from protobuf field <code>bool use_table_schema = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getUseTableSchema()
    {
        return $this->use_table_schema;
    }

    /**
     * Optional. When true, use the BigQuery table's schema as the columns to
     * write to in BigQuery. `use_table_schema` and `use_topic_schema` cannot be
     * enabled at the same time.
     *
     * Generated from protobuf field <code>bool use_table_schema = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setUseTableSchema($var)
    {
        GPBUtil::checkBool($var);
        $this->use_table_schema = $var;

        return $this;
    }

    /**
     * Optional. The service account to use to write to BigQuery. The subscription
     * creator or updater that specifies this field must have
     * `iam.serviceAccounts.actAs` permission on the service account. If not
     * specified, the Pub/Sub [service
     * agent](https://cloud.google.com/iam/docs/service-agents),
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com, is used.
     *
     * Generated from protobuf field <code>string service_account_email = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getServiceAccountEmail()
    {
        return $this->service_account_email;
    }

    /**
     * Optional. The service account to use to write to BigQuery. The subscription
     * creator or updater that specifies this field must have
     * `iam.serviceAccounts.actAs` permission on the service account. If not
     * specified, the Pub/Sub [service
     * agent](https://cloud.google.com/iam/docs/service-agents),
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com, is used.
     *
     * Generated from protobuf field <code>string service_account_email = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccountEmail($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account_email = $var;

        return $this;
    }

}

