<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/telcoautomation/v1/telcoautomation.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\TelcoAutomation\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\TelcoAutomation\V1\ApplyDeploymentRequest;
use Google\Cloud\TelcoAutomation\V1\ApplyHydratedDeploymentRequest;
use Google\Cloud\TelcoAutomation\V1\ApproveBlueprintRequest;
use Google\Cloud\TelcoAutomation\V1\Blueprint;
use Google\Cloud\TelcoAutomation\V1\ComputeDeploymentStatusRequest;
use Google\Cloud\TelcoAutomation\V1\ComputeDeploymentStatusResponse;
use Google\Cloud\TelcoAutomation\V1\CreateBlueprintRequest;
use Google\Cloud\TelcoAutomation\V1\CreateDeploymentRequest;
use Google\Cloud\TelcoAutomation\V1\CreateEdgeSlmRequest;
use Google\Cloud\TelcoAutomation\V1\CreateOrchestrationClusterRequest;
use Google\Cloud\TelcoAutomation\V1\DeleteBlueprintRequest;
use Google\Cloud\TelcoAutomation\V1\DeleteEdgeSlmRequest;
use Google\Cloud\TelcoAutomation\V1\DeleteOrchestrationClusterRequest;
use Google\Cloud\TelcoAutomation\V1\Deployment;
use Google\Cloud\TelcoAutomation\V1\DiscardBlueprintChangesRequest;
use Google\Cloud\TelcoAutomation\V1\DiscardBlueprintChangesResponse;
use Google\Cloud\TelcoAutomation\V1\DiscardDeploymentChangesRequest;
use Google\Cloud\TelcoAutomation\V1\DiscardDeploymentChangesResponse;
use Google\Cloud\TelcoAutomation\V1\EdgeSlm;
use Google\Cloud\TelcoAutomation\V1\GetBlueprintRequest;
use Google\Cloud\TelcoAutomation\V1\GetDeploymentRequest;
use Google\Cloud\TelcoAutomation\V1\GetEdgeSlmRequest;
use Google\Cloud\TelcoAutomation\V1\GetHydratedDeploymentRequest;
use Google\Cloud\TelcoAutomation\V1\GetOrchestrationClusterRequest;
use Google\Cloud\TelcoAutomation\V1\GetPublicBlueprintRequest;
use Google\Cloud\TelcoAutomation\V1\HydratedDeployment;
use Google\Cloud\TelcoAutomation\V1\ListBlueprintRevisionsRequest;
use Google\Cloud\TelcoAutomation\V1\ListBlueprintsRequest;
use Google\Cloud\TelcoAutomation\V1\ListDeploymentRevisionsRequest;
use Google\Cloud\TelcoAutomation\V1\ListDeploymentsRequest;
use Google\Cloud\TelcoAutomation\V1\ListEdgeSlmsRequest;
use Google\Cloud\TelcoAutomation\V1\ListHydratedDeploymentsRequest;
use Google\Cloud\TelcoAutomation\V1\ListOrchestrationClustersRequest;
use Google\Cloud\TelcoAutomation\V1\ListPublicBlueprintsRequest;
use Google\Cloud\TelcoAutomation\V1\OrchestrationCluster;
use Google\Cloud\TelcoAutomation\V1\ProposeBlueprintRequest;
use Google\Cloud\TelcoAutomation\V1\PublicBlueprint;
use Google\Cloud\TelcoAutomation\V1\RejectBlueprintRequest;
use Google\Cloud\TelcoAutomation\V1\RemoveDeploymentRequest;
use Google\Cloud\TelcoAutomation\V1\RollbackDeploymentRequest;
use Google\Cloud\TelcoAutomation\V1\SearchBlueprintRevisionsRequest;
use Google\Cloud\TelcoAutomation\V1\SearchDeploymentRevisionsRequest;
use Google\Cloud\TelcoAutomation\V1\UpdateBlueprintRequest;
use Google\Cloud\TelcoAutomation\V1\UpdateDeploymentRequest;
use Google\Cloud\TelcoAutomation\V1\UpdateHydratedDeploymentRequest;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: TelcoAutomation Service manages the control plane cluster a.k.a.
 * Orchestration Cluster (GKE cluster with config controller) of TNA. It also
 * exposes blueprint APIs which manages the lifecycle of blueprints that control
 * the infrastructure setup (e.g GDCE clusters) and deployment of network
 * functions.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface applyDeploymentAsync(ApplyDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface applyHydratedDeploymentAsync(ApplyHydratedDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface approveBlueprintAsync(ApproveBlueprintRequest $request, array $optionalArgs = [])
 * @method PromiseInterface computeDeploymentStatusAsync(ComputeDeploymentStatusRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createBlueprintAsync(CreateBlueprintRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createDeploymentAsync(CreateDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createEdgeSlmAsync(CreateEdgeSlmRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createOrchestrationClusterAsync(CreateOrchestrationClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteBlueprintAsync(DeleteBlueprintRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteEdgeSlmAsync(DeleteEdgeSlmRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteOrchestrationClusterAsync(DeleteOrchestrationClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface discardBlueprintChangesAsync(DiscardBlueprintChangesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface discardDeploymentChangesAsync(DiscardDeploymentChangesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getBlueprintAsync(GetBlueprintRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getDeploymentAsync(GetDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getEdgeSlmAsync(GetEdgeSlmRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getHydratedDeploymentAsync(GetHydratedDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getOrchestrationClusterAsync(GetOrchestrationClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getPublicBlueprintAsync(GetPublicBlueprintRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listBlueprintRevisionsAsync(ListBlueprintRevisionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listBlueprintsAsync(ListBlueprintsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDeploymentRevisionsAsync(ListDeploymentRevisionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDeploymentsAsync(ListDeploymentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listEdgeSlmsAsync(ListEdgeSlmsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listHydratedDeploymentsAsync(ListHydratedDeploymentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listOrchestrationClustersAsync(ListOrchestrationClustersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listPublicBlueprintsAsync(ListPublicBlueprintsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface proposeBlueprintAsync(ProposeBlueprintRequest $request, array $optionalArgs = [])
 * @method PromiseInterface rejectBlueprintAsync(RejectBlueprintRequest $request, array $optionalArgs = [])
 * @method PromiseInterface removeDeploymentAsync(RemoveDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface rollbackDeploymentAsync(RollbackDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface searchBlueprintRevisionsAsync(SearchBlueprintRevisionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface searchDeploymentRevisionsAsync(SearchDeploymentRevisionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateBlueprintAsync(UpdateBlueprintRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateDeploymentAsync(UpdateDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateHydratedDeploymentAsync(UpdateHydratedDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class TelcoAutomationClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.telcoautomation.v1.TelcoAutomation';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'telcoautomation.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'telcoautomation.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/telco_automation_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/telco_automation_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/telco_automation_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/telco_automation_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a blueprint
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $orchestrationCluster
     * @param string $blueprint
     *
     * @return string The formatted blueprint resource.
     */
    public static function blueprintName(
        string $project,
        string $location,
        string $orchestrationCluster,
        string $blueprint
    ): string {
        return self::getPathTemplate('blueprint')->render([
            'project' => $project,
            'location' => $location,
            'orchestration_cluster' => $orchestrationCluster,
            'blueprint' => $blueprint,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a deployment
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $orchestrationCluster
     * @param string $deployment
     *
     * @return string The formatted deployment resource.
     */
    public static function deploymentName(
        string $project,
        string $location,
        string $orchestrationCluster,
        string $deployment
    ): string {
        return self::getPathTemplate('deployment')->render([
            'project' => $project,
            'location' => $location,
            'orchestration_cluster' => $orchestrationCluster,
            'deployment' => $deployment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a edge_slm
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $edgeSlm
     *
     * @return string The formatted edge_slm resource.
     */
    public static function edgeSlmName(string $project, string $location, string $edgeSlm): string
    {
        return self::getPathTemplate('edgeSlm')->render([
            'project' => $project,
            'location' => $location,
            'edge_slm' => $edgeSlm,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * hydrated_deployment resource.
     *
     * @param string $project
     * @param string $location
     * @param string $orchestrationCluster
     * @param string $deployment
     * @param string $hydratedDeployment
     *
     * @return string The formatted hydrated_deployment resource.
     */
    public static function hydratedDeploymentName(
        string $project,
        string $location,
        string $orchestrationCluster,
        string $deployment,
        string $hydratedDeployment
    ): string {
        return self::getPathTemplate('hydratedDeployment')->render([
            'project' => $project,
            'location' => $location,
            'orchestration_cluster' => $orchestrationCluster,
            'deployment' => $deployment,
            'hydrated_deployment' => $hydratedDeployment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * orchestration_cluster resource.
     *
     * @param string $project
     * @param string $location
     * @param string $orchestrationCluster
     *
     * @return string The formatted orchestration_cluster resource.
     */
    public static function orchestrationClusterName(
        string $project,
        string $location,
        string $orchestrationCluster
    ): string {
        return self::getPathTemplate('orchestrationCluster')->render([
            'project' => $project,
            'location' => $location,
            'orchestration_cluster' => $orchestrationCluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * public_blueprint resource.
     *
     * @param string $project
     * @param string $location
     * @param string $publicLueprint
     *
     * @return string The formatted public_blueprint resource.
     */
    public static function publicBlueprintName(string $project, string $location, string $publicLueprint): string
    {
        return self::getPathTemplate('publicBlueprint')->render([
            'project' => $project,
            'location' => $location,
            'public_lueprint' => $publicLueprint,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - blueprint: projects/{project}/locations/{location}/orchestrationClusters/{orchestration_cluster}/blueprints/{blueprint}
     * - deployment: projects/{project}/locations/{location}/orchestrationClusters/{orchestration_cluster}/deployments/{deployment}
     * - edgeSlm: projects/{project}/locations/{location}/edgeSlms/{edge_slm}
     * - hydratedDeployment: projects/{project}/locations/{location}/orchestrationClusters/{orchestration_cluster}/deployments/{deployment}/hydratedDeployments/{hydrated_deployment}
     * - location: projects/{project}/locations/{location}
     * - orchestrationCluster: projects/{project}/locations/{location}/orchestrationClusters/{orchestration_cluster}
     * - publicBlueprint: projects/{project}/locations/{location}/publicBlueprints/{public_lueprint}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'telcoautomation.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Applies the deployment's YAML files to the parent orchestration cluster.
     *
     * The async variant is {@see TelcoAutomationClient::applyDeploymentAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/apply_deployment.php
     *
     * @param ApplyDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Deployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function applyDeployment(ApplyDeploymentRequest $request, array $callOptions = []): Deployment
    {
        return $this->startApiCall('ApplyDeployment', $request, $callOptions)->wait();
    }

    /**
     * Applies a hydrated deployment to a workload cluster.
     *
     * The async variant is
     * {@see TelcoAutomationClient::applyHydratedDeploymentAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/apply_hydrated_deployment.php
     *
     * @param ApplyHydratedDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HydratedDeployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function applyHydratedDeployment(
        ApplyHydratedDeploymentRequest $request,
        array $callOptions = []
    ): HydratedDeployment {
        return $this->startApiCall('ApplyHydratedDeployment', $request, $callOptions)->wait();
    }

    /**
     * Approves a blueprint and commits a new revision.
     *
     * The async variant is {@see TelcoAutomationClient::approveBlueprintAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/approve_blueprint.php
     *
     * @param ApproveBlueprintRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Blueprint
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function approveBlueprint(ApproveBlueprintRequest $request, array $callOptions = []): Blueprint
    {
        return $this->startApiCall('ApproveBlueprint', $request, $callOptions)->wait();
    }

    /**
     * Returns the requested deployment status.
     *
     * The async variant is
     * {@see TelcoAutomationClient::computeDeploymentStatusAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/compute_deployment_status.php
     *
     * @param ComputeDeploymentStatusRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ComputeDeploymentStatusResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function computeDeploymentStatus(
        ComputeDeploymentStatusRequest $request,
        array $callOptions = []
    ): ComputeDeploymentStatusResponse {
        return $this->startApiCall('ComputeDeploymentStatus', $request, $callOptions)->wait();
    }

    /**
     * Creates a blueprint.
     *
     * The async variant is {@see TelcoAutomationClient::createBlueprintAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/create_blueprint.php
     *
     * @param CreateBlueprintRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Blueprint
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBlueprint(CreateBlueprintRequest $request, array $callOptions = []): Blueprint
    {
        return $this->startApiCall('CreateBlueprint', $request, $callOptions)->wait();
    }

    /**
     * Creates a deployment.
     *
     * The async variant is {@see TelcoAutomationClient::createDeploymentAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/create_deployment.php
     *
     * @param CreateDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Deployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDeployment(CreateDeploymentRequest $request, array $callOptions = []): Deployment
    {
        return $this->startApiCall('CreateDeployment', $request, $callOptions)->wait();
    }

    /**
     * Creates a new EdgeSlm in a given project and location.
     *
     * The async variant is {@see TelcoAutomationClient::createEdgeSlmAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/create_edge_slm.php
     *
     * @param CreateEdgeSlmRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createEdgeSlm(CreateEdgeSlmRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateEdgeSlm', $request, $callOptions)->wait();
    }

    /**
     * Creates a new OrchestrationCluster in a given project and location.
     *
     * The async variant is
     * {@see TelcoAutomationClient::createOrchestrationClusterAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/create_orchestration_cluster.php
     *
     * @param CreateOrchestrationClusterRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createOrchestrationCluster(
        CreateOrchestrationClusterRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateOrchestrationCluster', $request, $callOptions)->wait();
    }

    /**
     * Deletes a blueprint and all its revisions.
     *
     * The async variant is {@see TelcoAutomationClient::deleteBlueprintAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/delete_blueprint.php
     *
     * @param DeleteBlueprintRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBlueprint(DeleteBlueprintRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteBlueprint', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single EdgeSlm.
     *
     * The async variant is {@see TelcoAutomationClient::deleteEdgeSlmAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/delete_edge_slm.php
     *
     * @param DeleteEdgeSlmRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteEdgeSlm(DeleteEdgeSlmRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteEdgeSlm', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single OrchestrationCluster.
     *
     * The async variant is
     * {@see TelcoAutomationClient::deleteOrchestrationClusterAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/delete_orchestration_cluster.php
     *
     * @param DeleteOrchestrationClusterRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteOrchestrationCluster(
        DeleteOrchestrationClusterRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteOrchestrationCluster', $request, $callOptions)->wait();
    }

    /**
     * Discards the changes in a blueprint and reverts the blueprint to the last
     * approved blueprint revision. No changes take place if a blueprint does not
     * have revisions.
     *
     * The async variant is
     * {@see TelcoAutomationClient::discardBlueprintChangesAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/discard_blueprint_changes.php
     *
     * @param DiscardBlueprintChangesRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DiscardBlueprintChangesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function discardBlueprintChanges(
        DiscardBlueprintChangesRequest $request,
        array $callOptions = []
    ): DiscardBlueprintChangesResponse {
        return $this->startApiCall('DiscardBlueprintChanges', $request, $callOptions)->wait();
    }

    /**
     * Discards the changes in a deployment and reverts the deployment to the last
     * approved deployment revision. No changes take place if a deployment does
     * not have revisions.
     *
     * The async variant is
     * {@see TelcoAutomationClient::discardDeploymentChangesAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/discard_deployment_changes.php
     *
     * @param DiscardDeploymentChangesRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DiscardDeploymentChangesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function discardDeploymentChanges(
        DiscardDeploymentChangesRequest $request,
        array $callOptions = []
    ): DiscardDeploymentChangesResponse {
        return $this->startApiCall('DiscardDeploymentChanges', $request, $callOptions)->wait();
    }

    /**
     * Returns the requested blueprint.
     *
     * The async variant is {@see TelcoAutomationClient::getBlueprintAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/get_blueprint.php
     *
     * @param GetBlueprintRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Blueprint
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBlueprint(GetBlueprintRequest $request, array $callOptions = []): Blueprint
    {
        return $this->startApiCall('GetBlueprint', $request, $callOptions)->wait();
    }

    /**
     * Returns the requested deployment.
     *
     * The async variant is {@see TelcoAutomationClient::getDeploymentAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/get_deployment.php
     *
     * @param GetDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Deployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDeployment(GetDeploymentRequest $request, array $callOptions = []): Deployment
    {
        return $this->startApiCall('GetDeployment', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single EdgeSlm.
     *
     * The async variant is {@see TelcoAutomationClient::getEdgeSlmAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/get_edge_slm.php
     *
     * @param GetEdgeSlmRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EdgeSlm
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEdgeSlm(GetEdgeSlmRequest $request, array $callOptions = []): EdgeSlm
    {
        return $this->startApiCall('GetEdgeSlm', $request, $callOptions)->wait();
    }

    /**
     * Returns the requested hydrated deployment.
     *
     * The async variant is {@see TelcoAutomationClient::getHydratedDeploymentAsync()}
     * .
     *
     * @example samples/V1/TelcoAutomationClient/get_hydrated_deployment.php
     *
     * @param GetHydratedDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HydratedDeployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getHydratedDeployment(
        GetHydratedDeploymentRequest $request,
        array $callOptions = []
    ): HydratedDeployment {
        return $this->startApiCall('GetHydratedDeployment', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single OrchestrationCluster.
     *
     * The async variant is
     * {@see TelcoAutomationClient::getOrchestrationClusterAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/get_orchestration_cluster.php
     *
     * @param GetOrchestrationClusterRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OrchestrationCluster
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getOrchestrationCluster(
        GetOrchestrationClusterRequest $request,
        array $callOptions = []
    ): OrchestrationCluster {
        return $this->startApiCall('GetOrchestrationCluster', $request, $callOptions)->wait();
    }

    /**
     * Returns the requested public blueprint.
     *
     * The async variant is {@see TelcoAutomationClient::getPublicBlueprintAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/get_public_blueprint.php
     *
     * @param GetPublicBlueprintRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PublicBlueprint
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getPublicBlueprint(GetPublicBlueprintRequest $request, array $callOptions = []): PublicBlueprint
    {
        return $this->startApiCall('GetPublicBlueprint', $request, $callOptions)->wait();
    }

    /**
     * List blueprint revisions of a given blueprint.
     *
     * The async variant is {@see TelcoAutomationClient::listBlueprintRevisionsAsync()}
     * .
     *
     * @example samples/V1/TelcoAutomationClient/list_blueprint_revisions.php
     *
     * @param ListBlueprintRevisionsRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBlueprintRevisions(
        ListBlueprintRevisionsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListBlueprintRevisions', $request, $callOptions);
    }

    /**
     * List all blueprints.
     *
     * The async variant is {@see TelcoAutomationClient::listBlueprintsAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/list_blueprints.php
     *
     * @param ListBlueprintsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBlueprints(ListBlueprintsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBlueprints', $request, $callOptions);
    }

    /**
     * List deployment revisions of a given deployment.
     *
     * The async variant is
     * {@see TelcoAutomationClient::listDeploymentRevisionsAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/list_deployment_revisions.php
     *
     * @param ListDeploymentRevisionsRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDeploymentRevisions(
        ListDeploymentRevisionsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListDeploymentRevisions', $request, $callOptions);
    }

    /**
     * List all deployments.
     *
     * The async variant is {@see TelcoAutomationClient::listDeploymentsAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/list_deployments.php
     *
     * @param ListDeploymentsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDeployments(ListDeploymentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDeployments', $request, $callOptions);
    }

    /**
     * Lists EdgeSlms in a given project and location.
     *
     * The async variant is {@see TelcoAutomationClient::listEdgeSlmsAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/list_edge_slms.php
     *
     * @param ListEdgeSlmsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEdgeSlms(ListEdgeSlmsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEdgeSlms', $request, $callOptions);
    }

    /**
     * List all hydrated deployments present under a deployment.
     *
     * The async variant is
     * {@see TelcoAutomationClient::listHydratedDeploymentsAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/list_hydrated_deployments.php
     *
     * @param ListHydratedDeploymentsRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listHydratedDeployments(
        ListHydratedDeploymentsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListHydratedDeployments', $request, $callOptions);
    }

    /**
     * Lists OrchestrationClusters in a given project and location.
     *
     * The async variant is
     * {@see TelcoAutomationClient::listOrchestrationClustersAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/list_orchestration_clusters.php
     *
     * @param ListOrchestrationClustersRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listOrchestrationClusters(
        ListOrchestrationClustersRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListOrchestrationClusters', $request, $callOptions);
    }

    /**
     * Lists the blueprints in TNA's public catalog. Default page size = 20,
     * Max Page Size = 100.
     *
     * The async variant is {@see TelcoAutomationClient::listPublicBlueprintsAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/list_public_blueprints.php
     *
     * @param ListPublicBlueprintsRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPublicBlueprints(
        ListPublicBlueprintsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListPublicBlueprints', $request, $callOptions);
    }

    /**
     * Proposes a blueprint for approval of changes.
     *
     * The async variant is {@see TelcoAutomationClient::proposeBlueprintAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/propose_blueprint.php
     *
     * @param ProposeBlueprintRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Blueprint
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function proposeBlueprint(ProposeBlueprintRequest $request, array $callOptions = []): Blueprint
    {
        return $this->startApiCall('ProposeBlueprint', $request, $callOptions)->wait();
    }

    /**
     * Rejects a blueprint revision proposal and flips it back to Draft state.
     *
     * The async variant is {@see TelcoAutomationClient::rejectBlueprintAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/reject_blueprint.php
     *
     * @param RejectBlueprintRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Blueprint
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function rejectBlueprint(RejectBlueprintRequest $request, array $callOptions = []): Blueprint
    {
        return $this->startApiCall('RejectBlueprint', $request, $callOptions)->wait();
    }

    /**
     * Removes the deployment by marking it as DELETING. Post which deployment and
     * it's revisions gets deleted.
     *
     * The async variant is {@see TelcoAutomationClient::removeDeploymentAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/remove_deployment.php
     *
     * @param RemoveDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function removeDeployment(RemoveDeploymentRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('RemoveDeployment', $request, $callOptions)->wait();
    }

    /**
     * Rollback the active deployment to the given past approved deployment
     * revision.
     *
     * The async variant is {@see TelcoAutomationClient::rollbackDeploymentAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/rollback_deployment.php
     *
     * @param RollbackDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Deployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function rollbackDeployment(RollbackDeploymentRequest $request, array $callOptions = []): Deployment
    {
        return $this->startApiCall('RollbackDeployment', $request, $callOptions)->wait();
    }

    /**
     * Searches across blueprint revisions.
     *
     * The async variant is
     * {@see TelcoAutomationClient::searchBlueprintRevisionsAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/search_blueprint_revisions.php
     *
     * @param SearchBlueprintRevisionsRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function searchBlueprintRevisions(
        SearchBlueprintRevisionsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('SearchBlueprintRevisions', $request, $callOptions);
    }

    /**
     * Searches across deployment revisions.
     *
     * The async variant is
     * {@see TelcoAutomationClient::searchDeploymentRevisionsAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/search_deployment_revisions.php
     *
     * @param SearchDeploymentRevisionsRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function searchDeploymentRevisions(
        SearchDeploymentRevisionsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('SearchDeploymentRevisions', $request, $callOptions);
    }

    /**
     * Updates a blueprint.
     *
     * The async variant is {@see TelcoAutomationClient::updateBlueprintAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/update_blueprint.php
     *
     * @param UpdateBlueprintRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Blueprint
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBlueprint(UpdateBlueprintRequest $request, array $callOptions = []): Blueprint
    {
        return $this->startApiCall('UpdateBlueprint', $request, $callOptions)->wait();
    }

    /**
     * Updates a deployment.
     *
     * The async variant is {@see TelcoAutomationClient::updateDeploymentAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/update_deployment.php
     *
     * @param UpdateDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Deployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDeployment(UpdateDeploymentRequest $request, array $callOptions = []): Deployment
    {
        return $this->startApiCall('UpdateDeployment', $request, $callOptions)->wait();
    }

    /**
     * Updates a hydrated deployment.
     *
     * The async variant is
     * {@see TelcoAutomationClient::updateHydratedDeploymentAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/update_hydrated_deployment.php
     *
     * @param UpdateHydratedDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HydratedDeployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateHydratedDeployment(
        UpdateHydratedDeploymentRequest $request,
        array $callOptions = []
    ): HydratedDeployment {
        return $this->startApiCall('UpdateHydratedDeployment', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see TelcoAutomationClient::getLocationAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see TelcoAutomationClient::listLocationsAsync()} .
     *
     * @example samples/V1/TelcoAutomationClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
