<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/purge_config.proto

namespace Google\Cloud\Retail\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for PurgeProducts method.
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.PurgeProductsRequest</code>
 */
class PurgeProductsRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the branch under which the products are
     * created. The format is
     * `projects/${projectId}/locations/global/catalogs/${catalogId}/branches/${branchId}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $parent = '';
    /**
     * Required. The filter string to specify the products to be deleted with a
     * length limit of 5,000 characters.
     * Empty string filter is not allowed. "*" implies delete all items in a
     * branch.
     * The eligible fields for filtering are:
     * * `availability`: Double quoted
     * [Product.availability][google.cloud.retail.v2.Product.availability] string.
     * * `create_time` : in ISO 8601 "zulu" format.
     * Supported syntax:
     * * Comparators (">", "<", ">=", "<=", "=").
     *   Examples:
     *   * create_time <= "2015-02-13T17:05:46Z"
     *   * availability = "IN_STOCK"
     * * Conjunctions ("AND")
     *   Examples:
     *   * create_time <= "2015-02-13T17:05:46Z" AND availability = "PREORDER"
     * * Disjunctions ("OR")
     *   Examples:
     *   * create_time <= "2015-02-13T17:05:46Z" OR availability = "IN_STOCK"
     * * Can support nested queries.
     *   Examples:
     *   * (create_time <= "2015-02-13T17:05:46Z" AND availability = "PREORDER")
     *   OR (create_time >= "2015-02-14T13:03:32Z" AND availability = "IN_STOCK")
     * * Filter Limits:
     *   * Filter should not contain more than 6 conditions.
     *   * Max nesting depth should not exceed 2 levels.
     * Examples queries:
     * * Delete back order products created before a timestamp.
     *   create_time <= "2015-02-13T17:05:46Z" OR availability = "BACKORDER"
     *
     * Generated from protobuf field <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $filter = '';
    /**
     * Actually perform the purge.
     * If `force` is set to false, the method will return the expected purge count
     * without deleting any products.
     *
     * Generated from protobuf field <code>bool force = 3;</code>
     */
    private $force = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The resource name of the branch under which the products are
     *           created. The format is
     *           `projects/${projectId}/locations/global/catalogs/${catalogId}/branches/${branchId}`
     *     @type string $filter
     *           Required. The filter string to specify the products to be deleted with a
     *           length limit of 5,000 characters.
     *           Empty string filter is not allowed. "*" implies delete all items in a
     *           branch.
     *           The eligible fields for filtering are:
     *           * `availability`: Double quoted
     *           [Product.availability][google.cloud.retail.v2.Product.availability] string.
     *           * `create_time` : in ISO 8601 "zulu" format.
     *           Supported syntax:
     *           * Comparators (">", "<", ">=", "<=", "=").
     *             Examples:
     *             * create_time <= "2015-02-13T17:05:46Z"
     *             * availability = "IN_STOCK"
     *           * Conjunctions ("AND")
     *             Examples:
     *             * create_time <= "2015-02-13T17:05:46Z" AND availability = "PREORDER"
     *           * Disjunctions ("OR")
     *             Examples:
     *             * create_time <= "2015-02-13T17:05:46Z" OR availability = "IN_STOCK"
     *           * Can support nested queries.
     *             Examples:
     *             * (create_time <= "2015-02-13T17:05:46Z" AND availability = "PREORDER")
     *             OR (create_time >= "2015-02-14T13:03:32Z" AND availability = "IN_STOCK")
     *           * Filter Limits:
     *             * Filter should not contain more than 6 conditions.
     *             * Max nesting depth should not exceed 2 levels.
     *           Examples queries:
     *           * Delete back order products created before a timestamp.
     *             create_time <= "2015-02-13T17:05:46Z" OR availability = "BACKORDER"
     *     @type bool $force
     *           Actually perform the purge.
     *           If `force` is set to false, the method will return the expected purge count
     *           without deleting any products.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\PurgeConfig::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The resource name of the branch under which the products are
     * created. The format is
     * `projects/${projectId}/locations/global/catalogs/${catalogId}/branches/${branchId}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The resource name of the branch under which the products are
     * created. The format is
     * `projects/${projectId}/locations/global/catalogs/${catalogId}/branches/${branchId}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The filter string to specify the products to be deleted with a
     * length limit of 5,000 characters.
     * Empty string filter is not allowed. "*" implies delete all items in a
     * branch.
     * The eligible fields for filtering are:
     * * `availability`: Double quoted
     * [Product.availability][google.cloud.retail.v2.Product.availability] string.
     * * `create_time` : in ISO 8601 "zulu" format.
     * Supported syntax:
     * * Comparators (">", "<", ">=", "<=", "=").
     *   Examples:
     *   * create_time <= "2015-02-13T17:05:46Z"
     *   * availability = "IN_STOCK"
     * * Conjunctions ("AND")
     *   Examples:
     *   * create_time <= "2015-02-13T17:05:46Z" AND availability = "PREORDER"
     * * Disjunctions ("OR")
     *   Examples:
     *   * create_time <= "2015-02-13T17:05:46Z" OR availability = "IN_STOCK"
     * * Can support nested queries.
     *   Examples:
     *   * (create_time <= "2015-02-13T17:05:46Z" AND availability = "PREORDER")
     *   OR (create_time >= "2015-02-14T13:03:32Z" AND availability = "IN_STOCK")
     * * Filter Limits:
     *   * Filter should not contain more than 6 conditions.
     *   * Max nesting depth should not exceed 2 levels.
     * Examples queries:
     * * Delete back order products created before a timestamp.
     *   create_time <= "2015-02-13T17:05:46Z" OR availability = "BACKORDER"
     *
     * Generated from protobuf field <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * Required. The filter string to specify the products to be deleted with a
     * length limit of 5,000 characters.
     * Empty string filter is not allowed. "*" implies delete all items in a
     * branch.
     * The eligible fields for filtering are:
     * * `availability`: Double quoted
     * [Product.availability][google.cloud.retail.v2.Product.availability] string.
     * * `create_time` : in ISO 8601 "zulu" format.
     * Supported syntax:
     * * Comparators (">", "<", ">=", "<=", "=").
     *   Examples:
     *   * create_time <= "2015-02-13T17:05:46Z"
     *   * availability = "IN_STOCK"
     * * Conjunctions ("AND")
     *   Examples:
     *   * create_time <= "2015-02-13T17:05:46Z" AND availability = "PREORDER"
     * * Disjunctions ("OR")
     *   Examples:
     *   * create_time <= "2015-02-13T17:05:46Z" OR availability = "IN_STOCK"
     * * Can support nested queries.
     *   Examples:
     *   * (create_time <= "2015-02-13T17:05:46Z" AND availability = "PREORDER")
     *   OR (create_time >= "2015-02-14T13:03:32Z" AND availability = "IN_STOCK")
     * * Filter Limits:
     *   * Filter should not contain more than 6 conditions.
     *   * Max nesting depth should not exceed 2 levels.
     * Examples queries:
     * * Delete back order products created before a timestamp.
     *   create_time <= "2015-02-13T17:05:46Z" OR availability = "BACKORDER"
     *
     * Generated from protobuf field <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter = $var;

        return $this;
    }

    /**
     * Actually perform the purge.
     * If `force` is set to false, the method will return the expected purge count
     * without deleting any products.
     *
     * Generated from protobuf field <code>bool force = 3;</code>
     * @return bool
     */
    public function getForce()
    {
        return $this->force;
    }

    /**
     * Actually perform the purge.
     * If `force` is set to false, the method will return the expected purge count
     * without deleting any products.
     *
     * Generated from protobuf field <code>bool force = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setForce($var)
    {
        GPBUtil::checkBool($var);
        $this->force = $var;

        return $this;
    }

}

