<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/resourcesettings/v1/resource_settings.proto

namespace Google\Cloud\ResourceSettings\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The schema for settings.
 *
 * Generated from protobuf message <code>google.cloud.resourcesettings.v1.Setting</code>
 */
class Setting extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource name of the setting. Must be in one of the following forms:
     * * `projects/{project_number}/settings/{setting_name}`
     * * `folders/{folder_id}/settings/{setting_name}`
     * * `organizations/{organization_id}/settings/{setting_name}`
     * For example, "/projects/123/settings/gcp-enableMyFeature"
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Output only. Metadata about a setting which is not editable by the end
     * user.
     *
     * Generated from protobuf field <code>.google.cloud.resourcesettings.v1.SettingMetadata metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $metadata = null;
    /**
     * The configured value of the setting at the given parent resource (ignoring
     * the resource hierarchy). The data type of
     * [Value][google.cloud.resourcesettings.v1.Value] must always be consistent
     * with the data type defined in
     * [Setting.metadata][google.cloud.resourcesettings.v1.Setting.metadata].
     *
     * Generated from protobuf field <code>.google.cloud.resourcesettings.v1.Value local_value = 8;</code>
     */
    private $local_value = null;
    /**
     * Output only. The computed effective value of the setting at the given
     * parent resource (based on the resource hierarchy).
     * The effective value evaluates to one of the following options in the given
     * order (the next option is used if the previous one does not exist):
     * 1. the local setting value on the given resource:
     * [Setting.local_value][google.cloud.resourcesettings.v1.Setting.local_value]
     * 2. if one of the given resource's ancestors have a local setting value,
     *    the local value at the nearest such ancestor
     * 3. the setting's default value:
     * [SettingMetadata.default_value][google.cloud.resourcesettings.v1.SettingMetadata.default_value]
     * 4. an empty value (defined as a `Value` with all fields unset)
     * The data type of [Value][google.cloud.resourcesettings.v1.Value] must
     * always be consistent with the data type defined in
     * [Setting.metadata][google.cloud.resourcesettings.v1.Setting.metadata].
     *
     * Generated from protobuf field <code>.google.cloud.resourcesettings.v1.Value effective_value = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $effective_value = null;
    /**
     * A fingerprint used for optimistic concurrency. See
     * [UpdateSetting][google.cloud.resourcesettings.v1.ResourceSettingsService.UpdateSetting]
     * for more details.
     *
     * Generated from protobuf field <code>string etag = 10;</code>
     */
    private $etag = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The resource name of the setting. Must be in one of the following forms:
     *           * `projects/{project_number}/settings/{setting_name}`
     *           * `folders/{folder_id}/settings/{setting_name}`
     *           * `organizations/{organization_id}/settings/{setting_name}`
     *           For example, "/projects/123/settings/gcp-enableMyFeature"
     *     @type \Google\Cloud\ResourceSettings\V1\SettingMetadata $metadata
     *           Output only. Metadata about a setting which is not editable by the end
     *           user.
     *     @type \Google\Cloud\ResourceSettings\V1\Value $local_value
     *           The configured value of the setting at the given parent resource (ignoring
     *           the resource hierarchy). The data type of
     *           [Value][google.cloud.resourcesettings.v1.Value] must always be consistent
     *           with the data type defined in
     *           [Setting.metadata][google.cloud.resourcesettings.v1.Setting.metadata].
     *     @type \Google\Cloud\ResourceSettings\V1\Value $effective_value
     *           Output only. The computed effective value of the setting at the given
     *           parent resource (based on the resource hierarchy).
     *           The effective value evaluates to one of the following options in the given
     *           order (the next option is used if the previous one does not exist):
     *           1. the local setting value on the given resource:
     *           [Setting.local_value][google.cloud.resourcesettings.v1.Setting.local_value]
     *           2. if one of the given resource's ancestors have a local setting value,
     *              the local value at the nearest such ancestor
     *           3. the setting's default value:
     *           [SettingMetadata.default_value][google.cloud.resourcesettings.v1.SettingMetadata.default_value]
     *           4. an empty value (defined as a `Value` with all fields unset)
     *           The data type of [Value][google.cloud.resourcesettings.v1.Value] must
     *           always be consistent with the data type defined in
     *           [Setting.metadata][google.cloud.resourcesettings.v1.Setting.metadata].
     *     @type string $etag
     *           A fingerprint used for optimistic concurrency. See
     *           [UpdateSetting][google.cloud.resourcesettings.v1.ResourceSettingsService.UpdateSetting]
     *           for more details.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Resourcesettings\V1\ResourceSettings::initOnce();
        parent::__construct($data);
    }

    /**
     * The resource name of the setting. Must be in one of the following forms:
     * * `projects/{project_number}/settings/{setting_name}`
     * * `folders/{folder_id}/settings/{setting_name}`
     * * `organizations/{organization_id}/settings/{setting_name}`
     * For example, "/projects/123/settings/gcp-enableMyFeature"
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The resource name of the setting. Must be in one of the following forms:
     * * `projects/{project_number}/settings/{setting_name}`
     * * `folders/{folder_id}/settings/{setting_name}`
     * * `organizations/{organization_id}/settings/{setting_name}`
     * For example, "/projects/123/settings/gcp-enableMyFeature"
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Metadata about a setting which is not editable by the end
     * user.
     *
     * Generated from protobuf field <code>.google.cloud.resourcesettings.v1.SettingMetadata metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\ResourceSettings\V1\SettingMetadata|null
     */
    public function getMetadata()
    {
        return $this->metadata;
    }

    public function hasMetadata()
    {
        return isset($this->metadata);
    }

    public function clearMetadata()
    {
        unset($this->metadata);
    }

    /**
     * Output only. Metadata about a setting which is not editable by the end
     * user.
     *
     * Generated from protobuf field <code>.google.cloud.resourcesettings.v1.SettingMetadata metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\ResourceSettings\V1\SettingMetadata $var
     * @return $this
     */
    public function setMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ResourceSettings\V1\SettingMetadata::class);
        $this->metadata = $var;

        return $this;
    }

    /**
     * The configured value of the setting at the given parent resource (ignoring
     * the resource hierarchy). The data type of
     * [Value][google.cloud.resourcesettings.v1.Value] must always be consistent
     * with the data type defined in
     * [Setting.metadata][google.cloud.resourcesettings.v1.Setting.metadata].
     *
     * Generated from protobuf field <code>.google.cloud.resourcesettings.v1.Value local_value = 8;</code>
     * @return \Google\Cloud\ResourceSettings\V1\Value|null
     */
    public function getLocalValue()
    {
        return $this->local_value;
    }

    public function hasLocalValue()
    {
        return isset($this->local_value);
    }

    public function clearLocalValue()
    {
        unset($this->local_value);
    }

    /**
     * The configured value of the setting at the given parent resource (ignoring
     * the resource hierarchy). The data type of
     * [Value][google.cloud.resourcesettings.v1.Value] must always be consistent
     * with the data type defined in
     * [Setting.metadata][google.cloud.resourcesettings.v1.Setting.metadata].
     *
     * Generated from protobuf field <code>.google.cloud.resourcesettings.v1.Value local_value = 8;</code>
     * @param \Google\Cloud\ResourceSettings\V1\Value $var
     * @return $this
     */
    public function setLocalValue($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ResourceSettings\V1\Value::class);
        $this->local_value = $var;

        return $this;
    }

    /**
     * Output only. The computed effective value of the setting at the given
     * parent resource (based on the resource hierarchy).
     * The effective value evaluates to one of the following options in the given
     * order (the next option is used if the previous one does not exist):
     * 1. the local setting value on the given resource:
     * [Setting.local_value][google.cloud.resourcesettings.v1.Setting.local_value]
     * 2. if one of the given resource's ancestors have a local setting value,
     *    the local value at the nearest such ancestor
     * 3. the setting's default value:
     * [SettingMetadata.default_value][google.cloud.resourcesettings.v1.SettingMetadata.default_value]
     * 4. an empty value (defined as a `Value` with all fields unset)
     * The data type of [Value][google.cloud.resourcesettings.v1.Value] must
     * always be consistent with the data type defined in
     * [Setting.metadata][google.cloud.resourcesettings.v1.Setting.metadata].
     *
     * Generated from protobuf field <code>.google.cloud.resourcesettings.v1.Value effective_value = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\ResourceSettings\V1\Value|null
     */
    public function getEffectiveValue()
    {
        return $this->effective_value;
    }

    public function hasEffectiveValue()
    {
        return isset($this->effective_value);
    }

    public function clearEffectiveValue()
    {
        unset($this->effective_value);
    }

    /**
     * Output only. The computed effective value of the setting at the given
     * parent resource (based on the resource hierarchy).
     * The effective value evaluates to one of the following options in the given
     * order (the next option is used if the previous one does not exist):
     * 1. the local setting value on the given resource:
     * [Setting.local_value][google.cloud.resourcesettings.v1.Setting.local_value]
     * 2. if one of the given resource's ancestors have a local setting value,
     *    the local value at the nearest such ancestor
     * 3. the setting's default value:
     * [SettingMetadata.default_value][google.cloud.resourcesettings.v1.SettingMetadata.default_value]
     * 4. an empty value (defined as a `Value` with all fields unset)
     * The data type of [Value][google.cloud.resourcesettings.v1.Value] must
     * always be consistent with the data type defined in
     * [Setting.metadata][google.cloud.resourcesettings.v1.Setting.metadata].
     *
     * Generated from protobuf field <code>.google.cloud.resourcesettings.v1.Value effective_value = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\ResourceSettings\V1\Value $var
     * @return $this
     */
    public function setEffectiveValue($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ResourceSettings\V1\Value::class);
        $this->effective_value = $var;

        return $this;
    }

    /**
     * A fingerprint used for optimistic concurrency. See
     * [UpdateSetting][google.cloud.resourcesettings.v1.ResourceSettingsService.UpdateSetting]
     * for more details.
     *
     * Generated from protobuf field <code>string etag = 10;</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * A fingerprint used for optimistic concurrency. See
     * [UpdateSetting][google.cloud.resourcesettings.v1.ResourceSettingsService.UpdateSetting]
     * for more details.
     *
     * Generated from protobuf field <code>string etag = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

}

