<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/alloydb/v1beta/resources.proto

namespace Google\Cloud\AlloyDb\V1beta\Instance;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * PscInstanceConfig contains PSC related configuration at an
 * instance level.
 *
 * Generated from protobuf message <code>google.cloud.alloydb.v1beta.Instance.PscInstanceConfig</code>
 */
class PscInstanceConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The service attachment created when Private
     * Service Connect (PSC) is enabled for the instance.
     * The name of the resource will be in the format of
     * `projects/<alloydb-tenant-project-number>/regions/<region-name>/serviceAttachments/<service-attachment-name>`
     *
     * Generated from protobuf field <code>string service_attachment_link = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $service_attachment_link = '';
    /**
     * Optional. List of consumer projects that are allowed to create
     * PSC endpoints to service-attachments to this instance.
     *
     * Generated from protobuf field <code>repeated string allowed_consumer_projects = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $allowed_consumer_projects;
    /**
     * Optional. List of consumer networks that are allowed to create
     * PSC endpoints to service-attachments to this instance.
     *
     * Generated from protobuf field <code>repeated string allowed_consumer_networks = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $allowed_consumer_networks;
    /**
     * Optional. Configurations for setting up PSC interfaces attached to the
     * instance which are used for outbound connectivity. Only primary instances
     * can have PSC interface attached. All the VMs created for the primary
     * instance will share the same configurations. Currently we only support 0
     * or 1 PSC interface.
     *
     * Generated from protobuf field <code>repeated .google.cloud.alloydb.v1beta.Instance.PscInterfaceConfig psc_interface_configs = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $psc_interface_configs;
    /**
     * Optional. List of service attachments that this instance has created
     * endpoints to connect with. Currently, only a single outgoing service
     * attachment is supported per instance.
     *
     * Generated from protobuf field <code>repeated string outgoing_service_attachment_links = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $outgoing_service_attachment_links;
    /**
     * Optional. Whether PSC connectivity is enabled for this instance.
     * This is populated by referencing the value from the parent cluster.
     *
     * Generated from protobuf field <code>bool psc_enabled = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $psc_enabled = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $service_attachment_link
     *           Output only. The service attachment created when Private
     *           Service Connect (PSC) is enabled for the instance.
     *           The name of the resource will be in the format of
     *           `projects/<alloydb-tenant-project-number>/regions/<region-name>/serviceAttachments/<service-attachment-name>`
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $allowed_consumer_projects
     *           Optional. List of consumer projects that are allowed to create
     *           PSC endpoints to service-attachments to this instance.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $allowed_consumer_networks
     *           Optional. List of consumer networks that are allowed to create
     *           PSC endpoints to service-attachments to this instance.
     *     @type array<\Google\Cloud\AlloyDb\V1beta\Instance\PscInterfaceConfig>|\Google\Protobuf\Internal\RepeatedField $psc_interface_configs
     *           Optional. Configurations for setting up PSC interfaces attached to the
     *           instance which are used for outbound connectivity. Only primary instances
     *           can have PSC interface attached. All the VMs created for the primary
     *           instance will share the same configurations. Currently we only support 0
     *           or 1 PSC interface.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $outgoing_service_attachment_links
     *           Optional. List of service attachments that this instance has created
     *           endpoints to connect with. Currently, only a single outgoing service
     *           attachment is supported per instance.
     *     @type bool $psc_enabled
     *           Optional. Whether PSC connectivity is enabled for this instance.
     *           This is populated by referencing the value from the parent cluster.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Alloydb\V1Beta\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The service attachment created when Private
     * Service Connect (PSC) is enabled for the instance.
     * The name of the resource will be in the format of
     * `projects/<alloydb-tenant-project-number>/regions/<region-name>/serviceAttachments/<service-attachment-name>`
     *
     * Generated from protobuf field <code>string service_attachment_link = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getServiceAttachmentLink()
    {
        return $this->service_attachment_link;
    }

    /**
     * Output only. The service attachment created when Private
     * Service Connect (PSC) is enabled for the instance.
     * The name of the resource will be in the format of
     * `projects/<alloydb-tenant-project-number>/regions/<region-name>/serviceAttachments/<service-attachment-name>`
     *
     * Generated from protobuf field <code>string service_attachment_link = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAttachmentLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_attachment_link = $var;

        return $this;
    }

    /**
     * Optional. List of consumer projects that are allowed to create
     * PSC endpoints to service-attachments to this instance.
     *
     * Generated from protobuf field <code>repeated string allowed_consumer_projects = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAllowedConsumerProjects()
    {
        return $this->allowed_consumer_projects;
    }

    /**
     * Optional. List of consumer projects that are allowed to create
     * PSC endpoints to service-attachments to this instance.
     *
     * Generated from protobuf field <code>repeated string allowed_consumer_projects = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAllowedConsumerProjects($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->allowed_consumer_projects = $arr;

        return $this;
    }

    /**
     * Optional. List of consumer networks that are allowed to create
     * PSC endpoints to service-attachments to this instance.
     *
     * Generated from protobuf field <code>repeated string allowed_consumer_networks = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAllowedConsumerNetworks()
    {
        return $this->allowed_consumer_networks;
    }

    /**
     * Optional. List of consumer networks that are allowed to create
     * PSC endpoints to service-attachments to this instance.
     *
     * Generated from protobuf field <code>repeated string allowed_consumer_networks = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAllowedConsumerNetworks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->allowed_consumer_networks = $arr;

        return $this;
    }

    /**
     * Optional. Configurations for setting up PSC interfaces attached to the
     * instance which are used for outbound connectivity. Only primary instances
     * can have PSC interface attached. All the VMs created for the primary
     * instance will share the same configurations. Currently we only support 0
     * or 1 PSC interface.
     *
     * Generated from protobuf field <code>repeated .google.cloud.alloydb.v1beta.Instance.PscInterfaceConfig psc_interface_configs = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPscInterfaceConfigs()
    {
        return $this->psc_interface_configs;
    }

    /**
     * Optional. Configurations for setting up PSC interfaces attached to the
     * instance which are used for outbound connectivity. Only primary instances
     * can have PSC interface attached. All the VMs created for the primary
     * instance will share the same configurations. Currently we only support 0
     * or 1 PSC interface.
     *
     * Generated from protobuf field <code>repeated .google.cloud.alloydb.v1beta.Instance.PscInterfaceConfig psc_interface_configs = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\AlloyDb\V1beta\Instance\PscInterfaceConfig>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPscInterfaceConfigs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\AlloyDb\V1beta\Instance\PscInterfaceConfig::class);
        $this->psc_interface_configs = $arr;

        return $this;
    }

    /**
     * Optional. List of service attachments that this instance has created
     * endpoints to connect with. Currently, only a single outgoing service
     * attachment is supported per instance.
     *
     * Generated from protobuf field <code>repeated string outgoing_service_attachment_links = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getOutgoingServiceAttachmentLinks()
    {
        return $this->outgoing_service_attachment_links;
    }

    /**
     * Optional. List of service attachments that this instance has created
     * endpoints to connect with. Currently, only a single outgoing service
     * attachment is supported per instance.
     *
     * Generated from protobuf field <code>repeated string outgoing_service_attachment_links = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setOutgoingServiceAttachmentLinks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->outgoing_service_attachment_links = $arr;

        return $this;
    }

    /**
     * Optional. Whether PSC connectivity is enabled for this instance.
     * This is populated by referencing the value from the parent cluster.
     *
     * Generated from protobuf field <code>bool psc_enabled = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getPscEnabled()
    {
        return $this->psc_enabled;
    }

    /**
     * Optional. Whether PSC connectivity is enabled for this instance.
     * This is populated by referencing the value from the parent cluster.
     *
     * Generated from protobuf field <code>bool psc_enabled = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setPscEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->psc_enabled = $var;

        return $this;
    }

}


