<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/aiplatform/v1/match_service.proto

namespace Google\Cloud\AIPlatform\V1\FindNeighborsRequest;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A query to find a number of the nearest neighbors (most similar vectors)
 * of a vector.
 *
 * Generated from protobuf message <code>google.cloud.aiplatform.v1.FindNeighborsRequest.Query</code>
 */
class Query extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The datapoint/vector whose nearest neighbors should be searched
     * for.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.IndexDatapoint datapoint = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $datapoint = null;
    /**
     * The number of nearest neighbors to be retrieved from database for each
     * query. If not set, will use the default from the service configuration
     * (https://cloud.google.com/vertex-ai/docs/matching-engine/configuring-indexes#nearest-neighbor-search-config).
     *
     * Generated from protobuf field <code>int32 neighbor_count = 2;</code>
     */
    private $neighbor_count = 0;
    /**
     * Crowding is a constraint on a neighbor list produced by nearest neighbor
     * search requiring that no more than some value k' of the k neighbors
     * returned have the same value of crowding_attribute.
     * It's used for improving result diversity.
     * This field is the maximum number of matches with the same crowding tag.
     *
     * Generated from protobuf field <code>int32 per_crowding_attribute_neighbor_count = 3;</code>
     */
    private $per_crowding_attribute_neighbor_count = 0;
    /**
     * The number of neighbors to find via approximate search before
     * exact reordering is performed. If not set, the default value from scam
     * config is used; if set, this value must be > 0.
     *
     * Generated from protobuf field <code>int32 approximate_neighbor_count = 4;</code>
     */
    private $approximate_neighbor_count = 0;
    /**
     * The fraction of the number of leaves to search, set at query time allows
     * user to tune search performance. This value increase result in both
     * search accuracy and latency increase. The value should be between 0.0
     * and 1.0. If not set or set to 0.0, query uses the default value specified
     * in
     * NearestNeighborSearchConfig.TreeAHConfig.fraction_leaf_nodes_to_search.
     *
     * Generated from protobuf field <code>double fraction_leaf_nodes_to_search_override = 5;</code>
     */
    private $fraction_leaf_nodes_to_search_override = 0.0;
    protected $ranking;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\AIPlatform\V1\FindNeighborsRequest\Query\RRF $rrf
     *           Optional. Represents RRF algorithm that combines search results.
     *     @type \Google\Cloud\AIPlatform\V1\IndexDatapoint $datapoint
     *           Required. The datapoint/vector whose nearest neighbors should be searched
     *           for.
     *     @type int $neighbor_count
     *           The number of nearest neighbors to be retrieved from database for each
     *           query. If not set, will use the default from the service configuration
     *           (https://cloud.google.com/vertex-ai/docs/matching-engine/configuring-indexes#nearest-neighbor-search-config).
     *     @type int $per_crowding_attribute_neighbor_count
     *           Crowding is a constraint on a neighbor list produced by nearest neighbor
     *           search requiring that no more than some value k' of the k neighbors
     *           returned have the same value of crowding_attribute.
     *           It's used for improving result diversity.
     *           This field is the maximum number of matches with the same crowding tag.
     *     @type int $approximate_neighbor_count
     *           The number of neighbors to find via approximate search before
     *           exact reordering is performed. If not set, the default value from scam
     *           config is used; if set, this value must be > 0.
     *     @type float $fraction_leaf_nodes_to_search_override
     *           The fraction of the number of leaves to search, set at query time allows
     *           user to tune search performance. This value increase result in both
     *           search accuracy and latency increase. The value should be between 0.0
     *           and 1.0. If not set or set to 0.0, query uses the default value specified
     *           in
     *           NearestNeighborSearchConfig.TreeAHConfig.fraction_leaf_nodes_to_search.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Aiplatform\V1\MatchService::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Represents RRF algorithm that combines search results.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.FindNeighborsRequest.Query.RRF rrf = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\AIPlatform\V1\FindNeighborsRequest\Query\RRF|null
     */
    public function getRrf()
    {
        return $this->readOneof(6);
    }

    public function hasRrf()
    {
        return $this->hasOneof(6);
    }

    /**
     * Optional. Represents RRF algorithm that combines search results.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.FindNeighborsRequest.Query.RRF rrf = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\AIPlatform\V1\FindNeighborsRequest\Query\RRF $var
     * @return $this
     */
    public function setRrf($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\FindNeighborsRequest\Query\RRF::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Required. The datapoint/vector whose nearest neighbors should be searched
     * for.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.IndexDatapoint datapoint = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\AIPlatform\V1\IndexDatapoint|null
     */
    public function getDatapoint()
    {
        return $this->datapoint;
    }

    public function hasDatapoint()
    {
        return isset($this->datapoint);
    }

    public function clearDatapoint()
    {
        unset($this->datapoint);
    }

    /**
     * Required. The datapoint/vector whose nearest neighbors should be searched
     * for.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.IndexDatapoint datapoint = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\AIPlatform\V1\IndexDatapoint $var
     * @return $this
     */
    public function setDatapoint($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\IndexDatapoint::class);
        $this->datapoint = $var;

        return $this;
    }

    /**
     * The number of nearest neighbors to be retrieved from database for each
     * query. If not set, will use the default from the service configuration
     * (https://cloud.google.com/vertex-ai/docs/matching-engine/configuring-indexes#nearest-neighbor-search-config).
     *
     * Generated from protobuf field <code>int32 neighbor_count = 2;</code>
     * @return int
     */
    public function getNeighborCount()
    {
        return $this->neighbor_count;
    }

    /**
     * The number of nearest neighbors to be retrieved from database for each
     * query. If not set, will use the default from the service configuration
     * (https://cloud.google.com/vertex-ai/docs/matching-engine/configuring-indexes#nearest-neighbor-search-config).
     *
     * Generated from protobuf field <code>int32 neighbor_count = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setNeighborCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->neighbor_count = $var;

        return $this;
    }

    /**
     * Crowding is a constraint on a neighbor list produced by nearest neighbor
     * search requiring that no more than some value k' of the k neighbors
     * returned have the same value of crowding_attribute.
     * It's used for improving result diversity.
     * This field is the maximum number of matches with the same crowding tag.
     *
     * Generated from protobuf field <code>int32 per_crowding_attribute_neighbor_count = 3;</code>
     * @return int
     */
    public function getPerCrowdingAttributeNeighborCount()
    {
        return $this->per_crowding_attribute_neighbor_count;
    }

    /**
     * Crowding is a constraint on a neighbor list produced by nearest neighbor
     * search requiring that no more than some value k' of the k neighbors
     * returned have the same value of crowding_attribute.
     * It's used for improving result diversity.
     * This field is the maximum number of matches with the same crowding tag.
     *
     * Generated from protobuf field <code>int32 per_crowding_attribute_neighbor_count = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setPerCrowdingAttributeNeighborCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->per_crowding_attribute_neighbor_count = $var;

        return $this;
    }

    /**
     * The number of neighbors to find via approximate search before
     * exact reordering is performed. If not set, the default value from scam
     * config is used; if set, this value must be > 0.
     *
     * Generated from protobuf field <code>int32 approximate_neighbor_count = 4;</code>
     * @return int
     */
    public function getApproximateNeighborCount()
    {
        return $this->approximate_neighbor_count;
    }

    /**
     * The number of neighbors to find via approximate search before
     * exact reordering is performed. If not set, the default value from scam
     * config is used; if set, this value must be > 0.
     *
     * Generated from protobuf field <code>int32 approximate_neighbor_count = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setApproximateNeighborCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->approximate_neighbor_count = $var;

        return $this;
    }

    /**
     * The fraction of the number of leaves to search, set at query time allows
     * user to tune search performance. This value increase result in both
     * search accuracy and latency increase. The value should be between 0.0
     * and 1.0. If not set or set to 0.0, query uses the default value specified
     * in
     * NearestNeighborSearchConfig.TreeAHConfig.fraction_leaf_nodes_to_search.
     *
     * Generated from protobuf field <code>double fraction_leaf_nodes_to_search_override = 5;</code>
     * @return float
     */
    public function getFractionLeafNodesToSearchOverride()
    {
        return $this->fraction_leaf_nodes_to_search_override;
    }

    /**
     * The fraction of the number of leaves to search, set at query time allows
     * user to tune search performance. This value increase result in both
     * search accuracy and latency increase. The value should be between 0.0
     * and 1.0. If not set or set to 0.0, query uses the default value specified
     * in
     * NearestNeighborSearchConfig.TreeAHConfig.fraction_leaf_nodes_to_search.
     *
     * Generated from protobuf field <code>double fraction_leaf_nodes_to_search_override = 5;</code>
     * @param float $var
     * @return $this
     */
    public function setFractionLeafNodesToSearchOverride($var)
    {
        GPBUtil::checkDouble($var);
        $this->fraction_leaf_nodes_to_search_override = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getRanking()
    {
        return $this->whichOneof("ranking");
    }

}


