<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/devtools/cloudprofiler/v2/profiler.proto

namespace Google\Cloud\Profiler\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * CreateProfileRequest describes a profile resource online creation request.
 * The deployment field must be populated. The profile_type specifies the list
 * of profile types supported by the agent. The creation call will hang until a
 * profile of one of these types needs to be collected.
 *
 * Generated from protobuf message <code>google.devtools.cloudprofiler.v2.CreateProfileRequest</code>
 */
class CreateProfileRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Parent project to create the profile in.
     *
     * Generated from protobuf field <code>string parent = 4 [(.google.api.resource_reference) = {</code>
     */
    private $parent = '';
    /**
     * Deployment details.
     *
     * Generated from protobuf field <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 1;</code>
     */
    private $deployment = null;
    /**
     * One or more profile types that the agent is capable of providing.
     *
     * Generated from protobuf field <code>repeated .google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
     */
    private $profile_type;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Parent project to create the profile in.
     *     @type \Google\Cloud\Profiler\V2\Deployment $deployment
     *           Deployment details.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $profile_type
     *           One or more profile types that the agent is capable of providing.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Devtools\Cloudprofiler\V2\Profiler::initOnce();
        parent::__construct($data);
    }

    /**
     * Parent project to create the profile in.
     *
     * Generated from protobuf field <code>string parent = 4 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Parent project to create the profile in.
     *
     * Generated from protobuf field <code>string parent = 4 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Deployment details.
     *
     * Generated from protobuf field <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 1;</code>
     * @return \Google\Cloud\Profiler\V2\Deployment|null
     */
    public function getDeployment()
    {
        return $this->deployment;
    }

    public function hasDeployment()
    {
        return isset($this->deployment);
    }

    public function clearDeployment()
    {
        unset($this->deployment);
    }

    /**
     * Deployment details.
     *
     * Generated from protobuf field <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 1;</code>
     * @param \Google\Cloud\Profiler\V2\Deployment $var
     * @return $this
     */
    public function setDeployment($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Profiler\V2\Deployment::class);
        $this->deployment = $var;

        return $this;
    }

    /**
     * One or more profile types that the agent is capable of providing.
     *
     * Generated from protobuf field <code>repeated .google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getProfileType()
    {
        return $this->profile_type;
    }

    /**
     * One or more profile types that the agent is capable of providing.
     *
     * Generated from protobuf field <code>repeated .google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setProfileType($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\Profiler\V2\ProfileType::class);
        $this->profile_type = $arr;

        return $this;
    }

}

