<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/filestore/v1/cloud_filestore_service.proto

namespace Google\Cloud\Filestore\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * CreateBackupRequest creates a backup.
 *
 * Generated from protobuf message <code>google.cloud.filestore.v1.CreateBackupRequest</code>
 */
class CreateBackupRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The backup's project and location, in the format
     * `projects/{project_number}/locations/{location}`. In Filestore,
     * backup locations map to Google Cloud regions, for example **us-west1**.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $parent = '';
    /**
     * Required. A [backup resource][google.cloud.filestore.v1.Backup]
     *
     * Generated from protobuf field <code>.google.cloud.filestore.v1.Backup backup = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $backup = null;
    /**
     * Required. The ID to use for the backup.
     * The ID must be unique within the specified project and location.
     * This value must start with a lowercase letter followed by up to 62
     * lowercase letters, numbers, or hyphens, and cannot end with a hyphen.
     * Values that do not match this pattern will trigger an INVALID_ARGUMENT
     * error.
     *
     * Generated from protobuf field <code>string backup_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $backup_id = '';

    /**
     * @param string                            $parent   Required. The backup's project and location, in the format
     *                                                    `projects/{project_number}/locations/{location}`. In Filestore,
     *                                                    backup locations map to Google Cloud regions, for example **us-west1**. Please see
     *                                                    {@see CloudFilestoreManagerClient::locationName()} for help formatting this field.
     * @param \Google\Cloud\Filestore\V1\Backup $backup   Required. A [backup resource][google.cloud.filestore.v1.Backup]
     * @param string                            $backupId Required. The ID to use for the backup.
     *                                                    The ID must be unique within the specified project and location.
     *
     *                                                    This value must start with a lowercase letter followed by up to 62
     *                                                    lowercase letters, numbers, or hyphens, and cannot end with a hyphen.
     *                                                    Values that do not match this pattern will trigger an INVALID_ARGUMENT
     *                                                    error.
     *
     * @return \Google\Cloud\Filestore\V1\CreateBackupRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\Filestore\V1\Backup $backup, string $backupId): self
    {
        return (new self())
            ->setParent($parent)
            ->setBackup($backup)
            ->setBackupId($backupId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The backup's project and location, in the format
     *           `projects/{project_number}/locations/{location}`. In Filestore,
     *           backup locations map to Google Cloud regions, for example **us-west1**.
     *     @type \Google\Cloud\Filestore\V1\Backup $backup
     *           Required. A [backup resource][google.cloud.filestore.v1.Backup]
     *     @type string $backup_id
     *           Required. The ID to use for the backup.
     *           The ID must be unique within the specified project and location.
     *           This value must start with a lowercase letter followed by up to 62
     *           lowercase letters, numbers, or hyphens, and cannot end with a hyphen.
     *           Values that do not match this pattern will trigger an INVALID_ARGUMENT
     *           error.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Filestore\V1\CloudFilestoreService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The backup's project and location, in the format
     * `projects/{project_number}/locations/{location}`. In Filestore,
     * backup locations map to Google Cloud regions, for example **us-west1**.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The backup's project and location, in the format
     * `projects/{project_number}/locations/{location}`. In Filestore,
     * backup locations map to Google Cloud regions, for example **us-west1**.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. A [backup resource][google.cloud.filestore.v1.Backup]
     *
     * Generated from protobuf field <code>.google.cloud.filestore.v1.Backup backup = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Filestore\V1\Backup|null
     */
    public function getBackup()
    {
        return $this->backup;
    }

    public function hasBackup()
    {
        return isset($this->backup);
    }

    public function clearBackup()
    {
        unset($this->backup);
    }

    /**
     * Required. A [backup resource][google.cloud.filestore.v1.Backup]
     *
     * Generated from protobuf field <code>.google.cloud.filestore.v1.Backup backup = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Filestore\V1\Backup $var
     * @return $this
     */
    public function setBackup($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Filestore\V1\Backup::class);
        $this->backup = $var;

        return $this;
    }

    /**
     * Required. The ID to use for the backup.
     * The ID must be unique within the specified project and location.
     * This value must start with a lowercase letter followed by up to 62
     * lowercase letters, numbers, or hyphens, and cannot end with a hyphen.
     * Values that do not match this pattern will trigger an INVALID_ARGUMENT
     * error.
     *
     * Generated from protobuf field <code>string backup_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getBackupId()
    {
        return $this->backup_id;
    }

    /**
     * Required. The ID to use for the backup.
     * The ID must be unique within the specified project and location.
     * This value must start with a lowercase letter followed by up to 62
     * lowercase letters, numbers, or hyphens, and cannot end with a hyphen.
     * Values that do not match this pattern will trigger an INVALID_ARGUMENT
     * error.
     *
     * Generated from protobuf field <code>string backup_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setBackupId($var)
    {
        GPBUtil::checkString($var, True);
        $this->backup_id = $var;

        return $this;
    }

}

