<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/compute/v1/compute.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Compute\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Compute\V1\AbandonInstancesRegionInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\CreateInstancesRegionInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\DeleteInstancesRegionInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\DeletePerInstanceConfigsRegionInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\DeleteRegionInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\GetRegionInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\InsertRegionInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\InstanceGroupManager;
use Google\Cloud\Compute\V1\ListErrorsRegionInstanceGroupManagersRequest;
use Google\Cloud\Compute\V1\ListManagedInstancesRegionInstanceGroupManagersRequest;
use Google\Cloud\Compute\V1\ListPerInstanceConfigsRegionInstanceGroupManagersRequest;
use Google\Cloud\Compute\V1\ListRegionInstanceGroupManagersRequest;
use Google\Cloud\Compute\V1\PatchPerInstanceConfigsRegionInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\PatchRegionInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\RecreateInstancesRegionInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\RegionOperationsClient;
use Google\Cloud\Compute\V1\ResizeRegionInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\SetInstanceTemplateRegionInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\SetTargetPoolsRegionInstanceGroupManagerRequest;
use Google\Cloud\Compute\V1\UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: The RegionInstanceGroupManagers API.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * @method PromiseInterface abandonInstancesAsync(AbandonInstancesRegionInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface applyUpdatesToInstancesAsync(ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createInstancesAsync(CreateInstancesRegionInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteAsync(DeleteRegionInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteInstancesAsync(DeleteInstancesRegionInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deletePerInstanceConfigsAsync(DeletePerInstanceConfigsRegionInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getAsync(GetRegionInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface insertAsync(InsertRegionInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listAsync(ListRegionInstanceGroupManagersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listErrorsAsync(ListErrorsRegionInstanceGroupManagersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listManagedInstancesAsync(ListManagedInstancesRegionInstanceGroupManagersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listPerInstanceConfigsAsync(ListPerInstanceConfigsRegionInstanceGroupManagersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface patchAsync(PatchRegionInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface patchPerInstanceConfigsAsync(PatchPerInstanceConfigsRegionInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface recreateInstancesAsync(RecreateInstancesRegionInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface resizeAsync(ResizeRegionInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setInstanceTemplateAsync(SetInstanceTemplateRegionInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setTargetPoolsAsync(SetTargetPoolsRegionInstanceGroupManagerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updatePerInstanceConfigsAsync(UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest $request, array $optionalArgs = [])
 */
final class RegionInstanceGroupManagersClient
{
    use GapicClientTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.compute.v1.RegionInstanceGroupManagers';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'compute.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'compute.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/compute',
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/region_instance_group_managers_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/region_instance_group_managers_descriptor_config.php',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
                'useJwtAccessWithScope' => false,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/region_instance_group_managers_rest_client_config.php',
                ],
            ],
            'operationsClientClass' => RegionOperationsClient::class,
        ];
    }

    /** Implements GapicClientTrait::defaultTransport. */
    private static function defaultTransport()
    {
        return 'rest';
    }

    /** Implements GapicClientTrait::getSupportedTransports. */
    private static function getSupportedTransports()
    {
        return [
            'rest',
        ];
    }

    /**
     * Return an RegionOperationsClient object with the same endpoint as $this.
     *
     * @return RegionOperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /** Return the default longrunning operation descriptor config. */
    private function getDefaultOperationDescriptor()
    {
        return [
            'additionalArgumentMethods' => [
                'getProject',
                'getRegion',
            ],
            'getOperationMethod' => 'get',
            'cancelOperationMethod' => null,
            'deleteOperationMethod' => 'delete',
            'operationErrorCodeMethod' => 'getHttpErrorStatusCode',
            'operationErrorMessageMethod' => 'getHttpErrorMessage',
            'operationNameMethod' => 'getName',
            'operationStatusMethod' => 'getStatus',
            'operationStatusDoneValue' => \Google\Cloud\Compute\V1\Operation\Status::DONE,
        ];
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : $this->getDefaultOperationDescriptor();
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'compute.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. At the moment, supports only
     *           `rest`. *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\RestTransport::build()} method for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Flags the specified instances to be immediately removed from the managed instance group. Abandoning an instance does not delete the instance, but it does remove the instance from any target pools that are applied by the managed instance group. This method reduces the targetSize of the managed instance group by the number of instances that you abandon. This operation is marked as DONE when the action is scheduled even if the instances have not yet been removed from the group. You must separately verify the status of the abandoning action with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.
     *
     * The async variant is
     * {@see RegionInstanceGroupManagersClient::abandonInstancesAsync()} .
     *
     * @param AbandonInstancesRegionInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function abandonInstances(AbandonInstancesRegionInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('AbandonInstances', $request, $callOptions)->wait();
    }

    /**
     * Apply updates to selected instances the managed instance group.
     *
     * The async variant is
     * {@see RegionInstanceGroupManagersClient::applyUpdatesToInstancesAsync()} .
     *
     * @param ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function applyUpdatesToInstances(ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ApplyUpdatesToInstances', $request, $callOptions)->wait();
    }

    /**
     * Creates instances with per-instance configurations in this regional managed instance group. Instances are created using the current instance template. The create instances operation is marked DONE if the createInstances request is successful. The underlying actions take additional time. You must separately verify the status of the creating or actions with the listmanagedinstances method.
     *
     * The async variant is
     * {@see RegionInstanceGroupManagersClient::createInstancesAsync()} .
     *
     * @param CreateInstancesRegionInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createInstances(CreateInstancesRegionInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateInstances', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified managed instance group and all of the instances in that group.
     *
     * The async variant is {@see RegionInstanceGroupManagersClient::deleteAsync()} .
     *
     * @param DeleteRegionInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function delete(DeleteRegionInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('Delete', $request, $callOptions)->wait();
    }

    /**
     * Flags the specified instances in the managed instance group to be immediately deleted. The instances are also removed from any target pools of which they were a member. This method reduces the targetSize of the managed instance group by the number of instances that you delete. The deleteInstances operation is marked DONE if the deleteInstances request is successful. The underlying actions take additional time. You must separately verify the status of the deleting action with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.
     *
     * The async variant is
     * {@see RegionInstanceGroupManagersClient::deleteInstancesAsync()} .
     *
     * @param DeleteInstancesRegionInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteInstances(DeleteInstancesRegionInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteInstances', $request, $callOptions)->wait();
    }

    /**
     * Deletes selected per-instance configurations for the managed instance group.
     *
     * The async variant is
     * {@see RegionInstanceGroupManagersClient::deletePerInstanceConfigsAsync()} .
     *
     * @param DeletePerInstanceConfigsRegionInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deletePerInstanceConfigs(DeletePerInstanceConfigsRegionInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeletePerInstanceConfigs', $request, $callOptions)->wait();
    }

    /**
     * Returns all of the details about the specified managed instance group.
     *
     * The async variant is {@see RegionInstanceGroupManagersClient::getAsync()} .
     *
     * @param GetRegionInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return InstanceGroupManager
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function get(GetRegionInstanceGroupManagerRequest $request, array $callOptions = []): InstanceGroupManager
    {
        return $this->startApiCall('Get', $request, $callOptions)->wait();
    }

    /**
     * Creates a managed instance group using the information that you specify in the request. After the group is created, instances in the group are created using the specified instance template. This operation is marked as DONE when the group is created even if the instances in the group have not yet been created. You must separately verify the status of the individual instances with the listmanagedinstances method. A regional managed instance group can contain up to 2000 instances.
     *
     * The async variant is {@see RegionInstanceGroupManagersClient::insertAsync()} .
     *
     * @param InsertRegionInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function insert(InsertRegionInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('Insert', $request, $callOptions)->wait();
    }

    /**
     * Retrieves the list of managed instance groups that are contained within the specified region.
     *
     * The async variant is {@see RegionInstanceGroupManagersClient::listAsync()} .
     *
     * @param ListRegionInstanceGroupManagersRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function list(ListRegionInstanceGroupManagersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('List', $request, $callOptions);
    }

    /**
     * Lists all errors thrown by actions on instances for a given regional managed instance group. The filter and orderBy query parameters are not supported.
     *
     * The async variant is {@see RegionInstanceGroupManagersClient::listErrorsAsync()}
     * .
     *
     * @param ListErrorsRegionInstanceGroupManagersRequest $request     A request to house fields associated with the call.
     * @param array                                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listErrors(ListErrorsRegionInstanceGroupManagersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListErrors', $request, $callOptions);
    }

    /**
     * Lists the instances in the managed instance group and instances that are scheduled to be created. The list includes any current actions that the group has scheduled for its instances. The orderBy query parameter is not supported. The `pageToken` query parameter is supported only if the group's `listManagedInstancesResults` field is set to `PAGINATED`.
     *
     * The async variant is
     * {@see RegionInstanceGroupManagersClient::listManagedInstancesAsync()} .
     *
     * @param ListManagedInstancesRegionInstanceGroupManagersRequest $request     A request to house fields associated with the call.
     * @param array                                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listManagedInstances(ListManagedInstancesRegionInstanceGroupManagersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListManagedInstances', $request, $callOptions);
    }

    /**
     * Lists all of the per-instance configurations defined for the managed instance group. The orderBy query parameter is not supported.
     *
     * The async variant is
     * {@see RegionInstanceGroupManagersClient::listPerInstanceConfigsAsync()} .
     *
     * @param ListPerInstanceConfigsRegionInstanceGroupManagersRequest $request     A request to house fields associated with the call.
     * @param array                                                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPerInstanceConfigs(ListPerInstanceConfigsRegionInstanceGroupManagersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPerInstanceConfigs', $request, $callOptions);
    }

    /**
     * Updates a managed instance group using the information that you specify in the request. This operation is marked as DONE when the group is patched even if the instances in the group are still in the process of being patched. You must separately verify the status of the individual instances with the listmanagedinstances method. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. If you update your group to specify a new template or instance configuration, it's possible that your intended specification for each VM in the group is different from the current state of that VM. To learn how to apply an updated configuration to the VMs in a MIG, see Updating instances in a MIG.
     *
     * The async variant is {@see RegionInstanceGroupManagersClient::patchAsync()} .
     *
     * @param PatchRegionInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function patch(PatchRegionInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('Patch', $request, $callOptions)->wait();
    }

    /**
     * Inserts or patches per-instance configurations for the managed instance group. perInstanceConfig.name serves as a key used to distinguish whether to perform insert or patch.
     *
     * The async variant is
     * {@see RegionInstanceGroupManagersClient::patchPerInstanceConfigsAsync()} .
     *
     * @param PatchPerInstanceConfigsRegionInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function patchPerInstanceConfigs(PatchPerInstanceConfigsRegionInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('PatchPerInstanceConfigs', $request, $callOptions)->wait();
    }

    /**
     * Flags the specified VM instances in the managed instance group to be immediately recreated. Each instance is recreated using the group's current configuration. This operation is marked as DONE when the flag is set even if the instances have not yet been recreated. You must separately verify the status of each instance by checking its currentAction field; for more information, see Checking the status of managed instances. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.
     *
     * The async variant is
     * {@see RegionInstanceGroupManagersClient::recreateInstancesAsync()} .
     *
     * @param RecreateInstancesRegionInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function recreateInstances(RecreateInstancesRegionInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RecreateInstances', $request, $callOptions)->wait();
    }

    /**
     * Changes the intended size of the managed instance group. If you increase the size, the group creates new instances using the current instance template. If you decrease the size, the group deletes one or more instances. The resize operation is marked DONE if the resize request is successful. The underlying actions take additional time. You must separately verify the status of the creating or deleting actions with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.
     *
     * The async variant is {@see RegionInstanceGroupManagersClient::resizeAsync()} .
     *
     * @param ResizeRegionInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function resize(ResizeRegionInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('Resize', $request, $callOptions)->wait();
    }

    /**
     * Sets the instance template to use when creating new instances or recreating instances in this group. Existing instances are not affected.
     *
     * The async variant is
     * {@see RegionInstanceGroupManagersClient::setInstanceTemplateAsync()} .
     *
     * @param SetInstanceTemplateRegionInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setInstanceTemplate(SetInstanceTemplateRegionInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetInstanceTemplate', $request, $callOptions)->wait();
    }

    /**
     * Modifies the target pools to which all new instances in this group are assigned. Existing instances in the group are not affected.
     *
     * The async variant is
     * {@see RegionInstanceGroupManagersClient::setTargetPoolsAsync()} .
     *
     * @param SetTargetPoolsRegionInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setTargetPools(SetTargetPoolsRegionInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetTargetPools', $request, $callOptions)->wait();
    }

    /**
     * Inserts or updates per-instance configurations for the managed instance group. perInstanceConfig.name serves as a key used to distinguish whether to perform insert or patch.
     *
     * The async variant is
     * {@see RegionInstanceGroupManagersClient::updatePerInstanceConfigsAsync()} .
     *
     * @param UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest $request     A request to house fields associated with the call.
     * @param array                                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updatePerInstanceConfigs(UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdatePerInstanceConfigs', $request, $callOptions)->wait();
    }
}
