<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/bigquery/storage/v1/storage.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\BigQuery\Storage\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\BigQuery\Storage\V1\AppendRowsRequest;
use Google\Cloud\BigQuery\Storage\V1\AppendRowsResponse;
use Google\Cloud\BigQuery\Storage\V1\BatchCommitWriteStreamsRequest;
use Google\Cloud\BigQuery\Storage\V1\BatchCommitWriteStreamsResponse;
use Google\Cloud\BigQuery\Storage\V1\CreateWriteStreamRequest;
use Google\Cloud\BigQuery\Storage\V1\FinalizeWriteStreamRequest;
use Google\Cloud\BigQuery\Storage\V1\FinalizeWriteStreamResponse;
use Google\Cloud\BigQuery\Storage\V1\FlushRowsRequest;
use Google\Cloud\BigQuery\Storage\V1\FlushRowsResponse;
use Google\Cloud\BigQuery\Storage\V1\GetWriteStreamRequest;
use Google\Cloud\BigQuery\Storage\V1\WriteStream;
use Google\Protobuf\Int64Value;

/**
 * Service Description: BigQuery Write API.
 *
 * The Write API can be used to write data to BigQuery.
 *
 * For supplementary information about the Write API, see:
 * https://cloud.google.com/bigquery/docs/write-api
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $bigQueryWriteClient = new BigQueryWriteClient();
 * try {
 *     $writeStream = 'write_stream';
 *     $request = new AppendRowsRequest();
 *     $request->setWriteStream($writeStream);
 *     // Write all requests to the server, then read all responses until the
 *     // stream is complete
 *     $requests = [
 *         $request,
 *     ];
 *     $stream = $bigQueryWriteClient->appendRows();
 *     $stream->writeAll($requests);
 *     foreach ($stream->closeWriteAndReadAll() as $element) {
 *         // doSomethingWith($element);
 *     }
 *     // Alternatively:
 *     // Write requests individually, making read() calls if
 *     // required. Call closeWrite() once writes are complete, and read the
 *     // remaining responses from the server.
 *     $requests = [
 *         $request,
 *     ];
 *     $stream = $bigQueryWriteClient->appendRows();
 *     foreach ($requests as $request) {
 *         $stream->write($request);
 *         // if required, read a single response from the stream
 *         $element = $stream->read();
 *         // doSomethingWith($element)
 *     }
 *     $stream->closeWrite();
 *     $element = $stream->read();
 *     while (!is_null($element)) {
 *         // doSomethingWith($element)
 *         $element = $stream->read();
 *     }
 * } finally {
 *     $bigQueryWriteClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class BigQueryWriteGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.bigquery.storage.v1.BigQueryWrite';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'bigquerystorage.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/bigquery',
        'https://www.googleapis.com/auth/bigquery.insertdata',
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $tableNameTemplate;

    private static $writeStreamNameTemplate;

    private static $pathTemplateMap;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/big_query_write_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/big_query_write_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/big_query_write_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/big_query_write_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getTableNameTemplate()
    {
        if (self::$tableNameTemplate == null) {
            self::$tableNameTemplate = new PathTemplate(
                'projects/{project}/datasets/{dataset}/tables/{table}'
            );
        }

        return self::$tableNameTemplate;
    }

    private static function getWriteStreamNameTemplate()
    {
        if (self::$writeStreamNameTemplate == null) {
            self::$writeStreamNameTemplate = new PathTemplate(
                'projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}'
            );
        }

        return self::$writeStreamNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'table' => self::getTableNameTemplate(),
                'writeStream' => self::getWriteStreamNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a table
     * resource.
     *
     * @param string $project
     * @param string $dataset
     * @param string $table
     *
     * @return string The formatted table resource.
     */
    public static function tableName($project, $dataset, $table)
    {
        return self::getTableNameTemplate()->render([
            'project' => $project,
            'dataset' => $dataset,
            'table' => $table,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a write_stream
     * resource.
     *
     * @param string $project
     * @param string $dataset
     * @param string $table
     * @param string $stream
     *
     * @return string The formatted write_stream resource.
     */
    public static function writeStreamName($project, $dataset, $table, $stream)
    {
        return self::getWriteStreamNameTemplate()->render([
            'project' => $project,
            'dataset' => $dataset,
            'table' => $table,
            'stream' => $stream,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - table: projects/{project}/datasets/{dataset}/tables/{table}
     * - writeStream: projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'bigquerystorage.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Appends data to the given stream.
     *
     * If `offset` is specified, the `offset` is checked against the end of
     * stream. The server returns `OUT_OF_RANGE` in `AppendRowsResponse` if an
     * attempt is made to append to an offset beyond the current end of the stream
     * or `ALREADY_EXISTS` if user provides an `offset` that has already been
     * written to. User can retry with adjusted offset within the same RPC
     * connection. If `offset` is not specified, append happens at the end of the
     * stream.
     *
     * The response contains an optional offset at which the append
     * happened.  No offset information will be returned for appends to a
     * default stream.
     *
     * Responses are received in the same order in which requests are sent.
     * There will be one response for each successful inserted request.  Responses
     * may optionally embed error information if the originating AppendRequest was
     * not successfully processed.
     *
     * The specifics of when successfully appended data is made visible to the
     * table are governed by the type of stream:
     *
     * * For COMMITTED streams (which includes the default stream), data is
     * visible immediately upon successful append.
     *
     * * For BUFFERED streams, data is made visible via a subsequent `FlushRows`
     * rpc which advances a cursor to a newer offset in the stream.
     *
     * * For PENDING streams, data is not made visible until the stream itself is
     * finalized (via the `FinalizeWriteStream` rpc), and the stream is explicitly
     * committed via the `BatchCommitWriteStreams` rpc.
     *
     * Sample code:
     * ```
     * $bigQueryWriteClient = new BigQueryWriteClient();
     * try {
     *     $writeStream = 'write_stream';
     *     $request = new AppendRowsRequest();
     *     $request->setWriteStream($writeStream);
     *     // Write all requests to the server, then read all responses until the
     *     // stream is complete
     *     $requests = [
     *         $request,
     *     ];
     *     $stream = $bigQueryWriteClient->appendRows();
     *     $stream->writeAll($requests);
     *     foreach ($stream->closeWriteAndReadAll() as $element) {
     *         // doSomethingWith($element);
     *     }
     *     // Alternatively:
     *     // Write requests individually, making read() calls if
     *     // required. Call closeWrite() once writes are complete, and read the
     *     // remaining responses from the server.
     *     $requests = [
     *         $request,
     *     ];
     *     $stream = $bigQueryWriteClient->appendRows();
     *     foreach ($requests as $request) {
     *         $stream->write($request);
     *         // if required, read a single response from the stream
     *         $element = $stream->read();
     *         // doSomethingWith($element)
     *     }
     *     $stream->closeWrite();
     *     $element = $stream->read();
     *     while (!is_null($element)) {
     *         // doSomethingWith($element)
     *         $element = $stream->read();
     *     }
     * } finally {
     *     $bigQueryWriteClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type int $timeoutMillis
     *           Timeout to use for this call.
     * }
     *
     * @return \Google\ApiCore\BidiStream
     *
     * @throws ApiException if the remote call fails
     */
    public function appendRows(array $optionalArgs = [])
    {
        return $this->startCall(
            'AppendRows',
            AppendRowsResponse::class,
            $optionalArgs,
            null,
            Call::BIDI_STREAMING_CALL
        );
    }

    /**
     * Atomically commits a group of `PENDING` streams that belong to the same
     * `parent` table.
     *
     * Streams must be finalized before commit and cannot be committed multiple
     * times. Once a stream is committed, data in the stream becomes available
     * for read operations.
     *
     * Sample code:
     * ```
     * $bigQueryWriteClient = new BigQueryWriteClient();
     * try {
     *     $formattedParent = $bigQueryWriteClient->tableName('[PROJECT]', '[DATASET]', '[TABLE]');
     *     $writeStreams = [];
     *     $response = $bigQueryWriteClient->batchCommitWriteStreams($formattedParent, $writeStreams);
     * } finally {
     *     $bigQueryWriteClient->close();
     * }
     * ```
     *
     * @param string   $parent       Required. Parent table that all the streams should belong to, in the form
     *                               of `projects/{project}/datasets/{dataset}/tables/{table}`.
     * @param string[] $writeStreams Required. The group of streams that will be committed atomically.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BigQuery\Storage\V1\BatchCommitWriteStreamsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function batchCommitWriteStreams(
        $parent,
        $writeStreams,
        array $optionalArgs = []
    ) {
        $request = new BatchCommitWriteStreamsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setWriteStreams($writeStreams);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'BatchCommitWriteStreams',
            BatchCommitWriteStreamsResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a write stream to the given table.
     * Additionally, every table has a special stream named '_default'
     * to which data can be written. This stream doesn't need to be created using
     * CreateWriteStream. It is a stream that can be used simultaneously by any
     * number of clients. Data written to this stream is considered committed as
     * soon as an acknowledgement is received.
     *
     * Sample code:
     * ```
     * $bigQueryWriteClient = new BigQueryWriteClient();
     * try {
     *     $formattedParent = $bigQueryWriteClient->tableName('[PROJECT]', '[DATASET]', '[TABLE]');
     *     $writeStream = new WriteStream();
     *     $response = $bigQueryWriteClient->createWriteStream($formattedParent, $writeStream);
     * } finally {
     *     $bigQueryWriteClient->close();
     * }
     * ```
     *
     * @param string      $parent       Required. Reference to the table to which the stream belongs, in the format
     *                                  of `projects/{project}/datasets/{dataset}/tables/{table}`.
     * @param WriteStream $writeStream  Required. Stream to be created.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BigQuery\Storage\V1\WriteStream
     *
     * @throws ApiException if the remote call fails
     */
    public function createWriteStream(
        $parent,
        $writeStream,
        array $optionalArgs = []
    ) {
        $request = new CreateWriteStreamRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setWriteStream($writeStream);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateWriteStream',
            WriteStream::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Finalize a write stream so that no new data can be appended to the
     * stream. Finalize is not supported on the '_default' stream.
     *
     * Sample code:
     * ```
     * $bigQueryWriteClient = new BigQueryWriteClient();
     * try {
     *     $formattedName = $bigQueryWriteClient->writeStreamName('[PROJECT]', '[DATASET]', '[TABLE]', '[STREAM]');
     *     $response = $bigQueryWriteClient->finalizeWriteStream($formattedName);
     * } finally {
     *     $bigQueryWriteClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the stream to finalize, in the form of
     *                             `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BigQuery\Storage\V1\FinalizeWriteStreamResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function finalizeWriteStream($name, array $optionalArgs = [])
    {
        $request = new FinalizeWriteStreamRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'FinalizeWriteStream',
            FinalizeWriteStreamResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Flushes rows to a BUFFERED stream.
     *
     * If users are appending rows to BUFFERED stream, flush operation is
     * required in order for the rows to become available for reading. A
     * Flush operation flushes up to any previously flushed offset in a BUFFERED
     * stream, to the offset specified in the request.
     *
     * Flush is not supported on the _default stream, since it is not BUFFERED.
     *
     * Sample code:
     * ```
     * $bigQueryWriteClient = new BigQueryWriteClient();
     * try {
     *     $formattedWriteStream = $bigQueryWriteClient->writeStreamName('[PROJECT]', '[DATASET]', '[TABLE]', '[STREAM]');
     *     $response = $bigQueryWriteClient->flushRows($formattedWriteStream);
     * } finally {
     *     $bigQueryWriteClient->close();
     * }
     * ```
     *
     * @param string $writeStream  Required. The stream that is the target of the flush operation.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type Int64Value $offset
     *           Ending offset of the flush operation. Rows before this offset(including
     *           this offset) will be flushed.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BigQuery\Storage\V1\FlushRowsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function flushRows($writeStream, array $optionalArgs = [])
    {
        $request = new FlushRowsRequest();
        $requestParamHeaders = [];
        $request->setWriteStream($writeStream);
        $requestParamHeaders['write_stream'] = $writeStream;
        if (isset($optionalArgs['offset'])) {
            $request->setOffset($optionalArgs['offset']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'FlushRows',
            FlushRowsResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets information about a write stream.
     *
     * Sample code:
     * ```
     * $bigQueryWriteClient = new BigQueryWriteClient();
     * try {
     *     $formattedName = $bigQueryWriteClient->writeStreamName('[PROJECT]', '[DATASET]', '[TABLE]', '[STREAM]');
     *     $response = $bigQueryWriteClient->getWriteStream($formattedName);
     * } finally {
     *     $bigQueryWriteClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the stream to get, in the form of
     *                             `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $view
     *           Indicates whether to get full or partial view of the WriteStream. If
     *           not set, view returned will be basic.
     *           For allowed values, use constants defined on {@see \Google\Cloud\BigQuery\Storage\V1\WriteStreamView}
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BigQuery\Storage\V1\WriteStream
     *
     * @throws ApiException if the remote call fails
     */
    public function getWriteStream($name, array $optionalArgs = [])
    {
        $request = new GetWriteStreamRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['view'])) {
            $request->setView($optionalArgs['view']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetWriteStream',
            WriteStream::class,
            $optionalArgs,
            $request
        )->wait();
    }
}
