<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/securitycenter/v1/finding.proto

namespace Google\Cloud\SecurityCenter\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Security Command Center finding.
 * A finding is a record of assessment data like security, risk, health, or
 * privacy, that is ingested into Security Command Center for presentation,
 * notification, analysis, policy testing, and enforcement. For example, a
 * cross-site scripting (XSS) vulnerability in an App Engine application is a
 * finding.
 *
 * Generated from protobuf message <code>google.cloud.securitycenter.v1.Finding</code>
 */
class Finding extends \Google\Protobuf\Internal\Message
{
    /**
     * The relative resource name of this finding. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}"
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * The relative resource name of the source the finding belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * This field is immutable after creation time.
     * For example:
     * "organizations/{organization_id}/sources/{source_id}"
     *
     * Generated from protobuf field <code>string parent = 2;</code>
     */
    private $parent = '';
    /**
     * For findings on Google Cloud resources, the full resource
     * name of the Google Cloud resource this finding is for. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * When the finding is for a non-Google Cloud resource, the resourceName can
     * be a customer or partner defined string. This field is immutable after
     * creation time.
     *
     * Generated from protobuf field <code>string resource_name = 3;</code>
     */
    private $resource_name = '';
    /**
     * The state of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
     */
    private $state = 0;
    /**
     * The additional taxonomy group within findings from a given source.
     * This field is immutable after creation time.
     * Example: "XSS_FLASH_INJECTION"
     *
     * Generated from protobuf field <code>string category = 5;</code>
     */
    private $category = '';
    /**
     * The URI that, if available, points to a web page outside of Security
     * Command Center where additional information about the finding can be found.
     * This field is guaranteed to be either empty or a well formed URL.
     *
     * Generated from protobuf field <code>string external_uri = 6;</code>
     */
    private $external_uri = '';
    /**
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> source_properties = 7;</code>
     */
    private $source_properties;
    /**
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $security_marks = null;
    /**
     * The time at which the event took place, or when an update to the finding
     * occurred. For example, if the finding represents an open firewall it would
     * capture the time the detector believes the firewall became open. The
     * accuracy is determined by the detector. If the finding were to be resolved
     * afterward, this time would reflect when the finding was resolved. Must not
     * be set to a value greater than the current timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 9;</code>
     */
    private $event_time = null;
    /**
     * The time at which the finding was created in Security Command Center.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    private $create_time = null;
    /**
     * The severity of the finding. This field is managed by the source that
     * writes the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.Severity severity = 12;</code>
     */
    private $severity = 0;
    /**
     * The canonical name of the finding. It's either
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
     * "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
     * depending on the closest CRM ancestor of the resource associated with the
     * finding.
     *
     * Generated from protobuf field <code>string canonical_name = 14;</code>
     */
    private $canonical_name = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The relative resource name of this finding. See:
     *           https://cloud.google.com/apis/design/resource_names#relative_resource_name
     *           Example:
     *           "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}"
     *     @type string $parent
     *           The relative resource name of the source the finding belongs to. See:
     *           https://cloud.google.com/apis/design/resource_names#relative_resource_name
     *           This field is immutable after creation time.
     *           For example:
     *           "organizations/{organization_id}/sources/{source_id}"
     *     @type string $resource_name
     *           For findings on Google Cloud resources, the full resource
     *           name of the Google Cloud resource this finding is for. See:
     *           https://cloud.google.com/apis/design/resource_names#full_resource_name
     *           When the finding is for a non-Google Cloud resource, the resourceName can
     *           be a customer or partner defined string. This field is immutable after
     *           creation time.
     *     @type int $state
     *           The state of the finding.
     *     @type string $category
     *           The additional taxonomy group within findings from a given source.
     *           This field is immutable after creation time.
     *           Example: "XSS_FLASH_INJECTION"
     *     @type string $external_uri
     *           The URI that, if available, points to a web page outside of Security
     *           Command Center where additional information about the finding can be found.
     *           This field is guaranteed to be either empty or a well formed URL.
     *     @type array|\Google\Protobuf\Internal\MapField $source_properties
     *           Source specific properties. These properties are managed by the source
     *           that writes the finding. The key names in the source_properties map must be
     *           between 1 and 255 characters, and must start with a letter and contain
     *           alphanumeric characters or underscores only.
     *     @type \Google\Cloud\SecurityCenter\V1\SecurityMarks $security_marks
     *           Output only. User specified security marks. These marks are entirely
     *           managed by the user and come from the SecurityMarks resource that belongs
     *           to the finding.
     *     @type \Google\Protobuf\Timestamp $event_time
     *           The time at which the event took place, or when an update to the finding
     *           occurred. For example, if the finding represents an open firewall it would
     *           capture the time the detector believes the firewall became open. The
     *           accuracy is determined by the detector. If the finding were to be resolved
     *           afterward, this time would reflect when the finding was resolved. Must not
     *           be set to a value greater than the current timestamp.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           The time at which the finding was created in Security Command Center.
     *     @type int $severity
     *           The severity of the finding. This field is managed by the source that
     *           writes the finding.
     *     @type string $canonical_name
     *           The canonical name of the finding. It's either
     *           "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     *           "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
     *           "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
     *           depending on the closest CRM ancestor of the resource associated with the
     *           finding.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Securitycenter\V1\Finding::initOnce();
        parent::__construct($data);
    }

    /**
     * The relative resource name of this finding. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}"
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The relative resource name of this finding. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}"
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The relative resource name of the source the finding belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * This field is immutable after creation time.
     * For example:
     * "organizations/{organization_id}/sources/{source_id}"
     *
     * Generated from protobuf field <code>string parent = 2;</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * The relative resource name of the source the finding belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * This field is immutable after creation time.
     * For example:
     * "organizations/{organization_id}/sources/{source_id}"
     *
     * Generated from protobuf field <code>string parent = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * For findings on Google Cloud resources, the full resource
     * name of the Google Cloud resource this finding is for. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * When the finding is for a non-Google Cloud resource, the resourceName can
     * be a customer or partner defined string. This field is immutable after
     * creation time.
     *
     * Generated from protobuf field <code>string resource_name = 3;</code>
     * @return string
     */
    public function getResourceName()
    {
        return $this->resource_name;
    }

    /**
     * For findings on Google Cloud resources, the full resource
     * name of the Google Cloud resource this finding is for. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * When the finding is for a non-Google Cloud resource, the resourceName can
     * be a customer or partner defined string. This field is immutable after
     * creation time.
     *
     * Generated from protobuf field <code>string resource_name = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setResourceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource_name = $var;

        return $this;
    }

    /**
     * The state of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * The state of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\SecurityCenter\V1\Finding\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * The additional taxonomy group within findings from a given source.
     * This field is immutable after creation time.
     * Example: "XSS_FLASH_INJECTION"
     *
     * Generated from protobuf field <code>string category = 5;</code>
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }

    /**
     * The additional taxonomy group within findings from a given source.
     * This field is immutable after creation time.
     * Example: "XSS_FLASH_INJECTION"
     *
     * Generated from protobuf field <code>string category = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setCategory($var)
    {
        GPBUtil::checkString($var, True);
        $this->category = $var;

        return $this;
    }

    /**
     * The URI that, if available, points to a web page outside of Security
     * Command Center where additional information about the finding can be found.
     * This field is guaranteed to be either empty or a well formed URL.
     *
     * Generated from protobuf field <code>string external_uri = 6;</code>
     * @return string
     */
    public function getExternalUri()
    {
        return $this->external_uri;
    }

    /**
     * The URI that, if available, points to a web page outside of Security
     * Command Center where additional information about the finding can be found.
     * This field is guaranteed to be either empty or a well formed URL.
     *
     * Generated from protobuf field <code>string external_uri = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setExternalUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->external_uri = $var;

        return $this;
    }

    /**
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> source_properties = 7;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getSourceProperties()
    {
        return $this->source_properties;
    }

    /**
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> source_properties = 7;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setSourceProperties($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Protobuf\Value::class);
        $this->source_properties = $arr;

        return $this;
    }

    /**
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\SecurityCenter\V1\SecurityMarks|null
     */
    public function getSecurityMarks()
    {
        return isset($this->security_marks) ? $this->security_marks : null;
    }

    public function hasSecurityMarks()
    {
        return isset($this->security_marks);
    }

    public function clearSecurityMarks()
    {
        unset($this->security_marks);
    }

    /**
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\SecurityCenter\V1\SecurityMarks $var
     * @return $this
     */
    public function setSecurityMarks($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\SecurityMarks::class);
        $this->security_marks = $var;

        return $this;
    }

    /**
     * The time at which the event took place, or when an update to the finding
     * occurred. For example, if the finding represents an open firewall it would
     * capture the time the detector believes the firewall became open. The
     * accuracy is determined by the detector. If the finding were to be resolved
     * afterward, this time would reflect when the finding was resolved. Must not
     * be set to a value greater than the current timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 9;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEventTime()
    {
        return isset($this->event_time) ? $this->event_time : null;
    }

    public function hasEventTime()
    {
        return isset($this->event_time);
    }

    public function clearEventTime()
    {
        unset($this->event_time);
    }

    /**
     * The time at which the event took place, or when an update to the finding
     * occurred. For example, if the finding represents an open firewall it would
     * capture the time the detector believes the firewall became open. The
     * accuracy is determined by the detector. If the finding were to be resolved
     * afterward, this time would reflect when the finding was resolved. Must not
     * be set to a value greater than the current timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 9;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEventTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->event_time = $var;

        return $this;
    }

    /**
     * The time at which the finding was created in Security Command Center.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 10;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return isset($this->create_time) ? $this->create_time : null;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * The time at which the finding was created in Security Command Center.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 10;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * The severity of the finding. This field is managed by the source that
     * writes the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.Severity severity = 12;</code>
     * @return int
     */
    public function getSeverity()
    {
        return $this->severity;
    }

    /**
     * The severity of the finding. This field is managed by the source that
     * writes the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.Severity severity = 12;</code>
     * @param int $var
     * @return $this
     */
    public function setSeverity($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\SecurityCenter\V1\Finding\Severity::class);
        $this->severity = $var;

        return $this;
    }

    /**
     * The canonical name of the finding. It's either
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
     * "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
     * depending on the closest CRM ancestor of the resource associated with the
     * finding.
     *
     * Generated from protobuf field <code>string canonical_name = 14;</code>
     * @return string
     */
    public function getCanonicalName()
    {
        return $this->canonical_name;
    }

    /**
     * The canonical name of the finding. It's either
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
     * "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
     * depending on the closest CRM ancestor of the resource associated with the
     * finding.
     *
     * Generated from protobuf field <code>string canonical_name = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setCanonicalName($var)
    {
        GPBUtil::checkString($var, True);
        $this->canonical_name = $var;

        return $this;
    }

}

