<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/networkservices/v1/network_services.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\NetworkServices\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\Cloud\NetworkServices\V1\CreateEndpointPolicyRequest;
use Google\Cloud\NetworkServices\V1\CreateGatewayRequest;
use Google\Cloud\NetworkServices\V1\CreateGrpcRouteRequest;
use Google\Cloud\NetworkServices\V1\CreateHttpRouteRequest;
use Google\Cloud\NetworkServices\V1\CreateMeshRequest;
use Google\Cloud\NetworkServices\V1\CreateServiceBindingRequest;
use Google\Cloud\NetworkServices\V1\CreateTcpRouteRequest;
use Google\Cloud\NetworkServices\V1\CreateTlsRouteRequest;
use Google\Cloud\NetworkServices\V1\DeleteEndpointPolicyRequest;
use Google\Cloud\NetworkServices\V1\DeleteGatewayRequest;
use Google\Cloud\NetworkServices\V1\DeleteGrpcRouteRequest;
use Google\Cloud\NetworkServices\V1\DeleteHttpRouteRequest;
use Google\Cloud\NetworkServices\V1\DeleteMeshRequest;
use Google\Cloud\NetworkServices\V1\DeleteServiceBindingRequest;
use Google\Cloud\NetworkServices\V1\DeleteTcpRouteRequest;
use Google\Cloud\NetworkServices\V1\DeleteTlsRouteRequest;
use Google\Cloud\NetworkServices\V1\EndpointPolicy;
use Google\Cloud\NetworkServices\V1\Gateway;
use Google\Cloud\NetworkServices\V1\GetEndpointPolicyRequest;
use Google\Cloud\NetworkServices\V1\GetGatewayRequest;
use Google\Cloud\NetworkServices\V1\GetGrpcRouteRequest;
use Google\Cloud\NetworkServices\V1\GetHttpRouteRequest;
use Google\Cloud\NetworkServices\V1\GetMeshRequest;
use Google\Cloud\NetworkServices\V1\GetServiceBindingRequest;
use Google\Cloud\NetworkServices\V1\GetTcpRouteRequest;
use Google\Cloud\NetworkServices\V1\GetTlsRouteRequest;
use Google\Cloud\NetworkServices\V1\GrpcRoute;
use Google\Cloud\NetworkServices\V1\HttpRoute;
use Google\Cloud\NetworkServices\V1\ListEndpointPoliciesRequest;
use Google\Cloud\NetworkServices\V1\ListEndpointPoliciesResponse;
use Google\Cloud\NetworkServices\V1\ListGatewaysRequest;
use Google\Cloud\NetworkServices\V1\ListGatewaysResponse;
use Google\Cloud\NetworkServices\V1\ListGrpcRoutesRequest;
use Google\Cloud\NetworkServices\V1\ListGrpcRoutesResponse;
use Google\Cloud\NetworkServices\V1\ListHttpRoutesRequest;
use Google\Cloud\NetworkServices\V1\ListHttpRoutesResponse;
use Google\Cloud\NetworkServices\V1\ListMeshesRequest;
use Google\Cloud\NetworkServices\V1\ListMeshesResponse;
use Google\Cloud\NetworkServices\V1\ListServiceBindingsRequest;
use Google\Cloud\NetworkServices\V1\ListServiceBindingsResponse;
use Google\Cloud\NetworkServices\V1\ListTcpRoutesRequest;
use Google\Cloud\NetworkServices\V1\ListTcpRoutesResponse;
use Google\Cloud\NetworkServices\V1\ListTlsRoutesRequest;
use Google\Cloud\NetworkServices\V1\ListTlsRoutesResponse;
use Google\Cloud\NetworkServices\V1\Mesh;
use Google\Cloud\NetworkServices\V1\ServiceBinding;
use Google\Cloud\NetworkServices\V1\TcpRoute;
use Google\Cloud\NetworkServices\V1\TlsRoute;
use Google\Cloud\NetworkServices\V1\UpdateEndpointPolicyRequest;
use Google\Cloud\NetworkServices\V1\UpdateGatewayRequest;
use Google\Cloud\NetworkServices\V1\UpdateGrpcRouteRequest;
use Google\Cloud\NetworkServices\V1\UpdateHttpRouteRequest;
use Google\Cloud\NetworkServices\V1\UpdateMeshRequest;
use Google\Cloud\NetworkServices\V1\UpdateTcpRouteRequest;
use Google\Cloud\NetworkServices\V1\UpdateTlsRouteRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: Service describing handlers for resources.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $networkServicesClient = new NetworkServicesClient();
 * try {
 *     $formattedParent = $networkServicesClient->locationName('[PROJECT]', '[LOCATION]');
 *     $endpointPolicyId = 'endpoint_policy_id';
 *     $endpointPolicy = new EndpointPolicy();
 *     $operationResponse = $networkServicesClient->createEndpointPolicy($formattedParent, $endpointPolicyId, $endpointPolicy);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $networkServicesClient->createEndpointPolicy($formattedParent, $endpointPolicyId, $endpointPolicy);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'createEndpointPolicy');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $networkServicesClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @deprecated This class will be removed in the next major version update.
 */
class NetworkServicesGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.networkservices.v1.NetworkServices';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    const SERVICE_ADDRESS = 'networkservices.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'networkservices.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $authorizationPolicyNameTemplate;

    private static $backendServiceNameTemplate;

    private static $clientTlsPolicyNameTemplate;

    private static $endpointPolicyNameTemplate;

    private static $gatewayNameTemplate;

    private static $grpcRouteNameTemplate;

    private static $httpRouteNameTemplate;

    private static $locationNameTemplate;

    private static $meshNameTemplate;

    private static $serverTlsPolicyNameTemplate;

    private static $serviceBindingNameTemplate;

    private static $tcpRouteNameTemplate;

    private static $tlsRouteNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/network_services_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/network_services_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/network_services_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/network_services_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getAuthorizationPolicyNameTemplate()
    {
        if (self::$authorizationPolicyNameTemplate == null) {
            self::$authorizationPolicyNameTemplate = new PathTemplate('projects/{project}/locations/{location}/authorizationPolicies/{authorization_policy}');
        }

        return self::$authorizationPolicyNameTemplate;
    }

    private static function getBackendServiceNameTemplate()
    {
        if (self::$backendServiceNameTemplate == null) {
            self::$backendServiceNameTemplate = new PathTemplate('projects/{project}/locations/{location}/backendServices/{backend_service}');
        }

        return self::$backendServiceNameTemplate;
    }

    private static function getClientTlsPolicyNameTemplate()
    {
        if (self::$clientTlsPolicyNameTemplate == null) {
            self::$clientTlsPolicyNameTemplate = new PathTemplate('projects/{project}/locations/{location}/clientTlsPolicies/{client_tls_policy}');
        }

        return self::$clientTlsPolicyNameTemplate;
    }

    private static function getEndpointPolicyNameTemplate()
    {
        if (self::$endpointPolicyNameTemplate == null) {
            self::$endpointPolicyNameTemplate = new PathTemplate('projects/{project}/locations/{location}/endpointPolicies/{endpoint_policy}');
        }

        return self::$endpointPolicyNameTemplate;
    }

    private static function getGatewayNameTemplate()
    {
        if (self::$gatewayNameTemplate == null) {
            self::$gatewayNameTemplate = new PathTemplate('projects/{project}/locations/{location}/gateways/{gateway}');
        }

        return self::$gatewayNameTemplate;
    }

    private static function getGrpcRouteNameTemplate()
    {
        if (self::$grpcRouteNameTemplate == null) {
            self::$grpcRouteNameTemplate = new PathTemplate('projects/{project}/locations/{location}/grpcRoutes/{grpc_route}');
        }

        return self::$grpcRouteNameTemplate;
    }

    private static function getHttpRouteNameTemplate()
    {
        if (self::$httpRouteNameTemplate == null) {
            self::$httpRouteNameTemplate = new PathTemplate('projects/{project}/locations/{location}/httpRoutes/{http_route}');
        }

        return self::$httpRouteNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate('projects/{project}/locations/{location}');
        }

        return self::$locationNameTemplate;
    }

    private static function getMeshNameTemplate()
    {
        if (self::$meshNameTemplate == null) {
            self::$meshNameTemplate = new PathTemplate('projects/{project}/locations/{location}/meshes/{mesh}');
        }

        return self::$meshNameTemplate;
    }

    private static function getServerTlsPolicyNameTemplate()
    {
        if (self::$serverTlsPolicyNameTemplate == null) {
            self::$serverTlsPolicyNameTemplate = new PathTemplate('projects/{project}/locations/{location}/serverTlsPolicies/{server_tls_policy}');
        }

        return self::$serverTlsPolicyNameTemplate;
    }

    private static function getServiceBindingNameTemplate()
    {
        if (self::$serviceBindingNameTemplate == null) {
            self::$serviceBindingNameTemplate = new PathTemplate('projects/{project}/locations/{location}/serviceBindings/{service_binding}');
        }

        return self::$serviceBindingNameTemplate;
    }

    private static function getTcpRouteNameTemplate()
    {
        if (self::$tcpRouteNameTemplate == null) {
            self::$tcpRouteNameTemplate = new PathTemplate('projects/{project}/locations/{location}/tcpRoutes/{tcp_route}');
        }

        return self::$tcpRouteNameTemplate;
    }

    private static function getTlsRouteNameTemplate()
    {
        if (self::$tlsRouteNameTemplate == null) {
            self::$tlsRouteNameTemplate = new PathTemplate('projects/{project}/locations/{location}/tlsRoutes/{tls_route}');
        }

        return self::$tlsRouteNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'authorizationPolicy' => self::getAuthorizationPolicyNameTemplate(),
                'backendService' => self::getBackendServiceNameTemplate(),
                'clientTlsPolicy' => self::getClientTlsPolicyNameTemplate(),
                'endpointPolicy' => self::getEndpointPolicyNameTemplate(),
                'gateway' => self::getGatewayNameTemplate(),
                'grpcRoute' => self::getGrpcRouteNameTemplate(),
                'httpRoute' => self::getHttpRouteNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'mesh' => self::getMeshNameTemplate(),
                'serverTlsPolicy' => self::getServerTlsPolicyNameTemplate(),
                'serviceBinding' => self::getServiceBindingNameTemplate(),
                'tcpRoute' => self::getTcpRouteNameTemplate(),
                'tlsRoute' => self::getTlsRouteNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * authorization_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $authorizationPolicy
     *
     * @return string The formatted authorization_policy resource.
     */
    public static function authorizationPolicyName($project, $location, $authorizationPolicy)
    {
        return self::getAuthorizationPolicyNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'authorization_policy' => $authorizationPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * backend_service resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backendService
     *
     * @return string The formatted backend_service resource.
     */
    public static function backendServiceName($project, $location, $backendService)
    {
        return self::getBackendServiceNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'backend_service' => $backendService,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * client_tls_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $clientTlsPolicy
     *
     * @return string The formatted client_tls_policy resource.
     */
    public static function clientTlsPolicyName($project, $location, $clientTlsPolicy)
    {
        return self::getClientTlsPolicyNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'client_tls_policy' => $clientTlsPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * endpoint_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $endpointPolicy
     *
     * @return string The formatted endpoint_policy resource.
     */
    public static function endpointPolicyName($project, $location, $endpointPolicy)
    {
        return self::getEndpointPolicyNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'endpoint_policy' => $endpointPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a gateway
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $gateway
     *
     * @return string The formatted gateway resource.
     */
    public static function gatewayName($project, $location, $gateway)
    {
        return self::getGatewayNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'gateway' => $gateway,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a grpc_route
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $grpcRoute
     *
     * @return string The formatted grpc_route resource.
     */
    public static function grpcRouteName($project, $location, $grpcRoute)
    {
        return self::getGrpcRouteNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'grpc_route' => $grpcRoute,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a http_route
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $httpRoute
     *
     * @return string The formatted http_route resource.
     */
    public static function httpRouteName($project, $location, $httpRoute)
    {
        return self::getHttpRouteNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'http_route' => $httpRoute,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a mesh
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $mesh
     *
     * @return string The formatted mesh resource.
     */
    public static function meshName($project, $location, $mesh)
    {
        return self::getMeshNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'mesh' => $mesh,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * server_tls_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $serverTlsPolicy
     *
     * @return string The formatted server_tls_policy resource.
     */
    public static function serverTlsPolicyName($project, $location, $serverTlsPolicy)
    {
        return self::getServerTlsPolicyNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'server_tls_policy' => $serverTlsPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * service_binding resource.
     *
     * @param string $project
     * @param string $location
     * @param string $serviceBinding
     *
     * @return string The formatted service_binding resource.
     */
    public static function serviceBindingName($project, $location, $serviceBinding)
    {
        return self::getServiceBindingNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'service_binding' => $serviceBinding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a tcp_route
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tcpRoute
     *
     * @return string The formatted tcp_route resource.
     */
    public static function tcpRouteName($project, $location, $tcpRoute)
    {
        return self::getTcpRouteNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'tcp_route' => $tcpRoute,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a tls_route
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tlsRoute
     *
     * @return string The formatted tls_route resource.
     */
    public static function tlsRouteName($project, $location, $tlsRoute)
    {
        return self::getTlsRouteNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'tls_route' => $tlsRoute,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - authorizationPolicy: projects/{project}/locations/{location}/authorizationPolicies/{authorization_policy}
     * - backendService: projects/{project}/locations/{location}/backendServices/{backend_service}
     * - clientTlsPolicy: projects/{project}/locations/{location}/clientTlsPolicies/{client_tls_policy}
     * - endpointPolicy: projects/{project}/locations/{location}/endpointPolicies/{endpoint_policy}
     * - gateway: projects/{project}/locations/{location}/gateways/{gateway}
     * - grpcRoute: projects/{project}/locations/{location}/grpcRoutes/{grpc_route}
     * - httpRoute: projects/{project}/locations/{location}/httpRoutes/{http_route}
     * - location: projects/{project}/locations/{location}
     * - mesh: projects/{project}/locations/{location}/meshes/{mesh}
     * - serverTlsPolicy: projects/{project}/locations/{location}/serverTlsPolicies/{server_tls_policy}
     * - serviceBinding: projects/{project}/locations/{location}/serviceBindings/{service_binding}
     * - tcpRoute: projects/{project}/locations/{location}/tcpRoutes/{tcp_route}
     * - tlsRoute: projects/{project}/locations/{location}/tlsRoutes/{tls_route}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'networkservices.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a new EndpointPolicy in a given project and location.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedParent = $networkServicesClient->locationName('[PROJECT]', '[LOCATION]');
     *     $endpointPolicyId = 'endpoint_policy_id';
     *     $endpointPolicy = new EndpointPolicy();
     *     $operationResponse = $networkServicesClient->createEndpointPolicy($formattedParent, $endpointPolicyId, $endpointPolicy);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->createEndpointPolicy($formattedParent, $endpointPolicyId, $endpointPolicy);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'createEndpointPolicy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string         $parent           Required. The parent resource of the EndpointPolicy. Must be in the
     *                                         format `projects/&#42;/locations/global`.
     * @param string         $endpointPolicyId Required. Short name of the EndpointPolicy resource to be created.
     *                                         E.g. "CustomECS".
     * @param EndpointPolicy $endpointPolicy   Required. EndpointPolicy resource to be created.
     * @param array          $optionalArgs     {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createEndpointPolicy($parent, $endpointPolicyId, $endpointPolicy, array $optionalArgs = [])
    {
        $request = new CreateEndpointPolicyRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setEndpointPolicyId($endpointPolicyId);
        $request->setEndpointPolicy($endpointPolicy);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateEndpointPolicy', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new Gateway in a given project and location.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedParent = $networkServicesClient->locationName('[PROJECT]', '[LOCATION]');
     *     $gatewayId = 'gateway_id';
     *     $gateway = new Gateway();
     *     $operationResponse = $networkServicesClient->createGateway($formattedParent, $gatewayId, $gateway);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->createGateway($formattedParent, $gatewayId, $gateway);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'createGateway');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string  $parent       Required. The parent resource of the Gateway. Must be in the
     *                              format `projects/&#42;/locations/*`.
     * @param string  $gatewayId    Required. Short name of the Gateway resource to be created.
     * @param Gateway $gateway      Required. Gateway resource to be created.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createGateway($parent, $gatewayId, $gateway, array $optionalArgs = [])
    {
        $request = new CreateGatewayRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setGatewayId($gatewayId);
        $request->setGateway($gateway);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateGateway', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new GrpcRoute in a given project and location.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedParent = $networkServicesClient->locationName('[PROJECT]', '[LOCATION]');
     *     $grpcRouteId = 'grpc_route_id';
     *     $grpcRoute = new GrpcRoute();
     *     $operationResponse = $networkServicesClient->createGrpcRoute($formattedParent, $grpcRouteId, $grpcRoute);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->createGrpcRoute($formattedParent, $grpcRouteId, $grpcRoute);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'createGrpcRoute');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string    $parent       Required. The parent resource of the GrpcRoute. Must be in the
     *                                format `projects/&#42;/locations/global`.
     * @param string    $grpcRouteId  Required. Short name of the GrpcRoute resource to be created.
     * @param GrpcRoute $grpcRoute    Required. GrpcRoute resource to be created.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createGrpcRoute($parent, $grpcRouteId, $grpcRoute, array $optionalArgs = [])
    {
        $request = new CreateGrpcRouteRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setGrpcRouteId($grpcRouteId);
        $request->setGrpcRoute($grpcRoute);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateGrpcRoute', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new HttpRoute in a given project and location.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedParent = $networkServicesClient->locationName('[PROJECT]', '[LOCATION]');
     *     $httpRouteId = 'http_route_id';
     *     $httpRoute = new HttpRoute();
     *     $operationResponse = $networkServicesClient->createHttpRoute($formattedParent, $httpRouteId, $httpRoute);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->createHttpRoute($formattedParent, $httpRouteId, $httpRoute);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'createHttpRoute');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string    $parent       Required. The parent resource of the HttpRoute. Must be in the
     *                                format `projects/&#42;/locations/global`.
     * @param string    $httpRouteId  Required. Short name of the HttpRoute resource to be created.
     * @param HttpRoute $httpRoute    Required. HttpRoute resource to be created.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createHttpRoute($parent, $httpRouteId, $httpRoute, array $optionalArgs = [])
    {
        $request = new CreateHttpRouteRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setHttpRouteId($httpRouteId);
        $request->setHttpRoute($httpRoute);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateHttpRoute', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new Mesh in a given project and location.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedParent = $networkServicesClient->locationName('[PROJECT]', '[LOCATION]');
     *     $meshId = 'mesh_id';
     *     $mesh = new Mesh();
     *     $operationResponse = $networkServicesClient->createMesh($formattedParent, $meshId, $mesh);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->createMesh($formattedParent, $meshId, $mesh);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'createMesh');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource of the Mesh. Must be in the
     *                             format `projects/&#42;/locations/global`.
     * @param string $meshId       Required. Short name of the Mesh resource to be created.
     * @param Mesh   $mesh         Required. Mesh resource to be created.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createMesh($parent, $meshId, $mesh, array $optionalArgs = [])
    {
        $request = new CreateMeshRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setMeshId($meshId);
        $request->setMesh($mesh);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateMesh', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new ServiceBinding in a given project and location.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedParent = $networkServicesClient->locationName('[PROJECT]', '[LOCATION]');
     *     $serviceBindingId = 'service_binding_id';
     *     $serviceBinding = new ServiceBinding();
     *     $operationResponse = $networkServicesClient->createServiceBinding($formattedParent, $serviceBindingId, $serviceBinding);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->createServiceBinding($formattedParent, $serviceBindingId, $serviceBinding);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'createServiceBinding');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string         $parent           Required. The parent resource of the ServiceBinding. Must be in the
     *                                         format `projects/&#42;/locations/global`.
     * @param string         $serviceBindingId Required. Short name of the ServiceBinding resource to be created.
     * @param ServiceBinding $serviceBinding   Required. ServiceBinding resource to be created.
     * @param array          $optionalArgs     {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createServiceBinding($parent, $serviceBindingId, $serviceBinding, array $optionalArgs = [])
    {
        $request = new CreateServiceBindingRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setServiceBindingId($serviceBindingId);
        $request->setServiceBinding($serviceBinding);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateServiceBinding', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new TcpRoute in a given project and location.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedParent = $networkServicesClient->locationName('[PROJECT]', '[LOCATION]');
     *     $tcpRouteId = 'tcp_route_id';
     *     $tcpRoute = new TcpRoute();
     *     $operationResponse = $networkServicesClient->createTcpRoute($formattedParent, $tcpRouteId, $tcpRoute);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->createTcpRoute($formattedParent, $tcpRouteId, $tcpRoute);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'createTcpRoute');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string   $parent       Required. The parent resource of the TcpRoute. Must be in the
     *                               format `projects/&#42;/locations/global`.
     * @param string   $tcpRouteId   Required. Short name of the TcpRoute resource to be created.
     * @param TcpRoute $tcpRoute     Required. TcpRoute resource to be created.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createTcpRoute($parent, $tcpRouteId, $tcpRoute, array $optionalArgs = [])
    {
        $request = new CreateTcpRouteRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setTcpRouteId($tcpRouteId);
        $request->setTcpRoute($tcpRoute);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateTcpRoute', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new TlsRoute in a given project and location.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedParent = $networkServicesClient->locationName('[PROJECT]', '[LOCATION]');
     *     $tlsRouteId = 'tls_route_id';
     *     $tlsRoute = new TlsRoute();
     *     $operationResponse = $networkServicesClient->createTlsRoute($formattedParent, $tlsRouteId, $tlsRoute);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->createTlsRoute($formattedParent, $tlsRouteId, $tlsRoute);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'createTlsRoute');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string   $parent       Required. The parent resource of the TlsRoute. Must be in the
     *                               format `projects/&#42;/locations/global`.
     * @param string   $tlsRouteId   Required. Short name of the TlsRoute resource to be created.
     * @param TlsRoute $tlsRoute     Required. TlsRoute resource to be created.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createTlsRoute($parent, $tlsRouteId, $tlsRoute, array $optionalArgs = [])
    {
        $request = new CreateTlsRouteRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setTlsRouteId($tlsRouteId);
        $request->setTlsRoute($tlsRoute);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateTlsRoute', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single EndpointPolicy.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedName = $networkServicesClient->endpointPolicyName('[PROJECT]', '[LOCATION]', '[ENDPOINT_POLICY]');
     *     $operationResponse = $networkServicesClient->deleteEndpointPolicy($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->deleteEndpointPolicy($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'deleteEndpointPolicy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the EndpointPolicy to delete. Must be in the format
     *                             `projects/&#42;/locations/global/endpointPolicies/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteEndpointPolicy($name, array $optionalArgs = [])
    {
        $request = new DeleteEndpointPolicyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteEndpointPolicy', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single Gateway.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedName = $networkServicesClient->gatewayName('[PROJECT]', '[LOCATION]', '[GATEWAY]');
     *     $operationResponse = $networkServicesClient->deleteGateway($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->deleteGateway($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'deleteGateway');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the Gateway to delete. Must be in the format
     *                             `projects/&#42;/locations/&#42;/gateways/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteGateway($name, array $optionalArgs = [])
    {
        $request = new DeleteGatewayRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteGateway', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single GrpcRoute.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedName = $networkServicesClient->grpcRouteName('[PROJECT]', '[LOCATION]', '[GRPC_ROUTE]');
     *     $operationResponse = $networkServicesClient->deleteGrpcRoute($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->deleteGrpcRoute($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'deleteGrpcRoute');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the GrpcRoute to delete. Must be in the format
     *                             `projects/&#42;/locations/global/grpcRoutes/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteGrpcRoute($name, array $optionalArgs = [])
    {
        $request = new DeleteGrpcRouteRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteGrpcRoute', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single HttpRoute.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedName = $networkServicesClient->httpRouteName('[PROJECT]', '[LOCATION]', '[HTTP_ROUTE]');
     *     $operationResponse = $networkServicesClient->deleteHttpRoute($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->deleteHttpRoute($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'deleteHttpRoute');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the HttpRoute to delete. Must be in the format
     *                             `projects/&#42;/locations/global/httpRoutes/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteHttpRoute($name, array $optionalArgs = [])
    {
        $request = new DeleteHttpRouteRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteHttpRoute', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single Mesh.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedName = $networkServicesClient->meshName('[PROJECT]', '[LOCATION]', '[MESH]');
     *     $operationResponse = $networkServicesClient->deleteMesh($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->deleteMesh($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'deleteMesh');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the Mesh to delete. Must be in the format
     *                             `projects/&#42;/locations/global/meshes/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteMesh($name, array $optionalArgs = [])
    {
        $request = new DeleteMeshRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteMesh', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single ServiceBinding.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedName = $networkServicesClient->serviceBindingName('[PROJECT]', '[LOCATION]', '[SERVICE_BINDING]');
     *     $operationResponse = $networkServicesClient->deleteServiceBinding($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->deleteServiceBinding($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'deleteServiceBinding');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the ServiceBinding to delete. Must be in the format
     *                             `projects/&#42;/locations/global/serviceBindings/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteServiceBinding($name, array $optionalArgs = [])
    {
        $request = new DeleteServiceBindingRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteServiceBinding', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single TcpRoute.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedName = $networkServicesClient->tcpRouteName('[PROJECT]', '[LOCATION]', '[TCP_ROUTE]');
     *     $operationResponse = $networkServicesClient->deleteTcpRoute($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->deleteTcpRoute($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'deleteTcpRoute');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the TcpRoute to delete. Must be in the format
     *                             `projects/&#42;/locations/global/tcpRoutes/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteTcpRoute($name, array $optionalArgs = [])
    {
        $request = new DeleteTcpRouteRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteTcpRoute', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single TlsRoute.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedName = $networkServicesClient->tlsRouteName('[PROJECT]', '[LOCATION]', '[TLS_ROUTE]');
     *     $operationResponse = $networkServicesClient->deleteTlsRoute($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->deleteTlsRoute($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'deleteTlsRoute');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the TlsRoute to delete. Must be in the format
     *                             `projects/&#42;/locations/global/tlsRoutes/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteTlsRoute($name, array $optionalArgs = [])
    {
        $request = new DeleteTlsRouteRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteTlsRoute', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Gets details of a single EndpointPolicy.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedName = $networkServicesClient->endpointPolicyName('[PROJECT]', '[LOCATION]', '[ENDPOINT_POLICY]');
     *     $response = $networkServicesClient->getEndpointPolicy($formattedName);
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the EndpointPolicy to get. Must be in the format
     *                             `projects/&#42;/locations/global/endpointPolicies/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\NetworkServices\V1\EndpointPolicy
     *
     * @throws ApiException if the remote call fails
     */
    public function getEndpointPolicy($name, array $optionalArgs = [])
    {
        $request = new GetEndpointPolicyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetEndpointPolicy', EndpointPolicy::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets details of a single Gateway.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedName = $networkServicesClient->gatewayName('[PROJECT]', '[LOCATION]', '[GATEWAY]');
     *     $response = $networkServicesClient->getGateway($formattedName);
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the Gateway to get. Must be in the format
     *                             `projects/&#42;/locations/&#42;/gateways/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\NetworkServices\V1\Gateway
     *
     * @throws ApiException if the remote call fails
     */
    public function getGateway($name, array $optionalArgs = [])
    {
        $request = new GetGatewayRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetGateway', Gateway::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets details of a single GrpcRoute.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedName = $networkServicesClient->grpcRouteName('[PROJECT]', '[LOCATION]', '[GRPC_ROUTE]');
     *     $response = $networkServicesClient->getGrpcRoute($formattedName);
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the GrpcRoute to get. Must be in the format
     *                             `projects/&#42;/locations/global/grpcRoutes/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\NetworkServices\V1\GrpcRoute
     *
     * @throws ApiException if the remote call fails
     */
    public function getGrpcRoute($name, array $optionalArgs = [])
    {
        $request = new GetGrpcRouteRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetGrpcRoute', GrpcRoute::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets details of a single HttpRoute.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedName = $networkServicesClient->httpRouteName('[PROJECT]', '[LOCATION]', '[HTTP_ROUTE]');
     *     $response = $networkServicesClient->getHttpRoute($formattedName);
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the HttpRoute to get. Must be in the format
     *                             `projects/&#42;/locations/global/httpRoutes/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\NetworkServices\V1\HttpRoute
     *
     * @throws ApiException if the remote call fails
     */
    public function getHttpRoute($name, array $optionalArgs = [])
    {
        $request = new GetHttpRouteRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetHttpRoute', HttpRoute::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets details of a single Mesh.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedName = $networkServicesClient->meshName('[PROJECT]', '[LOCATION]', '[MESH]');
     *     $response = $networkServicesClient->getMesh($formattedName);
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the Mesh to get. Must be in the format
     *                             `projects/&#42;/locations/global/meshes/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\NetworkServices\V1\Mesh
     *
     * @throws ApiException if the remote call fails
     */
    public function getMesh($name, array $optionalArgs = [])
    {
        $request = new GetMeshRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetMesh', Mesh::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets details of a single ServiceBinding.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedName = $networkServicesClient->serviceBindingName('[PROJECT]', '[LOCATION]', '[SERVICE_BINDING]');
     *     $response = $networkServicesClient->getServiceBinding($formattedName);
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the ServiceBinding to get. Must be in the format
     *                             `projects/&#42;/locations/global/serviceBindings/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\NetworkServices\V1\ServiceBinding
     *
     * @throws ApiException if the remote call fails
     */
    public function getServiceBinding($name, array $optionalArgs = [])
    {
        $request = new GetServiceBindingRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetServiceBinding', ServiceBinding::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets details of a single TcpRoute.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedName = $networkServicesClient->tcpRouteName('[PROJECT]', '[LOCATION]', '[TCP_ROUTE]');
     *     $response = $networkServicesClient->getTcpRoute($formattedName);
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the TcpRoute to get. Must be in the format
     *                             `projects/&#42;/locations/global/tcpRoutes/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\NetworkServices\V1\TcpRoute
     *
     * @throws ApiException if the remote call fails
     */
    public function getTcpRoute($name, array $optionalArgs = [])
    {
        $request = new GetTcpRouteRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetTcpRoute', TcpRoute::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets details of a single TlsRoute.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedName = $networkServicesClient->tlsRouteName('[PROJECT]', '[LOCATION]', '[TLS_ROUTE]');
     *     $response = $networkServicesClient->getTlsRoute($formattedName);
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the TlsRoute to get. Must be in the format
     *                             `projects/&#42;/locations/global/tlsRoutes/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\NetworkServices\V1\TlsRoute
     *
     * @throws ApiException if the remote call fails
     */
    public function getTlsRoute($name, array $optionalArgs = [])
    {
        $request = new GetTlsRouteRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetTlsRoute', TlsRoute::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lists EndpointPolicies in a given project and location.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedParent = $networkServicesClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $networkServicesClient->listEndpointPolicies($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $networkServicesClient->listEndpointPolicies($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location from which the EndpointPolicies should
     *                             be listed, specified in the format `projects/&#42;/locations/global`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listEndpointPolicies($parent, array $optionalArgs = [])
    {
        $request = new ListEndpointPoliciesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListEndpointPolicies', $optionalArgs, ListEndpointPoliciesResponse::class, $request);
    }

    /**
     * Lists Gateways in a given project and location.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedParent = $networkServicesClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $networkServicesClient->listGateways($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $networkServicesClient->listGateways($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location from which the Gateways should be
     *                             listed, specified in the format `projects/&#42;/locations/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listGateways($parent, array $optionalArgs = [])
    {
        $request = new ListGatewaysRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListGateways', $optionalArgs, ListGatewaysResponse::class, $request);
    }

    /**
     * Lists GrpcRoutes in a given project and location.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedParent = $networkServicesClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $networkServicesClient->listGrpcRoutes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $networkServicesClient->listGrpcRoutes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location from which the GrpcRoutes should be
     *                             listed, specified in the format `projects/&#42;/locations/global`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listGrpcRoutes($parent, array $optionalArgs = [])
    {
        $request = new ListGrpcRoutesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListGrpcRoutes', $optionalArgs, ListGrpcRoutesResponse::class, $request);
    }

    /**
     * Lists HttpRoute in a given project and location.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedParent = $networkServicesClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $networkServicesClient->listHttpRoutes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $networkServicesClient->listHttpRoutes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location from which the HttpRoutes should be
     *                             listed, specified in the format `projects/&#42;/locations/global`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listHttpRoutes($parent, array $optionalArgs = [])
    {
        $request = new ListHttpRoutesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListHttpRoutes', $optionalArgs, ListHttpRoutesResponse::class, $request);
    }

    /**
     * Lists Meshes in a given project and location.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedParent = $networkServicesClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $networkServicesClient->listMeshes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $networkServicesClient->listMeshes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location from which the Meshes should be
     *                             listed, specified in the format `projects/&#42;/locations/global`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listMeshes($parent, array $optionalArgs = [])
    {
        $request = new ListMeshesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListMeshes', $optionalArgs, ListMeshesResponse::class, $request);
    }

    /**
     * Lists ServiceBinding in a given project and location.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedParent = $networkServicesClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $networkServicesClient->listServiceBindings($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $networkServicesClient->listServiceBindings($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location from which the ServiceBindings should be
     *                             listed, specified in the format `projects/&#42;/locations/global`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listServiceBindings($parent, array $optionalArgs = [])
    {
        $request = new ListServiceBindingsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListServiceBindings', $optionalArgs, ListServiceBindingsResponse::class, $request);
    }

    /**
     * Lists TcpRoute in a given project and location.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedParent = $networkServicesClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $networkServicesClient->listTcpRoutes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $networkServicesClient->listTcpRoutes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location from which the TcpRoutes should be
     *                             listed, specified in the format `projects/&#42;/locations/global`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTcpRoutes($parent, array $optionalArgs = [])
    {
        $request = new ListTcpRoutesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListTcpRoutes', $optionalArgs, ListTcpRoutesResponse::class, $request);
    }

    /**
     * Lists TlsRoute in a given project and location.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $formattedParent = $networkServicesClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $networkServicesClient->listTlsRoutes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $networkServicesClient->listTlsRoutes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location from which the TlsRoutes should be
     *                             listed, specified in the format `projects/&#42;/locations/global`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTlsRoutes($parent, array $optionalArgs = [])
    {
        $request = new ListTlsRoutesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListTlsRoutes', $optionalArgs, ListTlsRoutesResponse::class, $request);
    }

    /**
     * Updates the parameters of a single EndpointPolicy.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $endpointPolicy = new EndpointPolicy();
     *     $operationResponse = $networkServicesClient->updateEndpointPolicy($endpointPolicy);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->updateEndpointPolicy($endpointPolicy);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'updateEndpointPolicy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param EndpointPolicy $endpointPolicy Required. Updated EndpointPolicy resource.
     * @param array          $optionalArgs   {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Field mask is used to specify the fields to be overwritten in the
     *           EndpointPolicy resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then all fields will be overwritten.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateEndpointPolicy($endpointPolicy, array $optionalArgs = [])
    {
        $request = new UpdateEndpointPolicyRequest();
        $requestParamHeaders = [];
        $request->setEndpointPolicy($endpointPolicy);
        $requestParamHeaders['endpoint_policy.name'] = $endpointPolicy->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateEndpointPolicy', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the parameters of a single Gateway.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $gateway = new Gateway();
     *     $operationResponse = $networkServicesClient->updateGateway($gateway);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->updateGateway($gateway);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'updateGateway');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param Gateway $gateway      Required. Updated Gateway resource.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Field mask is used to specify the fields to be overwritten in the
     *           Gateway resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then all fields will be overwritten.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateGateway($gateway, array $optionalArgs = [])
    {
        $request = new UpdateGatewayRequest();
        $requestParamHeaders = [];
        $request->setGateway($gateway);
        $requestParamHeaders['gateway.name'] = $gateway->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateGateway', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the parameters of a single GrpcRoute.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $grpcRoute = new GrpcRoute();
     *     $operationResponse = $networkServicesClient->updateGrpcRoute($grpcRoute);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->updateGrpcRoute($grpcRoute);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'updateGrpcRoute');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param GrpcRoute $grpcRoute    Required. Updated GrpcRoute resource.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Field mask is used to specify the fields to be overwritten in the
     *           GrpcRoute resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then all fields will be overwritten.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateGrpcRoute($grpcRoute, array $optionalArgs = [])
    {
        $request = new UpdateGrpcRouteRequest();
        $requestParamHeaders = [];
        $request->setGrpcRoute($grpcRoute);
        $requestParamHeaders['grpc_route.name'] = $grpcRoute->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateGrpcRoute', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the parameters of a single HttpRoute.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $httpRoute = new HttpRoute();
     *     $operationResponse = $networkServicesClient->updateHttpRoute($httpRoute);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->updateHttpRoute($httpRoute);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'updateHttpRoute');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param HttpRoute $httpRoute    Required. Updated HttpRoute resource.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Field mask is used to specify the fields to be overwritten in the
     *           HttpRoute resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then all fields will be overwritten.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateHttpRoute($httpRoute, array $optionalArgs = [])
    {
        $request = new UpdateHttpRouteRequest();
        $requestParamHeaders = [];
        $request->setHttpRoute($httpRoute);
        $requestParamHeaders['http_route.name'] = $httpRoute->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateHttpRoute', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the parameters of a single Mesh.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $mesh = new Mesh();
     *     $operationResponse = $networkServicesClient->updateMesh($mesh);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->updateMesh($mesh);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'updateMesh');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param Mesh  $mesh         Required. Updated Mesh resource.
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Field mask is used to specify the fields to be overwritten in the
     *           Mesh resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then all fields will be overwritten.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateMesh($mesh, array $optionalArgs = [])
    {
        $request = new UpdateMeshRequest();
        $requestParamHeaders = [];
        $request->setMesh($mesh);
        $requestParamHeaders['mesh.name'] = $mesh->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateMesh', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the parameters of a single TcpRoute.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $tcpRoute = new TcpRoute();
     *     $operationResponse = $networkServicesClient->updateTcpRoute($tcpRoute);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->updateTcpRoute($tcpRoute);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'updateTcpRoute');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param TcpRoute $tcpRoute     Required. Updated TcpRoute resource.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Field mask is used to specify the fields to be overwritten in the
     *           TcpRoute resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then all fields will be overwritten.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateTcpRoute($tcpRoute, array $optionalArgs = [])
    {
        $request = new UpdateTcpRouteRequest();
        $requestParamHeaders = [];
        $request->setTcpRoute($tcpRoute);
        $requestParamHeaders['tcp_route.name'] = $tcpRoute->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateTcpRoute', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the parameters of a single TlsRoute.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $tlsRoute = new TlsRoute();
     *     $operationResponse = $networkServicesClient->updateTlsRoute($tlsRoute);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkServicesClient->updateTlsRoute($tlsRoute);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkServicesClient->resumeOperation($operationName, 'updateTlsRoute');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param TlsRoute $tlsRoute     Required. Updated TlsRoute resource.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Field mask is used to specify the fields to be overwritten in the
     *           TlsRoute resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then all fields will be overwritten.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateTlsRoute($tlsRoute, array $optionalArgs = [])
    {
        $request = new UpdateTlsRouteRequest();
        $requestParamHeaders = [];
        $request->setTlsRoute($tlsRoute);
        $requestParamHeaders['tls_route.name'] = $tlsRoute->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateTlsRoute', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $response = $networkServicesClient->getLocation();
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetLocation', Location::class, $optionalArgs, $request, Call::UNARY_CALL, 'google.cloud.location.Locations')->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $networkServicesClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $networkServicesClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListLocations', $optionalArgs, ListLocationsResponse::class, $request, 'google.cloud.location.Locations');
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $resource = 'resource';
     *     $response = $networkServicesClient->getIamPolicy($resource);
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetIamPolicy', Policy::class, $optionalArgs, $request, Call::UNARY_CALL, 'google.iam.v1.IAMPolicy')->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $networkServicesClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('SetIamPolicy', Policy::class, $optionalArgs, $request, Call::UNARY_CALL, 'google.iam.v1.IAMPolicy')->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $networkServicesClient = new NetworkServicesClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $networkServicesClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $networkServicesClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions($resource, $permissions, array $optionalArgs = [])
    {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('TestIamPermissions', TestIamPermissionsResponse::class, $optionalArgs, $request, Call::UNARY_CALL, 'google.iam.v1.IAMPolicy')->wait();
    }
}
