<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/search_service.proto

namespace Google\Cloud\Retail\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for
 * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] method.
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.SearchRequest</code>
 */
class SearchRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the Retail Search serving config, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/default_serving_config`
     * or the name of the legacy placement resource, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/default_search`.
     * This field is used to identify the serving config name and the set
     * of models that are used to make the search.
     *
     * Generated from protobuf field <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $placement = '';
    /**
     * The branch resource name, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/0`.
     * Use "default_branch" as the branch ID or leave this field empty, to search
     * products under the default branch.
     *
     * Generated from protobuf field <code>string branch = 2 [(.google.api.resource_reference) = {</code>
     */
    protected $branch = '';
    /**
     * Raw search query.
     * If this field is empty, the request is considered a category browsing
     * request and returned results are based on
     * [filter][google.cloud.retail.v2.SearchRequest.filter] and
     * [page_categories][google.cloud.retail.v2.SearchRequest.page_categories].
     *
     * Generated from protobuf field <code>string query = 3;</code>
     */
    protected $query = '';
    /**
     * Required. A unique identifier for tracking visitors. For example, this
     * could be implemented with an HTTP cookie, which should be able to uniquely
     * identify a visitor on a single device. This unique identifier should not
     * change if the visitor logs in or out of the website.
     * This should be the same identifier as
     * [UserEvent.visitor_id][google.cloud.retail.v2.UserEvent.visitor_id].
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string visitor_id = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $visitor_id = '';
    /**
     * User information.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.UserInfo user_info = 5;</code>
     */
    protected $user_info = null;
    /**
     * Maximum number of [Product][google.cloud.retail.v2.Product]s to return. If
     * unspecified, defaults to a reasonable value. The maximum allowed value is
     * 120. Values above 120 will be coerced to 120.
     * If this field is negative, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>int32 page_size = 7;</code>
     */
    protected $page_size = 0;
    /**
     * A page token
     * [SearchResponse.next_page_token][google.cloud.retail.v2.SearchResponse.next_page_token],
     * received from a previous
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] call.
     * Provide this to retrieve the subsequent page.
     * When paginating, all other parameters provided to
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] must
     * match the call that provided the page token. Otherwise, an INVALID_ARGUMENT
     * error is returned.
     *
     * Generated from protobuf field <code>string page_token = 8;</code>
     */
    protected $page_token = '';
    /**
     * A 0-indexed integer that specifies the current offset (that is, starting
     * result location, amongst the [Product][google.cloud.retail.v2.Product]s
     * deemed by the API as relevant) in search results. This field is only
     * considered if [page_token][google.cloud.retail.v2.SearchRequest.page_token]
     * is unset.
     * If this field is negative, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>int32 offset = 9;</code>
     */
    protected $offset = 0;
    /**
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the products being filtered. Filter
     * expression is case-sensitive. For more information, see
     * [Filter](https://cloud.google.com/retail/docs/filter-and-order#filter).
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>string filter = 10;</code>
     */
    protected $filter = '';
    /**
     * The default filter that is applied when a user performs a search without
     * checking any filters on the search page.
     * The filter applied to every search request when quality improvement such as
     * query expansion is needed. In the case a query does not have a sufficient
     * amount of results this filter will be used to determine whether or not to
     * enable the query expansion flow. The original filter will still be used for
     * the query expanded search.
     * This field is strongly recommended to achieve high search quality.
     * For more information about filter syntax, see
     * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter].
     *
     * Generated from protobuf field <code>string canonical_filter = 28;</code>
     */
    protected $canonical_filter = '';
    /**
     * The order in which products are returned. Products can be ordered by
     * a field in an [Product][google.cloud.retail.v2.Product] object. Leave it
     * unset if ordered by relevance. OrderBy expression is case-sensitive. For
     * more information, see
     * [Order](https://cloud.google.com/retail/docs/filter-and-order#order).
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>string order_by = 11;</code>
     */
    protected $order_by = '';
    /**
     * Facet specifications for faceted search. If empty, no facets are returned.
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.SearchRequest.FacetSpec facet_specs = 12;</code>
     */
    private $facet_specs;
    /**
     * Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
     * to enable dynamic facets. Do not set this field.
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 21 [deprecated = true];</code>
     * @deprecated
     */
    protected $dynamic_facet_spec = null;
    /**
     * Boost specification to boost certain products. For more information, see
     * [Boost results](https://cloud.google.com/retail/docs/boosting).
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.BoostSpec boost_spec = 13;</code>
     */
    protected $boost_spec = null;
    /**
     * The query expansion specification that specifies the conditions under which
     * query expansion occurs. For more information, see [Query
     * expansion](https://cloud.google.com/retail/docs/result-size#query_expansion).
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.QueryExpansionSpec query_expansion_spec = 14;</code>
     */
    protected $query_expansion_spec = null;
    /**
     * The keys to fetch and rollup the matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s attributes,
     * [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo] or
     * [LocalInventory][google.cloud.retail.v2.LocalInventory]s attributes. The
     * attributes from all the matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s or
     * [LocalInventory][google.cloud.retail.v2.LocalInventory]s are merged and
     * de-duplicated. Notice that rollup attributes will lead to extra query
     * latency. Maximum number of keys is 30.
     * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], a
     * fulfillment type and a fulfillment ID must be provided in the format of
     * "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
     * "pickupInStore" is fulfillment type and "store123" is the store ID.
     * Supported keys are:
     * * colorFamilies
     * * price
     * * originalPrice
     * * discount
     * * variantId
     * * inventory(place_id,price)
     * * inventory(place_id,original_price)
     * * inventory(place_id,attributes.key), where key is any key in the
     *   [Product.local_inventories.attributes][google.cloud.retail.v2.LocalInventory.attributes]
     *   map.
     * * attributes.key, where key is any key in the
     *   [Product.attributes][google.cloud.retail.v2.Product.attributes] map.
     * * pickupInStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "pickup-in-store".
     * * shipToStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "ship-to-store".
     * * sameDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "same-day-delivery".
     * * nextDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "next-day-delivery".
     * * customFulfillment1.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-1".
     * * customFulfillment2.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-2".
     * * customFulfillment3.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-3".
     * * customFulfillment4.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-4".
     * * customFulfillment5.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-5".
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>repeated string variant_rollup_keys = 17;</code>
     */
    private $variant_rollup_keys;
    /**
     * The categories associated with a category page. Must be set for category
     * navigation queries to achieve good search quality. The format should be
     * the same as
     * [UserEvent.page_categories][google.cloud.retail.v2.UserEvent.page_categories];
     * To represent full path of category, use '>' sign to separate different
     * hierarchies. If '>' is part of the category name, replace it with
     * other character(s).
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales > 2017 Black Friday Deals"].
     *
     * Generated from protobuf field <code>repeated string page_categories = 23;</code>
     */
    private $page_categories;
    /**
     * The search mode of the search request. If not specified, a single search
     * request triggers both product search and faceted search.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.SearchMode search_mode = 31;</code>
     */
    protected $search_mode = 0;
    /**
     * The specification for personalization.
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2.ServingConfig.personalization_spec].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.PersonalizationSpec personalization_spec = 32;</code>
     */
    protected $personalization_spec = null;
    /**
     * The labels applied to a resource must meet the following requirements:
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     * For more information, see [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * in the Resource Manager documentation.
     *
     * Generated from protobuf field <code>map<string, string> labels = 34;</code>
     */
    private $labels;
    /**
     * The spell correction specification that specifies the mode under
     * which spell correction will take effect.
     *
     * Generated from protobuf field <code>optional .google.cloud.retail.v2.SearchRequest.SpellCorrectionSpec spell_correction_spec = 35;</code>
     */
    protected $spell_correction_spec = null;
    /**
     * The entity for customers that may run multiple different entities, domains,
     * sites or regions, for example, `Google US`, `Google Ads`, `Waymo`,
     * `google.com`, `youtube.com`, etc.
     * If this is set, it should be exactly matched with
     * [UserEvent.entity][google.cloud.retail.v2.UserEvent.entity] to get search
     * results boosted by entity.
     *
     * Generated from protobuf field <code>string entity = 38;</code>
     */
    protected $entity = '';
    /**
     * Optional. This field specifies all conversational related parameters
     * addition to traditional retail search.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec conversational_search_spec = 40 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $conversational_search_spec = null;
    /**
     * Optional. This field specifies tile navigation related parameters.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.TileNavigationSpec tile_navigation_spec = 41 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $tile_navigation_spec = null;
    /**
     * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn"
     * [list](https://www.unicode.org/cldr/charts/46/summary/root.html). For more
     * information, see [Standardized codes](https://google.aip.dev/143). This
     * field helps to better interpret the query. If a value isn't specified, the
     * query language code is automatically detected, which may not be accurate.
     *
     * Generated from protobuf field <code>string language_code = 43 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $language_code = '';
    /**
     * Optional. The Unicode country/region code (CLDR) of a location, such as
     * "US" and "419"
     * [list](https://www.unicode.org/cldr/charts/46/supplemental/territory_information.html).
     * For more information, see [Standardized codes](https://google.aip.dev/143).
     * If set, then results will be boosted based on the region_code provided.
     *
     * Generated from protobuf field <code>string region_code = 44 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $region_code = '';
    /**
     * Optional. An id corresponding to a place, such as a store id or region id.
     * When specified, we use the price from the local inventory with the matching
     * product's
     * [LocalInventory.place_id][google.cloud.retail.v2.LocalInventory.place_id]
     * for revenue optimization.
     *
     * Generated from protobuf field <code>string place_id = 46 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $place_id = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $placement
     *           Required. The resource name of the Retail Search serving config, such as
     *           `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/default_serving_config`
     *           or the name of the legacy placement resource, such as
     *           `projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/default_search`.
     *           This field is used to identify the serving config name and the set
     *           of models that are used to make the search.
     *     @type string $branch
     *           The branch resource name, such as
     *           `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/0`.
     *           Use "default_branch" as the branch ID or leave this field empty, to search
     *           products under the default branch.
     *     @type string $query
     *           Raw search query.
     *           If this field is empty, the request is considered a category browsing
     *           request and returned results are based on
     *           [filter][google.cloud.retail.v2.SearchRequest.filter] and
     *           [page_categories][google.cloud.retail.v2.SearchRequest.page_categories].
     *     @type string $visitor_id
     *           Required. A unique identifier for tracking visitors. For example, this
     *           could be implemented with an HTTP cookie, which should be able to uniquely
     *           identify a visitor on a single device. This unique identifier should not
     *           change if the visitor logs in or out of the website.
     *           This should be the same identifier as
     *           [UserEvent.visitor_id][google.cloud.retail.v2.UserEvent.visitor_id].
     *           The field must be a UTF-8 encoded string with a length limit of 128
     *           characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *     @type \Google\Cloud\Retail\V2\UserInfo $user_info
     *           User information.
     *     @type int $page_size
     *           Maximum number of [Product][google.cloud.retail.v2.Product]s to return. If
     *           unspecified, defaults to a reasonable value. The maximum allowed value is
     *           120. Values above 120 will be coerced to 120.
     *           If this field is negative, an INVALID_ARGUMENT is returned.
     *     @type string $page_token
     *           A page token
     *           [SearchResponse.next_page_token][google.cloud.retail.v2.SearchResponse.next_page_token],
     *           received from a previous
     *           [SearchService.Search][google.cloud.retail.v2.SearchService.Search] call.
     *           Provide this to retrieve the subsequent page.
     *           When paginating, all other parameters provided to
     *           [SearchService.Search][google.cloud.retail.v2.SearchService.Search] must
     *           match the call that provided the page token. Otherwise, an INVALID_ARGUMENT
     *           error is returned.
     *     @type int $offset
     *           A 0-indexed integer that specifies the current offset (that is, starting
     *           result location, amongst the [Product][google.cloud.retail.v2.Product]s
     *           deemed by the API as relevant) in search results. This field is only
     *           considered if [page_token][google.cloud.retail.v2.SearchRequest.page_token]
     *           is unset.
     *           If this field is negative, an INVALID_ARGUMENT is returned.
     *     @type string $filter
     *           The filter syntax consists of an expression language for constructing a
     *           predicate from one or more fields of the products being filtered. Filter
     *           expression is case-sensitive. For more information, see
     *           [Filter](https://cloud.google.com/retail/docs/filter-and-order#filter).
     *           If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     *     @type string $canonical_filter
     *           The default filter that is applied when a user performs a search without
     *           checking any filters on the search page.
     *           The filter applied to every search request when quality improvement such as
     *           query expansion is needed. In the case a query does not have a sufficient
     *           amount of results this filter will be used to determine whether or not to
     *           enable the query expansion flow. The original filter will still be used for
     *           the query expanded search.
     *           This field is strongly recommended to achieve high search quality.
     *           For more information about filter syntax, see
     *           [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter].
     *     @type string $order_by
     *           The order in which products are returned. Products can be ordered by
     *           a field in an [Product][google.cloud.retail.v2.Product] object. Leave it
     *           unset if ordered by relevance. OrderBy expression is case-sensitive. For
     *           more information, see
     *           [Order](https://cloud.google.com/retail/docs/filter-and-order#order).
     *           If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     *     @type array<\Google\Cloud\Retail\V2\SearchRequest\FacetSpec>|\Google\Protobuf\Internal\RepeatedField $facet_specs
     *           Facet specifications for faceted search. If empty, no facets are returned.
     *           A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     *           is returned.
     *     @type \Google\Cloud\Retail\V2\SearchRequest\DynamicFacetSpec $dynamic_facet_spec
     *           Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
     *           to enable dynamic facets. Do not set this field.
     *           The specification for dynamically generated facets. Notice that only
     *           textual facets can be dynamically generated.
     *     @type \Google\Cloud\Retail\V2\SearchRequest\BoostSpec $boost_spec
     *           Boost specification to boost certain products. For more information, see
     *           [Boost results](https://cloud.google.com/retail/docs/boosting).
     *           Notice that if both
     *           [ServingConfig.boost_control_ids][google.cloud.retail.v2.ServingConfig.boost_control_ids]
     *           and
     *           [SearchRequest.boost_spec][google.cloud.retail.v2.SearchRequest.boost_spec]
     *           are set, the boost conditions from both places are evaluated. If a search
     *           request matches multiple boost conditions, the final boost score is equal
     *           to the sum of the boost scores from all matched boost conditions.
     *     @type \Google\Cloud\Retail\V2\SearchRequest\QueryExpansionSpec $query_expansion_spec
     *           The query expansion specification that specifies the conditions under which
     *           query expansion occurs. For more information, see [Query
     *           expansion](https://cloud.google.com/retail/docs/result-size#query_expansion).
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $variant_rollup_keys
     *           The keys to fetch and rollup the matching
     *           [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     *           [Product][google.cloud.retail.v2.Product]s attributes,
     *           [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo] or
     *           [LocalInventory][google.cloud.retail.v2.LocalInventory]s attributes. The
     *           attributes from all the matching
     *           [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     *           [Product][google.cloud.retail.v2.Product]s or
     *           [LocalInventory][google.cloud.retail.v2.LocalInventory]s are merged and
     *           de-duplicated. Notice that rollup attributes will lead to extra query
     *           latency. Maximum number of keys is 30.
     *           For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], a
     *           fulfillment type and a fulfillment ID must be provided in the format of
     *           "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
     *           "pickupInStore" is fulfillment type and "store123" is the store ID.
     *           Supported keys are:
     *           * colorFamilies
     *           * price
     *           * originalPrice
     *           * discount
     *           * variantId
     *           * inventory(place_id,price)
     *           * inventory(place_id,original_price)
     *           * inventory(place_id,attributes.key), where key is any key in the
     *             [Product.local_inventories.attributes][google.cloud.retail.v2.LocalInventory.attributes]
     *             map.
     *           * attributes.key, where key is any key in the
     *             [Product.attributes][google.cloud.retail.v2.Product.attributes] map.
     *           * pickupInStore.id, where id is any
     *           [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     *           for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *             "pickup-in-store".
     *           * shipToStore.id, where id is any
     *           [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     *           for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *             "ship-to-store".
     *           * sameDayDelivery.id, where id is any
     *           [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     *           for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *             "same-day-delivery".
     *           * nextDayDelivery.id, where id is any
     *           [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     *           for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *             "next-day-delivery".
     *           * customFulfillment1.id, where id is any
     *           [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     *           for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *             "custom-type-1".
     *           * customFulfillment2.id, where id is any
     *           [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     *           for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *             "custom-type-2".
     *           * customFulfillment3.id, where id is any
     *           [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     *           for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *             "custom-type-3".
     *           * customFulfillment4.id, where id is any
     *           [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     *           for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *             "custom-type-4".
     *           * customFulfillment5.id, where id is any
     *           [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     *           for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *             "custom-type-5".
     *           If this field is set to an invalid value other than these, an
     *           INVALID_ARGUMENT error is returned.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $page_categories
     *           The categories associated with a category page. Must be set for category
     *           navigation queries to achieve good search quality. The format should be
     *           the same as
     *           [UserEvent.page_categories][google.cloud.retail.v2.UserEvent.page_categories];
     *           To represent full path of category, use '>' sign to separate different
     *           hierarchies. If '>' is part of the category name, replace it with
     *           other character(s).
     *           Category pages include special pages such as sales or promotions. For
     *           instance, a special sale page may have the category hierarchy:
     *           "pageCategories" : ["Sales > 2017 Black Friday Deals"].
     *     @type int $search_mode
     *           The search mode of the search request. If not specified, a single search
     *           request triggers both product search and faceted search.
     *     @type \Google\Cloud\Retail\V2\SearchRequest\PersonalizationSpec $personalization_spec
     *           The specification for personalization.
     *           Notice that if both
     *           [ServingConfig.personalization_spec][google.cloud.retail.v2.ServingConfig.personalization_spec]
     *           and
     *           [SearchRequest.personalization_spec][google.cloud.retail.v2.SearchRequest.personalization_spec]
     *           are set.
     *           [SearchRequest.personalization_spec][google.cloud.retail.v2.SearchRequest.personalization_spec]
     *           will override
     *           [ServingConfig.personalization_spec][google.cloud.retail.v2.ServingConfig.personalization_spec].
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           The labels applied to a resource must meet the following requirements:
     *           * Each resource can have multiple labels, up to a maximum of 64.
     *           * Each label must be a key-value pair.
     *           * Keys have a minimum length of 1 character and a maximum length of 63
     *             characters and cannot be empty. Values can be empty and have a maximum
     *             length of 63 characters.
     *           * Keys and values can contain only lowercase letters, numeric characters,
     *             underscores, and dashes. All characters must use UTF-8 encoding, and
     *             international characters are allowed.
     *           * The key portion of a label must be unique. However, you can use the same
     *             key with multiple resources.
     *           * Keys must start with a lowercase letter or international character.
     *           For more information, see [Requirements for
     *           labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     *           in the Resource Manager documentation.
     *     @type \Google\Cloud\Retail\V2\SearchRequest\SpellCorrectionSpec $spell_correction_spec
     *           The spell correction specification that specifies the mode under
     *           which spell correction will take effect.
     *     @type string $entity
     *           The entity for customers that may run multiple different entities, domains,
     *           sites or regions, for example, `Google US`, `Google Ads`, `Waymo`,
     *           `google.com`, `youtube.com`, etc.
     *           If this is set, it should be exactly matched with
     *           [UserEvent.entity][google.cloud.retail.v2.UserEvent.entity] to get search
     *           results boosted by entity.
     *     @type \Google\Cloud\Retail\V2\SearchRequest\ConversationalSearchSpec $conversational_search_spec
     *           Optional. This field specifies all conversational related parameters
     *           addition to traditional retail search.
     *     @type \Google\Cloud\Retail\V2\SearchRequest\TileNavigationSpec $tile_navigation_spec
     *           Optional. This field specifies tile navigation related parameters.
     *     @type string $language_code
     *           Optional. The BCP-47 language code, such as "en-US" or "sr-Latn"
     *           [list](https://www.unicode.org/cldr/charts/46/summary/root.html). For more
     *           information, see [Standardized codes](https://google.aip.dev/143). This
     *           field helps to better interpret the query. If a value isn't specified, the
     *           query language code is automatically detected, which may not be accurate.
     *     @type string $region_code
     *           Optional. The Unicode country/region code (CLDR) of a location, such as
     *           "US" and "419"
     *           [list](https://www.unicode.org/cldr/charts/46/supplemental/territory_information.html).
     *           For more information, see [Standardized codes](https://google.aip.dev/143).
     *           If set, then results will be boosted based on the region_code provided.
     *     @type string $place_id
     *           Optional. An id corresponding to a place, such as a store id or region id.
     *           When specified, we use the price from the local inventory with the matching
     *           product's
     *           [LocalInventory.place_id][google.cloud.retail.v2.LocalInventory.place_id]
     *           for revenue optimization.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\SearchService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The resource name of the Retail Search serving config, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/default_serving_config`
     * or the name of the legacy placement resource, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/default_search`.
     * This field is used to identify the serving config name and the set
     * of models that are used to make the search.
     *
     * Generated from protobuf field <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getPlacement()
    {
        return $this->placement;
    }

    /**
     * Required. The resource name of the Retail Search serving config, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/default_serving_config`
     * or the name of the legacy placement resource, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/default_search`.
     * This field is used to identify the serving config name and the set
     * of models that are used to make the search.
     *
     * Generated from protobuf field <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setPlacement($var)
    {
        GPBUtil::checkString($var, True);
        $this->placement = $var;

        return $this;
    }

    /**
     * The branch resource name, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/0`.
     * Use "default_branch" as the branch ID or leave this field empty, to search
     * products under the default branch.
     *
     * Generated from protobuf field <code>string branch = 2 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getBranch()
    {
        return $this->branch;
    }

    /**
     * The branch resource name, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/0`.
     * Use "default_branch" as the branch ID or leave this field empty, to search
     * products under the default branch.
     *
     * Generated from protobuf field <code>string branch = 2 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setBranch($var)
    {
        GPBUtil::checkString($var, True);
        $this->branch = $var;

        return $this;
    }

    /**
     * Raw search query.
     * If this field is empty, the request is considered a category browsing
     * request and returned results are based on
     * [filter][google.cloud.retail.v2.SearchRequest.filter] and
     * [page_categories][google.cloud.retail.v2.SearchRequest.page_categories].
     *
     * Generated from protobuf field <code>string query = 3;</code>
     * @return string
     */
    public function getQuery()
    {
        return $this->query;
    }

    /**
     * Raw search query.
     * If this field is empty, the request is considered a category browsing
     * request and returned results are based on
     * [filter][google.cloud.retail.v2.SearchRequest.filter] and
     * [page_categories][google.cloud.retail.v2.SearchRequest.page_categories].
     *
     * Generated from protobuf field <code>string query = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setQuery($var)
    {
        GPBUtil::checkString($var, True);
        $this->query = $var;

        return $this;
    }

    /**
     * Required. A unique identifier for tracking visitors. For example, this
     * could be implemented with an HTTP cookie, which should be able to uniquely
     * identify a visitor on a single device. This unique identifier should not
     * change if the visitor logs in or out of the website.
     * This should be the same identifier as
     * [UserEvent.visitor_id][google.cloud.retail.v2.UserEvent.visitor_id].
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string visitor_id = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getVisitorId()
    {
        return $this->visitor_id;
    }

    /**
     * Required. A unique identifier for tracking visitors. For example, this
     * could be implemented with an HTTP cookie, which should be able to uniquely
     * identify a visitor on a single device. This unique identifier should not
     * change if the visitor logs in or out of the website.
     * This should be the same identifier as
     * [UserEvent.visitor_id][google.cloud.retail.v2.UserEvent.visitor_id].
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string visitor_id = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setVisitorId($var)
    {
        GPBUtil::checkString($var, True);
        $this->visitor_id = $var;

        return $this;
    }

    /**
     * User information.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.UserInfo user_info = 5;</code>
     * @return \Google\Cloud\Retail\V2\UserInfo|null
     */
    public function getUserInfo()
    {
        return $this->user_info;
    }

    public function hasUserInfo()
    {
        return isset($this->user_info);
    }

    public function clearUserInfo()
    {
        unset($this->user_info);
    }

    /**
     * User information.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.UserInfo user_info = 5;</code>
     * @param \Google\Cloud\Retail\V2\UserInfo $var
     * @return $this
     */
    public function setUserInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\UserInfo::class);
        $this->user_info = $var;

        return $this;
    }

    /**
     * Maximum number of [Product][google.cloud.retail.v2.Product]s to return. If
     * unspecified, defaults to a reasonable value. The maximum allowed value is
     * 120. Values above 120 will be coerced to 120.
     * If this field is negative, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>int32 page_size = 7;</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * Maximum number of [Product][google.cloud.retail.v2.Product]s to return. If
     * unspecified, defaults to a reasonable value. The maximum allowed value is
     * 120. Values above 120 will be coerced to 120.
     * If this field is negative, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>int32 page_size = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * A page token
     * [SearchResponse.next_page_token][google.cloud.retail.v2.SearchResponse.next_page_token],
     * received from a previous
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] call.
     * Provide this to retrieve the subsequent page.
     * When paginating, all other parameters provided to
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] must
     * match the call that provided the page token. Otherwise, an INVALID_ARGUMENT
     * error is returned.
     *
     * Generated from protobuf field <code>string page_token = 8;</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * A page token
     * [SearchResponse.next_page_token][google.cloud.retail.v2.SearchResponse.next_page_token],
     * received from a previous
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] call.
     * Provide this to retrieve the subsequent page.
     * When paginating, all other parameters provided to
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] must
     * match the call that provided the page token. Otherwise, an INVALID_ARGUMENT
     * error is returned.
     *
     * Generated from protobuf field <code>string page_token = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * A 0-indexed integer that specifies the current offset (that is, starting
     * result location, amongst the [Product][google.cloud.retail.v2.Product]s
     * deemed by the API as relevant) in search results. This field is only
     * considered if [page_token][google.cloud.retail.v2.SearchRequest.page_token]
     * is unset.
     * If this field is negative, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>int32 offset = 9;</code>
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * A 0-indexed integer that specifies the current offset (that is, starting
     * result location, amongst the [Product][google.cloud.retail.v2.Product]s
     * deemed by the API as relevant) in search results. This field is only
     * considered if [page_token][google.cloud.retail.v2.SearchRequest.page_token]
     * is unset.
     * If this field is negative, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>int32 offset = 9;</code>
     * @param int $var
     * @return $this
     */
    public function setOffset($var)
    {
        GPBUtil::checkInt32($var);
        $this->offset = $var;

        return $this;
    }

    /**
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the products being filtered. Filter
     * expression is case-sensitive. For more information, see
     * [Filter](https://cloud.google.com/retail/docs/filter-and-order#filter).
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>string filter = 10;</code>
     * @return string
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the products being filtered. Filter
     * expression is case-sensitive. For more information, see
     * [Filter](https://cloud.google.com/retail/docs/filter-and-order#filter).
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>string filter = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter = $var;

        return $this;
    }

    /**
     * The default filter that is applied when a user performs a search without
     * checking any filters on the search page.
     * The filter applied to every search request when quality improvement such as
     * query expansion is needed. In the case a query does not have a sufficient
     * amount of results this filter will be used to determine whether or not to
     * enable the query expansion flow. The original filter will still be used for
     * the query expanded search.
     * This field is strongly recommended to achieve high search quality.
     * For more information about filter syntax, see
     * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter].
     *
     * Generated from protobuf field <code>string canonical_filter = 28;</code>
     * @return string
     */
    public function getCanonicalFilter()
    {
        return $this->canonical_filter;
    }

    /**
     * The default filter that is applied when a user performs a search without
     * checking any filters on the search page.
     * The filter applied to every search request when quality improvement such as
     * query expansion is needed. In the case a query does not have a sufficient
     * amount of results this filter will be used to determine whether or not to
     * enable the query expansion flow. The original filter will still be used for
     * the query expanded search.
     * This field is strongly recommended to achieve high search quality.
     * For more information about filter syntax, see
     * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter].
     *
     * Generated from protobuf field <code>string canonical_filter = 28;</code>
     * @param string $var
     * @return $this
     */
    public function setCanonicalFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->canonical_filter = $var;

        return $this;
    }

    /**
     * The order in which products are returned. Products can be ordered by
     * a field in an [Product][google.cloud.retail.v2.Product] object. Leave it
     * unset if ordered by relevance. OrderBy expression is case-sensitive. For
     * more information, see
     * [Order](https://cloud.google.com/retail/docs/filter-and-order#order).
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>string order_by = 11;</code>
     * @return string
     */
    public function getOrderBy()
    {
        return $this->order_by;
    }

    /**
     * The order in which products are returned. Products can be ordered by
     * a field in an [Product][google.cloud.retail.v2.Product] object. Leave it
     * unset if ordered by relevance. OrderBy expression is case-sensitive. For
     * more information, see
     * [Order](https://cloud.google.com/retail/docs/filter-and-order#order).
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>string order_by = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setOrderBy($var)
    {
        GPBUtil::checkString($var, True);
        $this->order_by = $var;

        return $this;
    }

    /**
     * Facet specifications for faceted search. If empty, no facets are returned.
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.SearchRequest.FacetSpec facet_specs = 12;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFacetSpecs()
    {
        return $this->facet_specs;
    }

    /**
     * Facet specifications for faceted search. If empty, no facets are returned.
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.SearchRequest.FacetSpec facet_specs = 12;</code>
     * @param array<\Google\Cloud\Retail\V2\SearchRequest\FacetSpec>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFacetSpecs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Retail\V2\SearchRequest\FacetSpec::class);
        $this->facet_specs = $arr;

        return $this;
    }

    /**
     * Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
     * to enable dynamic facets. Do not set this field.
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 21 [deprecated = true];</code>
     * @return \Google\Cloud\Retail\V2\SearchRequest\DynamicFacetSpec|null
     * @deprecated
     */
    public function getDynamicFacetSpec()
    {
        if (isset($this->dynamic_facet_spec)) {
            @trigger_error('dynamic_facet_spec is deprecated.', E_USER_DEPRECATED);
        }
        return $this->dynamic_facet_spec;
    }

    public function hasDynamicFacetSpec()
    {
        if (isset($this->dynamic_facet_spec)) {
            @trigger_error('dynamic_facet_spec is deprecated.', E_USER_DEPRECATED);
        }
        return isset($this->dynamic_facet_spec);
    }

    public function clearDynamicFacetSpec()
    {
        @trigger_error('dynamic_facet_spec is deprecated.', E_USER_DEPRECATED);
        unset($this->dynamic_facet_spec);
    }

    /**
     * Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
     * to enable dynamic facets. Do not set this field.
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 21 [deprecated = true];</code>
     * @param \Google\Cloud\Retail\V2\SearchRequest\DynamicFacetSpec $var
     * @return $this
     * @deprecated
     */
    public function setDynamicFacetSpec($var)
    {
        @trigger_error('dynamic_facet_spec is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\SearchRequest\DynamicFacetSpec::class);
        $this->dynamic_facet_spec = $var;

        return $this;
    }

    /**
     * Boost specification to boost certain products. For more information, see
     * [Boost results](https://cloud.google.com/retail/docs/boosting).
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.BoostSpec boost_spec = 13;</code>
     * @return \Google\Cloud\Retail\V2\SearchRequest\BoostSpec|null
     */
    public function getBoostSpec()
    {
        return $this->boost_spec;
    }

    public function hasBoostSpec()
    {
        return isset($this->boost_spec);
    }

    public function clearBoostSpec()
    {
        unset($this->boost_spec);
    }

    /**
     * Boost specification to boost certain products. For more information, see
     * [Boost results](https://cloud.google.com/retail/docs/boosting).
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.BoostSpec boost_spec = 13;</code>
     * @param \Google\Cloud\Retail\V2\SearchRequest\BoostSpec $var
     * @return $this
     */
    public function setBoostSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\SearchRequest\BoostSpec::class);
        $this->boost_spec = $var;

        return $this;
    }

    /**
     * The query expansion specification that specifies the conditions under which
     * query expansion occurs. For more information, see [Query
     * expansion](https://cloud.google.com/retail/docs/result-size#query_expansion).
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.QueryExpansionSpec query_expansion_spec = 14;</code>
     * @return \Google\Cloud\Retail\V2\SearchRequest\QueryExpansionSpec|null
     */
    public function getQueryExpansionSpec()
    {
        return $this->query_expansion_spec;
    }

    public function hasQueryExpansionSpec()
    {
        return isset($this->query_expansion_spec);
    }

    public function clearQueryExpansionSpec()
    {
        unset($this->query_expansion_spec);
    }

    /**
     * The query expansion specification that specifies the conditions under which
     * query expansion occurs. For more information, see [Query
     * expansion](https://cloud.google.com/retail/docs/result-size#query_expansion).
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.QueryExpansionSpec query_expansion_spec = 14;</code>
     * @param \Google\Cloud\Retail\V2\SearchRequest\QueryExpansionSpec $var
     * @return $this
     */
    public function setQueryExpansionSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\SearchRequest\QueryExpansionSpec::class);
        $this->query_expansion_spec = $var;

        return $this;
    }

    /**
     * The keys to fetch and rollup the matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s attributes,
     * [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo] or
     * [LocalInventory][google.cloud.retail.v2.LocalInventory]s attributes. The
     * attributes from all the matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s or
     * [LocalInventory][google.cloud.retail.v2.LocalInventory]s are merged and
     * de-duplicated. Notice that rollup attributes will lead to extra query
     * latency. Maximum number of keys is 30.
     * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], a
     * fulfillment type and a fulfillment ID must be provided in the format of
     * "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
     * "pickupInStore" is fulfillment type and "store123" is the store ID.
     * Supported keys are:
     * * colorFamilies
     * * price
     * * originalPrice
     * * discount
     * * variantId
     * * inventory(place_id,price)
     * * inventory(place_id,original_price)
     * * inventory(place_id,attributes.key), where key is any key in the
     *   [Product.local_inventories.attributes][google.cloud.retail.v2.LocalInventory.attributes]
     *   map.
     * * attributes.key, where key is any key in the
     *   [Product.attributes][google.cloud.retail.v2.Product.attributes] map.
     * * pickupInStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "pickup-in-store".
     * * shipToStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "ship-to-store".
     * * sameDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "same-day-delivery".
     * * nextDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "next-day-delivery".
     * * customFulfillment1.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-1".
     * * customFulfillment2.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-2".
     * * customFulfillment3.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-3".
     * * customFulfillment4.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-4".
     * * customFulfillment5.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-5".
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>repeated string variant_rollup_keys = 17;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getVariantRollupKeys()
    {
        return $this->variant_rollup_keys;
    }

    /**
     * The keys to fetch and rollup the matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s attributes,
     * [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo] or
     * [LocalInventory][google.cloud.retail.v2.LocalInventory]s attributes. The
     * attributes from all the matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s or
     * [LocalInventory][google.cloud.retail.v2.LocalInventory]s are merged and
     * de-duplicated. Notice that rollup attributes will lead to extra query
     * latency. Maximum number of keys is 30.
     * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], a
     * fulfillment type and a fulfillment ID must be provided in the format of
     * "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
     * "pickupInStore" is fulfillment type and "store123" is the store ID.
     * Supported keys are:
     * * colorFamilies
     * * price
     * * originalPrice
     * * discount
     * * variantId
     * * inventory(place_id,price)
     * * inventory(place_id,original_price)
     * * inventory(place_id,attributes.key), where key is any key in the
     *   [Product.local_inventories.attributes][google.cloud.retail.v2.LocalInventory.attributes]
     *   map.
     * * attributes.key, where key is any key in the
     *   [Product.attributes][google.cloud.retail.v2.Product.attributes] map.
     * * pickupInStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "pickup-in-store".
     * * shipToStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "ship-to-store".
     * * sameDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "same-day-delivery".
     * * nextDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "next-day-delivery".
     * * customFulfillment1.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-1".
     * * customFulfillment2.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-2".
     * * customFulfillment3.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-3".
     * * customFulfillment4.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-4".
     * * customFulfillment5.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-5".
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>repeated string variant_rollup_keys = 17;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setVariantRollupKeys($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->variant_rollup_keys = $arr;

        return $this;
    }

    /**
     * The categories associated with a category page. Must be set for category
     * navigation queries to achieve good search quality. The format should be
     * the same as
     * [UserEvent.page_categories][google.cloud.retail.v2.UserEvent.page_categories];
     * To represent full path of category, use '>' sign to separate different
     * hierarchies. If '>' is part of the category name, replace it with
     * other character(s).
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales > 2017 Black Friday Deals"].
     *
     * Generated from protobuf field <code>repeated string page_categories = 23;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPageCategories()
    {
        return $this->page_categories;
    }

    /**
     * The categories associated with a category page. Must be set for category
     * navigation queries to achieve good search quality. The format should be
     * the same as
     * [UserEvent.page_categories][google.cloud.retail.v2.UserEvent.page_categories];
     * To represent full path of category, use '>' sign to separate different
     * hierarchies. If '>' is part of the category name, replace it with
     * other character(s).
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales > 2017 Black Friday Deals"].
     *
     * Generated from protobuf field <code>repeated string page_categories = 23;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPageCategories($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->page_categories = $arr;

        return $this;
    }

    /**
     * The search mode of the search request. If not specified, a single search
     * request triggers both product search and faceted search.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.SearchMode search_mode = 31;</code>
     * @return int
     */
    public function getSearchMode()
    {
        return $this->search_mode;
    }

    /**
     * The search mode of the search request. If not specified, a single search
     * request triggers both product search and faceted search.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.SearchMode search_mode = 31;</code>
     * @param int $var
     * @return $this
     */
    public function setSearchMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Retail\V2\SearchRequest\SearchMode::class);
        $this->search_mode = $var;

        return $this;
    }

    /**
     * The specification for personalization.
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2.ServingConfig.personalization_spec].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.PersonalizationSpec personalization_spec = 32;</code>
     * @return \Google\Cloud\Retail\V2\SearchRequest\PersonalizationSpec|null
     */
    public function getPersonalizationSpec()
    {
        return $this->personalization_spec;
    }

    public function hasPersonalizationSpec()
    {
        return isset($this->personalization_spec);
    }

    public function clearPersonalizationSpec()
    {
        unset($this->personalization_spec);
    }

    /**
     * The specification for personalization.
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2.ServingConfig.personalization_spec].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.PersonalizationSpec personalization_spec = 32;</code>
     * @param \Google\Cloud\Retail\V2\SearchRequest\PersonalizationSpec $var
     * @return $this
     */
    public function setPersonalizationSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\SearchRequest\PersonalizationSpec::class);
        $this->personalization_spec = $var;

        return $this;
    }

    /**
     * The labels applied to a resource must meet the following requirements:
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     * For more information, see [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * in the Resource Manager documentation.
     *
     * Generated from protobuf field <code>map<string, string> labels = 34;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * The labels applied to a resource must meet the following requirements:
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     * For more information, see [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * in the Resource Manager documentation.
     *
     * Generated from protobuf field <code>map<string, string> labels = 34;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * The spell correction specification that specifies the mode under
     * which spell correction will take effect.
     *
     * Generated from protobuf field <code>optional .google.cloud.retail.v2.SearchRequest.SpellCorrectionSpec spell_correction_spec = 35;</code>
     * @return \Google\Cloud\Retail\V2\SearchRequest\SpellCorrectionSpec|null
     */
    public function getSpellCorrectionSpec()
    {
        return $this->spell_correction_spec;
    }

    public function hasSpellCorrectionSpec()
    {
        return isset($this->spell_correction_spec);
    }

    public function clearSpellCorrectionSpec()
    {
        unset($this->spell_correction_spec);
    }

    /**
     * The spell correction specification that specifies the mode under
     * which spell correction will take effect.
     *
     * Generated from protobuf field <code>optional .google.cloud.retail.v2.SearchRequest.SpellCorrectionSpec spell_correction_spec = 35;</code>
     * @param \Google\Cloud\Retail\V2\SearchRequest\SpellCorrectionSpec $var
     * @return $this
     */
    public function setSpellCorrectionSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\SearchRequest\SpellCorrectionSpec::class);
        $this->spell_correction_spec = $var;

        return $this;
    }

    /**
     * The entity for customers that may run multiple different entities, domains,
     * sites or regions, for example, `Google US`, `Google Ads`, `Waymo`,
     * `google.com`, `youtube.com`, etc.
     * If this is set, it should be exactly matched with
     * [UserEvent.entity][google.cloud.retail.v2.UserEvent.entity] to get search
     * results boosted by entity.
     *
     * Generated from protobuf field <code>string entity = 38;</code>
     * @return string
     */
    public function getEntity()
    {
        return $this->entity;
    }

    /**
     * The entity for customers that may run multiple different entities, domains,
     * sites or regions, for example, `Google US`, `Google Ads`, `Waymo`,
     * `google.com`, `youtube.com`, etc.
     * If this is set, it should be exactly matched with
     * [UserEvent.entity][google.cloud.retail.v2.UserEvent.entity] to get search
     * results boosted by entity.
     *
     * Generated from protobuf field <code>string entity = 38;</code>
     * @param string $var
     * @return $this
     */
    public function setEntity($var)
    {
        GPBUtil::checkString($var, True);
        $this->entity = $var;

        return $this;
    }

    /**
     * Optional. This field specifies all conversational related parameters
     * addition to traditional retail search.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec conversational_search_spec = 40 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Retail\V2\SearchRequest\ConversationalSearchSpec|null
     */
    public function getConversationalSearchSpec()
    {
        return $this->conversational_search_spec;
    }

    public function hasConversationalSearchSpec()
    {
        return isset($this->conversational_search_spec);
    }

    public function clearConversationalSearchSpec()
    {
        unset($this->conversational_search_spec);
    }

    /**
     * Optional. This field specifies all conversational related parameters
     * addition to traditional retail search.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec conversational_search_spec = 40 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Retail\V2\SearchRequest\ConversationalSearchSpec $var
     * @return $this
     */
    public function setConversationalSearchSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\SearchRequest\ConversationalSearchSpec::class);
        $this->conversational_search_spec = $var;

        return $this;
    }

    /**
     * Optional. This field specifies tile navigation related parameters.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.TileNavigationSpec tile_navigation_spec = 41 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Retail\V2\SearchRequest\TileNavigationSpec|null
     */
    public function getTileNavigationSpec()
    {
        return $this->tile_navigation_spec;
    }

    public function hasTileNavigationSpec()
    {
        return isset($this->tile_navigation_spec);
    }

    public function clearTileNavigationSpec()
    {
        unset($this->tile_navigation_spec);
    }

    /**
     * Optional. This field specifies tile navigation related parameters.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.TileNavigationSpec tile_navigation_spec = 41 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Retail\V2\SearchRequest\TileNavigationSpec $var
     * @return $this
     */
    public function setTileNavigationSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\SearchRequest\TileNavigationSpec::class);
        $this->tile_navigation_spec = $var;

        return $this;
    }

    /**
     * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn"
     * [list](https://www.unicode.org/cldr/charts/46/summary/root.html). For more
     * information, see [Standardized codes](https://google.aip.dev/143). This
     * field helps to better interpret the query. If a value isn't specified, the
     * query language code is automatically detected, which may not be accurate.
     *
     * Generated from protobuf field <code>string language_code = 43 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->language_code;
    }

    /**
     * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn"
     * [list](https://www.unicode.org/cldr/charts/46/summary/root.html). For more
     * information, see [Standardized codes](https://google.aip.dev/143). This
     * field helps to better interpret the query. If a value isn't specified, the
     * query language code is automatically detected, which may not be accurate.
     *
     * Generated from protobuf field <code>string language_code = 43 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setLanguageCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->language_code = $var;

        return $this;
    }

    /**
     * Optional. The Unicode country/region code (CLDR) of a location, such as
     * "US" and "419"
     * [list](https://www.unicode.org/cldr/charts/46/supplemental/territory_information.html).
     * For more information, see [Standardized codes](https://google.aip.dev/143).
     * If set, then results will be boosted based on the region_code provided.
     *
     * Generated from protobuf field <code>string region_code = 44 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getRegionCode()
    {
        return $this->region_code;
    }

    /**
     * Optional. The Unicode country/region code (CLDR) of a location, such as
     * "US" and "419"
     * [list](https://www.unicode.org/cldr/charts/46/supplemental/territory_information.html).
     * For more information, see [Standardized codes](https://google.aip.dev/143).
     * If set, then results will be boosted based on the region_code provided.
     *
     * Generated from protobuf field <code>string region_code = 44 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setRegionCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->region_code = $var;

        return $this;
    }

    /**
     * Optional. An id corresponding to a place, such as a store id or region id.
     * When specified, we use the price from the local inventory with the matching
     * product's
     * [LocalInventory.place_id][google.cloud.retail.v2.LocalInventory.place_id]
     * for revenue optimization.
     *
     * Generated from protobuf field <code>string place_id = 46 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPlaceId()
    {
        return $this->place_id;
    }

    /**
     * Optional. An id corresponding to a place, such as a store id or region id.
     * When specified, we use the price from the local inventory with the matching
     * product's
     * [LocalInventory.place_id][google.cloud.retail.v2.LocalInventory.place_id]
     * for revenue optimization.
     *
     * Generated from protobuf field <code>string place_id = 46 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPlaceId($var)
    {
        GPBUtil::checkString($var, True);
        $this->place_id = $var;

        return $this;
    }

}

