<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/managedkafka/v1/resources.proto

namespace Google\Cloud\ManagedKafka\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents the set of ACLs for a given Kafka Resource Pattern, which consists
 * of resource_type, resource_name and pattern_type.
 *
 * Generated from protobuf message <code>google.cloud.managedkafka.v1.Acl</code>
 */
class Acl extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name for the acl. Represents a single Resource Pattern.
     * Structured like:
     * projects/{project}/locations/{location}/clusters/{cluster}/acls/{acl_id}
     * The structure of `acl_id` defines the Resource Pattern (resource_type,
     * resource_name, pattern_type) of the acl. `acl_id` is structured like one of
     * the following:
     * For acls on the cluster:
     *   `cluster`
     * For acls on a single resource within the cluster:
     *   `topic/{resource_name}`
     *   `consumerGroup/{resource_name}`
     *   `transactionalId/{resource_name}`
     * For acls on all resources that match a prefix:
     *   `topicPrefixed/{resource_name}`
     *   `consumerGroupPrefixed/{resource_name}`
     *   `transactionalIdPrefixed/{resource_name}`
     * For acls on all resources of a given type (i.e. the wildcard literal "*"):
     *   `allTopics` (represents `topic/&#42;`)
     *   `allConsumerGroups` (represents `consumerGroup/&#42;`)
     *   `allTransactionalIds` (represents `transactionalId/&#42;`)
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. The ACL entries that apply to the resource pattern. The maximum
     * number of allowed entries 100.
     *
     * Generated from protobuf field <code>repeated .google.cloud.managedkafka.v1.AclEntry acl_entries = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $acl_entries;
    /**
     * Optional. `etag` is used for concurrency control. An `etag` is returned in
     * the response to `GetAcl` and `CreateAcl`. Callers are required to put that
     * etag in the request to `UpdateAcl` to ensure that their change will be
     * applied to the same version of the acl that exists in the Kafka Cluster.
     * A terminal 'T' character in the etag indicates that the AclEntries were
     * truncated; more entries for the Acl exist on the Kafka Cluster, but can't
     * be returned in the Acl due to repeated field limits.
     *
     * Generated from protobuf field <code>string etag = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $etag = '';
    /**
     * Output only. The ACL resource type derived from the name. One of: CLUSTER,
     * TOPIC, GROUP, TRANSACTIONAL_ID.
     *
     * Generated from protobuf field <code>string resource_type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $resource_type = '';
    /**
     * Output only. The ACL resource name derived from the name. For cluster
     * resource_type, this is always "kafka-cluster". Can be the wildcard literal
     * "*".
     *
     * Generated from protobuf field <code>string resource_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $resource_name = '';
    /**
     * Output only. The ACL pattern type derived from the name. One of: LITERAL,
     * PREFIXED.
     *
     * Generated from protobuf field <code>string pattern_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $pattern_type = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The name for the acl. Represents a single Resource Pattern.
     *           Structured like:
     *           projects/{project}/locations/{location}/clusters/{cluster}/acls/{acl_id}
     *           The structure of `acl_id` defines the Resource Pattern (resource_type,
     *           resource_name, pattern_type) of the acl. `acl_id` is structured like one of
     *           the following:
     *           For acls on the cluster:
     *             `cluster`
     *           For acls on a single resource within the cluster:
     *             `topic/{resource_name}`
     *             `consumerGroup/{resource_name}`
     *             `transactionalId/{resource_name}`
     *           For acls on all resources that match a prefix:
     *             `topicPrefixed/{resource_name}`
     *             `consumerGroupPrefixed/{resource_name}`
     *             `transactionalIdPrefixed/{resource_name}`
     *           For acls on all resources of a given type (i.e. the wildcard literal "*"):
     *             `allTopics` (represents `topic/&#42;`)
     *             `allConsumerGroups` (represents `consumerGroup/&#42;`)
     *             `allTransactionalIds` (represents `transactionalId/&#42;`)
     *     @type array<\Google\Cloud\ManagedKafka\V1\AclEntry>|\Google\Protobuf\Internal\RepeatedField $acl_entries
     *           Required. The ACL entries that apply to the resource pattern. The maximum
     *           number of allowed entries 100.
     *     @type string $etag
     *           Optional. `etag` is used for concurrency control. An `etag` is returned in
     *           the response to `GetAcl` and `CreateAcl`. Callers are required to put that
     *           etag in the request to `UpdateAcl` to ensure that their change will be
     *           applied to the same version of the acl that exists in the Kafka Cluster.
     *           A terminal 'T' character in the etag indicates that the AclEntries were
     *           truncated; more entries for the Acl exist on the Kafka Cluster, but can't
     *           be returned in the Acl due to repeated field limits.
     *     @type string $resource_type
     *           Output only. The ACL resource type derived from the name. One of: CLUSTER,
     *           TOPIC, GROUP, TRANSACTIONAL_ID.
     *     @type string $resource_name
     *           Output only. The ACL resource name derived from the name. For cluster
     *           resource_type, this is always "kafka-cluster". Can be the wildcard literal
     *           "*".
     *     @type string $pattern_type
     *           Output only. The ACL pattern type derived from the name. One of: LITERAL,
     *           PREFIXED.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Managedkafka\V1\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The name for the acl. Represents a single Resource Pattern.
     * Structured like:
     * projects/{project}/locations/{location}/clusters/{cluster}/acls/{acl_id}
     * The structure of `acl_id` defines the Resource Pattern (resource_type,
     * resource_name, pattern_type) of the acl. `acl_id` is structured like one of
     * the following:
     * For acls on the cluster:
     *   `cluster`
     * For acls on a single resource within the cluster:
     *   `topic/{resource_name}`
     *   `consumerGroup/{resource_name}`
     *   `transactionalId/{resource_name}`
     * For acls on all resources that match a prefix:
     *   `topicPrefixed/{resource_name}`
     *   `consumerGroupPrefixed/{resource_name}`
     *   `transactionalIdPrefixed/{resource_name}`
     * For acls on all resources of a given type (i.e. the wildcard literal "*"):
     *   `allTopics` (represents `topic/&#42;`)
     *   `allConsumerGroups` (represents `consumerGroup/&#42;`)
     *   `allTransactionalIds` (represents `transactionalId/&#42;`)
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name for the acl. Represents a single Resource Pattern.
     * Structured like:
     * projects/{project}/locations/{location}/clusters/{cluster}/acls/{acl_id}
     * The structure of `acl_id` defines the Resource Pattern (resource_type,
     * resource_name, pattern_type) of the acl. `acl_id` is structured like one of
     * the following:
     * For acls on the cluster:
     *   `cluster`
     * For acls on a single resource within the cluster:
     *   `topic/{resource_name}`
     *   `consumerGroup/{resource_name}`
     *   `transactionalId/{resource_name}`
     * For acls on all resources that match a prefix:
     *   `topicPrefixed/{resource_name}`
     *   `consumerGroupPrefixed/{resource_name}`
     *   `transactionalIdPrefixed/{resource_name}`
     * For acls on all resources of a given type (i.e. the wildcard literal "*"):
     *   `allTopics` (represents `topic/&#42;`)
     *   `allConsumerGroups` (represents `consumerGroup/&#42;`)
     *   `allTransactionalIds` (represents `transactionalId/&#42;`)
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The ACL entries that apply to the resource pattern. The maximum
     * number of allowed entries 100.
     *
     * Generated from protobuf field <code>repeated .google.cloud.managedkafka.v1.AclEntry acl_entries = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAclEntries()
    {
        return $this->acl_entries;
    }

    /**
     * Required. The ACL entries that apply to the resource pattern. The maximum
     * number of allowed entries 100.
     *
     * Generated from protobuf field <code>repeated .google.cloud.managedkafka.v1.AclEntry acl_entries = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Cloud\ManagedKafka\V1\AclEntry>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAclEntries($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\ManagedKafka\V1\AclEntry::class);
        $this->acl_entries = $arr;

        return $this;
    }

    /**
     * Optional. `etag` is used for concurrency control. An `etag` is returned in
     * the response to `GetAcl` and `CreateAcl`. Callers are required to put that
     * etag in the request to `UpdateAcl` to ensure that their change will be
     * applied to the same version of the acl that exists in the Kafka Cluster.
     * A terminal 'T' character in the etag indicates that the AclEntries were
     * truncated; more entries for the Acl exist on the Kafka Cluster, but can't
     * be returned in the Acl due to repeated field limits.
     *
     * Generated from protobuf field <code>string etag = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Optional. `etag` is used for concurrency control. An `etag` is returned in
     * the response to `GetAcl` and `CreateAcl`. Callers are required to put that
     * etag in the request to `UpdateAcl` to ensure that their change will be
     * applied to the same version of the acl that exists in the Kafka Cluster.
     * A terminal 'T' character in the etag indicates that the AclEntries were
     * truncated; more entries for the Acl exist on the Kafka Cluster, but can't
     * be returned in the Acl due to repeated field limits.
     *
     * Generated from protobuf field <code>string etag = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * Output only. The ACL resource type derived from the name. One of: CLUSTER,
     * TOPIC, GROUP, TRANSACTIONAL_ID.
     *
     * Generated from protobuf field <code>string resource_type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getResourceType()
    {
        return $this->resource_type;
    }

    /**
     * Output only. The ACL resource type derived from the name. One of: CLUSTER,
     * TOPIC, GROUP, TRANSACTIONAL_ID.
     *
     * Generated from protobuf field <code>string resource_type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setResourceType($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource_type = $var;

        return $this;
    }

    /**
     * Output only. The ACL resource name derived from the name. For cluster
     * resource_type, this is always "kafka-cluster". Can be the wildcard literal
     * "*".
     *
     * Generated from protobuf field <code>string resource_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getResourceName()
    {
        return $this->resource_name;
    }

    /**
     * Output only. The ACL resource name derived from the name. For cluster
     * resource_type, this is always "kafka-cluster". Can be the wildcard literal
     * "*".
     *
     * Generated from protobuf field <code>string resource_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setResourceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource_name = $var;

        return $this;
    }

    /**
     * Output only. The ACL pattern type derived from the name. One of: LITERAL,
     * PREFIXED.
     *
     * Generated from protobuf field <code>string pattern_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getPatternType()
    {
        return $this->pattern_type;
    }

    /**
     * Output only. The ACL pattern type derived from the name. One of: LITERAL,
     * PREFIXED.
     *
     * Generated from protobuf field <code>string pattern_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setPatternType($var)
    {
        GPBUtil::checkString($var, True);
        $this->pattern_type = $var;

        return $this;
    }

}

