<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/eventarc/v1/pipeline.proto

namespace Google\Cloud\Eventarc\V1\Pipeline\Destination\AuthenticationConfig;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Contains information needed for generating an
 * [OAuth token](https://developers.google.com/identity/protocols/OAuth2).
 * This type of authorization should generally only be used when calling
 * Google APIs hosted on *.googleapis.com.
 *
 * Generated from protobuf message <code>google.cloud.eventarc.v1.Pipeline.Destination.AuthenticationConfig.OAuthToken</code>
 */
class OAuthToken extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Service account email used to generate the [OAuth
     * token](https://developers.google.com/identity/protocols/OAuth2).
     * The principal who calls this API must have
     * iam.serviceAccounts.actAs permission in the service account. See
     * https://cloud.google.com/iam/docs/understanding-service-accounts?hl=en#sa_common
     * for more information. Eventarc service agents must have
     * roles/roles/iam.serviceAccountTokenCreator role to allow Pipeline
     * to create OAuth2 tokens for authenticated requests.
     *
     * Generated from protobuf field <code>string service_account = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $service_account = '';
    /**
     * Optional. OAuth scope to be used for generating OAuth access token.
     * If not specified, "https://www.googleapis.com/auth/cloud-platform"
     * will be used.
     *
     * Generated from protobuf field <code>string scope = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $scope = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $service_account
     *           Required. Service account email used to generate the [OAuth
     *           token](https://developers.google.com/identity/protocols/OAuth2).
     *           The principal who calls this API must have
     *           iam.serviceAccounts.actAs permission in the service account. See
     *           https://cloud.google.com/iam/docs/understanding-service-accounts?hl=en#sa_common
     *           for more information. Eventarc service agents must have
     *           roles/roles/iam.serviceAccountTokenCreator role to allow Pipeline
     *           to create OAuth2 tokens for authenticated requests.
     *     @type string $scope
     *           Optional. OAuth scope to be used for generating OAuth access token.
     *           If not specified, "https://www.googleapis.com/auth/cloud-platform"
     *           will be used.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Eventarc\V1\Pipeline::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Service account email used to generate the [OAuth
     * token](https://developers.google.com/identity/protocols/OAuth2).
     * The principal who calls this API must have
     * iam.serviceAccounts.actAs permission in the service account. See
     * https://cloud.google.com/iam/docs/understanding-service-accounts?hl=en#sa_common
     * for more information. Eventarc service agents must have
     * roles/roles/iam.serviceAccountTokenCreator role to allow Pipeline
     * to create OAuth2 tokens for authenticated requests.
     *
     * Generated from protobuf field <code>string service_account = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getServiceAccount()
    {
        return $this->service_account;
    }

    /**
     * Required. Service account email used to generate the [OAuth
     * token](https://developers.google.com/identity/protocols/OAuth2).
     * The principal who calls this API must have
     * iam.serviceAccounts.actAs permission in the service account. See
     * https://cloud.google.com/iam/docs/understanding-service-accounts?hl=en#sa_common
     * for more information. Eventarc service agents must have
     * roles/roles/iam.serviceAccountTokenCreator role to allow Pipeline
     * to create OAuth2 tokens for authenticated requests.
     *
     * Generated from protobuf field <code>string service_account = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account = $var;

        return $this;
    }

    /**
     * Optional. OAuth scope to be used for generating OAuth access token.
     * If not specified, "https://www.googleapis.com/auth/cloud-platform"
     * will be used.
     *
     * Generated from protobuf field <code>string scope = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getScope()
    {
        return $this->scope;
    }

    /**
     * Optional. OAuth scope to be used for generating OAuth access token.
     * If not specified, "https://www.googleapis.com/auth/cloud-platform"
     * will be used.
     *
     * Generated from protobuf field <code>string scope = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setScope($var)
    {
        GPBUtil::checkString($var, True);
        $this->scope = $var;

        return $this;
    }

}


