<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/certificatemanager/v1/certificate_manager.proto

namespace Google\Cloud\CertificateManager\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A DnsAuthorization resource describes a way to perform domain authorization
 * for certificate issuance.
 *
 * Generated from protobuf message <code>google.cloud.certificatemanager.v1.DnsAuthorization</code>
 */
class DnsAuthorization extends \Google\Protobuf\Internal\Message
{
    /**
     * A user-defined name of the dns authorization. DnsAuthorization names must
     * be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;dnsAuthorizations/&#42;`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Output only. The creation timestamp of a DnsAuthorization.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. The last update timestamp of a DnsAuthorization.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * Set of labels associated with a DnsAuthorization.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     */
    private $labels;
    /**
     * One or more paragraphs of text description of a DnsAuthorization.
     *
     * Generated from protobuf field <code>string description = 5;</code>
     */
    private $description = '';
    /**
     * Required. Immutable. A domain that is being authorized. A DnsAuthorization
     * resource covers a single domain and its wildcard, e.g. authorization for
     * `example.com` can be used to issue certificates for `example.com` and
     * `*.example.com`.
     *
     * Generated from protobuf field <code>string domain = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $domain = '';
    /**
     * Output only. DNS Resource Record that needs to be added to DNS
     * configuration.
     *
     * Generated from protobuf field <code>.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord dns_resource_record = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $dns_resource_record = null;
    /**
     * Immutable. Type of DnsAuthorization. If unset during resource creation the
     * following default will be used:
     * - in location global: FIXED_RECORD.
     *
     * Generated from protobuf field <code>.google.cloud.certificatemanager.v1.DnsAuthorization.Type type = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $type = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           A user-defined name of the dns authorization. DnsAuthorization names must
     *           be unique globally and match pattern
     *           `projects/&#42;&#47;locations/&#42;&#47;dnsAuthorizations/&#42;`.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The creation timestamp of a DnsAuthorization.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The last update timestamp of a DnsAuthorization.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Set of labels associated with a DnsAuthorization.
     *     @type string $description
     *           One or more paragraphs of text description of a DnsAuthorization.
     *     @type string $domain
     *           Required. Immutable. A domain that is being authorized. A DnsAuthorization
     *           resource covers a single domain and its wildcard, e.g. authorization for
     *           `example.com` can be used to issue certificates for `example.com` and
     *           `*.example.com`.
     *     @type \Google\Cloud\CertificateManager\V1\DnsAuthorization\DnsResourceRecord $dns_resource_record
     *           Output only. DNS Resource Record that needs to be added to DNS
     *           configuration.
     *     @type int $type
     *           Immutable. Type of DnsAuthorization. If unset during resource creation the
     *           following default will be used:
     *           - in location global: FIXED_RECORD.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Certificatemanager\V1\CertificateManager::initOnce();
        parent::__construct($data);
    }

    /**
     * A user-defined name of the dns authorization. DnsAuthorization names must
     * be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;dnsAuthorizations/&#42;`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * A user-defined name of the dns authorization. DnsAuthorization names must
     * be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;dnsAuthorizations/&#42;`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The creation timestamp of a DnsAuthorization.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The creation timestamp of a DnsAuthorization.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The last update timestamp of a DnsAuthorization.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The last update timestamp of a DnsAuthorization.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Set of labels associated with a DnsAuthorization.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Set of labels associated with a DnsAuthorization.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * One or more paragraphs of text description of a DnsAuthorization.
     *
     * Generated from protobuf field <code>string description = 5;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * One or more paragraphs of text description of a DnsAuthorization.
     *
     * Generated from protobuf field <code>string description = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Required. Immutable. A domain that is being authorized. A DnsAuthorization
     * resource covers a single domain and its wildcard, e.g. authorization for
     * `example.com` can be used to issue certificates for `example.com` and
     * `*.example.com`.
     *
     * Generated from protobuf field <code>string domain = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getDomain()
    {
        return $this->domain;
    }

    /**
     * Required. Immutable. A domain that is being authorized. A DnsAuthorization
     * resource covers a single domain and its wildcard, e.g. authorization for
     * `example.com` can be used to issue certificates for `example.com` and
     * `*.example.com`.
     *
     * Generated from protobuf field <code>string domain = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setDomain($var)
    {
        GPBUtil::checkString($var, True);
        $this->domain = $var;

        return $this;
    }

    /**
     * Output only. DNS Resource Record that needs to be added to DNS
     * configuration.
     *
     * Generated from protobuf field <code>.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord dns_resource_record = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\CertificateManager\V1\DnsAuthorization\DnsResourceRecord|null
     */
    public function getDnsResourceRecord()
    {
        return $this->dns_resource_record;
    }

    public function hasDnsResourceRecord()
    {
        return isset($this->dns_resource_record);
    }

    public function clearDnsResourceRecord()
    {
        unset($this->dns_resource_record);
    }

    /**
     * Output only. DNS Resource Record that needs to be added to DNS
     * configuration.
     *
     * Generated from protobuf field <code>.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord dns_resource_record = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\CertificateManager\V1\DnsAuthorization\DnsResourceRecord $var
     * @return $this
     */
    public function setDnsResourceRecord($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CertificateManager\V1\DnsAuthorization\DnsResourceRecord::class);
        $this->dns_resource_record = $var;

        return $this;
    }

    /**
     * Immutable. Type of DnsAuthorization. If unset during resource creation the
     * following default will be used:
     * - in location global: FIXED_RECORD.
     *
     * Generated from protobuf field <code>.google.cloud.certificatemanager.v1.DnsAuthorization.Type type = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Immutable. Type of DnsAuthorization. If unset during resource creation the
     * following default will be used:
     * - in location global: FIXED_RECORD.
     *
     * Generated from protobuf field <code>.google.cloud.certificatemanager.v1.DnsAuthorization.Type type = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\CertificateManager\V1\DnsAuthorization\Type::class);
        $this->type = $var;

        return $this;
    }

}

