<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/aiplatform/v1/feature_registry_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AIPlatform\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AIPlatform\V1\CreateFeatureGroupRequest;
use Google\Cloud\AIPlatform\V1\CreateFeatureRequest;
use Google\Cloud\AIPlatform\V1\DeleteFeatureGroupRequest;
use Google\Cloud\AIPlatform\V1\DeleteFeatureRequest;
use Google\Cloud\AIPlatform\V1\Feature;
use Google\Cloud\AIPlatform\V1\FeatureGroup;
use Google\Cloud\AIPlatform\V1\GetFeatureGroupRequest;
use Google\Cloud\AIPlatform\V1\GetFeatureRequest;
use Google\Cloud\AIPlatform\V1\ListFeatureGroupsRequest;
use Google\Cloud\AIPlatform\V1\ListFeatureGroupsResponse;
use Google\Cloud\AIPlatform\V1\ListFeaturesRequest;
use Google\Cloud\AIPlatform\V1\ListFeaturesResponse;
use Google\Cloud\AIPlatform\V1\UpdateFeatureGroupRequest;
use Google\Cloud\AIPlatform\V1\UpdateFeatureRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: The service that handles CRUD and List for resources for
 * FeatureRegistry.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $featureRegistryServiceClient = new FeatureRegistryServiceClient();
 * try {
 *     $formattedParent = $featureRegistryServiceClient->entityTypeName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]', '[ENTITY_TYPE]');
 *     $feature = new Feature();
 *     $featureId = 'feature_id';
 *     $operationResponse = $featureRegistryServiceClient->createFeature($formattedParent, $feature, $featureId);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $featureRegistryServiceClient->createFeature($formattedParent, $feature, $featureId);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $featureRegistryServiceClient->resumeOperation($operationName, 'createFeature');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $featureRegistryServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @deprecated Please use the new service client {@see \Google\Cloud\AIPlatform\V1\Client\FeatureRegistryServiceClient}.
 */
class FeatureRegistryServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.aiplatform.v1.FeatureRegistryService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    const SERVICE_ADDRESS = 'aiplatform.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'aiplatform.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $entityTypeNameTemplate;

    private static $featureNameTemplate;

    private static $featureGroupNameTemplate;

    private static $locationNameTemplate;

    private static $projectLocationFeatureGroupFeatureNameTemplate;

    private static $projectLocationFeaturestoreEntityTypeFeatureNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ .
                '/../resources/feature_registry_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/feature_registry_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ .
                '/../resources/feature_registry_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/feature_registry_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getEntityTypeNameTemplate()
    {
        if (self::$entityTypeNameTemplate == null) {
            self::$entityTypeNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}'
            );
        }

        return self::$entityTypeNameTemplate;
    }

    private static function getFeatureNameTemplate()
    {
        if (self::$featureNameTemplate == null) {
            self::$featureNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}'
            );
        }

        return self::$featureNameTemplate;
    }

    private static function getFeatureGroupNameTemplate()
    {
        if (self::$featureGroupNameTemplate == null) {
            self::$featureGroupNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/featureGroups/{feature_group}'
            );
        }

        return self::$featureGroupNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getProjectLocationFeatureGroupFeatureNameTemplate()
    {
        if (self::$projectLocationFeatureGroupFeatureNameTemplate == null) {
            self::$projectLocationFeatureGroupFeatureNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}'
            );
        }

        return self::$projectLocationFeatureGroupFeatureNameTemplate;
    }

    private static function getProjectLocationFeaturestoreEntityTypeFeatureNameTemplate()
    {
        if (
            self::$projectLocationFeaturestoreEntityTypeFeatureNameTemplate ==
            null
        ) {
            self::$projectLocationFeaturestoreEntityTypeFeatureNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}'
            );
        }

        return self::$projectLocationFeaturestoreEntityTypeFeatureNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'entityType' => self::getEntityTypeNameTemplate(),
                'feature' => self::getFeatureNameTemplate(),
                'featureGroup' => self::getFeatureGroupNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'projectLocationFeatureGroupFeature' => self::getProjectLocationFeatureGroupFeatureNameTemplate(),
                'projectLocationFeaturestoreEntityTypeFeature' => self::getProjectLocationFeaturestoreEntityTypeFeatureNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a entity_type
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $featurestore
     * @param string $entityType
     *
     * @return string The formatted entity_type resource.
     */
    public static function entityTypeName(
        $project,
        $location,
        $featurestore,
        $entityType
    ) {
        return self::getEntityTypeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'featurestore' => $featurestore,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a feature
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $featurestore
     * @param string $entityType
     * @param string $feature
     *
     * @return string The formatted feature resource.
     */
    public static function featureName(
        $project,
        $location,
        $featurestore,
        $entityType,
        $feature
    ) {
        return self::getFeatureNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'featurestore' => $featurestore,
            'entity_type' => $entityType,
            'feature' => $feature,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * feature_group resource.
     *
     * @param string $project
     * @param string $location
     * @param string $featureGroup
     *
     * @return string The formatted feature_group resource.
     */
    public static function featureGroupName($project, $location, $featureGroup)
    {
        return self::getFeatureGroupNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'feature_group' => $featureGroup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_feature_group_feature resource.
     *
     * @param string $project
     * @param string $location
     * @param string $featureGroup
     * @param string $feature
     *
     * @return string The formatted project_location_feature_group_feature resource.
     */
    public static function projectLocationFeatureGroupFeatureName(
        $project,
        $location,
        $featureGroup,
        $feature
    ) {
        return self::getProjectLocationFeatureGroupFeatureNameTemplate()->render(
            [
                'project' => $project,
                'location' => $location,
                'feature_group' => $featureGroup,
                'feature' => $feature,
            ]
        );
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_featurestore_entity_type_feature resource.
     *
     * @param string $project
     * @param string $location
     * @param string $featurestore
     * @param string $entityType
     * @param string $feature
     *
     * @return string The formatted project_location_featurestore_entity_type_feature resource.
     */
    public static function projectLocationFeaturestoreEntityTypeFeatureName(
        $project,
        $location,
        $featurestore,
        $entityType,
        $feature
    ) {
        return self::getProjectLocationFeaturestoreEntityTypeFeatureNameTemplate()->render(
            [
                'project' => $project,
                'location' => $location,
                'featurestore' => $featurestore,
                'entity_type' => $entityType,
                'feature' => $feature,
            ]
        );
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - entityType: projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}
     * - feature: projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}
     * - featureGroup: projects/{project}/locations/{location}/featureGroups/{feature_group}
     * - location: projects/{project}/locations/{location}
     * - projectLocationFeatureGroupFeature: projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}
     * - projectLocationFeaturestoreEntityTypeFeature: projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'aiplatform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a new Feature in a given FeatureGroup.
     *
     * Sample code:
     * ```
     * $featureRegistryServiceClient = new FeatureRegistryServiceClient();
     * try {
     *     $formattedParent = $featureRegistryServiceClient->entityTypeName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]', '[ENTITY_TYPE]');
     *     $feature = new Feature();
     *     $featureId = 'feature_id';
     *     $operationResponse = $featureRegistryServiceClient->createFeature($formattedParent, $feature, $featureId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featureRegistryServiceClient->createFeature($formattedParent, $feature, $featureId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featureRegistryServiceClient->resumeOperation($operationName, 'createFeature');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featureRegistryServiceClient->close();
     * }
     * ```
     *
     * @param string  $parent       Required. The resource name of the EntityType or FeatureGroup to create a
     *                              Feature. Format for entity_type as parent:
     *                              `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
     *                              Format for feature_group as parent:
     *                              `projects/{project}/locations/{location}/featureGroups/{feature_group}`
     * @param Feature $feature      Required. The Feature to create.
     * @param string  $featureId    Required. The ID to use for the Feature, which will become the final
     *                              component of the Feature's resource name.
     *
     *                              This value may be up to 128 characters, and valid characters are
     *                              `[a-z0-9_]`. The first character cannot be a number.
     *
     *                              The value must be unique within an EntityType/FeatureGroup.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createFeature(
        $parent,
        $feature,
        $featureId,
        array $optionalArgs = []
    ) {
        $request = new CreateFeatureRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setFeature($feature);
        $request->setFeatureId($featureId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateFeature',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new FeatureGroup in a given project and location.
     *
     * Sample code:
     * ```
     * $featureRegistryServiceClient = new FeatureRegistryServiceClient();
     * try {
     *     $formattedParent = $featureRegistryServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $featureGroup = new FeatureGroup();
     *     $featureGroupId = 'feature_group_id';
     *     $operationResponse = $featureRegistryServiceClient->createFeatureGroup($formattedParent, $featureGroup, $featureGroupId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featureRegistryServiceClient->createFeatureGroup($formattedParent, $featureGroup, $featureGroupId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featureRegistryServiceClient->resumeOperation($operationName, 'createFeatureGroup');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featureRegistryServiceClient->close();
     * }
     * ```
     *
     * @param string       $parent         Required. The resource name of the Location to create FeatureGroups.
     *                                     Format:
     *                                     `projects/{project}/locations/{location}`
     * @param FeatureGroup $featureGroup   Required. The FeatureGroup to create.
     * @param string       $featureGroupId Required. The ID to use for this FeatureGroup, which will become the final
     *                                     component of the FeatureGroup's resource name.
     *
     *                                     This value may be up to 60 characters, and valid characters are
     *                                     `[a-z0-9_]`. The first character cannot be a number.
     *
     *                                     The value must be unique within the project and location.
     * @param array        $optionalArgs   {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createFeatureGroup(
        $parent,
        $featureGroup,
        $featureGroupId,
        array $optionalArgs = []
    ) {
        $request = new CreateFeatureGroupRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setFeatureGroup($featureGroup);
        $request->setFeatureGroupId($featureGroupId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateFeatureGroup',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single Feature.
     *
     * Sample code:
     * ```
     * $featureRegistryServiceClient = new FeatureRegistryServiceClient();
     * try {
     *     $formattedName = $featureRegistryServiceClient->featureName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]', '[ENTITY_TYPE]', '[FEATURE]');
     *     $operationResponse = $featureRegistryServiceClient->deleteFeature($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featureRegistryServiceClient->deleteFeature($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featureRegistryServiceClient->resumeOperation($operationName, 'deleteFeature');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featureRegistryServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Features to be deleted.
     *                             Format:
     *                             `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
     *                             `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteFeature($name, array $optionalArgs = [])
    {
        $request = new DeleteFeatureRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteFeature',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single FeatureGroup.
     *
     * Sample code:
     * ```
     * $featureRegistryServiceClient = new FeatureRegistryServiceClient();
     * try {
     *     $formattedName = $featureRegistryServiceClient->featureGroupName('[PROJECT]', '[LOCATION]', '[FEATURE_GROUP]');
     *     $operationResponse = $featureRegistryServiceClient->deleteFeatureGroup($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featureRegistryServiceClient->deleteFeatureGroup($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featureRegistryServiceClient->resumeOperation($operationName, 'deleteFeatureGroup');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featureRegistryServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the FeatureGroup to be deleted.
     *                             Format:
     *                             `projects/{project}/locations/{location}/featureGroups/{feature_group}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $force
     *           If set to true, any Features under this FeatureGroup
     *           will also be deleted. (Otherwise, the request will only work if the
     *           FeatureGroup has no Features.)
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteFeatureGroup($name, array $optionalArgs = [])
    {
        $request = new DeleteFeatureGroupRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteFeatureGroup',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets details of a single Feature.
     *
     * Sample code:
     * ```
     * $featureRegistryServiceClient = new FeatureRegistryServiceClient();
     * try {
     *     $formattedName = $featureRegistryServiceClient->featureName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]', '[ENTITY_TYPE]', '[FEATURE]');
     *     $response = $featureRegistryServiceClient->getFeature($formattedName);
     * } finally {
     *     $featureRegistryServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Feature resource.
     *                             Format for entity_type as parent:
     *                             `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
     *                             Format for feature_group as parent:
     *                             `projects/{project}/locations/{location}/featureGroups/{feature_group}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Feature
     *
     * @throws ApiException if the remote call fails
     */
    public function getFeature($name, array $optionalArgs = [])
    {
        $request = new GetFeatureRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetFeature',
            Feature::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single FeatureGroup.
     *
     * Sample code:
     * ```
     * $featureRegistryServiceClient = new FeatureRegistryServiceClient();
     * try {
     *     $formattedName = $featureRegistryServiceClient->featureGroupName('[PROJECT]', '[LOCATION]', '[FEATURE_GROUP]');
     *     $response = $featureRegistryServiceClient->getFeatureGroup($formattedName);
     * } finally {
     *     $featureRegistryServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the FeatureGroup resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\FeatureGroup
     *
     * @throws ApiException if the remote call fails
     */
    public function getFeatureGroup($name, array $optionalArgs = [])
    {
        $request = new GetFeatureGroupRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetFeatureGroup',
            FeatureGroup::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists FeatureGroups in a given project and location.
     *
     * Sample code:
     * ```
     * $featureRegistryServiceClient = new FeatureRegistryServiceClient();
     * try {
     *     $formattedParent = $featureRegistryServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $featureRegistryServiceClient->listFeatureGroups($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $featureRegistryServiceClient->listFeatureGroups($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $featureRegistryServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Location to list FeatureGroups.
     *                             Format:
     *                             `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Lists the FeatureGroups that match the filter expression. The
     *           following fields are supported:
     *
     *           * `create_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
     *           Values must be
     *           in RFC 3339 format.
     *           * `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
     *           Values must be
     *           in RFC 3339 format.
     *           * `labels`: Supports key-value equality and key presence.
     *
     *           Examples:
     *
     *           * `create_time > "2020-01-01" OR update_time > "2020-01-01"`
     *           FeatureGroups created or updated after 2020-01-01.
     *           * `labels.env = "prod"`
     *           FeatureGroups with label "env" set to "prod".
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           A comma-separated list of fields to order by, sorted in ascending order.
     *           Use "desc" after a field name for descending.
     *           Supported Fields:
     *
     *           * `create_time`
     *           * `update_time`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listFeatureGroups($parent, array $optionalArgs = [])
    {
        $request = new ListFeatureGroupsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListFeatureGroups',
            $optionalArgs,
            ListFeatureGroupsResponse::class,
            $request
        );
    }

    /**
     * Lists Features in a given FeatureGroup.
     *
     * Sample code:
     * ```
     * $featureRegistryServiceClient = new FeatureRegistryServiceClient();
     * try {
     *     $formattedParent = $featureRegistryServiceClient->entityTypeName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]', '[ENTITY_TYPE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $featureRegistryServiceClient->listFeatures($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $featureRegistryServiceClient->listFeatures($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $featureRegistryServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Location to list Features.
     *                             Format for entity_type as parent:
     *                             `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
     *                             Format for feature_group as parent:
     *                             `projects/{project}/locations/{location}/featureGroups/{feature_group}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Lists the Features that match the filter expression. The following
     *           filters are supported:
     *
     *           * `value_type`: Supports = and != comparisons.
     *           * `create_time`: Supports =, !=, <, >, >=, and <= comparisons. Values must
     *           be in RFC 3339 format.
     *           * `update_time`: Supports =, !=, <, >, >=, and <= comparisons. Values must
     *           be in RFC 3339 format.
     *           * `labels`: Supports key-value equality as well as key presence.
     *
     *           Examples:
     *
     *           * `value_type = DOUBLE` --> Features whose type is DOUBLE.
     *           * `create_time > \"2020-01-31T15:30:00.000000Z\" OR
     *           update_time > \"2020-01-31T15:30:00.000000Z\"` --> EntityTypes created
     *           or updated after 2020-01-31T15:30:00.000000Z.
     *           * `labels.active = yes AND labels.env = prod` --> Features having both
     *           (active: yes) and (env: prod) labels.
     *           * `labels.env: *` --> Any Feature which has a label with 'env' as the
     *           key.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           A comma-separated list of fields to order by, sorted in ascending order.
     *           Use "desc" after a field name for descending.
     *           Supported fields:
     *
     *           * `feature_id`
     *           * `value_type` (Not supported for FeatureRegistry Feature)
     *           * `create_time`
     *           * `update_time`
     *     @type FieldMask $readMask
     *           Mask specifying which fields to read.
     *     @type int $latestStatsCount
     *           Only applicable for Vertex AI Feature Store (Legacy).
     *           If set, return the most recent
     *           [ListFeaturesRequest.latest_stats_count][google.cloud.aiplatform.v1.ListFeaturesRequest.latest_stats_count]
     *           of stats for each Feature in response. Valid value is [0, 10]. If number of
     *           stats exists <
     *           [ListFeaturesRequest.latest_stats_count][google.cloud.aiplatform.v1.ListFeaturesRequest.latest_stats_count],
     *           return all existing stats.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listFeatures($parent, array $optionalArgs = [])
    {
        $request = new ListFeaturesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['readMask'])) {
            $request->setReadMask($optionalArgs['readMask']);
        }

        if (isset($optionalArgs['latestStatsCount'])) {
            $request->setLatestStatsCount($optionalArgs['latestStatsCount']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListFeatures',
            $optionalArgs,
            ListFeaturesResponse::class,
            $request
        );
    }

    /**
     * Updates the parameters of a single Feature.
     *
     * Sample code:
     * ```
     * $featureRegistryServiceClient = new FeatureRegistryServiceClient();
     * try {
     *     $feature = new Feature();
     *     $operationResponse = $featureRegistryServiceClient->updateFeature($feature);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featureRegistryServiceClient->updateFeature($feature);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featureRegistryServiceClient->resumeOperation($operationName, 'updateFeature');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featureRegistryServiceClient->close();
     * }
     * ```
     *
     * @param Feature $feature      Required. The Feature's `name` field is used to identify the Feature to be
     *                              updated.
     *                              Format:
     *                              `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
     *                              `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Field mask is used to specify the fields to be overwritten in the
     *           Features resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then only the non-empty fields present in the
     *           request will be overwritten. Set the update_mask to `*` to override all
     *           fields.
     *
     *           Updatable fields:
     *
     *           * `description`
     *           * `labels`
     *           * `disable_monitoring` (Not supported for FeatureRegistry Feature)
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateFeature($feature, array $optionalArgs = [])
    {
        $request = new UpdateFeatureRequest();
        $requestParamHeaders = [];
        $request->setFeature($feature);
        $requestParamHeaders['feature.name'] = $feature->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateFeature',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the parameters of a single FeatureGroup.
     *
     * Sample code:
     * ```
     * $featureRegistryServiceClient = new FeatureRegistryServiceClient();
     * try {
     *     $featureGroup = new FeatureGroup();
     *     $operationResponse = $featureRegistryServiceClient->updateFeatureGroup($featureGroup);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featureRegistryServiceClient->updateFeatureGroup($featureGroup);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featureRegistryServiceClient->resumeOperation($operationName, 'updateFeatureGroup');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featureRegistryServiceClient->close();
     * }
     * ```
     *
     * @param FeatureGroup $featureGroup Required. The FeatureGroup's `name` field is used to identify the
     *                                   FeatureGroup to be updated. Format:
     *                                   `projects/{project}/locations/{location}/featureGroups/{feature_group}`
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Field mask is used to specify the fields to be overwritten in the
     *           FeatureGroup resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then only the non-empty fields present in the
     *           request will be overwritten. Set the update_mask to `*` to override all
     *           fields.
     *
     *           Updatable fields:
     *
     *           * `labels`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateFeatureGroup($featureGroup, array $optionalArgs = [])
    {
        $request = new UpdateFeatureGroupRequest();
        $requestParamHeaders = [];
        $request->setFeatureGroup($featureGroup);
        $requestParamHeaders['feature_group.name'] = $featureGroup->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateFeatureGroup',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $featureRegistryServiceClient = new FeatureRegistryServiceClient();
     * try {
     *     $response = $featureRegistryServiceClient->getLocation();
     * } finally {
     *     $featureRegistryServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $featureRegistryServiceClient = new FeatureRegistryServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $featureRegistryServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $featureRegistryServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $featureRegistryServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $featureRegistryServiceClient = new FeatureRegistryServiceClient();
     * try {
     *     $resource = 'resource';
     *     $response = $featureRegistryServiceClient->getIamPolicy($resource);
     * } finally {
     *     $featureRegistryServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $featureRegistryServiceClient = new FeatureRegistryServiceClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $featureRegistryServiceClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $featureRegistryServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $featureRegistryServiceClient = new FeatureRegistryServiceClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $featureRegistryServiceClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $featureRegistryServiceClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }
}
