<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/aiplatform/v1/feature_online_store_admin_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AIPlatform\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AIPlatform\V1\CreateFeatureOnlineStoreRequest;
use Google\Cloud\AIPlatform\V1\CreateFeatureViewRequest;
use Google\Cloud\AIPlatform\V1\DeleteFeatureOnlineStoreRequest;
use Google\Cloud\AIPlatform\V1\DeleteFeatureViewRequest;
use Google\Cloud\AIPlatform\V1\FeatureOnlineStore;
use Google\Cloud\AIPlatform\V1\FeatureView;
use Google\Cloud\AIPlatform\V1\FeatureViewSync;
use Google\Cloud\AIPlatform\V1\GetFeatureOnlineStoreRequest;
use Google\Cloud\AIPlatform\V1\GetFeatureViewRequest;
use Google\Cloud\AIPlatform\V1\GetFeatureViewSyncRequest;
use Google\Cloud\AIPlatform\V1\ListFeatureOnlineStoresRequest;
use Google\Cloud\AIPlatform\V1\ListFeatureOnlineStoresResponse;
use Google\Cloud\AIPlatform\V1\ListFeatureViewSyncsRequest;
use Google\Cloud\AIPlatform\V1\ListFeatureViewSyncsResponse;
use Google\Cloud\AIPlatform\V1\ListFeatureViewsRequest;
use Google\Cloud\AIPlatform\V1\ListFeatureViewsResponse;
use Google\Cloud\AIPlatform\V1\SyncFeatureViewRequest;
use Google\Cloud\AIPlatform\V1\SyncFeatureViewResponse;
use Google\Cloud\AIPlatform\V1\UpdateFeatureOnlineStoreRequest;
use Google\Cloud\AIPlatform\V1\UpdateFeatureViewRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: The service that handles CRUD and List for resources for
 * FeatureOnlineStore.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $featureOnlineStoreAdminServiceClient = new FeatureOnlineStoreAdminServiceClient();
 * try {
 *     $formattedParent = $featureOnlineStoreAdminServiceClient->locationName('[PROJECT]', '[LOCATION]');
 *     $featureOnlineStore = new FeatureOnlineStore();
 *     $featureOnlineStoreId = 'feature_online_store_id';
 *     $operationResponse = $featureOnlineStoreAdminServiceClient->createFeatureOnlineStore($formattedParent, $featureOnlineStore, $featureOnlineStoreId);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $featureOnlineStoreAdminServiceClient->createFeatureOnlineStore($formattedParent, $featureOnlineStore, $featureOnlineStoreId);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $featureOnlineStoreAdminServiceClient->resumeOperation($operationName, 'createFeatureOnlineStore');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $featureOnlineStoreAdminServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @deprecated Please use the new service client {@see \Google\Cloud\AIPlatform\V1\Client\FeatureOnlineStoreAdminServiceClient}.
 */
class FeatureOnlineStoreAdminServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    const SERVICE_ADDRESS = 'aiplatform.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'aiplatform.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $featureOnlineStoreNameTemplate;

    private static $featureViewNameTemplate;

    private static $featureViewSyncNameTemplate;

    private static $locationNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ .
                '/../resources/feature_online_store_admin_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/feature_online_store_admin_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ .
                '/../resources/feature_online_store_admin_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/feature_online_store_admin_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getFeatureOnlineStoreNameTemplate()
    {
        if (self::$featureOnlineStoreNameTemplate == null) {
            self::$featureOnlineStoreNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}'
            );
        }

        return self::$featureOnlineStoreNameTemplate;
    }

    private static function getFeatureViewNameTemplate()
    {
        if (self::$featureViewNameTemplate == null) {
            self::$featureViewNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}'
            );
        }

        return self::$featureViewNameTemplate;
    }

    private static function getFeatureViewSyncNameTemplate()
    {
        if (self::$featureViewSyncNameTemplate == null) {
            self::$featureViewSyncNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}/featureViewSyncs/feature_view_sync'
            );
        }

        return self::$featureViewSyncNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'featureOnlineStore' => self::getFeatureOnlineStoreNameTemplate(),
                'featureView' => self::getFeatureViewNameTemplate(),
                'featureViewSync' => self::getFeatureViewSyncNameTemplate(),
                'location' => self::getLocationNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * feature_online_store resource.
     *
     * @param string $project
     * @param string $location
     * @param string $featureOnlineStore
     *
     * @return string The formatted feature_online_store resource.
     */
    public static function featureOnlineStoreName(
        $project,
        $location,
        $featureOnlineStore
    ) {
        return self::getFeatureOnlineStoreNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'feature_online_store' => $featureOnlineStore,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a feature_view
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $featureOnlineStore
     * @param string $featureView
     *
     * @return string The formatted feature_view resource.
     */
    public static function featureViewName(
        $project,
        $location,
        $featureOnlineStore,
        $featureView
    ) {
        return self::getFeatureViewNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'feature_online_store' => $featureOnlineStore,
            'feature_view' => $featureView,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * feature_view_sync resource.
     *
     * @param string $project
     * @param string $location
     * @param string $featureOnlineStore
     * @param string $featureView
     *
     * @return string The formatted feature_view_sync resource.
     */
    public static function featureViewSyncName(
        $project,
        $location,
        $featureOnlineStore,
        $featureView
    ) {
        return self::getFeatureViewSyncNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'feature_online_store' => $featureOnlineStore,
            'feature_view' => $featureView,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - featureOnlineStore: projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}
     * - featureView: projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}
     * - featureViewSync: projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}/featureViewSyncs/feature_view_sync
     * - location: projects/{project}/locations/{location}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'aiplatform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a new FeatureOnlineStore in a given project and location.
     *
     * Sample code:
     * ```
     * $featureOnlineStoreAdminServiceClient = new FeatureOnlineStoreAdminServiceClient();
     * try {
     *     $formattedParent = $featureOnlineStoreAdminServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $featureOnlineStore = new FeatureOnlineStore();
     *     $featureOnlineStoreId = 'feature_online_store_id';
     *     $operationResponse = $featureOnlineStoreAdminServiceClient->createFeatureOnlineStore($formattedParent, $featureOnlineStore, $featureOnlineStoreId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featureOnlineStoreAdminServiceClient->createFeatureOnlineStore($formattedParent, $featureOnlineStore, $featureOnlineStoreId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featureOnlineStoreAdminServiceClient->resumeOperation($operationName, 'createFeatureOnlineStore');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featureOnlineStoreAdminServiceClient->close();
     * }
     * ```
     *
     * @param string             $parent               Required. The resource name of the Location to create FeatureOnlineStores.
     *                                                 Format:
     *                                                 `projects/{project}/locations/{location}`
     * @param FeatureOnlineStore $featureOnlineStore   Required. The FeatureOnlineStore to create.
     * @param string             $featureOnlineStoreId Required. The ID to use for this FeatureOnlineStore, which will become the
     *                                                 final component of the FeatureOnlineStore's resource name.
     *
     *                                                 This value may be up to 60 characters, and valid characters are
     *                                                 `[a-z0-9_]`. The first character cannot be a number.
     *
     *                                                 The value must be unique within the project and location.
     * @param array              $optionalArgs         {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createFeatureOnlineStore(
        $parent,
        $featureOnlineStore,
        $featureOnlineStoreId,
        array $optionalArgs = []
    ) {
        $request = new CreateFeatureOnlineStoreRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setFeatureOnlineStore($featureOnlineStore);
        $request->setFeatureOnlineStoreId($featureOnlineStoreId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateFeatureOnlineStore',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new FeatureView in a given FeatureOnlineStore.
     *
     * Sample code:
     * ```
     * $featureOnlineStoreAdminServiceClient = new FeatureOnlineStoreAdminServiceClient();
     * try {
     *     $formattedParent = $featureOnlineStoreAdminServiceClient->featureOnlineStoreName('[PROJECT]', '[LOCATION]', '[FEATURE_ONLINE_STORE]');
     *     $featureView = new FeatureView();
     *     $featureViewId = 'feature_view_id';
     *     $operationResponse = $featureOnlineStoreAdminServiceClient->createFeatureView($formattedParent, $featureView, $featureViewId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featureOnlineStoreAdminServiceClient->createFeatureView($formattedParent, $featureView, $featureViewId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featureOnlineStoreAdminServiceClient->resumeOperation($operationName, 'createFeatureView');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featureOnlineStoreAdminServiceClient->close();
     * }
     * ```
     *
     * @param string      $parent        Required. The resource name of the FeatureOnlineStore to create
     *                                   FeatureViews. Format:
     *                                   `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}`
     * @param FeatureView $featureView   Required. The FeatureView to create.
     * @param string      $featureViewId Required. The ID to use for the FeatureView, which will become the final
     *                                   component of the FeatureView's resource name.
     *
     *                                   This value may be up to 60 characters, and valid characters are
     *                                   `[a-z0-9_]`. The first character cannot be a number.
     *
     *                                   The value must be unique within a FeatureOnlineStore.
     * @param array       $optionalArgs  {
     *     Optional.
     *
     *     @type bool $runSyncImmediately
     *           Immutable. If set to true, one on demand sync will be run immediately,
     *           regardless whether the
     *           [FeatureView.sync_config][google.cloud.aiplatform.v1.FeatureView.sync_config]
     *           is configured or not.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createFeatureView(
        $parent,
        $featureView,
        $featureViewId,
        array $optionalArgs = []
    ) {
        $request = new CreateFeatureViewRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setFeatureView($featureView);
        $request->setFeatureViewId($featureViewId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['runSyncImmediately'])) {
            $request->setRunSyncImmediately(
                $optionalArgs['runSyncImmediately']
            );
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateFeatureView',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single FeatureOnlineStore. The FeatureOnlineStore must not
     * contain any FeatureViews.
     *
     * Sample code:
     * ```
     * $featureOnlineStoreAdminServiceClient = new FeatureOnlineStoreAdminServiceClient();
     * try {
     *     $formattedName = $featureOnlineStoreAdminServiceClient->featureOnlineStoreName('[PROJECT]', '[LOCATION]', '[FEATURE_ONLINE_STORE]');
     *     $operationResponse = $featureOnlineStoreAdminServiceClient->deleteFeatureOnlineStore($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featureOnlineStoreAdminServiceClient->deleteFeatureOnlineStore($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featureOnlineStoreAdminServiceClient->resumeOperation($operationName, 'deleteFeatureOnlineStore');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featureOnlineStoreAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the FeatureOnlineStore to be deleted.
     *                             Format:
     *                             `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $force
     *           If set to true, any FeatureViews and Features for this FeatureOnlineStore
     *           will also be deleted. (Otherwise, the request will only work if the
     *           FeatureOnlineStore has no FeatureViews.)
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteFeatureOnlineStore($name, array $optionalArgs = [])
    {
        $request = new DeleteFeatureOnlineStoreRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteFeatureOnlineStore',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single FeatureView.
     *
     * Sample code:
     * ```
     * $featureOnlineStoreAdminServiceClient = new FeatureOnlineStoreAdminServiceClient();
     * try {
     *     $formattedName = $featureOnlineStoreAdminServiceClient->featureViewName('[PROJECT]', '[LOCATION]', '[FEATURE_ONLINE_STORE]', '[FEATURE_VIEW]');
     *     $operationResponse = $featureOnlineStoreAdminServiceClient->deleteFeatureView($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featureOnlineStoreAdminServiceClient->deleteFeatureView($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featureOnlineStoreAdminServiceClient->resumeOperation($operationName, 'deleteFeatureView');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featureOnlineStoreAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the FeatureView to be deleted.
     *                             Format:
     *                             `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteFeatureView($name, array $optionalArgs = [])
    {
        $request = new DeleteFeatureViewRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteFeatureView',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets details of a single FeatureOnlineStore.
     *
     * Sample code:
     * ```
     * $featureOnlineStoreAdminServiceClient = new FeatureOnlineStoreAdminServiceClient();
     * try {
     *     $formattedName = $featureOnlineStoreAdminServiceClient->featureOnlineStoreName('[PROJECT]', '[LOCATION]', '[FEATURE_ONLINE_STORE]');
     *     $response = $featureOnlineStoreAdminServiceClient->getFeatureOnlineStore($formattedName);
     * } finally {
     *     $featureOnlineStoreAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the FeatureOnlineStore resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\FeatureOnlineStore
     *
     * @throws ApiException if the remote call fails
     */
    public function getFeatureOnlineStore($name, array $optionalArgs = [])
    {
        $request = new GetFeatureOnlineStoreRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetFeatureOnlineStore',
            FeatureOnlineStore::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single FeatureView.
     *
     * Sample code:
     * ```
     * $featureOnlineStoreAdminServiceClient = new FeatureOnlineStoreAdminServiceClient();
     * try {
     *     $formattedName = $featureOnlineStoreAdminServiceClient->featureViewName('[PROJECT]', '[LOCATION]', '[FEATURE_ONLINE_STORE]', '[FEATURE_VIEW]');
     *     $response = $featureOnlineStoreAdminServiceClient->getFeatureView($formattedName);
     * } finally {
     *     $featureOnlineStoreAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the FeatureView resource.
     *                             Format:
     *                             `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\FeatureView
     *
     * @throws ApiException if the remote call fails
     */
    public function getFeatureView($name, array $optionalArgs = [])
    {
        $request = new GetFeatureViewRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetFeatureView',
            FeatureView::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single FeatureViewSync.
     *
     * Sample code:
     * ```
     * $featureOnlineStoreAdminServiceClient = new FeatureOnlineStoreAdminServiceClient();
     * try {
     *     $formattedName = $featureOnlineStoreAdminServiceClient->featureViewSyncName('[PROJECT]', '[LOCATION]', '[FEATURE_ONLINE_STORE]', '[FEATURE_VIEW]');
     *     $response = $featureOnlineStoreAdminServiceClient->getFeatureViewSync($formattedName);
     * } finally {
     *     $featureOnlineStoreAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the FeatureViewSync resource.
     *                             Format:
     *                             `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}/featureViewSyncs/{feature_view_sync}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\FeatureViewSync
     *
     * @throws ApiException if the remote call fails
     */
    public function getFeatureViewSync($name, array $optionalArgs = [])
    {
        $request = new GetFeatureViewSyncRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetFeatureViewSync',
            FeatureViewSync::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists FeatureOnlineStores in a given project and location.
     *
     * Sample code:
     * ```
     * $featureOnlineStoreAdminServiceClient = new FeatureOnlineStoreAdminServiceClient();
     * try {
     *     $formattedParent = $featureOnlineStoreAdminServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $featureOnlineStoreAdminServiceClient->listFeatureOnlineStores($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $featureOnlineStoreAdminServiceClient->listFeatureOnlineStores($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $featureOnlineStoreAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Location to list FeatureOnlineStores.
     *                             Format:
     *                             `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Lists the FeatureOnlineStores that match the filter expression. The
     *           following fields are supported:
     *
     *           * `create_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
     *           Values must be
     *           in RFC 3339 format.
     *           * `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
     *           Values must be
     *           in RFC 3339 format.
     *           * `labels`: Supports key-value equality and key presence.
     *
     *           Examples:
     *
     *           * `create_time > "2020-01-01" OR update_time > "2020-01-01"`
     *           FeatureOnlineStores created or updated after 2020-01-01.
     *           * `labels.env = "prod"`
     *           FeatureOnlineStores with label "env" set to "prod".
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           A comma-separated list of fields to order by, sorted in ascending order.
     *           Use "desc" after a field name for descending.
     *           Supported Fields:
     *
     *           * `create_time`
     *           * `update_time`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listFeatureOnlineStores($parent, array $optionalArgs = [])
    {
        $request = new ListFeatureOnlineStoresRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListFeatureOnlineStores',
            $optionalArgs,
            ListFeatureOnlineStoresResponse::class,
            $request
        );
    }

    /**
     * Lists FeatureViewSyncs in a given FeatureView.
     *
     * Sample code:
     * ```
     * $featureOnlineStoreAdminServiceClient = new FeatureOnlineStoreAdminServiceClient();
     * try {
     *     $formattedParent = $featureOnlineStoreAdminServiceClient->featureViewName('[PROJECT]', '[LOCATION]', '[FEATURE_ONLINE_STORE]', '[FEATURE_VIEW]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $featureOnlineStoreAdminServiceClient->listFeatureViewSyncs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $featureOnlineStoreAdminServiceClient->listFeatureViewSyncs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $featureOnlineStoreAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the FeatureView to list FeatureViewSyncs.
     *                             Format:
     *                             `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Lists the FeatureViewSyncs that match the filter expression. The following
     *           filters are supported:
     *
     *           * `create_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
     *           Values must be in RFC 3339 format.
     *
     *           Examples:
     *
     *           * `create_time > \"2020-01-31T15:30:00.000000Z\"` --> FeatureViewSyncs
     *           created after 2020-01-31T15:30:00.000000Z.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           A comma-separated list of fields to order by, sorted in ascending order.
     *           Use "desc" after a field name for descending.
     *
     *           Supported fields:
     *
     *           * `create_time`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listFeatureViewSyncs($parent, array $optionalArgs = [])
    {
        $request = new ListFeatureViewSyncsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListFeatureViewSyncs',
            $optionalArgs,
            ListFeatureViewSyncsResponse::class,
            $request
        );
    }

    /**
     * Lists FeatureViews in a given FeatureOnlineStore.
     *
     * Sample code:
     * ```
     * $featureOnlineStoreAdminServiceClient = new FeatureOnlineStoreAdminServiceClient();
     * try {
     *     $formattedParent = $featureOnlineStoreAdminServiceClient->featureOnlineStoreName('[PROJECT]', '[LOCATION]', '[FEATURE_ONLINE_STORE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $featureOnlineStoreAdminServiceClient->listFeatureViews($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $featureOnlineStoreAdminServiceClient->listFeatureViews($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $featureOnlineStoreAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the FeatureOnlineStore to list FeatureViews.
     *                             Format:
     *                             `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Lists the FeatureViews that match the filter expression. The following
     *           filters are supported:
     *
     *           * `create_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
     *           Values must be in RFC 3339 format.
     *           * `update_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
     *           Values must be in RFC 3339 format.
     *           * `labels`: Supports key-value equality as well as key presence.
     *
     *           Examples:
     *
     *           * `create_time > \"2020-01-31T15:30:00.000000Z\" OR
     *           update_time > \"2020-01-31T15:30:00.000000Z\"` --> FeatureViews
     *           created or updated after 2020-01-31T15:30:00.000000Z.
     *           * `labels.active = yes AND labels.env = prod` --> FeatureViews having both
     *           (active: yes) and (env: prod) labels.
     *           * `labels.env: *` --> Any FeatureView which has a label with 'env' as the
     *           key.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           A comma-separated list of fields to order by, sorted in ascending order.
     *           Use "desc" after a field name for descending.
     *
     *           Supported fields:
     *
     *           * `feature_view_id`
     *           * `create_time`
     *           * `update_time`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listFeatureViews($parent, array $optionalArgs = [])
    {
        $request = new ListFeatureViewsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListFeatureViews',
            $optionalArgs,
            ListFeatureViewsResponse::class,
            $request
        );
    }

    /**
     * Triggers on-demand sync for the FeatureView.
     *
     * Sample code:
     * ```
     * $featureOnlineStoreAdminServiceClient = new FeatureOnlineStoreAdminServiceClient();
     * try {
     *     $formattedFeatureView = $featureOnlineStoreAdminServiceClient->featureViewName('[PROJECT]', '[LOCATION]', '[FEATURE_ONLINE_STORE]', '[FEATURE_VIEW]');
     *     $response = $featureOnlineStoreAdminServiceClient->syncFeatureView($formattedFeatureView);
     * } finally {
     *     $featureOnlineStoreAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $featureView  Required. Format:
     *                             `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\SyncFeatureViewResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function syncFeatureView($featureView, array $optionalArgs = [])
    {
        $request = new SyncFeatureViewRequest();
        $requestParamHeaders = [];
        $request->setFeatureView($featureView);
        $requestParamHeaders['feature_view'] = $featureView;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SyncFeatureView',
            SyncFeatureViewResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates the parameters of a single FeatureOnlineStore.
     *
     * Sample code:
     * ```
     * $featureOnlineStoreAdminServiceClient = new FeatureOnlineStoreAdminServiceClient();
     * try {
     *     $featureOnlineStore = new FeatureOnlineStore();
     *     $operationResponse = $featureOnlineStoreAdminServiceClient->updateFeatureOnlineStore($featureOnlineStore);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featureOnlineStoreAdminServiceClient->updateFeatureOnlineStore($featureOnlineStore);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featureOnlineStoreAdminServiceClient->resumeOperation($operationName, 'updateFeatureOnlineStore');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featureOnlineStoreAdminServiceClient->close();
     * }
     * ```
     *
     * @param FeatureOnlineStore $featureOnlineStore Required. The FeatureOnlineStore's `name` field is used to identify the
     *                                               FeatureOnlineStore to be updated. Format:
     *                                               `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}`
     * @param array              $optionalArgs       {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Field mask is used to specify the fields to be overwritten in the
     *           FeatureOnlineStore resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then only the non-empty fields present in the
     *           request will be overwritten. Set the update_mask to `*` to override all
     *           fields.
     *
     *           Updatable fields:
     *
     *           * `big_query_source`
     *           * `bigtable`
     *           * `labels`
     *           * `sync_config`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateFeatureOnlineStore(
        $featureOnlineStore,
        array $optionalArgs = []
    ) {
        $request = new UpdateFeatureOnlineStoreRequest();
        $requestParamHeaders = [];
        $request->setFeatureOnlineStore($featureOnlineStore);
        $requestParamHeaders[
            'feature_online_store.name'
        ] = $featureOnlineStore->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateFeatureOnlineStore',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the parameters of a single FeatureView.
     *
     * Sample code:
     * ```
     * $featureOnlineStoreAdminServiceClient = new FeatureOnlineStoreAdminServiceClient();
     * try {
     *     $featureView = new FeatureView();
     *     $operationResponse = $featureOnlineStoreAdminServiceClient->updateFeatureView($featureView);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featureOnlineStoreAdminServiceClient->updateFeatureView($featureView);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featureOnlineStoreAdminServiceClient->resumeOperation($operationName, 'updateFeatureView');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featureOnlineStoreAdminServiceClient->close();
     * }
     * ```
     *
     * @param FeatureView $featureView  Required. The FeatureView's `name` field is used to identify the
     *                                  FeatureView to be updated. Format:
     *                                  `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Field mask is used to specify the fields to be overwritten in the
     *           FeatureView resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then only the non-empty fields present in the
     *           request will be overwritten. Set the update_mask to `*` to override all
     *           fields.
     *
     *           Updatable fields:
     *
     *           * `labels`
     *           * `serviceAgentType`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateFeatureView($featureView, array $optionalArgs = [])
    {
        $request = new UpdateFeatureViewRequest();
        $requestParamHeaders = [];
        $request->setFeatureView($featureView);
        $requestParamHeaders['feature_view.name'] = $featureView->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateFeatureView',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $featureOnlineStoreAdminServiceClient = new FeatureOnlineStoreAdminServiceClient();
     * try {
     *     $response = $featureOnlineStoreAdminServiceClient->getLocation();
     * } finally {
     *     $featureOnlineStoreAdminServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $featureOnlineStoreAdminServiceClient = new FeatureOnlineStoreAdminServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $featureOnlineStoreAdminServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $featureOnlineStoreAdminServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $featureOnlineStoreAdminServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $featureOnlineStoreAdminServiceClient = new FeatureOnlineStoreAdminServiceClient();
     * try {
     *     $resource = 'resource';
     *     $response = $featureOnlineStoreAdminServiceClient->getIamPolicy($resource);
     * } finally {
     *     $featureOnlineStoreAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $featureOnlineStoreAdminServiceClient = new FeatureOnlineStoreAdminServiceClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $featureOnlineStoreAdminServiceClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $featureOnlineStoreAdminServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $featureOnlineStoreAdminServiceClient = new FeatureOnlineStoreAdminServiceClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $featureOnlineStoreAdminServiceClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $featureOnlineStoreAdminServiceClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }
}
