<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents an Interconnect resource.
 * An Interconnect resource is a dedicated connection between the GCP network and your on-premises network. For more information, read the  Dedicated Interconnect Overview. (== resource_for {$api_version}.interconnects ==)
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.Interconnect</code>
 */
class Interconnect extends \Google\Protobuf\Internal\Message
{
    /**
     * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
     *
     * Generated from protobuf field <code>bool admin_enabled = 177239633;</code>
     */
    private $admin_enabled = false;
    /**
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;</code>
     */
    private $circuit_infos;
    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     */
    private $creation_timestamp = '';
    /**
     * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
     *
     * Generated from protobuf field <code>string customer_name = 3665484;</code>
     */
    private $customer_name = '';
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     */
    private $description = '';
    /**
     * [Output Only] A list of outages expected for this Interconnect.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;</code>
     */
    private $expected_outages;
    /**
     * [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
     *
     * Generated from protobuf field <code>string google_ip_address = 174670498;</code>
     */
    private $google_ip_address = '';
    /**
     * [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
     *
     * Generated from protobuf field <code>string google_reference_id = 266509013;</code>
     */
    private $google_reference_id = '';
    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     */
    private $id = '';
    /**
     * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
     *
     * Generated from protobuf field <code>repeated string interconnect_attachments = 156952959;</code>
     */
    private $interconnect_attachments;
    /**
     * Type of interconnect, which can take one of the following values:
     * - PARTNER: A partner-managed interconnection shared between customers though a partner.
     * - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Interconnect.InterconnectType interconnect_type = 246729803;</code>
     */
    private $interconnect_type = 0;
    /**
     * [Output Only] Type of the resource. Always compute#interconnect for interconnects.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     */
    private $kind = '';
    /**
     * Type of link requested, which can take one of the following values:
     * - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics
     * - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Interconnect.LinkType link_type = 254772319;</code>
     */
    private $link_type = 0;
    /**
     * URL of the InterconnectLocation object that represents where this connection is to be provisioned.
     *
     * Generated from protobuf field <code>string location = 21995445;</code>
     */
    private $location = '';
    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     */
    private $name = '';
    /**
     * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Stackdriver logs alerting and Cloud Notifications.
     *
     * Generated from protobuf field <code>string noc_contact_email = 14072832;</code>
     */
    private $noc_contact_email = '';
    /**
     * [Output Only] The current status of this Interconnect's functionality, which can take one of the following values:
     * - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect.
     * - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect.
     * - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Interconnect.OperationalStatus operational_status = 201070847;</code>
     */
    private $operational_status = 0;
    /**
     * [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
     *
     * Generated from protobuf field <code>string peer_ip_address = 207735769;</code>
     */
    private $peer_ip_address = '';
    /**
     * [Output Only] Number of links actually provisioned in this interconnect.
     *
     * Generated from protobuf field <code>int32 provisioned_link_count = 142453109;</code>
     */
    private $provisioned_link_count = 0;
    /**
     * Target number of physical links in the link bundle, as requested by the customer.
     *
     * Generated from protobuf field <code>int32 requested_link_count = 45051387;</code>
     */
    private $requested_link_count = 0;
    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     */
    private $self_link = '';
    /**
     * [Output Only] The current state of Interconnect functionality, which can take one of the following values:
     * - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect.
     * - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect.
     * - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Interconnect.State state = 109757585;</code>
     */
    private $state = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $admin_enabled
     *           Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
     *     @type \Google\Cloud\Compute\V1\InterconnectCircuitInfo[]|\Google\Protobuf\Internal\RepeatedField $circuit_infos
     *           [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     *     @type string $creation_timestamp
     *           [Output Only] Creation timestamp in RFC3339 text format.
     *     @type string $customer_name
     *           Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
     *     @type string $description
     *           An optional description of this resource. Provide this property when you create the resource.
     *     @type \Google\Cloud\Compute\V1\InterconnectOutageNotification[]|\Google\Protobuf\Internal\RepeatedField $expected_outages
     *           [Output Only] A list of outages expected for this Interconnect.
     *     @type string $google_ip_address
     *           [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
     *     @type string $google_reference_id
     *           [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
     *     @type string $id
     *           [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $interconnect_attachments
     *           [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
     *     @type int $interconnect_type
     *           Type of interconnect, which can take one of the following values:
     *           - PARTNER: A partner-managed interconnection shared between customers though a partner.
     *           - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
     *     @type string $kind
     *           [Output Only] Type of the resource. Always compute#interconnect for interconnects.
     *     @type int $link_type
     *           Type of link requested, which can take one of the following values:
     *           - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics
     *           - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
     *     @type string $location
     *           URL of the InterconnectLocation object that represents where this connection is to be provisioned.
     *     @type string $name
     *           Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *     @type string $noc_contact_email
     *           Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Stackdriver logs alerting and Cloud Notifications.
     *     @type int $operational_status
     *           [Output Only] The current status of this Interconnect's functionality, which can take one of the following values:
     *           - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect.
     *           - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect.
     *           - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     *     @type string $peer_ip_address
     *           [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
     *     @type int $provisioned_link_count
     *           [Output Only] Number of links actually provisioned in this interconnect.
     *     @type int $requested_link_count
     *           Target number of physical links in the link bundle, as requested by the customer.
     *     @type string $self_link
     *           [Output Only] Server-defined URL for the resource.
     *     @type int $state
     *           [Output Only] The current state of Interconnect functionality, which can take one of the following values:
     *           - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect.
     *           - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect.
     *           - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
     *
     * Generated from protobuf field <code>bool admin_enabled = 177239633;</code>
     * @return bool
     */
    public function getAdminEnabled()
    {
        return $this->admin_enabled;
    }

    /**
     * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
     *
     * Generated from protobuf field <code>bool admin_enabled = 177239633;</code>
     * @param bool $var
     * @return $this
     */
    public function setAdminEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->admin_enabled = $var;

        return $this;
    }

    /**
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCircuitInfos()
    {
        return $this->circuit_infos;
    }

    /**
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;</code>
     * @param \Google\Cloud\Compute\V1\InterconnectCircuitInfo[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCircuitInfos($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\InterconnectCircuitInfo::class);
        $this->circuit_infos = $arr;

        return $this;
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     * @return string
     */
    public function getCreationTimestamp()
    {
        return $this->creation_timestamp;
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     * @param string $var
     * @return $this
     */
    public function setCreationTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->creation_timestamp = $var;

        return $this;
    }

    /**
     * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
     *
     * Generated from protobuf field <code>string customer_name = 3665484;</code>
     * @return string
     */
    public function getCustomerName()
    {
        return $this->customer_name;
    }

    /**
     * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
     *
     * Generated from protobuf field <code>string customer_name = 3665484;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomerName($var)
    {
        GPBUtil::checkString($var, True);
        $this->customer_name = $var;

        return $this;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * [Output Only] A list of outages expected for this Interconnect.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExpectedOutages()
    {
        return $this->expected_outages;
    }

    /**
     * [Output Only] A list of outages expected for this Interconnect.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;</code>
     * @param \Google\Cloud\Compute\V1\InterconnectOutageNotification[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExpectedOutages($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\InterconnectOutageNotification::class);
        $this->expected_outages = $arr;

        return $this;
    }

    /**
     * [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
     *
     * Generated from protobuf field <code>string google_ip_address = 174670498;</code>
     * @return string
     */
    public function getGoogleIpAddress()
    {
        return $this->google_ip_address;
    }

    /**
     * [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
     *
     * Generated from protobuf field <code>string google_ip_address = 174670498;</code>
     * @param string $var
     * @return $this
     */
    public function setGoogleIpAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->google_ip_address = $var;

        return $this;
    }

    /**
     * [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
     *
     * Generated from protobuf field <code>string google_reference_id = 266509013;</code>
     * @return string
     */
    public function getGoogleReferenceId()
    {
        return $this->google_reference_id;
    }

    /**
     * [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
     *
     * Generated from protobuf field <code>string google_reference_id = 266509013;</code>
     * @param string $var
     * @return $this
     */
    public function setGoogleReferenceId($var)
    {
        GPBUtil::checkString($var, True);
        $this->google_reference_id = $var;

        return $this;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
     *
     * Generated from protobuf field <code>repeated string interconnect_attachments = 156952959;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getInterconnectAttachments()
    {
        return $this->interconnect_attachments;
    }

    /**
     * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
     *
     * Generated from protobuf field <code>repeated string interconnect_attachments = 156952959;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setInterconnectAttachments($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->interconnect_attachments = $arr;

        return $this;
    }

    /**
     * Type of interconnect, which can take one of the following values:
     * - PARTNER: A partner-managed interconnection shared between customers though a partner.
     * - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Interconnect.InterconnectType interconnect_type = 246729803;</code>
     * @return int
     */
    public function getInterconnectType()
    {
        return $this->interconnect_type;
    }

    /**
     * Type of interconnect, which can take one of the following values:
     * - PARTNER: A partner-managed interconnection shared between customers though a partner.
     * - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Interconnect.InterconnectType interconnect_type = 246729803;</code>
     * @param int $var
     * @return $this
     */
    public function setInterconnectType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\Interconnect\InterconnectType::class);
        $this->interconnect_type = $var;

        return $this;
    }

    /**
     * [Output Only] Type of the resource. Always compute#interconnect for interconnects.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * [Output Only] Type of the resource. Always compute#interconnect for interconnects.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * Type of link requested, which can take one of the following values:
     * - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics
     * - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Interconnect.LinkType link_type = 254772319;</code>
     * @return int
     */
    public function getLinkType()
    {
        return $this->link_type;
    }

    /**
     * Type of link requested, which can take one of the following values:
     * - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics
     * - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Interconnect.LinkType link_type = 254772319;</code>
     * @param int $var
     * @return $this
     */
    public function setLinkType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\Interconnect\LinkType::class);
        $this->link_type = $var;

        return $this;
    }

    /**
     * URL of the InterconnectLocation object that represents where this connection is to be provisioned.
     *
     * Generated from protobuf field <code>string location = 21995445;</code>
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * URL of the InterconnectLocation object that represents where this connection is to be provisioned.
     *
     * Generated from protobuf field <code>string location = 21995445;</code>
     * @param string $var
     * @return $this
     */
    public function setLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->location = $var;

        return $this;
    }

    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Stackdriver logs alerting and Cloud Notifications.
     *
     * Generated from protobuf field <code>string noc_contact_email = 14072832;</code>
     * @return string
     */
    public function getNocContactEmail()
    {
        return $this->noc_contact_email;
    }

    /**
     * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Stackdriver logs alerting and Cloud Notifications.
     *
     * Generated from protobuf field <code>string noc_contact_email = 14072832;</code>
     * @param string $var
     * @return $this
     */
    public function setNocContactEmail($var)
    {
        GPBUtil::checkString($var, True);
        $this->noc_contact_email = $var;

        return $this;
    }

    /**
     * [Output Only] The current status of this Interconnect's functionality, which can take one of the following values:
     * - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect.
     * - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect.
     * - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Interconnect.OperationalStatus operational_status = 201070847;</code>
     * @return int
     */
    public function getOperationalStatus()
    {
        return $this->operational_status;
    }

    /**
     * [Output Only] The current status of this Interconnect's functionality, which can take one of the following values:
     * - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect.
     * - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect.
     * - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Interconnect.OperationalStatus operational_status = 201070847;</code>
     * @param int $var
     * @return $this
     */
    public function setOperationalStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\Interconnect\OperationalStatus::class);
        $this->operational_status = $var;

        return $this;
    }

    /**
     * [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
     *
     * Generated from protobuf field <code>string peer_ip_address = 207735769;</code>
     * @return string
     */
    public function getPeerIpAddress()
    {
        return $this->peer_ip_address;
    }

    /**
     * [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
     *
     * Generated from protobuf field <code>string peer_ip_address = 207735769;</code>
     * @param string $var
     * @return $this
     */
    public function setPeerIpAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->peer_ip_address = $var;

        return $this;
    }

    /**
     * [Output Only] Number of links actually provisioned in this interconnect.
     *
     * Generated from protobuf field <code>int32 provisioned_link_count = 142453109;</code>
     * @return int
     */
    public function getProvisionedLinkCount()
    {
        return $this->provisioned_link_count;
    }

    /**
     * [Output Only] Number of links actually provisioned in this interconnect.
     *
     * Generated from protobuf field <code>int32 provisioned_link_count = 142453109;</code>
     * @param int $var
     * @return $this
     */
    public function setProvisionedLinkCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->provisioned_link_count = $var;

        return $this;
    }

    /**
     * Target number of physical links in the link bundle, as requested by the customer.
     *
     * Generated from protobuf field <code>int32 requested_link_count = 45051387;</code>
     * @return int
     */
    public function getRequestedLinkCount()
    {
        return $this->requested_link_count;
    }

    /**
     * Target number of physical links in the link bundle, as requested by the customer.
     *
     * Generated from protobuf field <code>int32 requested_link_count = 45051387;</code>
     * @param int $var
     * @return $this
     */
    public function setRequestedLinkCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->requested_link_count = $var;

        return $this;
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return $this->self_link;
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * [Output Only] The current state of Interconnect functionality, which can take one of the following values:
     * - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect.
     * - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect.
     * - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Interconnect.State state = 109757585;</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * [Output Only] The current state of Interconnect functionality, which can take one of the following values:
     * - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect.
     * - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect.
     * - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Interconnect.State state = 109757585;</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\Interconnect\State::class);
        $this->state = $var;

        return $this;
    }

}

