<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/networkservices/v1/network_services.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\NetworkServices\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\NetworkServices\V1\CreateEndpointPolicyRequest;
use Google\Cloud\NetworkServices\V1\CreateGatewayRequest;
use Google\Cloud\NetworkServices\V1\CreateGrpcRouteRequest;
use Google\Cloud\NetworkServices\V1\CreateHttpRouteRequest;
use Google\Cloud\NetworkServices\V1\CreateMeshRequest;
use Google\Cloud\NetworkServices\V1\CreateServiceBindingRequest;
use Google\Cloud\NetworkServices\V1\CreateTcpRouteRequest;
use Google\Cloud\NetworkServices\V1\CreateTlsRouteRequest;
use Google\Cloud\NetworkServices\V1\DeleteEndpointPolicyRequest;
use Google\Cloud\NetworkServices\V1\DeleteGatewayRequest;
use Google\Cloud\NetworkServices\V1\DeleteGrpcRouteRequest;
use Google\Cloud\NetworkServices\V1\DeleteHttpRouteRequest;
use Google\Cloud\NetworkServices\V1\DeleteMeshRequest;
use Google\Cloud\NetworkServices\V1\DeleteServiceBindingRequest;
use Google\Cloud\NetworkServices\V1\DeleteTcpRouteRequest;
use Google\Cloud\NetworkServices\V1\DeleteTlsRouteRequest;
use Google\Cloud\NetworkServices\V1\EndpointPolicy;
use Google\Cloud\NetworkServices\V1\Gateway;
use Google\Cloud\NetworkServices\V1\GetEndpointPolicyRequest;
use Google\Cloud\NetworkServices\V1\GetGatewayRequest;
use Google\Cloud\NetworkServices\V1\GetGrpcRouteRequest;
use Google\Cloud\NetworkServices\V1\GetHttpRouteRequest;
use Google\Cloud\NetworkServices\V1\GetMeshRequest;
use Google\Cloud\NetworkServices\V1\GetServiceBindingRequest;
use Google\Cloud\NetworkServices\V1\GetTcpRouteRequest;
use Google\Cloud\NetworkServices\V1\GetTlsRouteRequest;
use Google\Cloud\NetworkServices\V1\GrpcRoute;
use Google\Cloud\NetworkServices\V1\HttpRoute;
use Google\Cloud\NetworkServices\V1\ListEndpointPoliciesRequest;
use Google\Cloud\NetworkServices\V1\ListGatewaysRequest;
use Google\Cloud\NetworkServices\V1\ListGrpcRoutesRequest;
use Google\Cloud\NetworkServices\V1\ListHttpRoutesRequest;
use Google\Cloud\NetworkServices\V1\ListMeshesRequest;
use Google\Cloud\NetworkServices\V1\ListServiceBindingsRequest;
use Google\Cloud\NetworkServices\V1\ListTcpRoutesRequest;
use Google\Cloud\NetworkServices\V1\ListTlsRoutesRequest;
use Google\Cloud\NetworkServices\V1\Mesh;
use Google\Cloud\NetworkServices\V1\ServiceBinding;
use Google\Cloud\NetworkServices\V1\TcpRoute;
use Google\Cloud\NetworkServices\V1\TlsRoute;
use Google\Cloud\NetworkServices\V1\UpdateEndpointPolicyRequest;
use Google\Cloud\NetworkServices\V1\UpdateGatewayRequest;
use Google\Cloud\NetworkServices\V1\UpdateGrpcRouteRequest;
use Google\Cloud\NetworkServices\V1\UpdateHttpRouteRequest;
use Google\Cloud\NetworkServices\V1\UpdateMeshRequest;
use Google\Cloud\NetworkServices\V1\UpdateTcpRouteRequest;
use Google\Cloud\NetworkServices\V1\UpdateTlsRouteRequest;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Service describing handlers for resources.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> createEndpointPolicyAsync(CreateEndpointPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createGatewayAsync(CreateGatewayRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createGrpcRouteAsync(CreateGrpcRouteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createHttpRouteAsync(CreateHttpRouteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createMeshAsync(CreateMeshRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createServiceBindingAsync(CreateServiceBindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createTcpRouteAsync(CreateTcpRouteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createTlsRouteAsync(CreateTlsRouteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteEndpointPolicyAsync(DeleteEndpointPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteGatewayAsync(DeleteGatewayRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteGrpcRouteAsync(DeleteGrpcRouteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteHttpRouteAsync(DeleteHttpRouteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteMeshAsync(DeleteMeshRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteServiceBindingAsync(DeleteServiceBindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteTcpRouteAsync(DeleteTcpRouteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteTlsRouteAsync(DeleteTlsRouteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EndpointPolicy> getEndpointPolicyAsync(GetEndpointPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Gateway> getGatewayAsync(GetGatewayRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<GrpcRoute> getGrpcRouteAsync(GetGrpcRouteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<HttpRoute> getHttpRouteAsync(GetHttpRouteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Mesh> getMeshAsync(GetMeshRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ServiceBinding> getServiceBindingAsync(GetServiceBindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TcpRoute> getTcpRouteAsync(GetTcpRouteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TlsRoute> getTlsRouteAsync(GetTlsRouteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listEndpointPoliciesAsync(ListEndpointPoliciesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listGatewaysAsync(ListGatewaysRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listGrpcRoutesAsync(ListGrpcRoutesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listHttpRoutesAsync(ListHttpRoutesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listMeshesAsync(ListMeshesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listServiceBindingsAsync(ListServiceBindingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listTcpRoutesAsync(ListTcpRoutesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listTlsRoutesAsync(ListTlsRoutesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateEndpointPolicyAsync(UpdateEndpointPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateGatewayAsync(UpdateGatewayRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateGrpcRouteAsync(UpdateGrpcRouteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateHttpRouteAsync(UpdateHttpRouteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateMeshAsync(UpdateMeshRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateTcpRouteAsync(UpdateTcpRouteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateTlsRouteAsync(UpdateTlsRouteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class NetworkServicesClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.networkservices.v1.NetworkServices';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'networkservices.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'networkservices.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/network_services_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/network_services_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/network_services_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/network_services_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * authorization_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $authorizationPolicy
     *
     * @return string The formatted authorization_policy resource.
     */
    public static function authorizationPolicyName(
        string $project,
        string $location,
        string $authorizationPolicy
    ): string {
        return self::getPathTemplate('authorizationPolicy')->render([
            'project' => $project,
            'location' => $location,
            'authorization_policy' => $authorizationPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * backend_service resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backendService
     *
     * @return string The formatted backend_service resource.
     */
    public static function backendServiceName(string $project, string $location, string $backendService): string
    {
        return self::getPathTemplate('backendService')->render([
            'project' => $project,
            'location' => $location,
            'backend_service' => $backendService,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * client_tls_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $clientTlsPolicy
     *
     * @return string The formatted client_tls_policy resource.
     */
    public static function clientTlsPolicyName(string $project, string $location, string $clientTlsPolicy): string
    {
        return self::getPathTemplate('clientTlsPolicy')->render([
            'project' => $project,
            'location' => $location,
            'client_tls_policy' => $clientTlsPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * endpoint_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $endpointPolicy
     *
     * @return string The formatted endpoint_policy resource.
     */
    public static function endpointPolicyName(string $project, string $location, string $endpointPolicy): string
    {
        return self::getPathTemplate('endpointPolicy')->render([
            'project' => $project,
            'location' => $location,
            'endpoint_policy' => $endpointPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a gateway
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $gateway
     *
     * @return string The formatted gateway resource.
     */
    public static function gatewayName(string $project, string $location, string $gateway): string
    {
        return self::getPathTemplate('gateway')->render([
            'project' => $project,
            'location' => $location,
            'gateway' => $gateway,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a grpc_route
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $grpcRoute
     *
     * @return string The formatted grpc_route resource.
     */
    public static function grpcRouteName(string $project, string $location, string $grpcRoute): string
    {
        return self::getPathTemplate('grpcRoute')->render([
            'project' => $project,
            'location' => $location,
            'grpc_route' => $grpcRoute,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a http_route
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $httpRoute
     *
     * @return string The formatted http_route resource.
     */
    public static function httpRouteName(string $project, string $location, string $httpRoute): string
    {
        return self::getPathTemplate('httpRoute')->render([
            'project' => $project,
            'location' => $location,
            'http_route' => $httpRoute,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a mesh
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $mesh
     *
     * @return string The formatted mesh resource.
     */
    public static function meshName(string $project, string $location, string $mesh): string
    {
        return self::getPathTemplate('mesh')->render([
            'project' => $project,
            'location' => $location,
            'mesh' => $mesh,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * server_tls_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $serverTlsPolicy
     *
     * @return string The formatted server_tls_policy resource.
     */
    public static function serverTlsPolicyName(string $project, string $location, string $serverTlsPolicy): string
    {
        return self::getPathTemplate('serverTlsPolicy')->render([
            'project' => $project,
            'location' => $location,
            'server_tls_policy' => $serverTlsPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * service_binding resource.
     *
     * @param string $project
     * @param string $location
     * @param string $serviceBinding
     *
     * @return string The formatted service_binding resource.
     */
    public static function serviceBindingName(string $project, string $location, string $serviceBinding): string
    {
        return self::getPathTemplate('serviceBinding')->render([
            'project' => $project,
            'location' => $location,
            'service_binding' => $serviceBinding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a tcp_route
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tcpRoute
     *
     * @return string The formatted tcp_route resource.
     */
    public static function tcpRouteName(string $project, string $location, string $tcpRoute): string
    {
        return self::getPathTemplate('tcpRoute')->render([
            'project' => $project,
            'location' => $location,
            'tcp_route' => $tcpRoute,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a tls_route
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tlsRoute
     *
     * @return string The formatted tls_route resource.
     */
    public static function tlsRouteName(string $project, string $location, string $tlsRoute): string
    {
        return self::getPathTemplate('tlsRoute')->render([
            'project' => $project,
            'location' => $location,
            'tls_route' => $tlsRoute,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - authorizationPolicy: projects/{project}/locations/{location}/authorizationPolicies/{authorization_policy}
     * - backendService: projects/{project}/locations/{location}/backendServices/{backend_service}
     * - clientTlsPolicy: projects/{project}/locations/{location}/clientTlsPolicies/{client_tls_policy}
     * - endpointPolicy: projects/{project}/locations/{location}/endpointPolicies/{endpoint_policy}
     * - gateway: projects/{project}/locations/{location}/gateways/{gateway}
     * - grpcRoute: projects/{project}/locations/{location}/grpcRoutes/{grpc_route}
     * - httpRoute: projects/{project}/locations/{location}/httpRoutes/{http_route}
     * - location: projects/{project}/locations/{location}
     * - mesh: projects/{project}/locations/{location}/meshes/{mesh}
     * - serverTlsPolicy: projects/{project}/locations/{location}/serverTlsPolicies/{server_tls_policy}
     * - serviceBinding: projects/{project}/locations/{location}/serviceBindings/{service_binding}
     * - tcpRoute: projects/{project}/locations/{location}/tcpRoutes/{tcp_route}
     * - tlsRoute: projects/{project}/locations/{location}/tlsRoutes/{tls_route}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'networkservices.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *           *Important*: If you accept a credential configuration (credential
     *           JSON/File/Stream) from an external source for authentication to Google Cloud
     *           Platform, you must validate it before providing it to any Google API or library.
     *           Providing an unvalidated credential configuration to Google APIs can compromise
     *           the security of your systems and data. For more information {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a new EndpointPolicy in a given project and location.
     *
     * The async variant is {@see NetworkServicesClient::createEndpointPolicyAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/create_endpoint_policy.php
     *
     * @param CreateEndpointPolicyRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createEndpointPolicy(
        CreateEndpointPolicyRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateEndpointPolicy', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Gateway in a given project and location.
     *
     * The async variant is {@see NetworkServicesClient::createGatewayAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/create_gateway.php
     *
     * @param CreateGatewayRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createGateway(CreateGatewayRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateGateway', $request, $callOptions)->wait();
    }

    /**
     * Creates a new GrpcRoute in a given project and location.
     *
     * The async variant is {@see NetworkServicesClient::createGrpcRouteAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/create_grpc_route.php
     *
     * @param CreateGrpcRouteRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createGrpcRoute(CreateGrpcRouteRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateGrpcRoute', $request, $callOptions)->wait();
    }

    /**
     * Creates a new HttpRoute in a given project and location.
     *
     * The async variant is {@see NetworkServicesClient::createHttpRouteAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/create_http_route.php
     *
     * @param CreateHttpRouteRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createHttpRoute(CreateHttpRouteRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateHttpRoute', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Mesh in a given project and location.
     *
     * The async variant is {@see NetworkServicesClient::createMeshAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/create_mesh.php
     *
     * @param CreateMeshRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createMesh(CreateMeshRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateMesh', $request, $callOptions)->wait();
    }

    /**
     * Creates a new ServiceBinding in a given project and location.
     *
     * The async variant is {@see NetworkServicesClient::createServiceBindingAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/create_service_binding.php
     *
     * @param CreateServiceBindingRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createServiceBinding(
        CreateServiceBindingRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateServiceBinding', $request, $callOptions)->wait();
    }

    /**
     * Creates a new TcpRoute in a given project and location.
     *
     * The async variant is {@see NetworkServicesClient::createTcpRouteAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/create_tcp_route.php
     *
     * @param CreateTcpRouteRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTcpRoute(CreateTcpRouteRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateTcpRoute', $request, $callOptions)->wait();
    }

    /**
     * Creates a new TlsRoute in a given project and location.
     *
     * The async variant is {@see NetworkServicesClient::createTlsRouteAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/create_tls_route.php
     *
     * @param CreateTlsRouteRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTlsRoute(CreateTlsRouteRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateTlsRoute', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single EndpointPolicy.
     *
     * The async variant is {@see NetworkServicesClient::deleteEndpointPolicyAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/delete_endpoint_policy.php
     *
     * @param DeleteEndpointPolicyRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteEndpointPolicy(
        DeleteEndpointPolicyRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteEndpointPolicy', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Gateway.
     *
     * The async variant is {@see NetworkServicesClient::deleteGatewayAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/delete_gateway.php
     *
     * @param DeleteGatewayRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteGateway(DeleteGatewayRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteGateway', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single GrpcRoute.
     *
     * The async variant is {@see NetworkServicesClient::deleteGrpcRouteAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/delete_grpc_route.php
     *
     * @param DeleteGrpcRouteRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteGrpcRoute(DeleteGrpcRouteRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteGrpcRoute', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single HttpRoute.
     *
     * The async variant is {@see NetworkServicesClient::deleteHttpRouteAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/delete_http_route.php
     *
     * @param DeleteHttpRouteRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteHttpRoute(DeleteHttpRouteRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteHttpRoute', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Mesh.
     *
     * The async variant is {@see NetworkServicesClient::deleteMeshAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/delete_mesh.php
     *
     * @param DeleteMeshRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteMesh(DeleteMeshRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteMesh', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single ServiceBinding.
     *
     * The async variant is {@see NetworkServicesClient::deleteServiceBindingAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/delete_service_binding.php
     *
     * @param DeleteServiceBindingRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteServiceBinding(
        DeleteServiceBindingRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteServiceBinding', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single TcpRoute.
     *
     * The async variant is {@see NetworkServicesClient::deleteTcpRouteAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/delete_tcp_route.php
     *
     * @param DeleteTcpRouteRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTcpRoute(DeleteTcpRouteRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteTcpRoute', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single TlsRoute.
     *
     * The async variant is {@see NetworkServicesClient::deleteTlsRouteAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/delete_tls_route.php
     *
     * @param DeleteTlsRouteRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTlsRoute(DeleteTlsRouteRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteTlsRoute', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single EndpointPolicy.
     *
     * The async variant is {@see NetworkServicesClient::getEndpointPolicyAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/get_endpoint_policy.php
     *
     * @param GetEndpointPolicyRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EndpointPolicy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEndpointPolicy(GetEndpointPolicyRequest $request, array $callOptions = []): EndpointPolicy
    {
        return $this->startApiCall('GetEndpointPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Gateway.
     *
     * The async variant is {@see NetworkServicesClient::getGatewayAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/get_gateway.php
     *
     * @param GetGatewayRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Gateway
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getGateway(GetGatewayRequest $request, array $callOptions = []): Gateway
    {
        return $this->startApiCall('GetGateway', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single GrpcRoute.
     *
     * The async variant is {@see NetworkServicesClient::getGrpcRouteAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/get_grpc_route.php
     *
     * @param GetGrpcRouteRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GrpcRoute
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getGrpcRoute(GetGrpcRouteRequest $request, array $callOptions = []): GrpcRoute
    {
        return $this->startApiCall('GetGrpcRoute', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single HttpRoute.
     *
     * The async variant is {@see NetworkServicesClient::getHttpRouteAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/get_http_route.php
     *
     * @param GetHttpRouteRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HttpRoute
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getHttpRoute(GetHttpRouteRequest $request, array $callOptions = []): HttpRoute
    {
        return $this->startApiCall('GetHttpRoute', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Mesh.
     *
     * The async variant is {@see NetworkServicesClient::getMeshAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/get_mesh.php
     *
     * @param GetMeshRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Mesh
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getMesh(GetMeshRequest $request, array $callOptions = []): Mesh
    {
        return $this->startApiCall('GetMesh', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single ServiceBinding.
     *
     * The async variant is {@see NetworkServicesClient::getServiceBindingAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/get_service_binding.php
     *
     * @param GetServiceBindingRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ServiceBinding
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getServiceBinding(GetServiceBindingRequest $request, array $callOptions = []): ServiceBinding
    {
        return $this->startApiCall('GetServiceBinding', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single TcpRoute.
     *
     * The async variant is {@see NetworkServicesClient::getTcpRouteAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/get_tcp_route.php
     *
     * @param GetTcpRouteRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TcpRoute
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTcpRoute(GetTcpRouteRequest $request, array $callOptions = []): TcpRoute
    {
        return $this->startApiCall('GetTcpRoute', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single TlsRoute.
     *
     * The async variant is {@see NetworkServicesClient::getTlsRouteAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/get_tls_route.php
     *
     * @param GetTlsRouteRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TlsRoute
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTlsRoute(GetTlsRouteRequest $request, array $callOptions = []): TlsRoute
    {
        return $this->startApiCall('GetTlsRoute', $request, $callOptions)->wait();
    }

    /**
     * Lists EndpointPolicies in a given project and location.
     *
     * The async variant is {@see NetworkServicesClient::listEndpointPoliciesAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/list_endpoint_policies.php
     *
     * @param ListEndpointPoliciesRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEndpointPolicies(
        ListEndpointPoliciesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListEndpointPolicies', $request, $callOptions);
    }

    /**
     * Lists Gateways in a given project and location.
     *
     * The async variant is {@see NetworkServicesClient::listGatewaysAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/list_gateways.php
     *
     * @param ListGatewaysRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listGateways(ListGatewaysRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListGateways', $request, $callOptions);
    }

    /**
     * Lists GrpcRoutes in a given project and location.
     *
     * The async variant is {@see NetworkServicesClient::listGrpcRoutesAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/list_grpc_routes.php
     *
     * @param ListGrpcRoutesRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listGrpcRoutes(ListGrpcRoutesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListGrpcRoutes', $request, $callOptions);
    }

    /**
     * Lists HttpRoute in a given project and location.
     *
     * The async variant is {@see NetworkServicesClient::listHttpRoutesAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/list_http_routes.php
     *
     * @param ListHttpRoutesRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listHttpRoutes(ListHttpRoutesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListHttpRoutes', $request, $callOptions);
    }

    /**
     * Lists Meshes in a given project and location.
     *
     * The async variant is {@see NetworkServicesClient::listMeshesAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/list_meshes.php
     *
     * @param ListMeshesRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listMeshes(ListMeshesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListMeshes', $request, $callOptions);
    }

    /**
     * Lists ServiceBinding in a given project and location.
     *
     * The async variant is {@see NetworkServicesClient::listServiceBindingsAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/list_service_bindings.php
     *
     * @param ListServiceBindingsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listServiceBindings(ListServiceBindingsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListServiceBindings', $request, $callOptions);
    }

    /**
     * Lists TcpRoute in a given project and location.
     *
     * The async variant is {@see NetworkServicesClient::listTcpRoutesAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/list_tcp_routes.php
     *
     * @param ListTcpRoutesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTcpRoutes(ListTcpRoutesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListTcpRoutes', $request, $callOptions);
    }

    /**
     * Lists TlsRoute in a given project and location.
     *
     * The async variant is {@see NetworkServicesClient::listTlsRoutesAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/list_tls_routes.php
     *
     * @param ListTlsRoutesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTlsRoutes(ListTlsRoutesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListTlsRoutes', $request, $callOptions);
    }

    /**
     * Updates the parameters of a single EndpointPolicy.
     *
     * The async variant is {@see NetworkServicesClient::updateEndpointPolicyAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/update_endpoint_policy.php
     *
     * @param UpdateEndpointPolicyRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateEndpointPolicy(
        UpdateEndpointPolicyRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateEndpointPolicy', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single Gateway.
     *
     * The async variant is {@see NetworkServicesClient::updateGatewayAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/update_gateway.php
     *
     * @param UpdateGatewayRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateGateway(UpdateGatewayRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateGateway', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single GrpcRoute.
     *
     * The async variant is {@see NetworkServicesClient::updateGrpcRouteAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/update_grpc_route.php
     *
     * @param UpdateGrpcRouteRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateGrpcRoute(UpdateGrpcRouteRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateGrpcRoute', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single HttpRoute.
     *
     * The async variant is {@see NetworkServicesClient::updateHttpRouteAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/update_http_route.php
     *
     * @param UpdateHttpRouteRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateHttpRoute(UpdateHttpRouteRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateHttpRoute', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single Mesh.
     *
     * The async variant is {@see NetworkServicesClient::updateMeshAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/update_mesh.php
     *
     * @param UpdateMeshRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateMesh(UpdateMeshRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateMesh', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single TcpRoute.
     *
     * The async variant is {@see NetworkServicesClient::updateTcpRouteAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/update_tcp_route.php
     *
     * @param UpdateTcpRouteRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTcpRoute(UpdateTcpRouteRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateTcpRoute', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single TlsRoute.
     *
     * The async variant is {@see NetworkServicesClient::updateTlsRouteAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/update_tls_route.php
     *
     * @param UpdateTlsRouteRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTlsRoute(UpdateTlsRouteRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateTlsRoute', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see NetworkServicesClient::getLocationAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see NetworkServicesClient::listLocationsAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see NetworkServicesClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see NetworkServicesClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see NetworkServicesClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/NetworkServicesClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
