<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/video/transcoder/v1/services.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Video\Transcoder\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Video\Transcoder\V1\CreateJobRequest;
use Google\Cloud\Video\Transcoder\V1\CreateJobTemplateRequest;
use Google\Cloud\Video\Transcoder\V1\DeleteJobRequest;
use Google\Cloud\Video\Transcoder\V1\DeleteJobTemplateRequest;
use Google\Cloud\Video\Transcoder\V1\GetJobRequest;
use Google\Cloud\Video\Transcoder\V1\GetJobTemplateRequest;
use Google\Cloud\Video\Transcoder\V1\Job;
use Google\Cloud\Video\Transcoder\V1\JobTemplate;
use Google\Cloud\Video\Transcoder\V1\ListJobTemplatesRequest;
use Google\Cloud\Video\Transcoder\V1\ListJobTemplatesResponse;
use Google\Cloud\Video\Transcoder\V1\ListJobsRequest;
use Google\Cloud\Video\Transcoder\V1\ListJobsResponse;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: Using the Transcoder API, you can queue asynchronous jobs for transcoding
 * media into various output formats. Output formats may include different
 * streaming standards such as HTTP Live Streaming (HLS) and Dynamic Adaptive
 * Streaming over HTTP (DASH). You can also customize jobs using advanced
 * features such as Digital Rights Management (DRM), audio equalization, content
 * concatenation, and digital ad-stitch ready content generation.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $transcoderServiceClient = new TranscoderServiceClient();
 * try {
 *     $formattedParent = $transcoderServiceClient->locationName('[PROJECT]', '[LOCATION]');
 *     $job = new Job();
 *     $response = $transcoderServiceClient->createJob($formattedParent, $job);
 * } finally {
 *     $transcoderServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Cloud\Video\Transcoder\V1\Client\TranscoderServiceClient} to use the new
 * surface.
 */
class TranscoderServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.video.transcoder.v1.TranscoderService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'transcoder.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $jobNameTemplate;

    private static $jobTemplateNameTemplate;

    private static $locationNameTemplate;

    private static $pathTemplateMap;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/transcoder_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/transcoder_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/transcoder_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/transcoder_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getJobNameTemplate()
    {
        if (self::$jobNameTemplate == null) {
            self::$jobNameTemplate = new PathTemplate('projects/{project}/locations/{location}/jobs/{job}');
        }

        return self::$jobNameTemplate;
    }

    private static function getJobTemplateNameTemplate()
    {
        if (self::$jobTemplateNameTemplate == null) {
            self::$jobTemplateNameTemplate = new PathTemplate('projects/{project}/locations/{location}/jobTemplates/{job_template}');
        }

        return self::$jobTemplateNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate('projects/{project}/locations/{location}');
        }

        return self::$locationNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'job' => self::getJobNameTemplate(),
                'jobTemplate' => self::getJobTemplateNameTemplate(),
                'location' => self::getLocationNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a job
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $job
     *
     * @return string The formatted job resource.
     */
    public static function jobName($project, $location, $job)
    {
        return self::getJobNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'job' => $job,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a job_template
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $jobTemplate
     *
     * @return string The formatted job_template resource.
     */
    public static function jobTemplateName($project, $location, $jobTemplate)
    {
        return self::getJobTemplateNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'job_template' => $jobTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - job: projects/{project}/locations/{location}/jobs/{job}
     * - jobTemplate: projects/{project}/locations/{location}/jobTemplates/{job_template}
     * - location: projects/{project}/locations/{location}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'transcoder.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Creates a job in the specified region.
     *
     * Sample code:
     * ```
     * $transcoderServiceClient = new TranscoderServiceClient();
     * try {
     *     $formattedParent = $transcoderServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $job = new Job();
     *     $response = $transcoderServiceClient->createJob($formattedParent, $job);
     * } finally {
     *     $transcoderServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent location to create and process this job.
     *                             Format: `projects/{project}/locations/{location}`
     * @param Job    $job          Required. Parameters for creating transcoding job.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Video\Transcoder\V1\Job
     *
     * @throws ApiException if the remote call fails
     */
    public function createJob($parent, $job, array $optionalArgs = [])
    {
        $request = new CreateJobRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setJob($job);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateJob', Job::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a job template in the specified region.
     *
     * Sample code:
     * ```
     * $transcoderServiceClient = new TranscoderServiceClient();
     * try {
     *     $formattedParent = $transcoderServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $jobTemplate = new JobTemplate();
     *     $jobTemplateId = 'job_template_id';
     *     $response = $transcoderServiceClient->createJobTemplate($formattedParent, $jobTemplate, $jobTemplateId);
     * } finally {
     *     $transcoderServiceClient->close();
     * }
     * ```
     *
     * @param string      $parent        Required. The parent location to create this job template.
     *                                   Format: `projects/{project}/locations/{location}`
     * @param JobTemplate $jobTemplate   Required. Parameters for creating job template.
     * @param string      $jobTemplateId Required. The ID to use for the job template, which will become the final
     *                                   component of the job template's resource name.
     *
     *                                   This value should be 4-63 characters, and valid characters must match the
     *                                   regular expression `[a-zA-Z][a-zA-Z0-9_-]*`.
     * @param array       $optionalArgs  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Video\Transcoder\V1\JobTemplate
     *
     * @throws ApiException if the remote call fails
     */
    public function createJobTemplate($parent, $jobTemplate, $jobTemplateId, array $optionalArgs = [])
    {
        $request = new CreateJobTemplateRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setJobTemplate($jobTemplate);
        $request->setJobTemplateId($jobTemplateId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateJobTemplate', JobTemplate::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a job.
     *
     * Sample code:
     * ```
     * $transcoderServiceClient = new TranscoderServiceClient();
     * try {
     *     $formattedName = $transcoderServiceClient->jobName('[PROJECT]', '[LOCATION]', '[JOB]');
     *     $transcoderServiceClient->deleteJob($formattedName);
     * } finally {
     *     $transcoderServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the job to delete.
     *                             Format: `projects/{project}/locations/{location}/jobs/{job}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $allowMissing
     *           If set to true, and the job is not found, the request will succeed but no
     *           action will be taken on the server.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteJob($name, array $optionalArgs = [])
    {
        $request = new DeleteJobRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteJob', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a job template.
     *
     * Sample code:
     * ```
     * $transcoderServiceClient = new TranscoderServiceClient();
     * try {
     *     $formattedName = $transcoderServiceClient->jobTemplateName('[PROJECT]', '[LOCATION]', '[JOB_TEMPLATE]');
     *     $transcoderServiceClient->deleteJobTemplate($formattedName);
     * } finally {
     *     $transcoderServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the job template to delete.
     *                             `projects/{project}/locations/{location}/jobTemplates/{job_template}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $allowMissing
     *           If set to true, and the job template is not found, the request will succeed
     *           but no action will be taken on the server.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteJobTemplate($name, array $optionalArgs = [])
    {
        $request = new DeleteJobTemplateRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteJobTemplate', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns the job data.
     *
     * Sample code:
     * ```
     * $transcoderServiceClient = new TranscoderServiceClient();
     * try {
     *     $formattedName = $transcoderServiceClient->jobName('[PROJECT]', '[LOCATION]', '[JOB]');
     *     $response = $transcoderServiceClient->getJob($formattedName);
     * } finally {
     *     $transcoderServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the job to retrieve.
     *                             Format: `projects/{project}/locations/{location}/jobs/{job}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Video\Transcoder\V1\Job
     *
     * @throws ApiException if the remote call fails
     */
    public function getJob($name, array $optionalArgs = [])
    {
        $request = new GetJobRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetJob', Job::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns the job template data.
     *
     * Sample code:
     * ```
     * $transcoderServiceClient = new TranscoderServiceClient();
     * try {
     *     $formattedName = $transcoderServiceClient->jobTemplateName('[PROJECT]', '[LOCATION]', '[JOB_TEMPLATE]');
     *     $response = $transcoderServiceClient->getJobTemplate($formattedName);
     * } finally {
     *     $transcoderServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the job template to retrieve.
     *                             Format:
     *                             `projects/{project}/locations/{location}/jobTemplates/{job_template}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Video\Transcoder\V1\JobTemplate
     *
     * @throws ApiException if the remote call fails
     */
    public function getJobTemplate($name, array $optionalArgs = [])
    {
        $request = new GetJobTemplateRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetJobTemplate', JobTemplate::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lists job templates in the specified region.
     *
     * Sample code:
     * ```
     * $transcoderServiceClient = new TranscoderServiceClient();
     * try {
     *     $formattedParent = $transcoderServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $transcoderServiceClient->listJobTemplates($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $transcoderServiceClient->listJobTemplates($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $transcoderServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent location from which to retrieve the collection of job
     *                             templates. Format: `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           The filter expression, following the syntax outlined in
     *           https://google.aip.dev/160.
     *     @type string $orderBy
     *           One or more fields to compare and use to sort the output.
     *           See https://google.aip.dev/132#ordering.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listJobTemplates($parent, array $optionalArgs = [])
    {
        $request = new ListJobTemplatesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListJobTemplates', $optionalArgs, ListJobTemplatesResponse::class, $request);
    }

    /**
     * Lists jobs in the specified region.
     *
     * Sample code:
     * ```
     * $transcoderServiceClient = new TranscoderServiceClient();
     * try {
     *     $formattedParent = $transcoderServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $transcoderServiceClient->listJobs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $transcoderServiceClient->listJobs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $transcoderServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Format: `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           The filter expression, following the syntax outlined in
     *           https://google.aip.dev/160.
     *     @type string $orderBy
     *           One or more fields to compare and use to sort the output.
     *           See https://google.aip.dev/132#ordering.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listJobs($parent, array $optionalArgs = [])
    {
        $request = new ListJobsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListJobs', $optionalArgs, ListJobsResponse::class, $request);
    }
}
