<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/speech/v2/cloud_speech.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Speech\V2\Client\BaseClient;

use Google\ApiCore\ApiException;
use Google\ApiCore\BidiStream;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\Speech\V2\BatchRecognizeRequest;
use Google\Cloud\Speech\V2\Config;
use Google\Cloud\Speech\V2\CreateCustomClassRequest;
use Google\Cloud\Speech\V2\CreatePhraseSetRequest;
use Google\Cloud\Speech\V2\CreateRecognizerRequest;
use Google\Cloud\Speech\V2\CustomClass;
use Google\Cloud\Speech\V2\DeleteCustomClassRequest;
use Google\Cloud\Speech\V2\DeletePhraseSetRequest;
use Google\Cloud\Speech\V2\DeleteRecognizerRequest;
use Google\Cloud\Speech\V2\GetConfigRequest;
use Google\Cloud\Speech\V2\GetCustomClassRequest;
use Google\Cloud\Speech\V2\GetPhraseSetRequest;
use Google\Cloud\Speech\V2\GetRecognizerRequest;
use Google\Cloud\Speech\V2\ListCustomClassesRequest;
use Google\Cloud\Speech\V2\ListPhraseSetsRequest;
use Google\Cloud\Speech\V2\ListRecognizersRequest;
use Google\Cloud\Speech\V2\PhraseSet;
use Google\Cloud\Speech\V2\RecognizeRequest;
use Google\Cloud\Speech\V2\RecognizeResponse;
use Google\Cloud\Speech\V2\Recognizer;
use Google\Cloud\Speech\V2\UndeleteCustomClassRequest;
use Google\Cloud\Speech\V2\UndeletePhraseSetRequest;
use Google\Cloud\Speech\V2\UndeleteRecognizerRequest;
use Google\Cloud\Speech\V2\UpdateConfigRequest;
use Google\Cloud\Speech\V2\UpdateCustomClassRequest;
use Google\Cloud\Speech\V2\UpdatePhraseSetRequest;
use Google\Cloud\Speech\V2\UpdateRecognizerRequest;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Enables speech transcription and resource management.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes. See {@see
 * \Google\Cloud\Speech\V2\SpeechClient} for the stable implementation
 *
 * @experimental
 *
 * @internal
 *
 * @method PromiseInterface batchRecognizeAsync(BatchRecognizeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createCustomClassAsync(CreateCustomClassRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createPhraseSetAsync(CreatePhraseSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createRecognizerAsync(CreateRecognizerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteCustomClassAsync(DeleteCustomClassRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deletePhraseSetAsync(DeletePhraseSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteRecognizerAsync(DeleteRecognizerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getConfigAsync(GetConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getCustomClassAsync(GetCustomClassRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getPhraseSetAsync(GetPhraseSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getRecognizerAsync(GetRecognizerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listCustomClassesAsync(ListCustomClassesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listPhraseSetsAsync(ListPhraseSetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listRecognizersAsync(ListRecognizersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface recognizeAsync(RecognizeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface undeleteCustomClassAsync(UndeleteCustomClassRequest $request, array $optionalArgs = [])
 * @method PromiseInterface undeletePhraseSetAsync(UndeletePhraseSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface undeleteRecognizerAsync(UndeleteRecognizerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateConfigAsync(UpdateConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateCustomClassAsync(UpdateCustomClassRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updatePhraseSetAsync(UpdatePhraseSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateRecognizerAsync(UpdateRecognizerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
abstract class SpeechBaseClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.speech.v2.Speech';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'speech.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../../resources/speech_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../../resources/speech_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../../resources/speech_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../../resources/speech_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a config
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted config resource.
     */
    public static function configName(string $project, string $location): string
    {
        return self::getPathTemplate('config')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a crypto_key
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     * @param string $cryptoKey
     *
     * @return string The formatted crypto_key resource.
     */
    public static function cryptoKeyName(string $project, string $location, string $keyRing, string $cryptoKey): string
    {
        return self::getPathTemplate('cryptoKey')->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
            'crypto_key' => $cryptoKey,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * crypto_key_version resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     * @param string $cryptoKey
     * @param string $cryptoKeyVersion
     *
     * @return string The formatted crypto_key_version resource.
     */
    public static function cryptoKeyVersionName(string $project, string $location, string $keyRing, string $cryptoKey, string $cryptoKeyVersion): string
    {
        return self::getPathTemplate('cryptoKeyVersion')->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
            'crypto_key' => $cryptoKey,
            'crypto_key_version' => $cryptoKeyVersion,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a custom_class
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $customClass
     *
     * @return string The formatted custom_class resource.
     */
    public static function customClassName(string $project, string $location, string $customClass): string
    {
        return self::getPathTemplate('customClass')->render([
            'project' => $project,
            'location' => $location,
            'custom_class' => $customClass,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a phrase_set
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $phraseSet
     *
     * @return string The formatted phrase_set resource.
     */
    public static function phraseSetName(string $project, string $location, string $phraseSet): string
    {
        return self::getPathTemplate('phraseSet')->render([
            'project' => $project,
            'location' => $location,
            'phrase_set' => $phraseSet,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a recognizer
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $recognizer
     *
     * @return string The formatted recognizer resource.
     */
    public static function recognizerName(string $project, string $location, string $recognizer): string
    {
        return self::getPathTemplate('recognizer')->render([
            'project' => $project,
            'location' => $location,
            'recognizer' => $recognizer,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - config: projects/{project}/locations/{location}/config
     * - cryptoKey: projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}
     * - cryptoKeyVersion: projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}
     * - customClass: projects/{project}/locations/{location}/customClasses/{custom_class}
     * - location: projects/{project}/locations/{location}
     * - phraseSet: projects/{project}/locations/{location}/phraseSets/{phrase_set}
     * - recognizer: projects/{project}/locations/{location}/recognizers/{recognizer}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'speech.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Performs batch asynchronous speech recognition: send a request with N
     * audio files and receive a long running operation that can be polled to see
     * when the transcriptions are finished.
     *
     * The async variant is {@see self::batchRecognizeAsync()} .
     *
     * @param BatchRecognizeRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchRecognize(BatchRecognizeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('BatchRecognize', $request, $callOptions)->wait();
    }

    /**
     * Creates a [CustomClass][google.cloud.speech.v2.CustomClass].
     *
     * The async variant is {@see self::createCustomClassAsync()} .
     *
     * @param CreateCustomClassRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCustomClass(CreateCustomClassRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateCustomClass', $request, $callOptions)->wait();
    }

    /**
     * Creates a [PhraseSet][google.cloud.speech.v2.PhraseSet].
     *
     * The async variant is {@see self::createPhraseSetAsync()} .
     *
     * @param CreatePhraseSetRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createPhraseSet(CreatePhraseSetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreatePhraseSet', $request, $callOptions)->wait();
    }

    /**
     * Creates a [Recognizer][google.cloud.speech.v2.Recognizer].
     *
     * The async variant is {@see self::createRecognizerAsync()} .
     *
     * @param CreateRecognizerRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createRecognizer(CreateRecognizerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateRecognizer', $request, $callOptions)->wait();
    }

    /**
     * Deletes the [CustomClass][google.cloud.speech.v2.CustomClass].
     *
     * The async variant is {@see self::deleteCustomClassAsync()} .
     *
     * @param DeleteCustomClassRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteCustomClass(DeleteCustomClassRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteCustomClass', $request, $callOptions)->wait();
    }

    /**
     * Deletes the [PhraseSet][google.cloud.speech.v2.PhraseSet].
     *
     * The async variant is {@see self::deletePhraseSetAsync()} .
     *
     * @param DeletePhraseSetRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deletePhraseSet(DeletePhraseSetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeletePhraseSet', $request, $callOptions)->wait();
    }

    /**
     * Deletes the [Recognizer][google.cloud.speech.v2.Recognizer].
     *
     * The async variant is {@see self::deleteRecognizerAsync()} .
     *
     * @param DeleteRecognizerRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteRecognizer(DeleteRecognizerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteRecognizer', $request, $callOptions)->wait();
    }

    /**
     * Returns the requested [Config][google.cloud.speech.v2.Config].
     *
     * The async variant is {@see self::getConfigAsync()} .
     *
     * @param GetConfigRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Config
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getConfig(GetConfigRequest $request, array $callOptions = []): Config
    {
        return $this->startApiCall('GetConfig', $request, $callOptions)->wait();
    }

    /**
     * Returns the requested
     * [CustomClass][google.cloud.speech.v2.CustomClass].
     *
     * The async variant is {@see self::getCustomClassAsync()} .
     *
     * @param GetCustomClassRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomClass
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCustomClass(GetCustomClassRequest $request, array $callOptions = []): CustomClass
    {
        return $this->startApiCall('GetCustomClass', $request, $callOptions)->wait();
    }

    /**
     * Returns the requested
     * [PhraseSet][google.cloud.speech.v2.PhraseSet].
     *
     * The async variant is {@see self::getPhraseSetAsync()} .
     *
     * @param GetPhraseSetRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PhraseSet
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getPhraseSet(GetPhraseSetRequest $request, array $callOptions = []): PhraseSet
    {
        return $this->startApiCall('GetPhraseSet', $request, $callOptions)->wait();
    }

    /**
     * Returns the requested
     * [Recognizer][google.cloud.speech.v2.Recognizer]. Fails with
     * [NOT_FOUND][google.rpc.Code.NOT_FOUND] if the requested Recognizer doesn't
     * exist.
     *
     * The async variant is {@see self::getRecognizerAsync()} .
     *
     * @param GetRecognizerRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Recognizer
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRecognizer(GetRecognizerRequest $request, array $callOptions = []): Recognizer
    {
        return $this->startApiCall('GetRecognizer', $request, $callOptions)->wait();
    }

    /**
     * Lists CustomClasses.
     *
     * The async variant is {@see self::listCustomClassesAsync()} .
     *
     * @param ListCustomClassesRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCustomClasses(ListCustomClassesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCustomClasses', $request, $callOptions);
    }

    /**
     * Lists PhraseSets.
     *
     * The async variant is {@see self::listPhraseSetsAsync()} .
     *
     * @param ListPhraseSetsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPhraseSets(ListPhraseSetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPhraseSets', $request, $callOptions);
    }

    /**
     * Lists Recognizers.
     *
     * The async variant is {@see self::listRecognizersAsync()} .
     *
     * @param ListRecognizersRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRecognizers(ListRecognizersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRecognizers', $request, $callOptions);
    }

    /**
     * Performs synchronous Speech recognition: receive results after all audio
     * has been sent and processed.
     *
     * The async variant is {@see self::recognizeAsync()} .
     *
     * @param RecognizeRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RecognizeResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function recognize(RecognizeRequest $request, array $callOptions = []): RecognizeResponse
    {
        return $this->startApiCall('Recognize', $request, $callOptions)->wait();
    }

    /**
     * Performs bidirectional streaming speech recognition: receive results while
     * sending audio. This method is only available via the gRPC API (not REST).
     *
     * @param array $callOptions {
     *     Optional.
     *
     *     @type int $timeoutMillis
     *           Timeout to use for this call.
     * }
     *
     * @return BidiStream
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function streamingRecognize(array $callOptions = []): BidiStream
    {
        return $this->startApiCall('StreamingRecognize', null, $callOptions);
    }

    /**
     * Undeletes the [CustomClass][google.cloud.speech.v2.CustomClass].
     *
     * The async variant is {@see self::undeleteCustomClassAsync()} .
     *
     * @param UndeleteCustomClassRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function undeleteCustomClass(UndeleteCustomClassRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UndeleteCustomClass', $request, $callOptions)->wait();
    }

    /**
     * Undeletes the [PhraseSet][google.cloud.speech.v2.PhraseSet].
     *
     * The async variant is {@see self::undeletePhraseSetAsync()} .
     *
     * @param UndeletePhraseSetRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function undeletePhraseSet(UndeletePhraseSetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UndeletePhraseSet', $request, $callOptions)->wait();
    }

    /**
     * Undeletes the [Recognizer][google.cloud.speech.v2.Recognizer].
     *
     * The async variant is {@see self::undeleteRecognizerAsync()} .
     *
     * @param UndeleteRecognizerRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function undeleteRecognizer(UndeleteRecognizerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UndeleteRecognizer', $request, $callOptions)->wait();
    }

    /**
     * Updates the [Config][google.cloud.speech.v2.Config].
     *
     * The async variant is {@see self::updateConfigAsync()} .
     *
     * @param UpdateConfigRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Config
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateConfig(UpdateConfigRequest $request, array $callOptions = []): Config
    {
        return $this->startApiCall('UpdateConfig', $request, $callOptions)->wait();
    }

    /**
     * Updates the [CustomClass][google.cloud.speech.v2.CustomClass].
     *
     * The async variant is {@see self::updateCustomClassAsync()} .
     *
     * @param UpdateCustomClassRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCustomClass(UpdateCustomClassRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateCustomClass', $request, $callOptions)->wait();
    }

    /**
     * Updates the [PhraseSet][google.cloud.speech.v2.PhraseSet].
     *
     * The async variant is {@see self::updatePhraseSetAsync()} .
     *
     * @param UpdatePhraseSetRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updatePhraseSet(UpdatePhraseSetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdatePhraseSet', $request, $callOptions)->wait();
    }

    /**
     * Updates the [Recognizer][google.cloud.speech.v2.Recognizer].
     *
     * The async variant is {@see self::updateRecognizerAsync()} .
     *
     * @param UpdateRecognizerRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateRecognizer(UpdateRecognizerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateRecognizer', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see self::getLocationAsync()} .
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see self::listLocationsAsync()} .
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
