<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/osconfig/v1/osconfig_zonal_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\OsConfig\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\OsConfig\V1\CreateOSPolicyAssignmentRequest;
use Google\Cloud\OsConfig\V1\DeleteOSPolicyAssignmentRequest;
use Google\Cloud\OsConfig\V1\GetInventoryRequest;
use Google\Cloud\OsConfig\V1\GetOSPolicyAssignmentReportRequest;
use Google\Cloud\OsConfig\V1\GetOSPolicyAssignmentRequest;
use Google\Cloud\OsConfig\V1\GetVulnerabilityReportRequest;
use Google\Cloud\OsConfig\V1\Inventory;
use Google\Cloud\OsConfig\V1\ListInventoriesRequest;
use Google\Cloud\OsConfig\V1\ListInventoriesResponse;
use Google\Cloud\OsConfig\V1\ListOSPolicyAssignmentReportsRequest;
use Google\Cloud\OsConfig\V1\ListOSPolicyAssignmentReportsResponse;
use Google\Cloud\OsConfig\V1\ListOSPolicyAssignmentRevisionsRequest;
use Google\Cloud\OsConfig\V1\ListOSPolicyAssignmentRevisionsResponse;
use Google\Cloud\OsConfig\V1\ListOSPolicyAssignmentsRequest;
use Google\Cloud\OsConfig\V1\ListOSPolicyAssignmentsResponse;
use Google\Cloud\OsConfig\V1\ListVulnerabilityReportsRequest;
use Google\Cloud\OsConfig\V1\ListVulnerabilityReportsResponse;
use Google\Cloud\OsConfig\V1\OSPolicyAssignment;
use Google\Cloud\OsConfig\V1\OSPolicyAssignmentReport;
use Google\Cloud\OsConfig\V1\UpdateOSPolicyAssignmentRequest;
use Google\Cloud\OsConfig\V1\VulnerabilityReport;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: Zonal OS Config API
 *
 * The OS Config service is the server-side component that allows users to
 * manage package installations and patch jobs for Compute Engine VM instances.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $osConfigZonalServiceClient = new OsConfigZonalServiceClient();
 * try {
 *     $formattedParent = $osConfigZonalServiceClient->locationName('[PROJECT]', '[LOCATION]');
 *     $osPolicyAssignment = new OSPolicyAssignment();
 *     $osPolicyAssignmentId = 'os_policy_assignment_id';
 *     $operationResponse = $osConfigZonalServiceClient->createOSPolicyAssignment($formattedParent, $osPolicyAssignment, $osPolicyAssignmentId);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $osConfigZonalServiceClient->createOSPolicyAssignment($formattedParent, $osPolicyAssignment, $osPolicyAssignmentId);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $osConfigZonalServiceClient->resumeOperation($operationName, 'createOSPolicyAssignment');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $osConfigZonalServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Cloud\OsConfig\V1\Client\OsConfigZonalServiceClient} to use the new
 * surface.
 */
class OsConfigZonalServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.osconfig.v1.OsConfigZonalService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'osconfig.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $instanceNameTemplate;

    private static $instanceOSPolicyAssignmentNameTemplate;

    private static $inventoryNameTemplate;

    private static $locationNameTemplate;

    private static $oSPolicyAssignmentNameTemplate;

    private static $oSPolicyAssignmentReportNameTemplate;

    private static $projectLocationInstanceNameTemplate;

    private static $projectZoneInstanceNameTemplate;

    private static $vulnerabilityReportNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/os_config_zonal_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/os_config_zonal_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/os_config_zonal_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/os_config_zonal_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getInstanceNameTemplate()
    {
        if (self::$instanceNameTemplate == null) {
            self::$instanceNameTemplate = new PathTemplate('projects/{project}/zones/{zone}/instances/{instance}');
        }

        return self::$instanceNameTemplate;
    }

    private static function getInstanceOSPolicyAssignmentNameTemplate()
    {
        if (self::$instanceOSPolicyAssignmentNameTemplate == null) {
            self::$instanceOSPolicyAssignmentNameTemplate = new PathTemplate('projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}');
        }

        return self::$instanceOSPolicyAssignmentNameTemplate;
    }

    private static function getInventoryNameTemplate()
    {
        if (self::$inventoryNameTemplate == null) {
            self::$inventoryNameTemplate = new PathTemplate('projects/{project}/locations/{location}/instances/{instance}/inventory');
        }

        return self::$inventoryNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate('projects/{project}/locations/{location}');
        }

        return self::$locationNameTemplate;
    }

    private static function getOSPolicyAssignmentNameTemplate()
    {
        if (self::$oSPolicyAssignmentNameTemplate == null) {
            self::$oSPolicyAssignmentNameTemplate = new PathTemplate('projects/{project}/locations/{location}/osPolicyAssignments/{os_policy_assignment}');
        }

        return self::$oSPolicyAssignmentNameTemplate;
    }

    private static function getOSPolicyAssignmentReportNameTemplate()
    {
        if (self::$oSPolicyAssignmentReportNameTemplate == null) {
            self::$oSPolicyAssignmentReportNameTemplate = new PathTemplate('projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/report');
        }

        return self::$oSPolicyAssignmentReportNameTemplate;
    }

    private static function getProjectLocationInstanceNameTemplate()
    {
        if (self::$projectLocationInstanceNameTemplate == null) {
            self::$projectLocationInstanceNameTemplate = new PathTemplate('projects/{project}/locations/{location}/instances/{instance}');
        }

        return self::$projectLocationInstanceNameTemplate;
    }

    private static function getProjectZoneInstanceNameTemplate()
    {
        if (self::$projectZoneInstanceNameTemplate == null) {
            self::$projectZoneInstanceNameTemplate = new PathTemplate('projects/{project}/zones/{zone}/instances/{instance}');
        }

        return self::$projectZoneInstanceNameTemplate;
    }

    private static function getVulnerabilityReportNameTemplate()
    {
        if (self::$vulnerabilityReportNameTemplate == null) {
            self::$vulnerabilityReportNameTemplate = new PathTemplate('projects/{project}/locations/{location}/instances/{instance}/vulnerabilityReport');
        }

        return self::$vulnerabilityReportNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'instance' => self::getInstanceNameTemplate(),
                'instanceOSPolicyAssignment' => self::getInstanceOSPolicyAssignmentNameTemplate(),
                'inventory' => self::getInventoryNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'oSPolicyAssignment' => self::getOSPolicyAssignmentNameTemplate(),
                'oSPolicyAssignmentReport' => self::getOSPolicyAssignmentReportNameTemplate(),
                'projectLocationInstance' => self::getProjectLocationInstanceNameTemplate(),
                'projectZoneInstance' => self::getProjectZoneInstanceNameTemplate(),
                'vulnerabilityReport' => self::getVulnerabilityReportNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a instance
     * resource.
     *
     * @param string $project
     * @param string $zone
     * @param string $instance
     *
     * @return string The formatted instance resource.
     */
    public static function instanceName($project, $zone, $instance)
    {
        return self::getInstanceNameTemplate()->render([
            'project' => $project,
            'zone' => $zone,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * instance_os_policy_assignment resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     * @param string $assignment
     *
     * @return string The formatted instance_os_policy_assignment resource.
     */
    public static function instanceOSPolicyAssignmentName($project, $location, $instance, $assignment)
    {
        return self::getInstanceOSPolicyAssignmentNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
            'assignment' => $assignment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a inventory
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     *
     * @return string The formatted inventory resource.
     */
    public static function inventoryName($project, $location, $instance)
    {
        return self::getInventoryNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * os_policy_assignment resource.
     *
     * @param string $project
     * @param string $location
     * @param string $osPolicyAssignment
     *
     * @return string The formatted os_policy_assignment resource.
     */
    public static function oSPolicyAssignmentName($project, $location, $osPolicyAssignment)
    {
        return self::getOSPolicyAssignmentNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'os_policy_assignment' => $osPolicyAssignment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * os_policy_assignment_report resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     * @param string $assignment
     *
     * @return string The formatted os_policy_assignment_report resource.
     */
    public static function oSPolicyAssignmentReportName($project, $location, $instance, $assignment)
    {
        return self::getOSPolicyAssignmentReportNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
            'assignment' => $assignment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_instance resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     *
     * @return string The formatted project_location_instance resource.
     */
    public static function projectLocationInstanceName($project, $location, $instance)
    {
        return self::getProjectLocationInstanceNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_zone_instance resource.
     *
     * @param string $project
     * @param string $zone
     * @param string $instance
     *
     * @return string The formatted project_zone_instance resource.
     */
    public static function projectZoneInstanceName($project, $zone, $instance)
    {
        return self::getProjectZoneInstanceNameTemplate()->render([
            'project' => $project,
            'zone' => $zone,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * vulnerability_report resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     *
     * @return string The formatted vulnerability_report resource.
     */
    public static function vulnerabilityReportName($project, $location, $instance)
    {
        return self::getVulnerabilityReportNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - instance: projects/{project}/zones/{zone}/instances/{instance}
     * - instanceOSPolicyAssignment: projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}
     * - inventory: projects/{project}/locations/{location}/instances/{instance}/inventory
     * - location: projects/{project}/locations/{location}
     * - oSPolicyAssignment: projects/{project}/locations/{location}/osPolicyAssignments/{os_policy_assignment}
     * - oSPolicyAssignmentReport: projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/report
     * - projectLocationInstance: projects/{project}/locations/{location}/instances/{instance}
     * - projectZoneInstance: projects/{project}/zones/{zone}/instances/{instance}
     * - vulnerabilityReport: projects/{project}/locations/{location}/instances/{instance}/vulnerabilityReport
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'osconfig.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Create an OS policy assignment.
     *
     * This method also creates the first revision of the OS policy assignment.
     *
     * This method returns a long running operation (LRO) that contains the
     * rollout details. The rollout can be cancelled by cancelling the LRO.
     *
     * For more information, see [Method:
     * projects.locations.osPolicyAssignments.operations.cancel](https://cloud.google.com/compute/docs/osconfig/rest/v1/projects.locations.osPolicyAssignments.operations/cancel).
     *
     * Sample code:
     * ```
     * $osConfigZonalServiceClient = new OsConfigZonalServiceClient();
     * try {
     *     $formattedParent = $osConfigZonalServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $osPolicyAssignment = new OSPolicyAssignment();
     *     $osPolicyAssignmentId = 'os_policy_assignment_id';
     *     $operationResponse = $osConfigZonalServiceClient->createOSPolicyAssignment($formattedParent, $osPolicyAssignment, $osPolicyAssignmentId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $osConfigZonalServiceClient->createOSPolicyAssignment($formattedParent, $osPolicyAssignment, $osPolicyAssignmentId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $osConfigZonalServiceClient->resumeOperation($operationName, 'createOSPolicyAssignment');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $osConfigZonalServiceClient->close();
     * }
     * ```
     *
     * @param string             $parent               Required. The parent resource name in the form:
     *                                                 projects/{project}/locations/{location}
     * @param OSPolicyAssignment $osPolicyAssignment   Required. The OS policy assignment to be created.
     * @param string             $osPolicyAssignmentId Required. The logical name of the OS policy assignment in the project
     *                                                 with the following restrictions:
     *
     *                                                 * Must contain only lowercase letters, numbers, and hyphens.
     *                                                 * Must start with a letter.
     *                                                 * Must be between 1-63 characters.
     *                                                 * Must end with a number or a letter.
     *                                                 * Must be unique within the project.
     * @param array              $optionalArgs         {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createOSPolicyAssignment($parent, $osPolicyAssignment, $osPolicyAssignmentId, array $optionalArgs = [])
    {
        $request = new CreateOSPolicyAssignmentRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setOsPolicyAssignment($osPolicyAssignment);
        $request->setOsPolicyAssignmentId($osPolicyAssignmentId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateOSPolicyAssignment', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Delete the OS policy assignment.
     *
     * This method creates a new revision of the OS policy assignment.
     *
     * This method returns a long running operation (LRO) that contains the
     * rollout details. The rollout can be cancelled by cancelling the LRO.
     *
     * If the LRO completes and is not cancelled, all revisions associated with
     * the OS policy assignment are deleted.
     *
     * For more information, see [Method:
     * projects.locations.osPolicyAssignments.operations.cancel](https://cloud.google.com/compute/docs/osconfig/rest/v1/projects.locations.osPolicyAssignments.operations/cancel).
     *
     * Sample code:
     * ```
     * $osConfigZonalServiceClient = new OsConfigZonalServiceClient();
     * try {
     *     $formattedName = $osConfigZonalServiceClient->oSPolicyAssignmentName('[PROJECT]', '[LOCATION]', '[OS_POLICY_ASSIGNMENT]');
     *     $operationResponse = $osConfigZonalServiceClient->deleteOSPolicyAssignment($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $osConfigZonalServiceClient->deleteOSPolicyAssignment($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $osConfigZonalServiceClient->resumeOperation($operationName, 'deleteOSPolicyAssignment');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $osConfigZonalServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the OS policy assignment to be deleted
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteOSPolicyAssignment($name, array $optionalArgs = [])
    {
        $request = new DeleteOSPolicyAssignmentRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteOSPolicyAssignment', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Get inventory data for the specified VM instance. If the VM has no
     * associated inventory, the message `NOT_FOUND` is returned.
     *
     * Sample code:
     * ```
     * $osConfigZonalServiceClient = new OsConfigZonalServiceClient();
     * try {
     *     $formattedName = $osConfigZonalServiceClient->inventoryName('[PROJECT]', '[LOCATION]', '[INSTANCE]');
     *     $response = $osConfigZonalServiceClient->getInventory($formattedName);
     * } finally {
     *     $osConfigZonalServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. API resource name for inventory resource.
     *
     *                             Format:
     *                             `projects/{project}/locations/{location}/instances/{instance}/inventory`
     *
     *                             For `{project}`, either `project-number` or `project-id` can be provided.
     *                             For `{instance}`, either Compute Engine  `instance-id` or `instance-name`
     *                             can be provided.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $view
     *           Inventory view indicating what information should be included in the
     *           inventory resource. If unspecified, the default view is BASIC.
     *           For allowed values, use constants defined on {@see \Google\Cloud\OsConfig\V1\InventoryView}
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\OsConfig\V1\Inventory
     *
     * @throws ApiException if the remote call fails
     */
    public function getInventory($name, array $optionalArgs = [])
    {
        $request = new GetInventoryRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['view'])) {
            $request->setView($optionalArgs['view']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetInventory', Inventory::class, $optionalArgs, $request)->wait();
    }

    /**
     * Retrieve an existing OS policy assignment.
     *
     * This method always returns the latest revision. In order to retrieve a
     * previous revision of the assignment, also provide the revision ID in the
     * `name` parameter.
     *
     * Sample code:
     * ```
     * $osConfigZonalServiceClient = new OsConfigZonalServiceClient();
     * try {
     *     $formattedName = $osConfigZonalServiceClient->oSPolicyAssignmentName('[PROJECT]', '[LOCATION]', '[OS_POLICY_ASSIGNMENT]');
     *     $response = $osConfigZonalServiceClient->getOSPolicyAssignment($formattedName);
     * } finally {
     *     $osConfigZonalServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of OS policy assignment.
     *
     *                             Format:
     *                             `projects/{project}/locations/{location}/osPolicyAssignments/{os_policy_assignment}&#64;{revisionId}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\OsConfig\V1\OSPolicyAssignment
     *
     * @throws ApiException if the remote call fails
     */
    public function getOSPolicyAssignment($name, array $optionalArgs = [])
    {
        $request = new GetOSPolicyAssignmentRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetOSPolicyAssignment', OSPolicyAssignment::class, $optionalArgs, $request)->wait();
    }

    /**
     * Get the OS policy asssignment report for the specified Compute Engine VM
     * instance.
     *
     * Sample code:
     * ```
     * $osConfigZonalServiceClient = new OsConfigZonalServiceClient();
     * try {
     *     $formattedName = $osConfigZonalServiceClient->oSPolicyAssignmentReportName('[PROJECT]', '[LOCATION]', '[INSTANCE]', '[ASSIGNMENT]');
     *     $response = $osConfigZonalServiceClient->getOSPolicyAssignmentReport($formattedName);
     * } finally {
     *     $osConfigZonalServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. API resource name for OS policy assignment report.
     *
     *                             Format:
     *                             `/projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/report`
     *
     *                             For `{project}`, either `project-number` or `project-id` can be provided.
     *                             For `{instance_id}`, either Compute Engine `instance-id` or `instance-name`
     *                             can be provided.
     *                             For `{assignment_id}`, the OSPolicyAssignment id must be provided.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\OsConfig\V1\OSPolicyAssignmentReport
     *
     * @throws ApiException if the remote call fails
     */
    public function getOSPolicyAssignmentReport($name, array $optionalArgs = [])
    {
        $request = new GetOSPolicyAssignmentReportRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetOSPolicyAssignmentReport', OSPolicyAssignmentReport::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets the vulnerability report for the specified VM instance. Only VMs with
     * inventory data have vulnerability reports associated with them.
     *
     * Sample code:
     * ```
     * $osConfigZonalServiceClient = new OsConfigZonalServiceClient();
     * try {
     *     $formattedName = $osConfigZonalServiceClient->vulnerabilityReportName('[PROJECT]', '[LOCATION]', '[INSTANCE]');
     *     $response = $osConfigZonalServiceClient->getVulnerabilityReport($formattedName);
     * } finally {
     *     $osConfigZonalServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. API resource name for vulnerability resource.
     *
     *                             Format:
     *                             `projects/{project}/locations/{location}/instances/{instance}/vulnerabilityReport`
     *
     *                             For `{project}`, either `project-number` or `project-id` can be provided.
     *                             For `{instance}`, either Compute Engine `instance-id` or `instance-name`
     *                             can be provided.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\OsConfig\V1\VulnerabilityReport
     *
     * @throws ApiException if the remote call fails
     */
    public function getVulnerabilityReport($name, array $optionalArgs = [])
    {
        $request = new GetVulnerabilityReportRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetVulnerabilityReport', VulnerabilityReport::class, $optionalArgs, $request)->wait();
    }

    /**
     * List inventory data for all VM instances in the specified zone.
     *
     * Sample code:
     * ```
     * $osConfigZonalServiceClient = new OsConfigZonalServiceClient();
     * try {
     *     $formattedParent = $osConfigZonalServiceClient->instanceName('[PROJECT]', '[ZONE]', '[INSTANCE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $osConfigZonalServiceClient->listInventories($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $osConfigZonalServiceClient->listInventories($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $osConfigZonalServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource name.
     *
     *                             Format: `projects/{project}/locations/{location}/instances/-`
     *
     *                             For `{project}`, either `project-number` or `project-id` can be provided.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $view
     *           Inventory view indicating what information should be included in the
     *           inventory resource. If unspecified, the default view is BASIC.
     *           For allowed values, use constants defined on {@see \Google\Cloud\OsConfig\V1\InventoryView}
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           If provided, this field specifies the criteria that must be met by a
     *           `Inventory` API resource to be included in the response.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listInventories($parent, array $optionalArgs = [])
    {
        $request = new ListInventoriesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['view'])) {
            $request->setView($optionalArgs['view']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListInventories', $optionalArgs, ListInventoriesResponse::class, $request);
    }

    /**
     * List OS policy asssignment reports for all Compute Engine VM instances in
     * the specified zone.
     *
     * Sample code:
     * ```
     * $osConfigZonalServiceClient = new OsConfigZonalServiceClient();
     * try {
     *     $formattedParent = $osConfigZonalServiceClient->instanceOSPolicyAssignmentName('[PROJECT]', '[LOCATION]', '[INSTANCE]', '[ASSIGNMENT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $osConfigZonalServiceClient->listOSPolicyAssignmentReports($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $osConfigZonalServiceClient->listOSPolicyAssignmentReports($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $osConfigZonalServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource name.
     *
     *                             Format:
     *                             `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/reports`
     *
     *                             For `{project}`, either `project-number` or `project-id` can be provided.
     *                             For `{instance}`, either `instance-name`, `instance-id`, or `-` can be
     *                             provided. If '-' is provided, the response will include
     *                             OSPolicyAssignmentReports for all instances in the project/location.
     *                             For `{assignment}`, either `assignment-id` or `-` can be provided. If '-'
     *                             is provided, the response will include OSPolicyAssignmentReports for all
     *                             OSPolicyAssignments in the project/location.
     *                             Either {instance} or {assignment} must be `-`.
     *
     *                             For example:
     *                             `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/-/reports`
     *                             returns all reports for the instance
     *                             `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/{assignment-id}/reports`
     *                             returns all the reports for the given assignment across all instances.
     *                             `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/-/reports`
     *                             returns all the reports for all assignments across all instances.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $filter
     *           If provided, this field specifies the criteria that must be met by the
     *           `OSPolicyAssignmentReport` API resource that is included in the response.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listOSPolicyAssignmentReports($parent, array $optionalArgs = [])
    {
        $request = new ListOSPolicyAssignmentReportsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListOSPolicyAssignmentReports', $optionalArgs, ListOSPolicyAssignmentReportsResponse::class, $request);
    }

    /**
     * List the OS policy assignment revisions for a given OS policy assignment.
     *
     * Sample code:
     * ```
     * $osConfigZonalServiceClient = new OsConfigZonalServiceClient();
     * try {
     *     $formattedName = $osConfigZonalServiceClient->oSPolicyAssignmentName('[PROJECT]', '[LOCATION]', '[OS_POLICY_ASSIGNMENT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $osConfigZonalServiceClient->listOSPolicyAssignmentRevisions($formattedName);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $osConfigZonalServiceClient->listOSPolicyAssignmentRevisions($formattedName);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $osConfigZonalServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the OS policy assignment to list revisions for.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listOSPolicyAssignmentRevisions($name, array $optionalArgs = [])
    {
        $request = new ListOSPolicyAssignmentRevisionsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListOSPolicyAssignmentRevisions', $optionalArgs, ListOSPolicyAssignmentRevisionsResponse::class, $request);
    }

    /**
     * List the OS policy assignments under the parent resource.
     *
     * For each OS policy assignment, the latest revision is returned.
     *
     * Sample code:
     * ```
     * $osConfigZonalServiceClient = new OsConfigZonalServiceClient();
     * try {
     *     $formattedParent = $osConfigZonalServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $osConfigZonalServiceClient->listOSPolicyAssignments($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $osConfigZonalServiceClient->listOSPolicyAssignments($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $osConfigZonalServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listOSPolicyAssignments($parent, array $optionalArgs = [])
    {
        $request = new ListOSPolicyAssignmentsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListOSPolicyAssignments', $optionalArgs, ListOSPolicyAssignmentsResponse::class, $request);
    }

    /**
     * List vulnerability reports for all VM instances in the specified zone.
     *
     * Sample code:
     * ```
     * $osConfigZonalServiceClient = new OsConfigZonalServiceClient();
     * try {
     *     $formattedParent = $osConfigZonalServiceClient->instanceName('[PROJECT]', '[ZONE]', '[INSTANCE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $osConfigZonalServiceClient->listVulnerabilityReports($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $osConfigZonalServiceClient->listVulnerabilityReports($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $osConfigZonalServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource name.
     *
     *                             Format: `projects/{project}/locations/{location}/instances/-`
     *
     *                             For `{project}`, either `project-number` or `project-id` can be provided.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           If provided, this field specifies the criteria that must be met by a
     *           `vulnerabilityReport` API resource to be included in the response.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listVulnerabilityReports($parent, array $optionalArgs = [])
    {
        $request = new ListVulnerabilityReportsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListVulnerabilityReports', $optionalArgs, ListVulnerabilityReportsResponse::class, $request);
    }

    /**
     * Update an existing OS policy assignment.
     *
     * This method creates a new revision of the OS policy assignment.
     *
     * This method returns a long running operation (LRO) that contains the
     * rollout details. The rollout can be cancelled by cancelling the LRO.
     *
     * For more information, see [Method:
     * projects.locations.osPolicyAssignments.operations.cancel](https://cloud.google.com/compute/docs/osconfig/rest/v1/projects.locations.osPolicyAssignments.operations/cancel).
     *
     * Sample code:
     * ```
     * $osConfigZonalServiceClient = new OsConfigZonalServiceClient();
     * try {
     *     $osPolicyAssignment = new OSPolicyAssignment();
     *     $operationResponse = $osConfigZonalServiceClient->updateOSPolicyAssignment($osPolicyAssignment);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $osConfigZonalServiceClient->updateOSPolicyAssignment($osPolicyAssignment);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $osConfigZonalServiceClient->resumeOperation($operationName, 'updateOSPolicyAssignment');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $osConfigZonalServiceClient->close();
     * }
     * ```
     *
     * @param OSPolicyAssignment $osPolicyAssignment Required. The updated OS policy assignment.
     * @param array              $optionalArgs       {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Field mask that controls which fields of the assignment should be
     *           updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateOSPolicyAssignment($osPolicyAssignment, array $optionalArgs = [])
    {
        $request = new UpdateOSPolicyAssignmentRequest();
        $requestParamHeaders = [];
        $request->setOsPolicyAssignment($osPolicyAssignment);
        $requestParamHeaders['os_policy_assignment.name'] = $osPolicyAssignment->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateOSPolicyAssignment', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }
}
