<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dataproc/v1/node_groups.proto

namespace Google\Cloud\Dataproc\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A request to resize a node group.
 *
 * Generated from protobuf message <code>google.cloud.dataproc.v1.ResizeNodeGroupRequest</code>
 */
class ResizeNodeGroupRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The name of the node group to resize.
     * Format:
     * `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{nodeGroup}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $name = '';
    /**
     * Required. The number of running instances for the node group to maintain.
     * The group adds or removes instances to maintain the number of instances
     * specified by this parameter.
     *
     * Generated from protobuf field <code>int32 size = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $size = 0;
    /**
     * Optional. A unique ID used to identify the request. If the server receives
     * two
     * [ResizeNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.ResizeNodeGroupRequests)
     * with the same ID, the second request is ignored and the
     * first [google.longrunning.Operation][google.longrunning.Operation] created
     * and stored in the backend is returned.
     * Recommendation: Set this value to a
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     * The ID must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). The maximum length is 40 characters.
     *
     * Generated from protobuf field <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $request_id = '';
    /**
     * Optional. Timeout for graceful YARN decommissioning. [Graceful
     * decommissioning]
     * (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
     * allows the removal of nodes from the Compute Engine node group
     * without interrupting jobs in progress. This timeout specifies how long to
     * wait for jobs in progress to finish before forcefully removing nodes (and
     * potentially interrupting jobs). Default timeout is 0 (for forceful
     * decommission), and the maximum allowed timeout is 1 day. (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * Only supported on Dataproc image versions 1.2 and higher.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration graceful_decommission_timeout = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $graceful_decommission_timeout = null;

    /**
     * @param string $name Required. The name of the node group to resize.
     *                     Format:
     *                     `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{nodeGroup}`
     * @param int    $size Required. The number of running instances for the node group to maintain.
     *                     The group adds or removes instances to maintain the number of instances
     *                     specified by this parameter.
     *
     * @return \Google\Cloud\Dataproc\V1\ResizeNodeGroupRequest
     *
     * @experimental
     */
    public static function build(string $name, int $size): self
    {
        return (new self())
            ->setName($name)
            ->setSize($size);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. The name of the node group to resize.
     *           Format:
     *           `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{nodeGroup}`
     *     @type int $size
     *           Required. The number of running instances for the node group to maintain.
     *           The group adds or removes instances to maintain the number of instances
     *           specified by this parameter.
     *     @type string $request_id
     *           Optional. A unique ID used to identify the request. If the server receives
     *           two
     *           [ResizeNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.ResizeNodeGroupRequests)
     *           with the same ID, the second request is ignored and the
     *           first [google.longrunning.Operation][google.longrunning.Operation] created
     *           and stored in the backend is returned.
     *           Recommendation: Set this value to a
     *           [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     *           The ID must contain only letters (a-z, A-Z), numbers (0-9),
     *           underscores (_), and hyphens (-). The maximum length is 40 characters.
     *     @type \Google\Protobuf\Duration $graceful_decommission_timeout
     *           Optional. Timeout for graceful YARN decommissioning. [Graceful
     *           decommissioning]
     *           (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
     *           allows the removal of nodes from the Compute Engine node group
     *           without interrupting jobs in progress. This timeout specifies how long to
     *           wait for jobs in progress to finish before forcefully removing nodes (and
     *           potentially interrupting jobs). Default timeout is 0 (for forceful
     *           decommission), and the maximum allowed timeout is 1 day. (see JSON
     *           representation of
     *           [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *           Only supported on Dataproc image versions 1.2 and higher.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dataproc\V1\NodeGroups::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The name of the node group to resize.
     * Format:
     * `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{nodeGroup}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. The name of the node group to resize.
     * Format:
     * `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{nodeGroup}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The number of running instances for the node group to maintain.
     * The group adds or removes instances to maintain the number of instances
     * specified by this parameter.
     *
     * Generated from protobuf field <code>int32 size = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getSize()
    {
        return $this->size;
    }

    /**
     * Required. The number of running instances for the node group to maintain.
     * The group adds or removes instances to maintain the number of instances
     * specified by this parameter.
     *
     * Generated from protobuf field <code>int32 size = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->size = $var;

        return $this;
    }

    /**
     * Optional. A unique ID used to identify the request. If the server receives
     * two
     * [ResizeNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.ResizeNodeGroupRequests)
     * with the same ID, the second request is ignored and the
     * first [google.longrunning.Operation][google.longrunning.Operation] created
     * and stored in the backend is returned.
     * Recommendation: Set this value to a
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     * The ID must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). The maximum length is 40 characters.
     *
     * Generated from protobuf field <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getRequestId()
    {
        return $this->request_id;
    }

    /**
     * Optional. A unique ID used to identify the request. If the server receives
     * two
     * [ResizeNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.ResizeNodeGroupRequests)
     * with the same ID, the second request is ignored and the
     * first [google.longrunning.Operation][google.longrunning.Operation] created
     * and stored in the backend is returned.
     * Recommendation: Set this value to a
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     * The ID must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). The maximum length is 40 characters.
     *
     * Generated from protobuf field <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setRequestId($var)
    {
        GPBUtil::checkString($var, True);
        $this->request_id = $var;

        return $this;
    }

    /**
     * Optional. Timeout for graceful YARN decommissioning. [Graceful
     * decommissioning]
     * (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
     * allows the removal of nodes from the Compute Engine node group
     * without interrupting jobs in progress. This timeout specifies how long to
     * wait for jobs in progress to finish before forcefully removing nodes (and
     * potentially interrupting jobs). Default timeout is 0 (for forceful
     * decommission), and the maximum allowed timeout is 1 day. (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * Only supported on Dataproc image versions 1.2 and higher.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration graceful_decommission_timeout = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getGracefulDecommissionTimeout()
    {
        return $this->graceful_decommission_timeout;
    }

    public function hasGracefulDecommissionTimeout()
    {
        return isset($this->graceful_decommission_timeout);
    }

    public function clearGracefulDecommissionTimeout()
    {
        unset($this->graceful_decommission_timeout);
    }

    /**
     * Optional. Timeout for graceful YARN decommissioning. [Graceful
     * decommissioning]
     * (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
     * allows the removal of nodes from the Compute Engine node group
     * without interrupting jobs in progress. This timeout specifies how long to
     * wait for jobs in progress to finish before forcefully removing nodes (and
     * potentially interrupting jobs). Default timeout is 0 (for forceful
     * decommission), and the maximum allowed timeout is 1 day. (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * Only supported on Dataproc image versions 1.2 and higher.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration graceful_decommission_timeout = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setGracefulDecommissionTimeout($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->graceful_decommission_timeout = $var;

        return $this;
    }

}

