<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/aiplatform/v1/tensorboard_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AIPlatform\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AIPlatform\V1\BatchCreateTensorboardRunsRequest;
use Google\Cloud\AIPlatform\V1\BatchCreateTensorboardRunsResponse;
use Google\Cloud\AIPlatform\V1\BatchCreateTensorboardTimeSeriesRequest;
use Google\Cloud\AIPlatform\V1\BatchCreateTensorboardTimeSeriesResponse;
use Google\Cloud\AIPlatform\V1\BatchReadTensorboardTimeSeriesDataRequest;
use Google\Cloud\AIPlatform\V1\BatchReadTensorboardTimeSeriesDataResponse;
use Google\Cloud\AIPlatform\V1\CreateTensorboardExperimentRequest;
use Google\Cloud\AIPlatform\V1\CreateTensorboardRequest;
use Google\Cloud\AIPlatform\V1\CreateTensorboardRunRequest;
use Google\Cloud\AIPlatform\V1\CreateTensorboardTimeSeriesRequest;
use Google\Cloud\AIPlatform\V1\DeleteTensorboardExperimentRequest;
use Google\Cloud\AIPlatform\V1\DeleteTensorboardRequest;
use Google\Cloud\AIPlatform\V1\DeleteTensorboardRunRequest;
use Google\Cloud\AIPlatform\V1\DeleteTensorboardTimeSeriesRequest;
use Google\Cloud\AIPlatform\V1\ExportTensorboardTimeSeriesDataRequest;
use Google\Cloud\AIPlatform\V1\ExportTensorboardTimeSeriesDataResponse;
use Google\Cloud\AIPlatform\V1\GetTensorboardExperimentRequest;
use Google\Cloud\AIPlatform\V1\GetTensorboardRequest;
use Google\Cloud\AIPlatform\V1\GetTensorboardRunRequest;
use Google\Cloud\AIPlatform\V1\GetTensorboardTimeSeriesRequest;
use Google\Cloud\AIPlatform\V1\ListTensorboardExperimentsRequest;
use Google\Cloud\AIPlatform\V1\ListTensorboardExperimentsResponse;
use Google\Cloud\AIPlatform\V1\ListTensorboardRunsRequest;
use Google\Cloud\AIPlatform\V1\ListTensorboardRunsResponse;
use Google\Cloud\AIPlatform\V1\ListTensorboardTimeSeriesRequest;
use Google\Cloud\AIPlatform\V1\ListTensorboardTimeSeriesResponse;
use Google\Cloud\AIPlatform\V1\ListTensorboardsRequest;
use Google\Cloud\AIPlatform\V1\ListTensorboardsResponse;
use Google\Cloud\AIPlatform\V1\ReadTensorboardBlobDataRequest;
use Google\Cloud\AIPlatform\V1\ReadTensorboardBlobDataResponse;
use Google\Cloud\AIPlatform\V1\ReadTensorboardSizeRequest;
use Google\Cloud\AIPlatform\V1\ReadTensorboardSizeResponse;
use Google\Cloud\AIPlatform\V1\ReadTensorboardTimeSeriesDataRequest;
use Google\Cloud\AIPlatform\V1\ReadTensorboardTimeSeriesDataResponse;
use Google\Cloud\AIPlatform\V1\ReadTensorboardUsageRequest;
use Google\Cloud\AIPlatform\V1\ReadTensorboardUsageResponse;
use Google\Cloud\AIPlatform\V1\Tensorboard;
use Google\Cloud\AIPlatform\V1\TensorboardExperiment;
use Google\Cloud\AIPlatform\V1\TensorboardRun;
use Google\Cloud\AIPlatform\V1\TensorboardTimeSeries;
use Google\Cloud\AIPlatform\V1\TimeSeriesData;
use Google\Cloud\AIPlatform\V1\UpdateTensorboardExperimentRequest;
use Google\Cloud\AIPlatform\V1\UpdateTensorboardRequest;
use Google\Cloud\AIPlatform\V1\UpdateTensorboardRunRequest;
use Google\Cloud\AIPlatform\V1\UpdateTensorboardTimeSeriesRequest;
use Google\Cloud\AIPlatform\V1\WriteTensorboardExperimentDataRequest;
use Google\Cloud\AIPlatform\V1\WriteTensorboardExperimentDataResponse;
use Google\Cloud\AIPlatform\V1\WriteTensorboardRunDataRequest;
use Google\Cloud\AIPlatform\V1\WriteTensorboardRunDataResponse;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: TensorboardService
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $tensorboardServiceClient = new TensorboardServiceClient();
 * try {
 *     $formattedParent = $tensorboardServiceClient->tensorboardExperimentName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]', '[EXPERIMENT]');
 *     $requests = [];
 *     $response = $tensorboardServiceClient->batchCreateTensorboardRuns($formattedParent, $requests);
 * } finally {
 *     $tensorboardServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Cloud\AIPlatform\V1\Client\TensorboardServiceClient} to use the new
 * surface.
 */
class TensorboardServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.aiplatform.v1.TensorboardService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'aiplatform.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/cloud-platform.read-only',
    ];

    private static $locationNameTemplate;

    private static $tensorboardNameTemplate;

    private static $tensorboardExperimentNameTemplate;

    private static $tensorboardRunNameTemplate;

    private static $tensorboardTimeSeriesNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ .
                '/../resources/tensorboard_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/tensorboard_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/tensorboard_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/tensorboard_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getTensorboardNameTemplate()
    {
        if (self::$tensorboardNameTemplate == null) {
            self::$tensorboardNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/tensorboards/{tensorboard}'
            );
        }

        return self::$tensorboardNameTemplate;
    }

    private static function getTensorboardExperimentNameTemplate()
    {
        if (self::$tensorboardExperimentNameTemplate == null) {
            self::$tensorboardExperimentNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}'
            );
        }

        return self::$tensorboardExperimentNameTemplate;
    }

    private static function getTensorboardRunNameTemplate()
    {
        if (self::$tensorboardRunNameTemplate == null) {
            self::$tensorboardRunNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}'
            );
        }

        return self::$tensorboardRunNameTemplate;
    }

    private static function getTensorboardTimeSeriesNameTemplate()
    {
        if (self::$tensorboardTimeSeriesNameTemplate == null) {
            self::$tensorboardTimeSeriesNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}'
            );
        }

        return self::$tensorboardTimeSeriesNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'location' => self::getLocationNameTemplate(),
                'tensorboard' => self::getTensorboardNameTemplate(),
                'tensorboardExperiment' => self::getTensorboardExperimentNameTemplate(),
                'tensorboardRun' => self::getTensorboardRunNameTemplate(),
                'tensorboardTimeSeries' => self::getTensorboardTimeSeriesNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a tensorboard
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tensorboard
     *
     * @return string The formatted tensorboard resource.
     */
    public static function tensorboardName($project, $location, $tensorboard)
    {
        return self::getTensorboardNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'tensorboard' => $tensorboard,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * tensorboard_experiment resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tensorboard
     * @param string $experiment
     *
     * @return string The formatted tensorboard_experiment resource.
     */
    public static function tensorboardExperimentName(
        $project,
        $location,
        $tensorboard,
        $experiment
    ) {
        return self::getTensorboardExperimentNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'tensorboard' => $tensorboard,
            'experiment' => $experiment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * tensorboard_run resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tensorboard
     * @param string $experiment
     * @param string $run
     *
     * @return string The formatted tensorboard_run resource.
     */
    public static function tensorboardRunName(
        $project,
        $location,
        $tensorboard,
        $experiment,
        $run
    ) {
        return self::getTensorboardRunNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'tensorboard' => $tensorboard,
            'experiment' => $experiment,
            'run' => $run,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * tensorboard_time_series resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tensorboard
     * @param string $experiment
     * @param string $run
     * @param string $timeSeries
     *
     * @return string The formatted tensorboard_time_series resource.
     */
    public static function tensorboardTimeSeriesName(
        $project,
        $location,
        $tensorboard,
        $experiment,
        $run,
        $timeSeries
    ) {
        return self::getTensorboardTimeSeriesNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'tensorboard' => $tensorboard,
            'experiment' => $experiment,
            'run' => $run,
            'time_series' => $timeSeries,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - location: projects/{project}/locations/{location}
     * - tensorboard: projects/{project}/locations/{location}/tensorboards/{tensorboard}
     * - tensorboardExperiment: projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}
     * - tensorboardRun: projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}
     * - tensorboardTimeSeries: projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'aiplatform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Batch create TensorboardRuns.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedParent = $tensorboardServiceClient->tensorboardExperimentName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]', '[EXPERIMENT]');
     *     $requests = [];
     *     $response = $tensorboardServiceClient->batchCreateTensorboardRuns($formattedParent, $requests);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string                        $parent       Required. The resource name of the TensorboardExperiment to create the
     *                                                    TensorboardRuns in. Format:
     *                                                    `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
     *                                                    The parent field in the CreateTensorboardRunRequest messages must match
     *                                                    this field.
     * @param CreateTensorboardRunRequest[] $requests     Required. The request message specifying the TensorboardRuns to create.
     *                                                    A maximum of 1000 TensorboardRuns can be created in a batch.
     * @param array                         $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\BatchCreateTensorboardRunsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function batchCreateTensorboardRuns(
        $parent,
        $requests,
        array $optionalArgs = []
    ) {
        $request = new BatchCreateTensorboardRunsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setRequests($requests);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'BatchCreateTensorboardRuns',
            BatchCreateTensorboardRunsResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Batch create TensorboardTimeSeries that belong to a TensorboardExperiment.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedParent = $tensorboardServiceClient->tensorboardExperimentName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]', '[EXPERIMENT]');
     *     $requests = [];
     *     $response = $tensorboardServiceClient->batchCreateTensorboardTimeSeries($formattedParent, $requests);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string                               $parent       Required. The resource name of the TensorboardExperiment to create the
     *                                                           TensorboardTimeSeries in.
     *                                                           Format:
     *                                                           `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
     *                                                           The TensorboardRuns referenced by the parent fields in the
     *                                                           CreateTensorboardTimeSeriesRequest messages must be sub resources of this
     *                                                           TensorboardExperiment.
     * @param CreateTensorboardTimeSeriesRequest[] $requests     Required. The request message specifying the TensorboardTimeSeries to
     *                                                           create. A maximum of 1000 TensorboardTimeSeries can be created in a batch.
     * @param array                                $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\BatchCreateTensorboardTimeSeriesResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function batchCreateTensorboardTimeSeries(
        $parent,
        $requests,
        array $optionalArgs = []
    ) {
        $request = new BatchCreateTensorboardTimeSeriesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setRequests($requests);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'BatchCreateTensorboardTimeSeries',
            BatchCreateTensorboardTimeSeriesResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Reads multiple TensorboardTimeSeries' data. The data point number limit is
     * 1000 for scalars, 100 for tensors and blob references. If the number of
     * data points stored is less than the limit, all data is returned.
     * Otherwise, the number limit of data points is randomly selected from
     * this time series and returned.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedTensorboard = $tensorboardServiceClient->tensorboardName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]');
     *     $formattedTimeSeries = [
     *         $tensorboardServiceClient->tensorboardTimeSeriesName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]', '[EXPERIMENT]', '[RUN]', '[TIME_SERIES]'),
     *     ];
     *     $response = $tensorboardServiceClient->batchReadTensorboardTimeSeriesData($formattedTensorboard, $formattedTimeSeries);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string   $tensorboard  Required. The resource name of the Tensorboard containing
     *                               TensorboardTimeSeries to read data from. Format:
     *                               `projects/{project}/locations/{location}/tensorboards/{tensorboard}`.
     *                               The TensorboardTimeSeries referenced by
     *                               [time_series][google.cloud.aiplatform.v1.BatchReadTensorboardTimeSeriesDataRequest.time_series]
     *                               must be sub resources of this Tensorboard.
     * @param string[] $timeSeries   Required. The resource names of the TensorboardTimeSeries to read data
     *                               from. Format:
     *                               `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\BatchReadTensorboardTimeSeriesDataResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function batchReadTensorboardTimeSeriesData(
        $tensorboard,
        $timeSeries,
        array $optionalArgs = []
    ) {
        $request = new BatchReadTensorboardTimeSeriesDataRequest();
        $requestParamHeaders = [];
        $request->setTensorboard($tensorboard);
        $request->setTimeSeries($timeSeries);
        $requestParamHeaders['tensorboard'] = $tensorboard;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'BatchReadTensorboardTimeSeriesData',
            BatchReadTensorboardTimeSeriesDataResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a Tensorboard.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedParent = $tensorboardServiceClient->tensorboardName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]');
     *     $tensorboard = new Tensorboard();
     *     $operationResponse = $tensorboardServiceClient->createTensorboard($formattedParent, $tensorboard);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $tensorboardServiceClient->createTensorboard($formattedParent, $tensorboard);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $tensorboardServiceClient->resumeOperation($operationName, 'createTensorboard');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string      $parent       Required. The resource name of the Location to create the Tensorboard in.
     *                                  Format: `projects/{project}/locations/{location}`
     * @param Tensorboard $tensorboard  Required. The Tensorboard to create.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createTensorboard(
        $parent,
        $tensorboard,
        array $optionalArgs = []
    ) {
        $request = new CreateTensorboardRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setTensorboard($tensorboard);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateTensorboard',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a TensorboardExperiment.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedParent = $tensorboardServiceClient->tensorboardExperimentName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]', '[EXPERIMENT]');
     *     $tensorboardExperimentId = 'tensorboard_experiment_id';
     *     $response = $tensorboardServiceClient->createTensorboardExperiment($formattedParent, $tensorboardExperimentId);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string $parent                  Required. The resource name of the Tensorboard to create the
     *                                        TensorboardExperiment in. Format:
     *                                        `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
     * @param string $tensorboardExperimentId Required. The ID to use for the Tensorboard experiment, which becomes the
     *                                        final component of the Tensorboard experiment's resource name.
     *
     *                                        This value should be 1-128 characters, and valid characters
     *                                        are /[a-z][0-9]-/.
     * @param array  $optionalArgs            {
     *     Optional.
     *
     *     @type TensorboardExperiment $tensorboardExperiment
     *           The TensorboardExperiment to create.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\TensorboardExperiment
     *
     * @throws ApiException if the remote call fails
     */
    public function createTensorboardExperiment(
        $parent,
        $tensorboardExperimentId,
        array $optionalArgs = []
    ) {
        $request = new CreateTensorboardExperimentRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setTensorboardExperimentId($tensorboardExperimentId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['tensorboardExperiment'])) {
            $request->setTensorboardExperiment(
                $optionalArgs['tensorboardExperiment']
            );
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateTensorboardExperiment',
            TensorboardExperiment::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a TensorboardRun.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedParent = $tensorboardServiceClient->tensorboardRunName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]', '[EXPERIMENT]', '[RUN]');
     *     $tensorboardRun = new TensorboardRun();
     *     $tensorboardRunId = 'tensorboard_run_id';
     *     $response = $tensorboardServiceClient->createTensorboardRun($formattedParent, $tensorboardRun, $tensorboardRunId);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string         $parent           Required. The resource name of the TensorboardExperiment to create the
     *                                         TensorboardRun in. Format:
     *                                         `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
     * @param TensorboardRun $tensorboardRun   Required. The TensorboardRun to create.
     * @param string         $tensorboardRunId Required. The ID to use for the Tensorboard run, which becomes the final
     *                                         component of the Tensorboard run's resource name.
     *
     *                                         This value should be 1-128 characters, and valid characters
     *                                         are /[a-z][0-9]-/.
     * @param array          $optionalArgs     {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\TensorboardRun
     *
     * @throws ApiException if the remote call fails
     */
    public function createTensorboardRun(
        $parent,
        $tensorboardRun,
        $tensorboardRunId,
        array $optionalArgs = []
    ) {
        $request = new CreateTensorboardRunRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setTensorboardRun($tensorboardRun);
        $request->setTensorboardRunId($tensorboardRunId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateTensorboardRun',
            TensorboardRun::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a TensorboardTimeSeries.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedParent = $tensorboardServiceClient->tensorboardTimeSeriesName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]', '[EXPERIMENT]', '[RUN]', '[TIME_SERIES]');
     *     $tensorboardTimeSeries = new TensorboardTimeSeries();
     *     $response = $tensorboardServiceClient->createTensorboardTimeSeries($formattedParent, $tensorboardTimeSeries);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string                $parent                Required. The resource name of the TensorboardRun to create the
     *                                                     TensorboardTimeSeries in.
     *                                                     Format:
     *                                                     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
     * @param TensorboardTimeSeries $tensorboardTimeSeries Required. The TensorboardTimeSeries to create.
     * @param array                 $optionalArgs          {
     *     Optional.
     *
     *     @type string $tensorboardTimeSeriesId
     *           Optional. The user specified unique ID to use for the
     *           TensorboardTimeSeries, which becomes the final component of the
     *           TensorboardTimeSeries's resource name. This value should match
     *           "[a-z0-9][a-z0-9-]{0, 127}"
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\TensorboardTimeSeries
     *
     * @throws ApiException if the remote call fails
     */
    public function createTensorboardTimeSeries(
        $parent,
        $tensorboardTimeSeries,
        array $optionalArgs = []
    ) {
        $request = new CreateTensorboardTimeSeriesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setTensorboardTimeSeries($tensorboardTimeSeries);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['tensorboardTimeSeriesId'])) {
            $request->setTensorboardTimeSeriesId(
                $optionalArgs['tensorboardTimeSeriesId']
            );
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateTensorboardTimeSeries',
            TensorboardTimeSeries::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a Tensorboard.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedName = $tensorboardServiceClient->tensorboardName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]');
     *     $operationResponse = $tensorboardServiceClient->deleteTensorboard($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $tensorboardServiceClient->deleteTensorboard($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $tensorboardServiceClient->resumeOperation($operationName, 'deleteTensorboard');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Tensorboard to be deleted.
     *                             Format:
     *                             `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteTensorboard($name, array $optionalArgs = [])
    {
        $request = new DeleteTensorboardRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteTensorboard',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a TensorboardExperiment.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedName = $tensorboardServiceClient->tensorboardExperimentName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]', '[EXPERIMENT]');
     *     $operationResponse = $tensorboardServiceClient->deleteTensorboardExperiment($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $tensorboardServiceClient->deleteTensorboardExperiment($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $tensorboardServiceClient->resumeOperation($operationName, 'deleteTensorboardExperiment');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the TensorboardExperiment to be deleted.
     *                             Format:
     *                             `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteTensorboardExperiment($name, array $optionalArgs = [])
    {
        $request = new DeleteTensorboardExperimentRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteTensorboardExperiment',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a TensorboardRun.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedName = $tensorboardServiceClient->tensorboardRunName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]', '[EXPERIMENT]', '[RUN]');
     *     $operationResponse = $tensorboardServiceClient->deleteTensorboardRun($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $tensorboardServiceClient->deleteTensorboardRun($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $tensorboardServiceClient->resumeOperation($operationName, 'deleteTensorboardRun');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the TensorboardRun to be deleted.
     *                             Format:
     *                             `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteTensorboardRun($name, array $optionalArgs = [])
    {
        $request = new DeleteTensorboardRunRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteTensorboardRun',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a TensorboardTimeSeries.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedName = $tensorboardServiceClient->tensorboardTimeSeriesName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]', '[EXPERIMENT]', '[RUN]', '[TIME_SERIES]');
     *     $operationResponse = $tensorboardServiceClient->deleteTensorboardTimeSeries($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $tensorboardServiceClient->deleteTensorboardTimeSeries($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $tensorboardServiceClient->resumeOperation($operationName, 'deleteTensorboardTimeSeries');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the TensorboardTimeSeries to be deleted.
     *                             Format:
     *                             `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteTensorboardTimeSeries($name, array $optionalArgs = [])
    {
        $request = new DeleteTensorboardTimeSeriesRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteTensorboardTimeSeries',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Exports a TensorboardTimeSeries' data. Data is returned in paginated
     * responses.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedTensorboardTimeSeries = $tensorboardServiceClient->tensorboardTimeSeriesName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]', '[EXPERIMENT]', '[RUN]', '[TIME_SERIES]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $tensorboardServiceClient->exportTensorboardTimeSeriesData($formattedTensorboardTimeSeries);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $tensorboardServiceClient->exportTensorboardTimeSeriesData($formattedTensorboardTimeSeries);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string $tensorboardTimeSeries Required. The resource name of the TensorboardTimeSeries to export data
     *                                      from. Format:
     *                                      `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
     * @param array  $optionalArgs          {
     *     Optional.
     *
     *     @type string $filter
     *           Exports the TensorboardTimeSeries' data that match the filter expression.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           Field to use to sort the TensorboardTimeSeries' data.
     *           By default, TensorboardTimeSeries' data is returned in a pseudo random
     *           order.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function exportTensorboardTimeSeriesData(
        $tensorboardTimeSeries,
        array $optionalArgs = []
    ) {
        $request = new ExportTensorboardTimeSeriesDataRequest();
        $requestParamHeaders = [];
        $request->setTensorboardTimeSeries($tensorboardTimeSeries);
        $requestParamHeaders[
            'tensorboard_time_series'
        ] = $tensorboardTimeSeries;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ExportTensorboardTimeSeriesData',
            $optionalArgs,
            ExportTensorboardTimeSeriesDataResponse::class,
            $request
        );
    }

    /**
     * Gets a Tensorboard.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedName = $tensorboardServiceClient->tensorboardName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]');
     *     $response = $tensorboardServiceClient->getTensorboard($formattedName);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Tensorboard resource.
     *                             Format:
     *                             `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Tensorboard
     *
     * @throws ApiException if the remote call fails
     */
    public function getTensorboard($name, array $optionalArgs = [])
    {
        $request = new GetTensorboardRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetTensorboard',
            Tensorboard::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a TensorboardExperiment.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedName = $tensorboardServiceClient->tensorboardExperimentName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]', '[EXPERIMENT]');
     *     $response = $tensorboardServiceClient->getTensorboardExperiment($formattedName);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the TensorboardExperiment resource.
     *                             Format:
     *                             `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\TensorboardExperiment
     *
     * @throws ApiException if the remote call fails
     */
    public function getTensorboardExperiment($name, array $optionalArgs = [])
    {
        $request = new GetTensorboardExperimentRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetTensorboardExperiment',
            TensorboardExperiment::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a TensorboardRun.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedName = $tensorboardServiceClient->tensorboardRunName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]', '[EXPERIMENT]', '[RUN]');
     *     $response = $tensorboardServiceClient->getTensorboardRun($formattedName);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the TensorboardRun resource.
     *                             Format:
     *                             `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\TensorboardRun
     *
     * @throws ApiException if the remote call fails
     */
    public function getTensorboardRun($name, array $optionalArgs = [])
    {
        $request = new GetTensorboardRunRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetTensorboardRun',
            TensorboardRun::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a TensorboardTimeSeries.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedName = $tensorboardServiceClient->tensorboardTimeSeriesName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]', '[EXPERIMENT]', '[RUN]', '[TIME_SERIES]');
     *     $response = $tensorboardServiceClient->getTensorboardTimeSeries($formattedName);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the TensorboardTimeSeries resource.
     *                             Format:
     *                             `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\TensorboardTimeSeries
     *
     * @throws ApiException if the remote call fails
     */
    public function getTensorboardTimeSeries($name, array $optionalArgs = [])
    {
        $request = new GetTensorboardTimeSeriesRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetTensorboardTimeSeries',
            TensorboardTimeSeries::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists TensorboardExperiments in a Location.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedParent = $tensorboardServiceClient->tensorboardName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $tensorboardServiceClient->listTensorboardExperiments($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $tensorboardServiceClient->listTensorboardExperiments($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Tensorboard to list
     *                             TensorboardExperiments. Format:
     *                             `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Lists the TensorboardExperiments that match the filter expression.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           Field to use to sort the list.
     *     @type FieldMask $readMask
     *           Mask specifying which fields to read.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTensorboardExperiments(
        $parent,
        array $optionalArgs = []
    ) {
        $request = new ListTensorboardExperimentsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['readMask'])) {
            $request->setReadMask($optionalArgs['readMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListTensorboardExperiments',
            $optionalArgs,
            ListTensorboardExperimentsResponse::class,
            $request
        );
    }

    /**
     * Lists TensorboardRuns in a Location.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedParent = $tensorboardServiceClient->tensorboardExperimentName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]', '[EXPERIMENT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $tensorboardServiceClient->listTensorboardRuns($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $tensorboardServiceClient->listTensorboardRuns($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the TensorboardExperiment to list
     *                             TensorboardRuns. Format:
     *                             `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Lists the TensorboardRuns that match the filter expression.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           Field to use to sort the list.
     *     @type FieldMask $readMask
     *           Mask specifying which fields to read.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTensorboardRuns($parent, array $optionalArgs = [])
    {
        $request = new ListTensorboardRunsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['readMask'])) {
            $request->setReadMask($optionalArgs['readMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListTensorboardRuns',
            $optionalArgs,
            ListTensorboardRunsResponse::class,
            $request
        );
    }

    /**
     * Lists TensorboardTimeSeries in a Location.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedParent = $tensorboardServiceClient->tensorboardRunName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]', '[EXPERIMENT]', '[RUN]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $tensorboardServiceClient->listTensorboardTimeSeries($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $tensorboardServiceClient->listTensorboardTimeSeries($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the TensorboardRun to list
     *                             TensorboardTimeSeries. Format:
     *                             `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Lists the TensorboardTimeSeries that match the filter expression.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           Field to use to sort the list.
     *     @type FieldMask $readMask
     *           Mask specifying which fields to read.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTensorboardTimeSeries($parent, array $optionalArgs = [])
    {
        $request = new ListTensorboardTimeSeriesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['readMask'])) {
            $request->setReadMask($optionalArgs['readMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListTensorboardTimeSeries',
            $optionalArgs,
            ListTensorboardTimeSeriesResponse::class,
            $request
        );
    }

    /**
     * Lists Tensorboards in a Location.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedParent = $tensorboardServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $tensorboardServiceClient->listTensorboards($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $tensorboardServiceClient->listTensorboards($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Location to list Tensorboards.
     *                             Format:
     *                             `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Lists the Tensorboards that match the filter expression.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           Field to use to sort the list.
     *     @type FieldMask $readMask
     *           Mask specifying which fields to read.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTensorboards($parent, array $optionalArgs = [])
    {
        $request = new ListTensorboardsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['readMask'])) {
            $request->setReadMask($optionalArgs['readMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListTensorboards',
            $optionalArgs,
            ListTensorboardsResponse::class,
            $request
        );
    }

    /**
     * Gets bytes of TensorboardBlobs.
     * This is to allow reading blob data stored in consumer project's Cloud
     * Storage bucket without users having to obtain Cloud Storage access
     * permission.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedTimeSeries = $tensorboardServiceClient->tensorboardTimeSeriesName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]', '[EXPERIMENT]', '[RUN]', '[TIME_SERIES]');
     *     // Read all responses until the stream is complete
     *     $stream = $tensorboardServiceClient->readTensorboardBlobData($formattedTimeSeries);
     *     foreach ($stream->readAll() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string $timeSeries   Required. The resource name of the TensorboardTimeSeries to list Blobs.
     *                             Format:
     *                             `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string[] $blobIds
     *           IDs of the blobs to read.
     *     @type int $timeoutMillis
     *           Timeout to use for this call.
     * }
     *
     * @return \Google\ApiCore\ServerStream
     *
     * @throws ApiException if the remote call fails
     */
    public function readTensorboardBlobData(
        $timeSeries,
        array $optionalArgs = []
    ) {
        $request = new ReadTensorboardBlobDataRequest();
        $requestParamHeaders = [];
        $request->setTimeSeries($timeSeries);
        $requestParamHeaders['time_series'] = $timeSeries;
        if (isset($optionalArgs['blobIds'])) {
            $request->setBlobIds($optionalArgs['blobIds']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ReadTensorboardBlobData',
            ReadTensorboardBlobDataResponse::class,
            $optionalArgs,
            $request,
            Call::SERVER_STREAMING_CALL
        );
    }

    /**
     * Returns the storage size for a given TensorBoard instance.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedTensorboard = $tensorboardServiceClient->tensorboardName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]');
     *     $response = $tensorboardServiceClient->readTensorboardSize($formattedTensorboard);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string $tensorboard  Required. The name of the Tensorboard resource.
     *                             Format:
     *                             `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\ReadTensorboardSizeResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function readTensorboardSize($tensorboard, array $optionalArgs = [])
    {
        $request = new ReadTensorboardSizeRequest();
        $requestParamHeaders = [];
        $request->setTensorboard($tensorboard);
        $requestParamHeaders['tensorboard'] = $tensorboard;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ReadTensorboardSize',
            ReadTensorboardSizeResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Reads a TensorboardTimeSeries' data. By default, if the number of data
     * points stored is less than 1000, all data is returned. Otherwise, 1000
     * data points is randomly selected from this time series and returned.
     * This value can be changed by changing max_data_points, which can't be
     * greater than 10k.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedTensorboardTimeSeries = $tensorboardServiceClient->tensorboardTimeSeriesName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]', '[EXPERIMENT]', '[RUN]', '[TIME_SERIES]');
     *     $response = $tensorboardServiceClient->readTensorboardTimeSeriesData($formattedTensorboardTimeSeries);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string $tensorboardTimeSeries Required. The resource name of the TensorboardTimeSeries to read data from.
     *                                      Format:
     *                                      `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
     * @param array  $optionalArgs          {
     *     Optional.
     *
     *     @type int $maxDataPoints
     *           The maximum number of TensorboardTimeSeries' data to return.
     *
     *           This value should be a positive integer.
     *           This value can be set to -1 to return all data.
     *     @type string $filter
     *           Reads the TensorboardTimeSeries' data that match the filter expression.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\ReadTensorboardTimeSeriesDataResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function readTensorboardTimeSeriesData(
        $tensorboardTimeSeries,
        array $optionalArgs = []
    ) {
        $request = new ReadTensorboardTimeSeriesDataRequest();
        $requestParamHeaders = [];
        $request->setTensorboardTimeSeries($tensorboardTimeSeries);
        $requestParamHeaders[
            'tensorboard_time_series'
        ] = $tensorboardTimeSeries;
        if (isset($optionalArgs['maxDataPoints'])) {
            $request->setMaxDataPoints($optionalArgs['maxDataPoints']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ReadTensorboardTimeSeriesData',
            ReadTensorboardTimeSeriesDataResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns a list of monthly active users for a given TensorBoard instance.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedTensorboard = $tensorboardServiceClient->tensorboardName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]');
     *     $response = $tensorboardServiceClient->readTensorboardUsage($formattedTensorboard);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string $tensorboard  Required. The name of the Tensorboard resource.
     *                             Format:
     *                             `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\ReadTensorboardUsageResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function readTensorboardUsage($tensorboard, array $optionalArgs = [])
    {
        $request = new ReadTensorboardUsageRequest();
        $requestParamHeaders = [];
        $request->setTensorboard($tensorboard);
        $requestParamHeaders['tensorboard'] = $tensorboard;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ReadTensorboardUsage',
            ReadTensorboardUsageResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates a Tensorboard.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $tensorboard = new Tensorboard();
     *     $operationResponse = $tensorboardServiceClient->updateTensorboard($updateMask, $tensorboard);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $tensorboardServiceClient->updateTensorboard($updateMask, $tensorboard);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $tensorboardServiceClient->resumeOperation($operationName, 'updateTensorboard');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask   $updateMask   Required. Field mask is used to specify the fields to be overwritten in the
     *                                  Tensorboard resource by the update.
     *                                  The fields specified in the update_mask are relative to the resource, not
     *                                  the full request. A field is overwritten if it's in the mask. If the
     *                                  user does not provide a mask then all fields are overwritten if new
     *                                  values are specified.
     * @param Tensorboard $tensorboard  Required. The Tensorboard's `name` field is used to identify the
     *                                  Tensorboard to be updated. Format:
     *                                  `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateTensorboard(
        $updateMask,
        $tensorboard,
        array $optionalArgs = []
    ) {
        $request = new UpdateTensorboardRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setTensorboard($tensorboard);
        $requestParamHeaders['tensorboard.name'] = $tensorboard->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateTensorboard',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates a TensorboardExperiment.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $tensorboardExperiment = new TensorboardExperiment();
     *     $response = $tensorboardServiceClient->updateTensorboardExperiment($updateMask, $tensorboardExperiment);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask             $updateMask            Required. Field mask is used to specify the fields to be overwritten in the
     *                                                     TensorboardExperiment resource by the update.
     *                                                     The fields specified in the update_mask are relative to the resource, not
     *                                                     the full request. A field is overwritten if it's in the mask. If the
     *                                                     user does not provide a mask then all fields are overwritten if new
     *                                                     values are specified.
     * @param TensorboardExperiment $tensorboardExperiment Required. The TensorboardExperiment's `name` field is used to identify the
     *                                                     TensorboardExperiment to be updated. Format:
     *                                                     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
     * @param array                 $optionalArgs          {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\TensorboardExperiment
     *
     * @throws ApiException if the remote call fails
     */
    public function updateTensorboardExperiment(
        $updateMask,
        $tensorboardExperiment,
        array $optionalArgs = []
    ) {
        $request = new UpdateTensorboardExperimentRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setTensorboardExperiment($tensorboardExperiment);
        $requestParamHeaders[
            'tensorboard_experiment.name'
        ] = $tensorboardExperiment->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateTensorboardExperiment',
            TensorboardExperiment::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates a TensorboardRun.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $tensorboardRun = new TensorboardRun();
     *     $response = $tensorboardServiceClient->updateTensorboardRun($updateMask, $tensorboardRun);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask      $updateMask     Required. Field mask is used to specify the fields to be overwritten in the
     *                                       TensorboardRun resource by the update.
     *                                       The fields specified in the update_mask are relative to the resource, not
     *                                       the full request. A field is overwritten if it's in the mask. If the
     *                                       user does not provide a mask then all fields are overwritten if new
     *                                       values are specified.
     * @param TensorboardRun $tensorboardRun Required. The TensorboardRun's `name` field is used to identify the
     *                                       TensorboardRun to be updated. Format:
     *                                       `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
     * @param array          $optionalArgs   {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\TensorboardRun
     *
     * @throws ApiException if the remote call fails
     */
    public function updateTensorboardRun(
        $updateMask,
        $tensorboardRun,
        array $optionalArgs = []
    ) {
        $request = new UpdateTensorboardRunRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setTensorboardRun($tensorboardRun);
        $requestParamHeaders[
            'tensorboard_run.name'
        ] = $tensorboardRun->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateTensorboardRun',
            TensorboardRun::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates a TensorboardTimeSeries.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $tensorboardTimeSeries = new TensorboardTimeSeries();
     *     $response = $tensorboardServiceClient->updateTensorboardTimeSeries($updateMask, $tensorboardTimeSeries);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask             $updateMask            Required. Field mask is used to specify the fields to be overwritten in the
     *                                                     TensorboardTimeSeries resource by the update.
     *                                                     The fields specified in the update_mask are relative to the resource, not
     *                                                     the full request. A field is overwritten if it's in the mask. If the
     *                                                     user does not provide a mask then all fields are overwritten if new
     *                                                     values are specified.
     * @param TensorboardTimeSeries $tensorboardTimeSeries Required. The TensorboardTimeSeries' `name` field is used to identify the
     *                                                     TensorboardTimeSeries to be updated.
     *                                                     Format:
     *                                                     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
     * @param array                 $optionalArgs          {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\TensorboardTimeSeries
     *
     * @throws ApiException if the remote call fails
     */
    public function updateTensorboardTimeSeries(
        $updateMask,
        $tensorboardTimeSeries,
        array $optionalArgs = []
    ) {
        $request = new UpdateTensorboardTimeSeriesRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setTensorboardTimeSeries($tensorboardTimeSeries);
        $requestParamHeaders[
            'tensorboard_time_series.name'
        ] = $tensorboardTimeSeries->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateTensorboardTimeSeries',
            TensorboardTimeSeries::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Write time series data points of multiple TensorboardTimeSeries in multiple
     * TensorboardRun's. If any data fail to be ingested, an error is returned.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedTensorboardExperiment = $tensorboardServiceClient->tensorboardExperimentName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]', '[EXPERIMENT]');
     *     $writeRunDataRequests = [];
     *     $response = $tensorboardServiceClient->writeTensorboardExperimentData($formattedTensorboardExperiment, $writeRunDataRequests);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string                           $tensorboardExperiment Required. The resource name of the TensorboardExperiment to write data to.
     *                                                                Format:
     *                                                                `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
     * @param WriteTensorboardRunDataRequest[] $writeRunDataRequests  Required. Requests containing per-run TensorboardTimeSeries data to write.
     * @param array                            $optionalArgs          {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\WriteTensorboardExperimentDataResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function writeTensorboardExperimentData(
        $tensorboardExperiment,
        $writeRunDataRequests,
        array $optionalArgs = []
    ) {
        $request = new WriteTensorboardExperimentDataRequest();
        $requestParamHeaders = [];
        $request->setTensorboardExperiment($tensorboardExperiment);
        $request->setWriteRunDataRequests($writeRunDataRequests);
        $requestParamHeaders['tensorboard_experiment'] = $tensorboardExperiment;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'WriteTensorboardExperimentData',
            WriteTensorboardExperimentDataResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Write time series data points into multiple TensorboardTimeSeries under
     * a TensorboardRun. If any data fail to be ingested, an error is returned.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $formattedTensorboardRun = $tensorboardServiceClient->tensorboardRunName('[PROJECT]', '[LOCATION]', '[TENSORBOARD]', '[EXPERIMENT]', '[RUN]');
     *     $timeSeriesData = [];
     *     $response = $tensorboardServiceClient->writeTensorboardRunData($formattedTensorboardRun, $timeSeriesData);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string           $tensorboardRun Required. The resource name of the TensorboardRun to write data to.
     *                                         Format:
     *                                         `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
     * @param TimeSeriesData[] $timeSeriesData Required. The TensorboardTimeSeries data to write.
     *                                         Values with in a time series are indexed by their step value.
     *                                         Repeated writes to the same step will overwrite the existing value for that
     *                                         step.
     *                                         The upper limit of data points per write request is 5000.
     * @param array            $optionalArgs   {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\WriteTensorboardRunDataResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function writeTensorboardRunData(
        $tensorboardRun,
        $timeSeriesData,
        array $optionalArgs = []
    ) {
        $request = new WriteTensorboardRunDataRequest();
        $requestParamHeaders = [];
        $request->setTensorboardRun($tensorboardRun);
        $request->setTimeSeriesData($timeSeriesData);
        $requestParamHeaders['tensorboard_run'] = $tensorboardRun;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'WriteTensorboardRunData',
            WriteTensorboardRunDataResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $response = $tensorboardServiceClient->getLocation();
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $tensorboardServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $tensorboardServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $resource = 'resource';
     *     $response = $tensorboardServiceClient->getIamPolicy($resource);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $tensorboardServiceClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $tensorboardServiceClient = new TensorboardServiceClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $tensorboardServiceClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $tensorboardServiceClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }
}
